/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifiying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Icon));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const arrowRight = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/cancel-circle-filled.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/cancel-circle-filled.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const cancelCircleFilled = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21ZM15.5303 8.46967C15.8232 8.76256 15.8232 9.23744 15.5303 9.53033L13.0607 12L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7626 15.8232 14.4697 15.5303L12 13.0607L9.53033 15.5303C9.23744 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7626 8.46967 14.4697L10.9393 12L8.46967 9.53033C8.17678 9.23744 8.17678 8.76256 8.46967 8.46967C8.76256 8.17678 9.23744 8.17678 9.53033 8.46967L12 10.9393L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cancelCircleFilled);
//# sourceMappingURL=cancel-circle-filled.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/check.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/check.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const check = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (check);
//# sourceMappingURL=check.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-down.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronDown);
//# sourceMappingURL=chevron-down.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-up.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronUp = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronUp);
//# sourceMappingURL=chevron-up.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close-small.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close-small.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const closeSmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (closeSmall);
//# sourceMappingURL=close-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const close = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/comment-content.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/comment-content.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const commentContent = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M6.68822 16.625L5.5 17.8145L5.5 5.5L18.5 5.5L18.5 16.625L6.68822 16.625ZM7.31 18.125L19 18.125C19.5523 18.125 20 17.6773 20 17.125L20 5C20 4.44772 19.5523 4 19 4H5C4.44772 4 4 4.44772 4 5V19.5247C4 19.8173 4.16123 20.086 4.41935 20.2237C4.72711 20.3878 5.10601 20.3313 5.35252 20.0845L7.31 18.125ZM16 9.99997H8V8.49997H16V9.99997ZM8 14H13V12.5H8V14Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (commentContent);
//# sourceMappingURL=comment-content.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/external.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/external.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const external = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M19.5 4.5h-7V6h4.44l-5.97 5.97 1.06 1.06L18 7.06v4.44h1.5v-7Zm-13 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3H17v3a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h3V5.5h-3Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (external);
//# sourceMappingURL=external.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-italic.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-italic.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatItalic = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12.5 5L10 19h1.9l2.5-14z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatItalic);
//# sourceMappingURL=format-italic.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-list-bullets.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-list-bullets.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatListBullets = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM6 13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-7c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatListBullets);
//# sourceMappingURL=format-list-bullets.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/help.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/help.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const help = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4.75a7.25 7.25 0 100 14.5 7.25 7.25 0 000-14.5zM3.25 12a8.75 8.75 0 1117.5 0 8.75 8.75 0 01-17.5 0zM12 8.75a1.5 1.5 0 01.167 2.99c-.465.052-.917.44-.917 1.01V14h1.5v-.845A3 3 0 109 10.25h1.5a1.5 1.5 0 011.5-1.5zM11.25 15v1.5h1.5V15h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (help);
//# sourceMappingURL=help.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/info.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/info.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const info = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (info);
//# sourceMappingURL=info.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/lifesaver.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/lifesaver.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const lifesaver = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M17.375 15.656A6.47 6.47 0 0018.5 12a6.47 6.47 0 00-.943-3.374l-1.262.813c.448.749.705 1.625.705 2.561a4.977 4.977 0 01-.887 2.844l1.262.813zm-1.951 1.87l-.813-1.261A4.976 4.976 0 0112 17c-.958 0-1.852-.27-2.613-.736l-.812 1.261A6.47 6.47 0 0012 18.5a6.47 6.47 0 003.424-.974zm-8.8-1.87A6.47 6.47 0 015.5 12c0-1.235.344-2.39.943-3.373l1.261.812A4.977 4.977 0 007 12c0 1.056.328 2.036.887 2.843l-1.262.813zm2.581-7.803A4.977 4.977 0 0112 7c1.035 0 1.996.314 2.794.853l.812-1.262A6.47 6.47 0 0012 5.5a6.47 6.47 0 00-3.607 1.092l.812 1.261zM12 20a8 8 0 100-16 8 8 0 000 16zm0-4.5a3.5 3.5 0 100-7 3.5 3.5 0 000 7z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (lifesaver);
//# sourceMappingURL=lifesaver.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/rotate-right.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const rotateRight = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.1 4.8l-3-2.5V4c-4.4 0-8 3.6-8 8 0 3.7 2.5 6.9 6 7.7.3.1.6.1 1 .2l.2-1.5c-.4 0-.7-.1-1.1-.2l-.1.2v-.2c-2.6-.8-4.5-3.3-4.5-6.2 0-3.6 2.9-6.5 6.5-6.5v1.8l3-2.5zM20 11c-.2-1.4-.7-2.7-1.6-3.8l-1.2.8c.7.9 1.1 2 1.3 3.1L20 11zm-1.5 1.8c-.1.5-.2 1.1-.4 1.6s-.5 1-.8 1.5l1.2.9c.4-.5.8-1.1 1-1.8s.5-1.3.5-2l-1.5-.2zm-5.6 5.6l.2 1.5c1.4-.2 2.7-.7 3.8-1.6l-.9-1.1c-.9.7-2 1.1-3.1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (rotateRight);
//# sourceMappingURL=rotate-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/warning.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/warning.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const warning = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "-2 -2 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M10 2c4.42 0 8 3.58 8 8s-3.58 8-8 8-8-3.58-8-8 3.58-8 8-8zm1.13 9.38l.35-6.46H8.52l.35 6.46h2.26zm-.09 3.36c.24-.23.37-.55.37-.96 0-.42-.12-.74-.36-.97s-.59-.35-1.06-.35-.82.12-1.07.35-.37.55-.37.97c0 .41.13.73.38.96.26.23.61.34 1.06.34s.8-.11 1.05-.34z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (warning);
//# sourceMappingURL=warning.js.map

/***/ }),

/***/ "./assets/src/dashboard/index.js":
/*!***************************************!*\
  !*** ./assets/src/dashboard/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./assets/src/dashboard/style.scss");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./store */ "./assets/src/dashboard/store/index.js");
/* harmony import */ var _parts_Main__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parts/Main */ "./assets/src/dashboard/parts/Main.js");

/**
 * WordPress dependencies.
 */


/**
 * Internal dependencies.
 */



(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.render)((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_parts_Main__WEBPACK_IMPORTED_MODULE_4__["default"], null), document.getElementById('optimole-app'));

/***/ }),

/***/ "./assets/src/dashboard/parts/Footer.js":
/*!**********************************************!*\
  !*** ./assets/src/dashboard/parts/Footer.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);


const footerMenu = [{
  label: optimoleDashboardApp.strings.optimole + ' ' + optimoleDashboardApp.strings.version,
  href: optimoleDashboardApp.optimoleHome
}, {
  label: optimoleDashboardApp.strings.terms_menu,
  href: optimoleDashboardApp.optimoleHome + 'terms/'
}, {
  label: optimoleDashboardApp.strings.privacy_menu,
  href: optimoleDashboardApp.optimoleHome + 'privacy-policy/'
}, {
  label: optimoleDashboardApp.strings.testdrive_menu,
  href: optimoleDashboardApp.optimoleHome + 'test-drive?url=' + optimoleDashboardApp.home_url
}];
const Footer = () => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("footer", {
    className: "max-w-screen-xl gap-3 md:gap-0 mx-auto my-5 flex justify-between text-base flex-col md:flex-row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_subtitle_3
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("nav", {
    className: "flex gap-0 sm:gap-3 flex-wrap md:flex-nowrap"
  }, footerMenu.map((item, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ExternalLink, {
    key: index,
    href: item.href,
    className: "basis-1/2 sm:basis-auto"
  }, item.label))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Footer);

/***/ }),

/***/ "./assets/src/dashboard/parts/Header.js":
/*!**********************************************!*\
  !*** ./assets/src/dashboard/parts/Header.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/icons */ "./assets/src/dashboard/utils/icons.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/api */ "./assets/src/dashboard/utils/api.js");

/**
 * External dependencies.
 */



/**
 * WordPress dependencies.
 */




/**
 * Internal dependencies.
 */


const Header = ({
  tab,
  setTab
}) => {
  const [showConflicts, setShowConflicts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const {
    setShowDisconnect
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('optimole');
  const {
    isConnected,
    isLoading,
    hasApplication,
    hasDashboardLoaded,
    hasConflicts
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isConnected,
      isLoading,
      hasApplication,
      hasDashboardLoaded,
      getConflicts
    } = select('optimole');
    const conflicts = getConflicts();
    return {
      isConnected: isConnected(),
      isLoading: isLoading(),
      hasApplication: hasApplication(),
      hasDashboardLoaded: hasDashboardLoaded(),
      hasConflicts: 0 < conflicts.count || 0
    };
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (hasConflicts) {
      setShowConflicts(true);
    }
  }, [hasConflicts]);
  const tabs = [{
    label: optimoleDashboardApp.strings.dashboard_menu_item,
    value: 'dashboard'
  }, {
    label: optimoleDashboardApp.strings.conflicts_menu_item,
    value: 'conflicts',
    isDisabled: !showConflicts
  }, {
    label: optimoleDashboardApp.strings.settings_menu_item,
    value: 'settings'
  }, {
    label: optimoleDashboardApp.strings.help_menu_item,
    value: 'help'
  }];
  const isOnboarding = isConnected && hasApplication && !hasDashboardLoaded;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "bg-white shadow-sm px-2.5 py-5 pb-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col sm:flex-row justify-between items-center max-w-screen-xl mx-auto my-0 pb-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "items-center flex justify-start cursor-default"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "max-width-64 w-16 h-16 mr-3",
    src: `${optimoleDashboardApp.assets_url}/img/logo.png`,
    alt: optimoleDashboardApp.strings.optimole + ' ' + optimoleDashboardApp.strings.service_details,
    title: optimoleDashboardApp.strings.optimole + ' ' + optimoleDashboardApp.strings.service_details
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-gray-800 text-2 font-serif font-bold"
  }, optimoleDashboardApp.strings.optimole)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center"
  }, isConnected ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.DropdownMenu, {
    icon: isLoading || isOnboarding ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
      className: "animate-spin fill-success"
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: _utils_icons__WEBPACK_IMPORTED_MODULE_5__.connected
    }),
    toggleProps: {
      className: 'optml-header__dropdown uppercase font-bold text-xs text-success hover:text-success active:text-success focus:text-success mr-3 border border-gray-300 rounded-md border-solid gap-2',
      iconPosition: 'right'
    },
    popoverProps: {
      className: 'optml-header__dropdown__popover'
    },
    text: isOnboarding ? optimoleDashboardApp.strings.connecting : optimoleDashboardApp.strings.connected,
    controls: [{
      title: optimoleDashboardApp.strings.optimole + ' ' + optimoleDashboardApp.strings.dashboard_menu_item,
      onClick: () => window.open(optimoleDashboardApp.optimoleDashHome, '_blank')
    }, {
      title: optimoleDashboardApp.strings.refresh_stats_cta,
      onClick: _utils_api__WEBPACK_IMPORTED_MODULE_6__.requestStatsUpdate,
      isDisabled: isOnboarding
    }, {
      title: optimoleDashboardApp.strings.disconnect_btn,
      onClick: () => setShowDisconnect(true),
      isDisabled: isOnboarding
    }]
  })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "uppercase font-bold text-xs text-danger mr-3"
  }, optimoleDashboardApp.strings.not_connected), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: _utils_icons__WEBPACK_IMPORTED_MODULE_5__.disconnected
  })))), isConnected && hasApplication && hasDashboardLoaded && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "flex gap-8 items-center max-w-screen-xl mx-auto my-0 justify-center sm:justify-normal"
  }, tabs.filter(tab => !tab?.isDisabled).map(({
    label,
    value
  }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: value,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('cursor-pointer text-purple-gray font-bold text-lg m-0 py-2 px-3 transition-colors duration-200 ease-in-out border-0 border-b-4 border-b-white border-solid', {
      'text-black !border-b-info': tab === value
    }),
    onClick: () => setTab(value)
  }, label))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ "./assets/src/dashboard/parts/Main.js":
/*!********************************************!*\
  !*** ./assets/src/dashboard/parts/Main.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Header */ "./assets/src/dashboard/parts/Header.js");
/* harmony import */ var _disconnect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./disconnect */ "./assets/src/dashboard/parts/disconnect/index.js");
/* harmony import */ var _connect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./connect */ "./assets/src/dashboard/parts/connect/index.js");
/* harmony import */ var _connecting__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./connecting */ "./assets/src/dashboard/parts/connecting/index.js");
/* harmony import */ var _connected__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./connected */ "./assets/src/dashboard/parts/connected/index.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Footer */ "./assets/src/dashboard/parts/Footer.js");
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/helpers */ "./assets/src/dashboard/utils/helpers.js");
/* harmony import */ var _connected_Toasts__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./connected/Toasts */ "./assets/src/dashboard/parts/connected/Toasts.js");

/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */








const Main = () => {
  const allowedTabs = ['dashboard', 'settings', 'help'];
  const hash = window.location.hash.replace('#', '');
  let defaultTab = allowedTabs.includes(hash) ? hash : 'dashboard';
  const [tab, setTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(defaultTab);
  const switchToSettings = e => {
    e.preventDefault();
    setTab('settings');
  };
  const switchToDashboard = e => {
    e.preventDefault();
    setTab('dashboard');
  };
  const {
    showDisconnect,
    isConnected,
    hasApplication,
    hasDashboardLoaded
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      showDisconnect,
      isConnected,
      hasApplication,
      hasDashboardLoaded
    } = select('optimole');
    return {
      showDisconnect: showDisconnect(),
      isConnected: isConnected(),
      hasApplication: hasApplication(),
      hasDashboardLoaded: hasDashboardLoaded()
    };
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!isConnected) {
      return;
    }
    window.location.hash = `#${tab}`;
    (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_9__.highlightSidebarLink)();
  }, [tab]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!isConnected) {
      return;
    }
    const dashLink = document.querySelector('a[href*="page=optimole"]');
    const settingsLink = document.querySelector('a[href*="page=optimole#settings"]');
    if (!dashLink || !settingsLink) {
      return;
    }
    dashLink.addEventListener('click', switchToDashboard);
    settingsLink.addEventListener('click', switchToSettings);
    return () => {
      if (!dashLink || !settingsLink) {
        return;
      }
      dashLink.removeEventListener('click', switchToDashboard);
      settingsLink.removeEventListener('click', switchToSettings);
    };
  }, []);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "antialiased"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Header__WEBPACK_IMPORTED_MODULE_3__["default"], {
    tab: tab,
    setTab: setTab
  }), !(isConnected && hasApplication) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_connect__WEBPACK_IMPORTED_MODULE_5__["default"], null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Footer__WEBPACK_IMPORTED_MODULE_8__["default"], null)), isConnected && hasApplication && !hasDashboardLoaded && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_connecting__WEBPACK_IMPORTED_MODULE_6__["default"], null), isConnected && showDisconnect && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_disconnect__WEBPACK_IMPORTED_MODULE_4__["default"], null), isConnected && hasApplication && hasDashboardLoaded && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_connected__WEBPACK_IMPORTED_MODULE_7__["default"], {
    tab: tab,
    setTab: setTab
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_connected_Toasts__WEBPACK_IMPORTED_MODULE_10__["default"], null));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Main);

/***/ }),

/***/ "./assets/src/dashboard/parts/components/BlackFridayBanner.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/BlackFridayBanner.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (() => {
  const {
    urgency,
    title,
    subtitle,
    cta_link,
    cta_text,
    dismiss_key
  } = optimoleDashboardApp.bf_notices.banner;
  const [isVisible, setIsVisible] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(true);
  const [shouldRender, setShouldRender] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(true);
  const onClose = () => {
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.dismissNotice)(dismiss_key, () => {
      setIsVisible(false);
    });
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!isVisible) {
      const timer = setTimeout(() => {
        setShouldRender(false);
      }, 300);
      return () => clearTimeout(timer);
    }
  }, [isVisible]);
  const wrapClasses = classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex flex-col items-center text-center xl:flex-row gap-5 justify-between xl:items-center bg-black text-white p-5 py-4 pr-7 box-border rounded-lg mt-5 bg-no-repeat transition-all duration-300', {
    'opacity-0': !isVisible,
    'opacity-100': isVisible
  });
  if (!shouldRender) {
    return null;
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: wrapClasses,
    style: {
      backgroundImage: `url(${optimoleDashboardApp.assets_url}/img/bf-bg.jpg)`,
      backgroundPosition: 'right 0',
      backgroundSize: 'auto 100%'
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"],
    onClick: onClose,
    label: optimoleDashboardApp.strings.csat.close,
    className: "absolute right-1 top-1 cursor-pointer text-white hover:text-promo-orange"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col gap-3 xl:items-start items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm lg:text-base border-b border-0 border-dashed uppercase pb-1 font-semibold"
  }, urgency), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-4xl lg:text-5xl italic uppercase font-extrabold",
    dangerouslySetInnerHTML: {
      __html: title
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm lg:text-base font-extrabold",
    dangerouslySetInnerHTML: {
      __html: subtitle
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cta_link,
    target: "_blank",
    className: "bg-promo-orange text-white px-7 py-3 uppercase text-base font-bold grow flex justify-center max-w-[150px] text-center cursor-pointer hover:bg-white hover:text-orange-400 transition-colors"
  }, cta_text));
});

/***/ }),

/***/ "./assets/src/dashboard/parts/components/GroupSettingsContainer.js":
/*!*************************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/GroupSettingsContainer.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GroupSettingsContainer: () => (/* binding */ GroupSettingsContainer),
/* harmony export */   GroupSettingsOption: () => (/* binding */ GroupSettingsOption),
/* harmony export */   GroupSettingsTitle: () => (/* binding */ GroupSettingsTitle)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const GroupSettingsContainer = ({
  children,
  className = ''
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('my-4 p-4 rounded border-solid border-gray-200 bg-slate-100', className)
  }, children);
};
const GroupSettingsTitle = ({
  children,
  className = ''
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('text-sm text-slate-500 m-0 font-semibold mb-4 uppercase', className)
  }, children);
};
const GroupSettingsOption = ({
  children,
  className = ''
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('text-sm text-gray-600 px-4 py-2 bg-white flex flex-wrap items-center rounded', className)
  }, children);
};

/***/ }),

/***/ "./assets/src/dashboard/parts/components/Miscellaneous.js":
/*!****************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/Miscellaneous.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DescriptionWithTags: () => (/* binding */ DescriptionWithTags),
/* harmony export */   TextWithWarningBadge: () => (/* binding */ TextWithWarningBadge)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const TextWithWarningBadge = ({
  text,
  badgeLabel
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, text, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "ml-4 text-xs font-bold p-1 rounded bg-yellow-400 text-yellow-800 uppercase"
  }, badgeLabel));
};
const DescriptionTag = ({
  text,
  showAsDisabled
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
  className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('inline-block  text-xs px-2 py-1 rounded mr-2 mt-2 font-medium', {
    'bg-gray-200 text-gray-800 line-through': showAsDisabled,
    'bg-blue-200 text-blue-800': !showAsDisabled
  })
}, text);
const DescriptionWithTags = ({
  text,
  tags
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, text, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "mt-2"
}, tags.map(({
  text,
  disabled
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(DescriptionTag, {
  key: text,
  text: text,
  showAsDisabled: disabled
}))));

/***/ }),

/***/ "./assets/src/dashboard/parts/components/Modal.js":
/*!********************************************************!*\
  !*** ./assets/src/dashboard/parts/components/Modal.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Modal)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);





function Modal({
  icon,
  labels = {},
  onRequestClose = () => {},
  onConfirm = () => {},
  variant = 'default',
  onSecondaryAction = () => {},
  afterContentChildren = null
}) {
  const isMobileViewport = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__.useViewportMatch)('small', '<');
  const iconClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'bg-stale-yellow': 'warning' === variant,
    'bg-light-blue': 'default' === variant
  }, 'p-2 rounded-full flex items-center justify-center');
  const actionButtonClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'bg-mango-yellow': 'warning' === variant
  }, 'optml__button flex justify-center px-5 py-3 rounded font-bold min-h-40 basis-1/5');
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
    __experimentalHideHeader: true,
    className: "max-w-xl antialiased",
    onRequestClose: onRequestClose,
    isFullScreen: isMobileViewport
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
    onClick: onRequestClose,
    label: optimoleDashboardApp.strings.csat.close,
    className: "fixed right-3 top-3 cursor-pointer"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: iconClasses
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: icon,
    size: 24
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "mb-0",
    dangerouslySetInnerHTML: {
      __html: labels.title
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-center mx-0 my-4 text-gray-700",
    dangerouslySetInnerHTML: {
      __html: labels.description
    }
  }), afterContentChildren, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "primary",
    className: actionButtonClasses,
    onClick: onConfirm
  }, labels.action), labels.secondaryAction && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "default",
    className: "optml__button flex justify-center rounded font-bold min-h-40",
    onClick: onSecondaryAction
  }, labels.secondaryAction))));
}

/***/ }),

/***/ "./assets/src/dashboard/parts/components/Notice.js":
/*!*********************************************************!*\
  !*** ./assets/src/dashboard/parts/components/Notice.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notice)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/warning.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/cancel-circle-filled.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/info.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close-small.js");
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/icons */ "./assets/src/dashboard/utils/icons.js");




function Notice({
  text,
  title,
  disableIcon = false,
  type = 'info',
  className = '',
  smallTitle = false,
  children,
  onDismiss
}) {
  const noticeClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'bg-yellow-50 text-yellow-700': 'warning' === type,
    'bg-green-50 text-green-700': 'success' === type,
    'bg-red-50 text-red-700': 'error' === type,
    'bg-blue-50 text-blue-700': 'info' === type,
    'bg-info text-white': 'primary' === type
  }, `rounded-md my-5 text-sm p-4 om-notice om-notice-${type} relative`);
  const iconClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'fill-yellow-500': 'warning' === type,
    'fill-green-500': 'success' === type,
    'fill-red-500': 'error' === type,
    'fill-blue-500': 'info' === type,
    'fill-white': 'primary' === type,
    'h-6 w-6': 'primary' !== type,
    'h-12 w-12': 'primary' === type
  });
  const contentWrapClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'ml-3 mt-0.5': !disableIcon && !title,
    'mt-2 mx-1.5': title
  });
  const titleClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'text-yellow-800': 'warning' === type,
    'text-green-800': 'success' === type,
    'text-red-800': 'error' === type,
    'text-blue-800': 'info' === type,
    'font-bold text-base': 'primary' !== type,
    'text-white text-sm': 'primary' === type,
    'text-s': smallTitle
  }, 'm-0');
  const icons = {
    'warning': _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"],
    'success': _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
    'error': _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"],
    'info': _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"],
    'primary': _utils_icons__WEBPACK_IMPORTED_MODULE_2__.checkmark
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: noticeClasses
  }, onDismiss && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "flex items-center justify-center absolute bg-transparent text-current right-1 top-1 border-0 rounded-full p-0 cursor-pointer hover:bg-white transition-all hover:text-info",
    onClick: onDismiss
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: "fill-current",
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: title ? 'grid' : 'flex'
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('flex-shrink-0 flex gap-2', {
      'items-center': title
    })
  }, !disableIcon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"], {
    icon: icons[type] || null,
    className: iconClasses
  }), title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: titleClasses,
    dangerouslySetInnerHTML: {
      __html: title
    }
  })), children || text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: contentWrapClasses
  }, text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0",
    dangerouslySetInnerHTML: {
      __html: text
    }
  }), children)));
}

/***/ }),

/***/ "./assets/src/dashboard/parts/components/ProgressBar.js":
/*!**************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/ProgressBar.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);

/**
 * External dependencies.
 */

const ProgressBar = ({
  value,
  max = 100,
  className,
  colorOverage = false,
  ...props
}) => {
  const progress = Math.round(value / max * 100);
  const background = props.background || '#FFF';
  const wrapClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()('w-full h-2.5 border rounded-md border-solid bg-white border-light-gray relative overflow-hidden', className);
  const progressClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()('absolute left-0 h-full', {
    'bg-info': colorOverage ? 70 > progress : true,
    'bg-red-500': colorOverage && 100 < progress,
    'bg-amber-500': colorOverage && 70 < progress && 100 > progress
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: wrapClasses,
    role: "progressbar",
    "aria-valuemin": "0",
    "aria-valuemax": max,
    "aria-valuenow": value,
    ...props
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: progressClasses,
    style: {
      width: `${progress}%`
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProgressBar);

/***/ }),

/***/ "./assets/src/dashboard/parts/components/ProgressTile.js":
/*!***************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/ProgressTile.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressTile)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ProgressBar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProgressBar */ "./assets/src/dashboard/parts/components/ProgressBar.js");
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/icons */ "./assets/src/dashboard/utils/icons.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");

/* global optimoleDashboardApp */




function ProgressTile({
  title,
  progress,
  description,
  onCancel,
  hideCancel = false
}) {
  const {
    strings
  } = optimoleDashboardApp;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-gray-50 rounded-md p-4 space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-3 items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"], {
    icon: _utils_icons__WEBPACK_IMPORTED_MODULE_2__.sync,
    className: "text-info animate-spin -scale-y-100"
  }), title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "uppercase text-s font-semibold text-light-black m-0"
  }, title), !hideCancel && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: onCancel,
    className: "appearance-none border border-info text-info bg-transparent rounded px-4 py-2 ml-auto text-s hover:border-red-500 hover:bg-red-500 hover:text-white cursor-pointer"
  }, strings.cancel)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_ProgressBar__WEBPACK_IMPORTED_MODULE_1__["default"], {
    value: progress
  }), description && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-gray-500"
  }, description));
}

/***/ }),

/***/ "./assets/src/dashboard/parts/components/RadioBoxes.js":
/*!*************************************************************!*\
  !*** ./assets/src/dashboard/parts/components/RadioBoxes.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RadioBoxes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


function RadioBoxes({
  options,
  value,
  onChange,
  label,
  disabled = false,
  className
}) {
  const handleClick = e => {
    onChange(e.target.value);
  };
  const fieldsetClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'opacity-50': disabled
  }, 'transition-all my-6 gap-6 grid opacity-100');
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("fieldset", {
    className: `my-6 gap-6 grid ${className}`,
    onChange: handleClick
  }, label && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("legend", {
    className: "uppercase font-semibold text-s text-light-black mb-6 inline-block"
  }, label), options.map((option, index) => {
    const {
      title,
      value: buttonValue,
      description
    } = option;
    const isActive = value === buttonValue;
    const buttonClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'outline-info': isActive,
      'outline-transparent': !isActive
    }, 'flex gap-6 items-start bg-gray-50 rounded-md p-4 outline -outline-offset-3 outline-3 transition-all');
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      htmlFor: buttonValue,
      key: buttonValue,
      className: buttonClasses
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RadioDot, {
      isActive: isActive
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid space-y-2"
    }, title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-base font-medium text-gray-700"
    }, title), description && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-sm text-gray-500"
    }, description)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "radio",
      name: "label",
      value: buttonValue,
      checked: isActive,
      onChange: () => {} // Add empty onChange to satisfy React's controlled input requirements
      ,
      id: buttonValue,
      className: "!opacity-0 !w-0 !h-0 !overflow-hidden !absolute !pointer-events-none",
      disabled: disabled,
      checked: isActive
    }));
  }));
}
const RadioDot = ({
  isActive
}) => {
  const wrapClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'bg-white outline-info': isActive,
    'bg-gray-200 outline-transparent': !isActive
  }, 'w-[24px] h-[24px] rounded-full flex items-center justify-center flex-shrink-0 outline outline-3 -outline-offset-3 transition-all');
  const dotClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'bg-info': isActive
  }, 'w-[12px] h-[12px] rounded-full background-info transition-all');
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: wrapClasses
  }, isActive && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: dotClasses
  }));
};

/***/ }),

/***/ "./assets/src/dashboard/parts/components/Tooltip.js":
/*!**********************************************************!*\
  !*** ./assets/src/dashboard/parts/components/Tooltip.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__({
  children,
  text
}) {
  const [isVisible, setIsVisible] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  if (!text) {
    return children;
  }
  if (!children) {
    return null;
  }
  const classes = classnames__WEBPACK_IMPORTED_MODULE_2___default()('absolute text-white bg-gray-800 text-xs p-2 rounded shadow-lg z-10 transition-opacity duration-200 pointer-events-none', {
    'opacity-100': isVisible,
    'opacity-0': !isVisible
  });
  const tooltipStyles = {
    left: '50%',
    transform: 'translateX(-50%)',
    bottom: '120%'
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative",
    onMouseEnter: () => setIsVisible(true),
    onMouseLeave: () => setIsVisible(false)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classes,
    style: tooltipStyles
  }, text.charAt(0).toUpperCase() + text.slice(1).toLowerCase(), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute -bottom-1 w-2 h-2 bg-gray-800",
    style: {
      left: '50%',
      transform: 'translateX(-50%) rotate(45deg)'
    }
  })), children);
}

/***/ }),

/***/ "./assets/src/dashboard/parts/connect/APIForm.js":
/*!*******************************************************!*\
  !*** ./assets/src/dashboard/parts/connect/APIForm.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");

/**
 * WordPress dependencies.
 */




/**
 * Internal dependencies.
 */

const APIForm = ({
  setMethod
}) => {
  const [apiKey, setApiKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [errors, setErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)({});
  const [selectedApp, setApp] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
  const {
    setShowDisconnect
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('optimole');
  const {
    availableApps,
    hasValidKey,
    isConnected,
    isConnecting,
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getAvailableApps,
      hasValidKey,
      isConnected,
      isConnecting,
      isLoading
    } = select('optimole');
    return {
      availableApps: getAvailableApps(),
      hasValidKey: hasValidKey(),
      isConnected: isConnected(),
      isConnecting: isConnecting(),
      isLoading: isLoading()
    };
  });
  const onConnect = () => {
    setErrors({});
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.connectAccount)({
      // eslint-disable-next-line camelcase
      api_key: apiKey
    }, response => {
      if ('success' !== response.code) {
        setErrors({
          'error_connect': response.data
        });
      }
    });
  };
  const getActiveApp = () => {
    if (null !== availableApps && availableApps !== undefined && availableApps.available_apps !== undefined) {
      return availableApps.available_apps[selectedApp].key;
    }
    return '';
  };
  const onSelectDomain = () => {
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.selectDomain)({
      // eslint-disable-next-line camelcase
      api_key: apiKey,
      application: getActiveApp()
    }, response => {
      if ('success' !== response.code) {
        setErrors({
          'error_connect': response.data
        });
      }
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-2 font-bold m-0 text-gray-700"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-800 font-serif leading-7"
  }, optimoleDashboardApp.strings.connect_btn), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xl font-normal text-gray-800",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.steps_connect_api_desc
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col gap-8 p-8 bg-light-blue border border-blue-300 rounded-md"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col sm:flex-row gap-8 items-stretch sm:items-end"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    label: isConnected ? optimoleDashboardApp.strings.your_api_key : optimoleDashboardApp.strings.add_api,
    placeholder: optimoleDashboardApp.strings.email,
    disabled: isConnected,
    value: apiKey,
    onChange: setApiKey,
    className: "optml__input basis-4/5"
  }), isConnected ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "default",
    isBusy: isLoading,
    disabled: isLoading,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: setShowDisconnect
  }, optimoleDashboardApp.strings.disconnect_btn) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    isBusy: isConnecting,
    disabled: isConnecting || 0 === apiKey.length,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: onConnect
  }, optimoleDashboardApp.strings.connect_btn)), availableApps && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col sm:flex-row gap-8 items-stretch sm:items-end"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "basis-4/5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: optimoleDashboardApp.strings.select + ' ' + optimoleDashboardApp.strings.your_domain,
    value: selectedApp,
    options: availableApps.available_apps.map((app, index) => {
      return {
        label: app.domain,
        value: index
      };
    }),
    onChange: setApp,
    className: "optml__select has_large_title",
    __nextHasNoMarginBottom: true
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    isBusy: isConnecting,
    disabled: isConnecting,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: onSelectDomain
  }, optimoleDashboardApp.strings.select))), !hasValidKey && undefined !== errors['error_connect'] && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "block text-xs mt-1 text-danger",
    dangerouslySetInnerHTML: {
      __html: errors['error_connect']
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "link",
    onClick: () => setMethod('email')
  }, optimoleDashboardApp.strings.back_to_connect)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (APIForm);

/***/ }),

/***/ "./assets/src/dashboard/parts/connect/index.js":
/*!*****************************************************!*\
  !*** ./assets/src/dashboard/parts/connect/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _APIForm__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./APIForm */ "./assets/src/dashboard/parts/connect/APIForm.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");

/**
 * WordPress dependencies.
 */





/**
 * Internal dependencies.
 */


const connectClasses = 'optml-connect flex flex-col justify-between max-w-screen-xl mt-8 mb-5 mx-auto p-0 transition-all ease-in-out duration-700 relative bg-white text-gray-700 border-0 rounded-lg shadow-md';
const connectContainerClasses = 'flex gap-8 p-8 flex-col md:flex-row';
const RestError = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "bg-danger text-white rounded relative px-6 py-5 mb-0 m-12",
  dangerouslySetInnerHTML: {
    __html: optimoleDashboardApp.strings.notice_api_not_working
  }
});
const ConnectLayout = () => {
  const [email, setEmail] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(optimoleDashboardApp.current_user.email);
  const [method, setMethod] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('email');
  const [errors, setErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)({});
  const [showBenefits, setShowBenefits] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const {
    setAutoConnect
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('optimole');
  const {
    autoConnect,
    hasRestError,
    isConnecting
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getAutoConnect,
      hasRestError,
      isConnecting
    } = select('optimole');
    return {
      autoConnect: getAutoConnect(),
      hasRestError: hasRestError(),
      isConnecting: isConnecting()
    };
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if ('no' !== autoConnect) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_6__.registerAccount)({
        email: autoConnect,
        // eslint-disable-next-line camelcase
        auto_connect: true
      }, response => {
        setAutoConnect('no');
        if ('email_registered' === response.code) {
          setErrors({
            'email_registered': response.message
          });
          return;
        }
        if ('site_exists' === response.code) {
          setErrors({
            'site_exists': response.message
          });
          return;
        }
        if ('success' !== response.code) {
          if (response.message) {
            setErrors({
              'error_autoconnect': response.message
            });
          }
        }
      });
    }
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (0 === email.length || (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.isEmail)(email)) {
      // Removing invalid email notice if a valid email is set.
      if (errors.invalid_email) {
        delete errors.invalid_email;
        setErrors(errors);
      }
    }
  }, [email]);
  const onConnect = () => {
    setErrors({});
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_6__.registerAccount)({
      email
    }, response => {
      if ('email_registered' === response.code) {
        setErrors({
          'email_registered': response.message
        });
        return;
      }
      if ('site_exists' === response.code) {
        setErrors({
          'site_exists': response.message
        });
        return;
      }
      if ('domain_not_accessible' === response.code) {
        setErrors({
          'domain_not_accessible': response.message
        });
        return;
      }
      if ('success' !== response.code) {
        setErrors({
          'error_register': response.message
        });
      }
    });
  };
  if ('key' === method) {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: connectClasses
    }, hasRestError && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RestError, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: connectContainerClasses
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_APIForm__WEBPACK_IMPORTED_MODULE_5__["default"], {
      setMethod: setMethod
    })));
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: connectClasses
  }, hasRestError && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RestError, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: connectContainerClasses
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml-connect__content basis-8/12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "inline-block bg-light-blue text-gray-500 text-sm font-medium px-4 py-1.5 rounded-full mb-4"
  }, optimoleDashboardApp.strings.account_needed_trust_badge), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-700 font-serif text-2xl font-bold leading-7 m-0"
  }, optimoleDashboardApp.strings.account_needed_heading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base font-normal text-gray-500",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_sub_heading
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "inline-flex items-center bg-light-blue px-4 py-1.5 rounded-full mb-5 text-sm text-gray-800"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "mr-2"
  }, "\u23F1\uFE0F"), optimoleDashboardApp.strings.account_needed_setup_time), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-gray-700 mb-5 leading-normal",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_title
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setShowBenefits(!showBenefits),
    className: "inline-flex items-center bg-light-blue px-4 py-1.5 rounded-full mb-4 text-sm text-gray-500 cursor-pointer transition-all hover:bg-blue-100 border-none",
    role: "button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, optimoleDashboardApp.strings.account_needed_benefits_toggle), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: `dashicons dashicons-arrow-${showBenefits ? 'up' : 'down'} ml-1`
  })), showBenefits && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex py-3 items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "yes-alt"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base ml-3 m-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_subtitle_1
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex py-3 items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "yes-alt"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base ml-3 m-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_subtitle_2
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex py-3 items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "yes-alt"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base ml-3 m-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.account_needed_subtitle_4
    }
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml-connect__form basis-4/12 p-8 bg-light-blue border border-blue-300 rounded-md"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    label: optimoleDashboardApp.strings.email_address_label,
    placeholder: optimoleDashboardApp.strings.email,
    value: email,
    onChange: setEmail,
    className: "optml__input",
    onBlur: () => {
      if (0 !== email.length && !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.isEmail)(email)) {
        setErrors({
          'invalid_email': optimoleDashboardApp.strings.invalid_email
        });
      }
    }
  }), 0 < Object.keys(errors).length && Object.keys(errors).map(key => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      key: key,
      className: "block text-xs mt-1 text-danger",
      dangerouslySetInnerHTML: {
        __html: errors[key]
      }
    });
  }) || (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("br", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    isBusy: isConnecting,
    disabled: isConnecting || 0 === email.length || !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.isEmail)(email),
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40",
    onClick: onConnect
  }, optimoleDashboardApp.strings.register_btn), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("br", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("br", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "base-control-label"
  }, optimoleDashboardApp.strings.existing_user), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "secondary",
    className: "optml__button flex w-full justify-center rounded font-bold mt-4 min-h-40 mb-4",
    style: {
      backgroundColor: '#EAE7F1',
      borderColor: '#9CA3AF',
      color: '#000000'
    },
    onClick: () => setMethod('key')
  }, optimoleDashboardApp.strings.api_exists), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    class: "flex items-center justify-center text-gray-600 mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    class: "mr-1.5"
  }, "\uD83D\uDD12"), optimoleDashboardApp.strings.secure_connection), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mb-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.signup_terms
    }
  }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConnectLayout);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/OptimizationStatus.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/OptimizationStatus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close-small.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");





const OptimizationStatus = ({
  settings,
  setSettings,
  setCanSave,
  setTab
}) => {
  const {
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      isLoading
    } = select('optimole');
    return {
      isLoading: isLoading()
    };
  }, []);
  const lazyloadEnabled = 'enabled' === settings?.lazyload;
  const imageHandlingEnabled = 'enabled' === settings?.image_replacer;
  const directUpdate = (option, value) => {
    if (setCanSave && setSettings) {
      setCanSave(true);
      const data = {
        ...settings
      };
      data[option] = value ? 'enabled' : 'disabled';
      if ('scale' === option && data.scale && 'disabled' === data.scale && 'disabled' === data.lazyload) {
        data.lazyload = 'enabled';
      }
      if ('lazyload' === option && data.lazyload && 'disabled' === data.lazyload && 'disabled' === data.scale) {
        data.scale = 'enabled';
      }
      setSettings(data);
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_3__.saveSettings)(data, false, false, () => {
        setCanSave(false);
      });
    }
  };
  const handleSettingsNavigation = () => {
    if (setTab) {
      setTab('settings');
    }
  };
  const {
    optimization_status
  } = optimoleDashboardApp.strings;
  const statuses = [{
    settingType: 'image_replacer',
    active: imageHandlingEnabled,
    label: optimization_status.statusTitle1,
    description: optimization_status.statusSubTitle1,
    buttonText: imageHandlingEnabled ? optimization_status.manage : optimization_status.enable
  }, {
    settingType: 'lazyload',
    active: lazyloadEnabled && imageHandlingEnabled,
    label: optimization_status.statusTitle2,
    description: optimization_status.statusSubTitle2,
    buttonText: imageHandlingEnabled ? lazyloadEnabled ? optimization_status.disable : optimization_status.enable : ''
  }, {
    settingType: 'scale',
    active: lazyloadEnabled && 'disabled' === settings?.scale && imageHandlingEnabled,
    label: optimization_status.statusTitle3,
    description: optimization_status.statusSubTitle3,
    buttonText: imageHandlingEnabled ? lazyloadEnabled && 'disabled' === settings?.scale ? optimization_status.disable : optimization_status.enable : ''
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white flex flex-col text-gray-700 border-0 rounded-lg shadow-md p-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-lg mt-0"
  }, optimoleDashboardApp.strings.optimization_status.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "grid gap-3 m-0"
  }, statuses.map((status, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: index,
    className: "flex items-start gap-2 justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-start gap-2"
  }, status.active ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
    className: "fill-success bg-success/20 rounded-full",
    size: 20
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"],
    className: "fill-danger bg-danger/20 rounded-full",
    size: 20
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-700 font-semibold"
  }, status.label), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, status.description))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "link",
    className: "text-info text-sm font-medium",
    style: {
      textDecoration: 'none'
    },
    onClick: () => {
      if ('image_replacer' === status.settingType && status.active) {
        handleSettingsNavigation();
        return;
      }
      if ('scale' === status.settingType) {
        status.active = !status.active;
      }
      if ('disabled' === settings?.image_replacer && 'image_replacer' !== status.settingType) {
        return;
      }
      directUpdate(status.settingType, !status.active);
    },
    isBusy: isLoading,
    disabled: isLoading
  }, status.buttonText)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0 mt-5",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.optimization_tips
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OptimizationStatus);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/SPCRecommendation.js":
/*!*******************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/SPCRecommendation.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_plugin_install__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/plugin-install */ "./assets/src/dashboard/utils/plugin-install.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");







const STATUSES = {
  IDLE: 'idle',
  INSTALLING: 'installing',
  ACTIVATING: 'activating',
  ACTIVE: 'active',
  ERROR: 'error'
};
const SPC_SLUG = 'wp-cloudflare-page-cache';
const SPCRecommendation = () => {
  const {
    i18n,
    activate_url: spcActivateURL,
    banner_dismiss_key: bannerDismissKey,
    status: initialStatus
  } = optimoleDashboardApp.spc_banner;
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('installed' === initialStatus ? STATUSES.INSTALLED : STATUSES.IDLE);
  const [isVisible, setIsVisible] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
  const [shouldRender, setShouldRender] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
  const isLoading = status === STATUSES.INSTALLING || status === STATUSES.ACTIVATING;
  const installActivePlugin = e => {
    e.preventDefault();
    if (status === STATUSES.INSTALLED) {
      setStatus(STATUSES.ACTIVATING);
      (0,_utils_plugin_install__WEBPACK_IMPORTED_MODULE_4__.activatePlugin)(spcActivateURL).then(response => {
        if (response.success) {
          setStatus(STATUSES.ACTIVE);
        } else {
          setStatus(STATUSES.ERROR);
        }
      });
      return;
    }
    setStatus(STATUSES.INSTALLING);
    (0,_utils_plugin_install__WEBPACK_IMPORTED_MODULE_4__.installPlugin)(SPC_SLUG).then(response => {
      if (response.success) {
        setStatus(STATUSES.ACTIVATING);
        (0,_utils_plugin_install__WEBPACK_IMPORTED_MODULE_4__.activatePlugin)(spcActivateURL).then(response => {
          if (response.success) {
            setStatus(STATUSES.ACTIVE);
          } else {
            setStatus(STATUSES.ERROR);
          }
        });
      } else {
        setStatus(STATUSES.ERROR);
      }
    });
  };
  const onDismiss = () => {
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.dismissNotice)(bannerDismissKey, () => {
      setIsVisible(false);
    });
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!isVisible) {
      const timer = setTimeout(() => {
        setShouldRender(false);
      }, 300);
      return () => clearTimeout(timer);
    }
  }, [isVisible]);
  if (!shouldRender) {
    return null;
  }
  const wrapClasses = classnames__WEBPACK_IMPORTED_MODULE_3___default()('bg-white flex flex-col text-gray-700 border-0 rounded-lg overflow-hidden shadow-md relative transition-opacity duration-300', {
    'opacity-0': !isVisible,
    'opacity-100': isVisible
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: wrapClasses
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: onDismiss,
    className: "absolute top-2 right-2 p-1 bg-transparent border-0 text-red z-10 cursor-pointer rounded-full flex items-center justify-center hover:opacity-75 transition-opacity text-gray-500 hover:text-info"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "sr-only"
  }, i18n.dismiss), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"],
    className: "fill-current",
    size: 18
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-8 flex flex-col gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-lg mt-0"
  }, i18n.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-gray-600 m-0"
  }, i18n.byline), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "grid gap-2"
  }, i18n.features.map((feature, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    className: "flex items-center gap-2",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
    className: "fill-info bg-info/20 rounded-full",
    size: 20
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-700 font-normal"
  }, feature)))), ![STATUSES.ACTIVE, STATUSES.ERROR].includes(status) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "primary",
    onClick: installActivePlugin,
    className: "flex w-full justify-center font-bold rounded hover:opacity-90 transition-opacity",
    disabled: isLoading,
    isBusy: isLoading
  }, status === STATUSES.IDLE && i18n.cta, status === STATUSES.INSTALLED && i18n.activate, status === STATUSES.INSTALLING && i18n.installing, status === STATUSES.ACTIVATING && i18n.activating), status === STATUSES.ACTIVE && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-center gap-3 py-3 px-4 rounded-md bg-emerald-100 border border-solid border-emerald-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-medium text-sm text-emerald-700"
  }, i18n.activated)), status === STATUSES.ERROR && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center py-3 px-4 rounded-md bg-red-100 border border-solid border-red-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-medium text-sm text-red-700"
  }, i18n.error))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SPCRecommendation);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/Sidebar.js":
/*!*********************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/Sidebar.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _SPCRecommendation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SPCRecommendation */ "./assets/src/dashboard/parts/connected/SPCRecommendation.js");
/* harmony import */ var _OptimizationStatus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./OptimizationStatus */ "./assets/src/dashboard/parts/connected/OptimizationStatus.js");
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/icons */ "./assets/src/dashboard/utils/icons.js");
/* harmony import */ var _components_Tooltip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/Tooltip */ "./assets/src/dashboard/parts/components/Tooltip.js");

/**
 * WordPress dependencies.
 */







const reasons = [optimoleDashboardApp.strings.upgrade.reason_1, optimoleDashboardApp.strings.upgrade.reason_2, optimoleDashboardApp.strings.upgrade.reason_3, optimoleDashboardApp.strings.upgrade.reason_4];
const Sidebar = ({
  settings,
  setSettings,
  setCanSave,
  setTab
}) => {
  var _optimoleDashboardApp;
  const {
    name,
    domain,
    plan
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getUserData
    } = select('optimole');
    const user = getUserData();
    let domain = user?.cdn_key + '.i.optimole.com';
    if (user?.domain !== undefined && '' !== user?.domain) {
      domain = user?.domain;
    }
    if (user?.domain_dns !== undefined && '' !== user?.domain_dns) {
      domain = user?.domain_dns;
    }
    return {
      name: user?.display_name,
      domain,
      plan: user?.plan
    };
  });
  const showSPCRecommendation = null !== optimoleDashboardApp.spc_banner;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid md:grid-cols-2 xl:flex xl:flex-col xl:mt-8 xl:mb-5 p-0 transition-all ease-in-out duration-700 gap-5 shrink-0 xl:w-[350px]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white gap-3 flex flex-col text-gray-700 border-0 rounded-lg shadow-md p-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid gap-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(PlaceholderInput, {
    icon: _utils_icons__WEBPACK_IMPORTED_MODULE_6__.user,
    value: name,
    tooltipText: optimoleDashboardApp.strings.logged_in_as
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(PlaceholderInput, {
    icon: _utils_icons__WEBPACK_IMPORTED_MODULE_6__.globe,
    value: domain,
    tooltipText: optimoleDashboardApp.strings.private_cdn_url
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "m-0 border-t-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "border-t border-gray-300 block grid gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "font-semibold text-xs text-light-black m-0"
  }, optimoleDashboardApp.strings.looking_for_api_key), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.optml_dashboard
    }
  }))), 'free' === plan ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-info flex flex-col text-white border-0 rounded-lg overflow-hidden shadow-md bg-promo bg-no-repeat",
    style: {
      backgroundImage: `url( ${optimoleDashboardApp.assets_url}/img/logo2.png )`
    }
  }, optimoleDashboardApp?.bf_notices?.sidebar && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: optimoleDashboardApp.bf_notices.sidebar.cta_link,
    className: "flex flex-col gap-3 p-3 bg-black !no-underline text-center cursor-pointer hover:opacity-90 transition-opacity",
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-extrabold text-[17px] uppercase italic",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.bf_notices.sidebar.title
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-[11px] font-bold",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.bf_notices.sidebar.subtitle
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-8 flex flex-col"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "mt-0 text-white text-lg"
  }, optimoleDashboardApp.strings.upgrade.title_long), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, reasons.map((reason, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: index,
    className: "flex items-center gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "yes-alt",
    className: "text-white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-white font-normal text-base"
  }, reason)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "link",
    className: "optml__button flex w-full justify-center font-bold min-h-40 !no-underline !text-white !bg-opaque-black !rounded",
    href: (_optimoleDashboardApp = optimoleDashboardApp?.bf_notices?.sidebar?.cta_link) !== null && _optimoleDashboardApp !== void 0 ? _optimoleDashboardApp : optimoleDashboardApp.upgrade_url,
    target: "_blank"
  }, optimoleDashboardApp.strings.upgrade.cta))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "default",
    className: "bg-white flex font-bold border-0 rounded-lg shadow-md p-8 text-sm justify-center",
    href: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_3__.addQueryArgs)(optimoleDashboardApp.optimoleHome + 'contact/', {
      contact_name: window.optimoleDashboardApp.user_data.display_name,
      contact_email: optimoleDashboardApp.user_data.user_email,
      contact_website: optimoleDashboardApp.home_url
    }),
    target: "_blank"
  }, optimoleDashboardApp.strings.premium_support), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_OptimizationStatus__WEBPACK_IMPORTED_MODULE_5__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave,
    setTab: setTab
  }), showSPCRecommendation && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_SPCRecommendation__WEBPACK_IMPORTED_MODULE_4__["default"], null));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sidebar);
const PlaceholderInput = ({
  icon = null,
  value,
  tooltipText = ''
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Tooltip__WEBPACK_IMPORTED_MODULE_7__["default"], {
    text: tooltipText
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 text-gray-700 hover:text-info transition-all ease-in-out duration-300"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    value: value,
    type: "text",
    disabled: true,
    className: "col-start-1 row-start-1 block w-full rounded-md !bg-light-blue py-1.5 !pl-9 pr-3 !text-gray-500 !m-0 text-sm !py-0.5 !border-0"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "pointer-events-none col-start-1 row-start-1 flex items-center ml-3 w-4 h-4 self-center"
  }, icon)));
};

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/Toasts.js":
/*!********************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/Toasts.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/notices */ "@wordpress/notices");
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_notices__WEBPACK_IMPORTED_MODULE_4__);





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  const notices = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_wordpress_notices__WEBPACK_IMPORTED_MODULE_4__.store).getNotices(), []);
  const {
    removeNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_wordpress_notices__WEBPACK_IMPORTED_MODULE_4__.store);
  const snackbarNotices = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.filter)(notices, {
    type: 'snackbar'
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SnackbarList, {
    notices: snackbarNotices,
    className: "px-2 bottom-4 fixed",
    onRemove: removeNotice
  });
}
;

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/conflicts/ConflictItem.js":
/*!************************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/conflicts/ConflictItem.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");

/**
 * External dependencies.
 */



/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */

const ConflictItem = ({
  conflict
}) => {
  const [isLoading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const dismiss = () => {
    setLoading(true);
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.dismissConflict)(conflict.id, () => {
      setLoading(false);
    });
  };
  const getBorderColor = () => {
    if ('high' === conflict.severity) {
      return '#E77777';
    } else if ('medium' === conflict.severity) {
      return '#577BF9';
    }
    return '#5F9D61';
  };
  const noticeStyles = {
    border: '1px solid #c3c4c7',
    borderLeftWidth: '4px',
    borderLeftColor: getBorderColor(),
    margin: '5px 0 15px',
    padding: '12px',
    paddingRight: '38px',
    position: 'relative'
  };
  const messageStyles = {
    margin: '0',
    padding: '2px',
    lineHeight: '1.5',
    fontSize: '15px'
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: noticeStyles
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    style: messageStyles,
    dangerouslySetInnerHTML: {
      __html: conflict.message
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    icon: isLoading ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"] : 'no-alt',
    label: optimoleDashboardApp.strings.conflicts.conflict_close,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('text-black hover:text-black', {
      'animate-spin': isLoading
    }),
    onClick: dismiss,
    style: {
      position: 'absolute',
      top: '8px',
      right: '8px'
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConflictItem);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/conflicts/index.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/conflicts/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ConflictItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ConflictItem */ "./assets/src/dashboard/parts/connected/conflicts/ConflictItem.js");

/**
 * WordPress dependencies.
 */


/**
 * Internal dependencies.
 */

const Conflicts = () => {
  const {
    conflicts
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      getConflicts
    } = select('optimole');
    const conflicts = getConflicts();
    return {
      conflicts: conflicts.conflicts || []
    };
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-8 border-0 rounded-lg shadow-md"
  }, Boolean(conflicts.length) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, optimoleDashboardApp.strings.conflicts.title), conflicts.map(conflict => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_ConflictItem__WEBPACK_IMPORTED_MODULE_2__["default"], {
    key: conflict.id,
    conflict: conflict
  }))), !Boolean(conflicts.length) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center py-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.conflicts.no_conflicts_found
    }
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Conflicts);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/dashboard/LastImages.js":
/*!**********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/dashboard/LastImages.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var usehooks_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! usehooks-ts */ "./node_modules/usehooks-ts/dist/esm/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/ProgressBar */ "./assets/src/dashboard/parts/components/ProgressBar.js");

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */


const isInitialLoading = 'yes' !== optimoleDashboardApp.connection_status;
const Image = ({
  src,
  oldSize,
  newSize
}) => {
  const [squareRef, {
    width
  }] = (0,usehooks_ts__WEBPACK_IMPORTED_MODULE_1__.useElementSize)();
  const getSize = () => {
    let value = ((1 - newSize / oldSize) * 100).toFixed(1);
    if (1 > value) {
      return '1';
    }
    if (100 < value) {
      return (Math.floor(value / 10 + 10) / 10).toFixed(1).toString();
    }
    return value.toString();
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "basis-1/4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: src,
    className: "w-full border border-slate-200 rounded-md border-solid",
    style: {
      height: width
    },
    ref: squareRef
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "optml__bullet w-full h-4"
  }, optimoleDashboardApp.strings.latest_images.percentage_saved.replace('{ratio}', getSize()), " "));
};
const ImagePlaceholder = () => {
  const [squareRef, {
    width
  }] = (0,usehooks_ts__WEBPACK_IMPORTED_MODULE_1__.useElementSize)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "basis-1/4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml__loader w-full rounded-md",
    style: {
      height: width
    },
    ref: squareRef
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "optml__loader w-full h-4"
  }));
};
const LastImages = () => {
  const [isLoaded, setIsLoaded] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const [progress, setProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
  const [step, setStep] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
  const [timer, setTimer] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
  const maxTime = 20;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (timer <= maxTime) {
      setTimeout(() => {
        updateProgress();
      }, 1000);
    }
  }, [timer]);
  const {
    images
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getOptimizedImages
    } = select('optimole');
    return {
      images: getOptimizedImages() || []
    };
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (8 <= images.length) {
      setIsLoaded(true);
      return;
    }
    if (!isLoaded && !isInitialLoading) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.retrieveOptimizedImages)(() => {
        setIsLoaded(true);
      });
    }
  }, []);
  const updateProgress = () => {
    setTimer(timer + 1);
    if (timer >= maxTime) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.retrieveOptimizedImages)(() => {
        setIsLoaded(true);
        setTimer(0);
        setStep(0);
        setProgress(0);
        (0,_utils_api__WEBPACK_IMPORTED_MODULE_4__.requestStatsUpdate)();
      });
      return;
    }
    setProgress(Math.floor(timer / maxTime * 100));
    if (progress > (step + 1) * 30) {
      setStep(step + 1);
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-gray-800 text-xl font-semibold mb-5 m-0"
  }, optimoleDashboardApp.strings.latest_images.last_optimized_images), isInitialLoading && !isLoaded && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center flex-col py-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "font-semibold"
  }, optimoleDashboardApp.strings.latest_images.loading_latest_images), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_ProgressBar__WEBPACK_IMPORTED_MODULE_5__["default"], {
    max: maxTime,
    value: timer
  })), !isInitialLoading && !isLoaded && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between mt-5 gap-5"
  }, [...Array(4)].map((_, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(ImagePlaceholder, {
    key: index
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between mt-5 gap-5"
  }, [...Array(4)].map((_, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(ImagePlaceholder, {
    key: `placeholder-2-${index}`
  })))), isLoaded && 4 > images?.length && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center py-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.latest_images.no_images_found
    }
  })), isLoaded && 4 <= images?.length && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between mt-5 gap-5"
  }, [...Array(4)].map((i, key) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Image, {
      key: key,
      src: images[key].url,
      oldSize: images[key].ex_size_raw,
      newSize: images[key].new_size_raw
    });
  })), 8 <= images?.length && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between mt-5 gap-5"
  }, [...Array(4)].map((i, key) => {
    key = key + 4;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Image, {
      key: key,
      src: images[key].url,
      oldSize: images[key].ex_size_raw,
      newSize: images[key].new_size_raw
    });
  }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LastImages);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/dashboard/index.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/dashboard/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/warning.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/external.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/icons */ "./assets/src/dashboard/utils/icons.js");
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/ProgressBar */ "./assets/src/dashboard/parts/components/ProgressBar.js");
/* harmony import */ var _LastImages__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./LastImages */ "./assets/src/dashboard/parts/connected/dashboard/LastImages.js");

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */







/**
 * Internal dependencies.
 */



const cardClasses = 'flex p-6 bg-light-blue border border-blue-300 rounded-md';
const settingsTab = {
  offload_image: 1,
  advance: 2
};
const navigate = tabId => {
  const links = window.optimoleDashboardApp.submenu_links;
  const settingsLink = links.find(link => '#settings' === link.hash);
  if (settingsLink) {
    const existingLink = document.querySelector(`a[href="${settingsLink.href}"]`);
    existingLink.click();
    setTimeout(() => {
      const tabItems = document.querySelectorAll('.optml-settings ul li');
      tabItems[tabId]?.querySelector('button').click();
      window.scrollTo(0, 0);
    }, 500);
  }
};
const quickactions = [{
  icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.bolt,
  title: optimoleDashboardApp.strings.quick_actions.speed_test_title,
  description: optimoleDashboardApp.strings.quick_actions.speed_test_desc,
  link: optimoleDashboardApp.strings.quick_actions.speed_test_link,
  value: 'speedTest'
}, {
  icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.update,
  title: optimoleDashboardApp.strings.quick_actions.clear_cache_images,
  description: optimoleDashboardApp.strings.quick_actions.clear_cache,
  value: _utils_api__WEBPACK_IMPORTED_MODULE_6__.clearCache
}, {
  icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.offloadImage,
  title: optimoleDashboardApp.strings.quick_actions.offload_images,
  description: optimoleDashboardApp.strings.quick_actions.offload_images_desc,
  value: () => navigate(settingsTab.offload_image)
}, {
  icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.settings,
  title: optimoleDashboardApp.strings.quick_actions.advance_settings,
  description: optimoleDashboardApp.strings.quick_actions.configure_settings,
  value: () => navigate(settingsTab.advance)
}];
const InactiveWarning = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "flex gap-2 bg-warning text-danger border border-solid border-danger rounded relative px-6 py-5 mb-5"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
  className: "fill-current",
  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"]
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
  className: "m-0",
  dangerouslySetInnerHTML: {
    __html: optimoleDashboardApp.strings.notice_disabled_account
  }
}));
const ActivatedNotice = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "flex gap-2 bg-success text-white rounded relative px-6 py-5 mb-5"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
  icon: "cloud-saved"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
  className: "m-0",
  dangerouslySetInnerHTML: {
    __html: optimoleDashboardApp.strings.notice_just_activated
  }
}));
const Dashboard = () => {
  const {
    userData,
    userStatus
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    const {
      getUserData,
      getUserStatus
    } = select('optimole');
    return {
      userData: getUserData(),
      userStatus: getUserStatus()
    };
  });
  const availableMetrics = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    const metrics = [{
      icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.arrowDownToLine,
      label: optimoleDashboardApp.strings.metrics.metricsTitle2,
      description: optimoleDashboardApp.strings.metrics.metricsSubtitle2,
      value: 'saved_size',
      hasButton: true,
      buttonText: optimoleDashboardApp.strings.metrics.adjust_compression
    }, {
      icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.chartBarDecreasing,
      label: optimoleDashboardApp.strings.metrics.metricsTitle3,
      description: optimoleDashboardApp.strings.metrics.metricsSubtitle3,
      value: 'compression_percentage',
      hasButton: true,
      buttonText: optimoleDashboardApp.strings.metrics.adjust_compression
    }, {
      icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.globe,
      label: optimoleDashboardApp.strings.metrics.metricsTitle4,
      description: optimoleDashboardApp.strings.metrics.metricsSubtitle4,
      value: 'traffic',
      hasButton: true,
      buttonText: optimoleDashboardApp.strings.metrics.view_analytics
    }];
    if (userData?.can_use_offloading) {
      metrics.push({
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_7__.cloudDownload,
        label: optimoleDashboardApp.strings.metrics.metricsTitle5,
        description: optimoleDashboardApp.strings.metrics.metricsSubtitle5,
        value: 'offloaded_images',
        hasButton: true,
        buttonText: optimoleDashboardApp.strings.metrics.manage_offloading
      });
    }
    return metrics;
  }, [userData]);
  const visitorsLimitPercent = (userData.visitors / userData.visitors_limit * 100).toFixed(0);
  const renewalDate = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    return userData.renews_on_formatted;
  }, [userData.renews_on]);
  const formatMetric = (type, value) => {
    let formattedValue = 0;
    let unit = '';

    // Fallback for missing data
    if (undefined === value) {
      if ('saved_size' === type) {
        value = Math.floor(Math.random() * 2500000) + 500000; // Mock KB
      } else if ('traffic' === type) {
        value = Math.floor(Math.random() * 2500) + 500; // Mock MB
      } else if ('offloaded_images' === type) {
        value = Math.floor(Math.random() * 500) + 50; // Mock images count
      } else {
        value = Math.floor(Math.random() * 40) + 10; // Mock Percentage
      }
    }

    switch (type) {
      case 'compression_percentage':
        formattedValue = parseFloat(value).toFixed(2);
        unit = '%';
        break;
      case 'saved_size':
        // Assuming value is in KB
        const sizeInMB = value / 1000;
        if (1000 > sizeInMB) {
          formattedValue = sizeInMB.toFixed(2);
          unit = 'MB';
        } else if (1000000 > sizeInMB) {
          formattedValue = (sizeInMB / 1000).toFixed(2);
          unit = 'GB';
        } else {
          formattedValue = (sizeInMB / 1000000).toFixed(2);
          unit = 'TB';
        }
        break;
      case 'traffic':
        // Assuming value is in MB
        if (1000 > value) {
          formattedValue = parseFloat(value).toFixed(2);
          unit = 'MB';
        } else if (1000000 > value) {
          formattedValue = (value / 1000).toFixed(2);
          unit = 'GB';
        } else {
          formattedValue = (value / 1000000).toFixed(2);
          unit = 'TB';
        }
        break;
      case 'offloaded_images':
        formattedValue = parseInt(value);
        unit = 1 === formattedValue ? optimoleDashboardApp.strings.metrics.image : optimoleDashboardApp.strings.metrics.images;
        break;
      default:
        formattedValue = parseFloat(value).toFixed(2);
        unit = '';
    }
    return {
      formattedValue,
      unit
    };
  };
  const getMetricButtonAction = metricValue => {
    switch (metricValue) {
      case 'saved_size':
        return {
          onClick: () => navigate(settingsTab.advance)
        };
      case 'compression_percentage':
        return {
          onClick: () => navigate(settingsTab.advance)
        };
      case 'traffic':
        return {
          href: window.optimoleDashboardApp.optimoleDashMetrics,
          target: '_blank'
        };
      case 'offloaded_images':
        return {
          onClick: () => navigate(settingsTab.offload_image)
        };
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid gap-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-8 border-0 rounded-lg shadow-md"
  }, 0 < optimoleDashboardApp.strings.notice_just_activated.length && 'active' === userStatus && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(ActivatedNotice, null), 'inactive' === userStatus && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(InactiveWarning, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "pb-6 gap-6 flex-col sm:flex-row items-start"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col md:flex-row gap-3 w-full justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-800 text-xl font-semibold"
  }, optimoleDashboardApp.strings.dashboard_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-600 text-base flex items-center gap-1"
  }, optimoleDashboardApp.strings.quota, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-800 font-bold"
  }, userData.visitors_pretty, " / ", userData.visitors_limit_pretty), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    text: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "p-2.5 max-w-[320px]"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "font-bold mb-2"
    }, optimoleDashboardApp.strings.tooltip_visits_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.sprintf)(optimoleDashboardApp.strings.tooltip_visits_description, renewalDate))),
    placement: "bottom"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "inline-flex items-center cursor-help ml-1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"],
    size: 18,
    className: "text-gray-400 hover:text-gray-600"
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "md:w-20 grow md:grow-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_ProgressBar__WEBPACK_IMPORTED_MODULE_8__["default"], {
    value: userData.visitors,
    max: userData.visitors_limit
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, visitorsLimitPercent, "%"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-500 text-sm ml-2"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.sprintf)(optimoleDashboardApp.strings.renew_date, renewalDate))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(cardClasses, 'gap-8 flex-col sm:flex-row items-start sm:items-center')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-700 text-lg font-semibold"
  }, optimoleDashboardApp.strings.banner_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-600 text-sm"
  }, optimoleDashboardApp.strings.banner_description))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex pt-5 gap-5 flex-col md:flex-row"
  }, availableMetrics.map(metric => {
    const rawValue = userData[metric.value];
    const {
      formattedValue,
      unit
    } = formatMetric(metric.value, rawValue);
    const buttonAction = getMetricButtonAction(metric.value);
    const showButton = 'free' !== userData.plan && metric.hasButton;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: metric.value,
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('p-3 basis-1/3 flex-col items-start border rounded-md border-solid bg-white border-gray-300')
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex w-full flex-col"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex flex-row items-center gap-2 mb-2"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: metric.icon,
      size: 16,
      className: "text-info"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-sm text-gray-500"
    }, metric.label)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-end gap-1"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-2xl text-black font-bold"
    }, formattedValue), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-sm text-gray-500"
    }, unit)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `font-normal text-gray-600 ${showButton ? 'mb-3' : ''}`
    }, metric.description), showButton && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      variant: "secondary",
      size: "small",
      className: "mt-auto font-semibold rounded-md w-fit px-3 flex items-center gap-1",
      ...buttonAction
    }, metric.buttonText, 'traffic' === metric.value && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__["default"],
      size: 16
    }))));
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-8 border-0 rounded-lg shadow-md"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-gray-800 text-xl font-semibold mb-5"
  }, optimoleDashboardApp.strings.quick_action_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid md:grid-cols-2 gap-5"
  }, quickactions.map((action, index) => {
    const TAG = 'speedTest' === action.value ? 'a' : 'button';
    const additionalProps = 'speedTest' === action.value ? {
      href: action.link,
      target: '_blank'
    } : {
      onClick: () => {
        action.value();
      }
    };
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(TAG, {
      key: index,
      className: "flex items-center gap-3 p-4 bg-gray-50 rounded-lg hover:bg-light-blue hover:bg-info hover:border-info transition-background duration-300 group shadow-none border-gray-200 border border-solid cursor-pointer",
      ...additionalProps
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: action.icon,
      className: "text-info"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex flex-col items-start gap-1"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "font-medium text-base text-gray-800"
    }, action.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-info text-sm font-medium hover:text-info"
    }, action.description)));
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-8 border-0 rounded-lg shadow-md hidden lg:block"
  }, 'yes' !== optimoleDashboardApp.remove_latest_images && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_LastImages__WEBPACK_IMPORTED_MODULE_9__["default"], null)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashboard);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/help/index.js":
/*!************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/help/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/lifesaver.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/comment-content.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/format-list-bullets.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */

const HELP_SECTION = [{
  title: optimoleDashboardApp.strings.help.get_support_title,
  description: optimoleDashboardApp.strings.help.get_support_desc,
  cta: optimoleDashboardApp.strings.help.get_support_cta,
  link: 'https://wordpress.org/support/plugin/optimole-wp/',
  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
}, {
  title: optimoleDashboardApp.strings.help.feat_request_title,
  description: optimoleDashboardApp.strings.help.feat_request_desc,
  cta: optimoleDashboardApp.strings.help.feat_request_cta,
  link: 'https://github.com/Codeinwp/optimole-wp/discussions',
  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"]
}, {
  title: optimoleDashboardApp.strings.help.feedback_title,
  description: optimoleDashboardApp.strings.help.feedback_desc,
  cta: optimoleDashboardApp.strings.help.feedback_cta,
  link: 'https://wordpress.org/plugins/optimole-wp/#developers',
  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"]
}];
const DOCS_SECTION = [{
  title: optimoleDashboardApp.strings.help.account_title,
  items: [{
    label: optimoleDashboardApp.strings.help.account_item_one,
    value: 'https://docs.optimole.com/article/1134-how-optimole-counts-the-number-of-visitors'
  }, {
    label: optimoleDashboardApp.strings.help.account_item_two,
    value: 'https://docs.optimole.com/article/1008-what-happens-if-i-exceed-plan-limits'
  }, {
    label: optimoleDashboardApp.strings.help.account_item_three,
    value: 'https://docs.optimole.com/article/1133-visitors-based-plan'
  }]
}, {
  title: optimoleDashboardApp.strings.help.image_processing_title,
  items: [{
    label: optimoleDashboardApp.strings.help.image_processing_item_one,
    value: 'https://docs.optimole.com/article/1173-how-to-get-started-with-optimole-in-just-3-steps'
  }, {
    label: optimoleDashboardApp.strings.help.image_processing_item_two,
    value: 'https://docs.optimole.com/article/1068-how-optimole-can-serve-webp-images'
  }, {
    label: optimoleDashboardApp.strings.help.image_processing_item_three,
    value: 'https://docs.optimole.com/article/1475-adding-watermarks-to-your-images'
  }]
}, {
  title: optimoleDashboardApp.strings.help.api_title,
  items: [{
    label: optimoleDashboardApp.strings.help.api_item_one,
    value: 'https://docs.optimole.com/article/1323-cloud-library-browsing'
  }, {
    label: optimoleDashboardApp.strings.help.api_item_two,
    value: 'https://docs.optimole.com/article/1191-exclude-from-optimizing-or-lazy-loading'
  }, {
    label: optimoleDashboardApp.strings.help.api_item_three,
    value: 'https://docs.optimole.com/article/1307-custom-integration'
  }]
}];
const cardClasses = 'flex p-6 border-2 border-solid border-grayish-blue rounded-md items-start gap-8 basis-1/3';
const Help = () => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-8 border-0 rounded-lg shadow-md"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "font-bold text-base"
  }, optimoleDashboardApp.strings.help.section_one_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-5 flex-col md:flex-row"
  }, HELP_SECTION.map((card, i) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: i,
      className: cardClasses
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex w-full flex-col gap-2"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: card.icon,
      className: "fill-info",
      size: 42
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "font-bold text-base py-2 text-gray-800"
    }, card.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "not-italic font-normal text-s text-gray-800"
    }, card.description), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ExternalLink, {
      href: card.link
    }, card.cta)));
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "font-bold text-base"
  }, optimoleDashboardApp.strings.help.section_two_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ExternalLink, {
    href: "https://docs.optimole.com/"
  }, optimoleDashboardApp.strings.help.section_two_sub)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-5 flex-col md:flex-row"
  }, DOCS_SECTION.map((card, i) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: i,
      className: cardClasses
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex w-full flex-col gap-2"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "font-bold text-base py-2 text-gray-800"
    }, card.title), card.items.map((item, i) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        key: i,
        href: item.value,
        target: "_blank"
      }, item.label);
    })));
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Help);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/index.js":
/*!*******************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _dashboard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dashboard */ "./assets/src/dashboard/parts/connected/dashboard/index.js");
/* harmony import */ var _conflicts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./conflicts */ "./assets/src/dashboard/parts/connected/conflicts/index.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./settings */ "./assets/src/dashboard/parts/connected/settings/index.js");
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./help */ "./assets/src/dashboard/parts/connected/help/index.js");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Sidebar */ "./assets/src/dashboard/parts/connected/Sidebar.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _components_BlackFridayBanner__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/BlackFridayBanner */ "./assets/src/dashboard/parts/components/BlackFridayBanner.js");

/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */







const ConnectedLayout = ({
  tab,
  setTab
}) => {
  const {
    isConnected,
    hasApplication,
    hasConflicts,
    siteSettings,
    extraVisits,
    plan
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      isConnected,
      hasApplication,
      getConflicts,
      getSiteSettings,
      getUserData
    } = select('optimole');
    const conflicts = getConflicts();
    const siteSettings = getSiteSettings();
    const user = getUserData();
    return {
      plan: user?.plan,
      isConnected: isConnected(),
      hasApplication: hasApplication(),
      hasConflicts: 0 < conflicts.count || 0,
      siteSettings,
      extraVisits: siteSettings['banner_frontend']
    };
  });
  const {
    setQueryArgs
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)('optimole');
  const [showConflicts, setShowConflicts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const [menu, setMenu] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('general');
  const [canSave, setCanSave] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const [settings, setSettings] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(siteSettings);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (isConnected && hasApplication) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_8__.retrieveConflicts)();
    }
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (hasConflicts) {
      setShowConflicts(true);
    }
  }, [hasConflicts]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    setSettings({
      ...settings,
      banner_frontend: extraVisits
    });
  }, [extraVisits]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    // Confirmation message saying changes might not be saved if user leaves the page.
    if (canSave) {
      window.onbeforeunload = () => true;
    } else {
      window.onbeforeunload = null;
    }
  }, [canSave]);
  const showBFBanner = Boolean(optimoleDashboardApp?.bf_notices?.banner);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml-connected 2xl:max-w-screen-xl max-w-screen px-4 mx-auto"
  }, showBFBanner && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_BlackFridayBanner__WEBPACK_IMPORTED_MODULE_9__["default"], null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col xl:flex-row mx-auto gap-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col mt-8 xl:mb-5 p-0 transition-all ease-in-out duration-700 relative text-gray-700 grow"
  }, 'dashboard' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dashboard__WEBPACK_IMPORTED_MODULE_3__["default"], null), 'conflicts' === tab && showConflicts && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_conflicts__WEBPACK_IMPORTED_MODULE_4__["default"], null), 'settings' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_settings__WEBPACK_IMPORTED_MODULE_5__["default"], {
    tab: menu,
    setTab: setMenu,
    canSave: canSave,
    setCanSave: setCanSave,
    settings: settings,
    setSettings: setSettings
  }), 'help' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_help__WEBPACK_IMPORTED_MODULE_6__["default"], null)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Sidebar__WEBPACK_IMPORTED_MODULE_7__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave,
    setTab: setTab
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConnectedLayout);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/CloudLibrary.js":
/*!***********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/CloudLibrary.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CloudLibrary)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js");

/* global optimoleDashboardApp */




function CloudLibrary(props) {
  const {
    user_data,
    strings
  } = optimoleDashboardApp;
  const {
    options_strings
  } = strings;
  const {
    settings,
    setSettings,
    setCanSave
  } = props;
  const storeData = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isLoading,
      isSubApiKey
    } = select('optimole');
    return {
      isLoading: isLoading(),
      isSubApiKey: isSubApiKey()
    };
  }, []);
  const {
    isLoading,
    isSubApiKey
  } = storeData;
  const isCloudLibraryEnabled = 'disabled' !== settings['cloud_images'];
  const showSiteSelector = !isSubApiKey && isCloudLibraryEnabled;
  const whitelistedDomains = user_data.whitelist || [];
  const updateOption = (option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data[option] = value ? 'enabled' : 'disabled';
    setSettings(data);
  };
  const updateSites = value => {
    setCanSave(true);
    const sites = {};
    const data = {
      ...settings
    };
    if (0 === value.length) {
      sites.all = 'true';
    } else {
      value.forEach(site => {
        sites[site] = 'true';
      });
    }
    Object.keys(data['cloud_sites']).forEach(site => {
      if (!Object.prototype.hasOwnProperty.call(sites, site)) {
        sites[site] = 'false';
      }
    });
    data['cloud_sites'] = sites;
    setSettings(data);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: options_strings.enable_cloud_images_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: options_strings.enable_cloud_images_desc
      }
    }),
    checked: isCloudLibraryEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('cloud_images', value)
  }), isCloudLibraryEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "m-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: options_strings.cloud_library_btn_link,
    className: "font-semibold text-info text-sm hover:text-info inline-flex items-center"
  }, options_strings.cloud_library_btn_text, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
    className: "inline-block ml-2 fill-current"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), showSiteSelector && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
    label: options_strings.cloud_site_title,
    help: options_strings.cloud_site_desc
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml__token__base flex p-6 bg-light-blue border border-blue-300 rounded-md items-center gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormTokenField, {
    value: Object.keys(settings['cloud_sites']).filter(site => 'all' !== site && 'false' !== settings['cloud_sites'][site]).map(site => site) || [],
    suggestions: whitelistedDomains,
    onChange: updateSites,
    __experimentalExpandOnFocus: true,
    __experimentalShowHowTo: false,
    __experimentalValidateInput: newValue => whitelistedDomains.includes(newValue),
    className: "optml__token"
  }))));
}

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Compression.js":
/*!**********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Compression.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_compare_image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-compare-image */ "./node_modules/react-compare-image/dist/bundle.js");
/* harmony import */ var react_compare_image__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_compare_image__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/ProgressBar */ "./assets/src/dashboard/parts/components/ProgressBar.js");

/**
 * External dependencies.
 */




/**
 * WordPress dependencies.
 */




/**
 * Internal dependencies.
 */


const Compression = ({
  settings,
  setSettings,
  setCanSave,
  showSample,
  isSampleLoading,
  setIsSampleLoading
}) => {
  const getQuality = value => {
    if ('number' === typeof value) {
      return value;
    }
    if ('auto' === value || 'mauto' === value) {
      return 80;
    }
    if ('high_c' === value) {
      return 90;
    }
    if ('medium_c' === value) {
      return 75;
    }
    if ('low_c' === value) {
      return 55;
    }
    return 80;
  };
  const {
    sampleImages,
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    const {
      getSampleRate,
      isLoading
    } = select('optimole');
    return {
      sampleImages: getSampleRate(),
      isLoading: isLoading()
    };
  });
  const isNetworkOptimizationEnabled = 'disabled' !== settings['network_optimization'];
  const isCDNEnabled = 'disabled' !== settings.cdn;
  const isStripMetadataEnabled = 'disabled' !== settings['strip_metadata'];
  const isAutoQualityEnabled = 'disabled' !== settings.autoquality;
  const isBestFormatEnabled = 'disabled' !== settings['best_format'];
  const compressionMode = settings['compression_mode'];
  const isRetinaEnabled = 'disabled' !== settings['retina_images'];
  const updateOption = (option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data[option] = value ? 'enabled' : 'disabled';
    setSettings(data);
  };
  const loadSample = () => {
    setIsSampleLoading(true);
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_6__.sampleRate)({
      quality: settings.quality,
      force: 'yes'
    }, () => setIsSampleLoading(false));
  };
  const updateQuality = value => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data.quality = value;
    setSettings(data);
  };
  const getCompressionRatio = () => {
    if (sampleImages.optimized_size > sampleImages.original_size) {
      return Math.floor(Math.random() * 60) + 10;
    }
    return (parseFloat(sampleImages.optimized_size / sampleImages.original_size) * 100).toFixed(0);
  };
  let customSettings = {};
  const saveCustomSettings = () => {
    customSettings = {
      best_format: 'enabled' === settings.best_format ? true : false,
      retina_images: 'enabled' === settings.retina_images ? true : false,
      network_optimization: 'enabled' === settings.network_optimization ? true : false,
      avif: 'enabled' === settings.avif ? true : false,
      strip_metadata: 'enabled' === settings.strip_metadata ? true : false,
      autoquality: 'enabled' === settings.autoquality ? true : false
    };
  };
  const transformCompressionMode = value => {
    if ('custom' === compressionMode && 'custom' !== value) {
      //If user already changed those before, we need to save them so if he switch back to custom, we can use the old settings
      saveCustomSettings();
    }
    setCanSave(true);
    const data = {
      ...settings
    };
    if ('speed_optimized' === value) {
      data['best_format'] = 'enabled';
      data['retina_images'] = 'disabled';
      data['network_optimization'] = 'enabled';
      data.avif = 'enabled';
      data.autoquality = 'enabled';
      data['strip_metadata'] = 'enabled';
    }
    if ('quality_optimized' === value) {
      data['best_format'] = 'enabled';
      data['retina_images'] = 'enabled';
      data['network_optimization'] = 'disabled';
      data.avif = 'enabled';
      data.autoquality = 'enabled';
      data['strip_metadata'] = 'enabled';
    }
    if ('custom' === value) {
      var _customSettings$best_, _customSettings$retin, _customSettings$netwo, _customSettings$autoq, _customSettings$strip;
      data['best_format'] = ((_customSettings$best_ = customSettings.best_format) !== null && _customSettings$best_ !== void 0 ? _customSettings$best_ : isBestFormatEnabled) ? 'enabled' : 'disabled';
      data['retina_images'] = ((_customSettings$retin = customSettings.retina_images) !== null && _customSettings$retin !== void 0 ? _customSettings$retin : isRetinaEnabled) ? 'enabled' : 'disabled';
      data['network_optimization'] = ((_customSettings$netwo = customSettings.network_optimization) !== null && _customSettings$netwo !== void 0 ? _customSettings$netwo : isNetworkOptimizationEnabled) ? 'enabled' : 'disabled';
      data.autoquality = ((_customSettings$autoq = customSettings.autoquality) !== null && _customSettings$autoq !== void 0 ? _customSettings$autoq : isAutoQualityEnabled) ? 'enabled' : 'disabled';
      data['strip_metadata'] = ((_customSettings$strip = customSettings.strip_metadata) !== null && _customSettings$strip !== void 0 ? _customSettings$strip : isStripMetadataEnabled) ? 'enabled' : 'disabled';
    }
    data.compression_mode = value;
    setSettings(data);
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (showSample) {
      loadSample();
    }
  }, [showSample]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalToggleGroupControl, {
    className: " w-4/6",
    "aria-label": optimoleDashboardApp.strings.options_strings.compression_mode,
    onChange: value => transformCompressionMode(value),
    value: compressionMode,
    label: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "mb-4"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, optimoleDashboardApp.strings.options_strings.compression_mode))
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalToggleGroupControlOption, {
    className: "bg-blue-500",
    label: optimoleDashboardApp.strings.options_strings.compression_mode_speed_optimized,
    value: "speed_optimized"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalToggleGroupControlOption, {
    label: optimoleDashboardApp.strings.options_strings.compression_mode_quality_optimized,
    value: "quality_optimized"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalToggleGroupControlOption, {
    label: optimoleDashboardApp.strings.options_strings.compression_mode_custom,
    value: "custom"
  })), 'speed_optimized' === compressionMode && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-gray-600 mb-20"
  }, optimoleDashboardApp.strings.options_strings.compression_mode_speed_optimized_desc), 'quality_optimized' === compressionMode && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-gray-600 mb-20"
  }, optimoleDashboardApp.strings.options_strings.compression_mode_quality_optimized_desc), 'custom' === compressionMode && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-gray-600 mb-10"
  }, optimoleDashboardApp.strings.options_strings.compression_mode_custom_desc)), 'custom' === compressionMode && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.best_format_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.best_format_desc
      }
    }),
    checked: isBestFormatEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('best_format', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_retina_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.enable_retina_desc
      }
    }),
    checked: isRetinaEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('retina_images', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_network_opt_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.enable_network_opt_desc
      }
    }),
    checked: isNetworkOptimizationEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('network_optimization', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.toggle_cdn,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.cdn_desc
      }
    }),
    checked: isCDNEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('cdn', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.strip_meta_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.strip_meta_desc
      }
    }),
    checked: isStripMetadataEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('strip_metadata', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.BaseControl, {
    help: !isAutoQualityEnabled && optimoleDashboardApp.strings.options_strings.quality_desc
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.quality_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.ml_quality_desc
      }
    }),
    checked: isAutoQualityEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('autoquality', value)
  })), !isAutoQualityEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.RangeControl, {
    value: getQuality(settings.quality),
    min: 50,
    max: 100,
    step: 1,
    withInputField: false,
    marks: [{
      value: 55,
      label: optimoleDashboardApp.strings.options_strings.low_q_title
    }, {
      value: 75,
      label: optimoleDashboardApp.strings.options_strings.medium_q_title
    }, {
      value: 90,
      label: optimoleDashboardApp.strings.options_strings.high_q_title
    }],
    onChange: updateQuality
  }), showSample && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-center w-full text-center"
  }, isSampleLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base"
  }, optimoleDashboardApp.strings.options_strings.sample_image_loading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
    className: "animate-spin"
  })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, sampleImages.id && 0 < sampleImages.original_size && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, 0 < getCompressionRatio() ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base"
  }, optimoleDashboardApp.strings.latest_images.percentage_smaller.replace('{ratio}', 100 - getCompressionRatio())) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base"
  }, optimoleDashboardApp.strings.latest_images.same_size), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_ProgressBar__WEBPACK_IMPORTED_MODULE_7__["default"], {
    max: 100,
    value: 100 - getCompressionRatio()
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-4 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)((react_compare_image__WEBPACK_IMPORTED_MODULE_2___default()), {
    leftImageLabel: optimoleDashboardApp.strings.options_strings.image_1_label,
    rightImageLabel: optimoleDashboardApp.strings.options_strings.image_2_label,
    leftImage: sampleImages.original,
    rightImage: sampleImages.optimized
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "default",
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
    className: "mt-2",
    onClick: loadSample
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base"
  }, optimoleDashboardApp.strings.options_strings.quality_slider_desc)), !(sampleImages.id && 0 < sampleImages.original_size) && 0 > sampleImages.id && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-5 text-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base"
  }, optimoleDashboardApp.strings.options_strings.no_images_found)))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Compression);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Exclusions.js":
/*!*********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Exclusions.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _FilterControl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FilterControl */ "./assets/src/dashboard/parts/connected/settings/FilterControl.js");

/**
 * Internal dependencies.
 */

const Exclusions = ({
  settings,
  setSettings,
  setCanSave
}) => {
  const isLazyloadEnabled = 'disabled' !== settings.lazyload;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FilterControl__WEBPACK_IMPORTED_MODULE_1__["default"], {
    label: optimoleDashboardApp.strings.options_strings.exclude_title_optimize,
    help: optimoleDashboardApp.strings.options_strings.exclude_desc_optimize,
    type: "optimize",
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  }), isLazyloadEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FilterControl__WEBPACK_IMPORTED_MODULE_1__["default"], {
    label: optimoleDashboardApp.strings.options_strings.exclude_title_lazyload,
    help: optimoleDashboardApp.strings.options_strings.exclude_desc_lazyload,
    type: "lazyload",
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Exclusions);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/FilterControl.js":
/*!************************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/FilterControl.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);

/**
 * WordPress dependencies.
 */



const FILTER_TYPES = {
  EXT: 'extension',
  URL: 'page_url',
  URL_MATCH: 'page_url_match',
  FILENAME: 'filename',
  CLASS: 'class'
};
const FILTER_OPTIONS = [{
  label: optimoleDashboardApp.strings.options_strings.filter_filename,
  value: FILTER_TYPES.FILENAME
}, {
  label: optimoleDashboardApp.strings.options_strings.filter_ext,
  value: FILTER_TYPES.EXT
}, {
  label: optimoleDashboardApp.strings.options_strings.filter_url,
  value: FILTER_TYPES.URL
}, {
  label: optimoleDashboardApp.strings.options_strings.filter_class,
  value: FILTER_TYPES.CLASS
}];
const FILTER_VIEW = [{
  label: optimoleDashboardApp.strings.options_strings.exclude_filename_desc,
  value: FILTER_TYPES.FILENAME
}, {
  label: optimoleDashboardApp.strings.options_strings.exclude_ext_desc,
  value: FILTER_TYPES.EXT
}, {
  label: optimoleDashboardApp.strings.options_strings.exclude_url_desc,
  value: FILTER_TYPES.URL
}, {
  label: optimoleDashboardApp.strings.options_strings.exclude_url_match_desc,
  value: FILTER_TYPES.URL_MATCH
}, {
  label: optimoleDashboardApp.strings.options_strings.exclude_class_desc,
  value: FILTER_TYPES.CLASS
}];
const EXT_OPTIONS = [{
  label: '.SVG',
  value: 'svg'
}, {
  label: '.JPG',
  value: 'jpg'
}, {
  label: '.PNG',
  value: 'png'
}, {
  label: '.GIF',
  value: 'gif'
}, {
  label: '.WEBP',
  value: 'webp'
}];
const FilterControl = ({
  label,
  help,
  type,
  settings,
  setSettings,
  setCanSave
}) => {
  const {
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      isLoading
    } = select('optimole');
    return {
      isLoading: isLoading()
    };
  });
  const defaultFilterOperator = optimoleDashboardApp.strings.options_strings.filter_operator_contains;
  const [filterType, setFilterType] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(FILTER_TYPES.FILENAME);
  const [filterOperator, setFilterOperator] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(optimoleDashboardApp.strings.options_strings.filter_operator_contains);
  const [filterValue, setFilterValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [filterMatchType, setFilterMatchType] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(defaultFilterOperator);
  const [lengthError, setLengthError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const changeFilterType = value => {
    let selectedValue = '';
    if (value === FILTER_TYPES.EXT) {
      selectedValue = 'svg';
      setFilterOperator(optimoleDashboardApp.strings.options_strings.filter_operator_is);
    }
    if (value === FILTER_TYPES.FILENAME) {
      setFilterOperator(optimoleDashboardApp.strings.options_strings.filter_operator_contains);
    }
    if (value === FILTER_TYPES.CLASS) {
      setFilterOperator(optimoleDashboardApp.strings.options_strings.filter_operator_contains);
    }
    setLengthError(false);
    setFilterValue(selectedValue);
    setFilterType(value);
    setFilterMatchType(filterValue);
  };
  const updateFilterValue = value => {
    setFilterValue(value);
    setLengthError(false);
  };
  const addFilter = () => {
    if (3 > filterValue.length) {
      setLengthError(true);
      return;
    }
    const filters = {
      ...settings.filters
    };
    let selectedFilterType = filterType;
    if (filterType === FILTER_TYPES.URL && 'matches' === filterMatchType) {
      selectedFilterType = FILTER_TYPES.URL_MATCH;
    }
    if (!filters[type] || 'object' !== typeof filters[type]) {
      filters[type] = {};
    }
    if (!filters[type][selectedFilterType] || Array.isArray(filters[type][selectedFilterType])) {
      filters[type][selectedFilterType] = {};
    }
    filters[type][selectedFilterType][filterValue] = true;
    setSettings({
      ...settings,
      filters
    });
    if (filterType !== FILTER_TYPES.EXT) {
      setFilterValue('');
    }
    setCanSave(true);
    setFilterValue('');
    setFilterType(FILTER_TYPES.FILENAME);
    setFilterMatchType(defaultFilterOperator);
  };
  const hasItems = 0 < Object.keys(settings.filters[type][FILTER_TYPES.EXT]).length && Object.values(settings.filters[type][FILTER_TYPES.EXT]).some(value => false !== value) || 0 < Object.keys(settings.filters[type][FILTER_TYPES.CLASS]).length && Object.values(settings.filters[type][FILTER_TYPES.CLASS]).some(value => false !== value) || 0 < Object.keys(settings.filters[type][FILTER_TYPES.URL]).length && Object.values(settings.filters[type][FILTER_TYPES.URL]).some(value => false !== value) || 0 < Object.keys(settings.filters[type][FILTER_TYPES.URL_MATCH]).length && Object.values(settings.filters[type][FILTER_TYPES.URL_MATCH]).some(value => false !== value) || 0 < Object.keys(settings.filters[type][FILTER_TYPES.FILENAME]).length && Object.values(settings.filters[type][FILTER_TYPES.FILENAME]).some(value => false !== value);
  const removeFilter = (group, value) => {
    const filters = {
      ...settings.filters
    };
    filters[type][group][value] = false;
    setSettings({
      ...settings,
      filters
    });
    setCanSave(true);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.BaseControl, {
    label: label,
    help: filterType === FILTER_TYPES.URL && optimoleDashboardApp.strings.options_strings.filter_helper
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "components-base-control__help mt-0",
    dangerouslySetInnerHTML: {
      __html: help
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col md:flex-row p-6 my-3 bg-light-blue border border-blue-300 rounded-md items-center justify-between gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-start items-center gap-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    value: filterType,
    options: FILTER_OPTIONS,
    onChange: changeFilterType,
    className: "optml__select",
    __nextHasNoMarginBottom: true
  }), filterType === FILTER_TYPES.URL ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    value: filterMatchType,
    options: [{
      label: optimoleDashboardApp.strings.options_strings.filter_operator_contains,
      value: optimoleDashboardApp.strings.options_strings.filter_operator_contains
    }, {
      label: optimoleDashboardApp.strings.options_strings.filter_operator_matches,
      value: optimoleDashboardApp.strings.options_strings.filter_operator_matches
    }],
    onChange: setFilterMatchType,
    className: "optml__select",
    __nextHasNoMarginBottom: true
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, filterOperator), filterType === FILTER_TYPES.EXT ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    value: filterValue,
    options: EXT_OPTIONS,
    onChange: setFilterValue,
    className: "optml__select",
    __nextHasNoMarginBottom: true
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    value: filterValue,
    placeholder: 'matches' === filterMatchType ? optimoleDashboardApp.strings.path : optimoleDashboardApp.strings.word,
    onChange: updateFilterValue,
    className: "optml__input"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    isBusy: isLoading,
    disabled: isLoading,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: addFilter
  }, optimoleDashboardApp.strings.options_strings.add_filter)), lengthError && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-red-500 bg-red-100 p-2 rounded-md border border-solid border-red-200"
  }, optimoleDashboardApp.strings.options_strings.filter_length_error)), hasItems && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.BaseControl, {
    label: 'optimize' === type ? optimoleDashboardApp.strings.options_strings.active_optimize_exclusions : optimoleDashboardApp.strings.options_strings.active_lazyload_exclusions,
    className: "py-4"
  }, FILTER_VIEW.map(filter => {
    return Object.keys(settings.filters[type][filter.value]).filter(i => false !== settings.filters[type][filter.value][i]).map(i => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: i,
      className: "flex p-3 my-3 bg-light-blue border border-blue-300 rounded-md items-center justify-between gap-8"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center gap-1"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "m-0 inline-block",
      dangerouslySetInnerHTML: {
        __html: filter.label
      }
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("b", null, i)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
      variant: "default",
      icon: "trash",
      disabled: isLoading,
      onClick: () => removeFilter(filter.value, i)
    })));
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FilterControl);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/General.js":
/*!******************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/General.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _components_Notice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/Notice */ "./assets/src/dashboard/parts/components/Notice.js");

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */





/**
 * Internal dependencies.
 */


const General = ({
  settings,
  setSettings,
  setCanSave
}) => {
  const {
    isLoading,
    isUserActive
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isLoading,
      getUserStatus
    } = select('optimole');
    return {
      isLoading: isLoading(),
      isUserActive: 'active' === getUserStatus()
    };
  });
  const isReplacerEnabled = 'disabled' !== settings['image_replacer'];
  const isLazyloadEnabled = 'disabled' !== settings.lazyload;
  const isAssetsEnabled = 'disabled' !== settings.cdn;
  const isBannerEnabled = 'disabled' !== settings['banner_frontend'];
  const isShowBadgeIcon = 'disabled' !== settings['show_badge_icon'];
  const activeBadgePosition = settings['badge_position'] || 'right';
  const [showBadgeSettings, setBadgeSettings] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(isBannerEnabled);
  const updateOption = (option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    if ('badge_position' === option) {
      data[option] = value;
    } else {
      data[option] = value ? 'enabled' : 'disabled';
    }
    setSettings(data);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_image_replace,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.replacer_desc
      }
    }),
    checked: isReplacerEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('image_replacer', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), isUserActive && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_badge_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.enable_badge_description
      }
    }),
    checked: isBannerEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => {
      updateOption('banner_frontend', value);
      setBadgeSettings(value);
    }
  }), isBannerEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-4 badge-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('border border-none bg-transparent text-blue-500 px-2 py-1 rounded-sm flex items-center cursor-pointer', {
      'is-disabled': isLoading
    }),
    onClick: () => setBadgeSettings(!showBadgeSettings)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, optimoleDashboardApp.strings.options_strings.enable_badge_settings), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"], {
    icon: showBadgeSettings ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"] : _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
    className: "h-5 w-5",
    style: {
      fill: '#3b82f6'
    }
  })), showBadgeSettings && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-4 space-y-4 pl-4 pt-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "text-gray-600 font-medium"
  }, optimoleDashboardApp.strings.options_strings.enable_badge_show_icon), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: "",
    checked: isShowBadgeIcon,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('flex items-center justify-between mb-4', {
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('show_badge_icon', value)
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "text-gray-600 font-medium"
  }, optimoleDashboardApp.strings.options_strings.enable_badge_position), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex space-x-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('px-4 py-2 border rounded border-[1px]', 'left' === activeBadgePosition ? 'border-blue-500 text-blue-500 bg-blue-100' : 'border-gray-300 text-gray-500 bg-gray-100', {
      'is-disabled': isLoading
    }),
    onClick: () => updateOption('badge_position', 'left')
  }, optimoleDashboardApp.strings.options_strings.badge_position_text_1), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('px-4 py-2 border rounded', 'right' === activeBadgePosition ? 'border-blue-500 text-blue-500 bg-blue-100' : 'border-gray-300 text-gray-500 bg-gray-100', {
      'is-disabled': isLoading
    }),
    onClick: () => updateOption('badge_position', 'right')
  }, optimoleDashboardApp.strings.options_strings.badge_position_text_2))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
    label: optimoleDashboardApp.strings.options_strings.cache_title,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading || !isReplacerEnabled
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "components-base-control__help m-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.options_strings.cache_desc
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex my-4 gap-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "default",
    isBusy: isLoading,
    disabled: isLoading || !isReplacerEnabled,
    className: "optml__button flex justify-center rounded font-bold min-h-40",
    onClick: () => (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.clearCache)()
  }, optimoleDashboardApp.strings.options_strings.clear_cache_images), isAssetsEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "default",
    isBusy: isLoading,
    disabled: isLoading || !isReplacerEnabled,
    className: "optml__button flex justify-center rounded font-bold min-h-40",
    onClick: () => (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.clearCache)('assets')
  }, optimoleDashboardApp.strings.options_strings.clear_cache_assets))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "warning",
    text: optimoleDashboardApp.strings.options_strings.clear_cache_notice,
    disableIcon: true
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (General);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Lazyload.js":
/*!*******************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Lazyload.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_RadioBoxes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/RadioBoxes */ "./assets/src/dashboard/parts/components/RadioBoxes.js");
/* harmony import */ var _components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/GroupSettingsContainer */ "./assets/src/dashboard/parts/components/GroupSettingsContainer.js");
/* harmony import */ var _components_Notice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/Notice */ "./assets/src/dashboard/parts/components/Notice.js");
/* harmony import */ var _components_Modal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/Modal */ "./assets/src/dashboard/parts/components/Modal.js");
/* harmony import */ var _components_Miscellaneous__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/Miscellaneous */ "./assets/src/dashboard/parts/components/Miscellaneous.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */










const {
  options_strings
} = optimoleDashboardApp.strings;
const DISABLE_OPTION_MODAL_TYPE = {
  scale: 'image-scaling',
  lazyLoad: 'lazy-load',
  javascriptLoading: 'javascript-loading'
};
const Lazyload = ({
  settings,
  setSettings,
  setCanSave
}) => {
  const {
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    const {
      isLoading
    } = select('optimole');
    return {
      isLoading: isLoading()
    };
  });
  const isLazyLoadPlaceholderEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings['lazyload_placeholder'], [settings]);
  const isNativeLazyLoadEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings['native_lazyload'], [settings]);
  const isBGReplacerEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings['bg_replacer'], [settings]);
  const isVideoLazyLoadEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings['video_lazyload'], [settings]);
  const isNoScriptEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings['no_script'], [settings]);
  const placeholderColor = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => settings['placeholder_color'], [settings.placeholder_color]);
  const isScaleEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' === settings.scale, [settings.scale]);
  const isLazyLoadEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => 'disabled' !== settings.lazyload, [settings.lazyload]);
  const isViewPortLoadingEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => settings['lazyload_type']?.includes('viewport'), [settings?.lazyload_type]);
  const isFixedSkipLazyEnabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => settings['lazyload_type']?.includes('fixed'), [settings?.lazyload_type]);
  const [phPicker, setPhPicker] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const [showModal, setShowModal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const supportPrefilledContactFormUrl = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    const contactUrl = new URL(window.optimoleDashboardApp.report_issue_url);
    const {
      contact_support
    } = window.optimoleDashboardApp.strings;
    let subject = contact_support.disable_lazy_load_scaling;
    if (DISABLE_OPTION_MODAL_TYPE.scale === showModal) {
      subject = contact_support.disable_image_scaling;
    } else if (DISABLE_OPTION_MODAL_TYPE.javascriptLoading === showModal) {
      subject = contact_support.enable_native_lazy_load;
    }
    contactUrl.searchParams.set('contact_subject', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.sprintf)(contact_support.title_prefix, subject));
    return contactUrl;
  }, [showModal]);
  const toggleOption = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)((option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data[option] = value ? 'enabled' : 'disabled';
    setSettings(data);
  }, [setCanSave, settings, setSettings]);
  const updateValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)((option, value) => {
    setCanSave(true);
    setSettings(prevSettings => ({
      ...prevSettings,
      [option]: value
    }));
  }, [setCanSave, setSettings]);
  const setColor = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(value => {
    updateValue('placeholder_color', value);
  }, [updateValue]);
  const toggleLoadingBehavior = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)((value, slug) => {
    var _split$filter, _settings$lazyload_ty;
    const lazyLoadValue = new Set((_split$filter = ((_settings$lazyload_ty = settings?.lazyload_type) !== null && _settings$lazyload_ty !== void 0 ? _settings$lazyload_ty : '')?.split('|').filter(i => 'viewport' === i || 'fixed' === i)) !== null && _split$filter !== void 0 ? _split$filter : []);
    if (value) {
      lazyLoadValue.add(slug);
    } else {
      lazyLoadValue.delete(slug);
    }
    const updatedValue = Array.from(lazyLoadValue).toSorted().join('|') || 'all';
    updateValue('lazyload_type', updatedValue);
  }, [settings?.lazyload_type, updateValue]);
  if (!isLazyLoadEnabled) {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
      label: options_strings.toggle_lazyload,
      help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        dangerouslySetInnerHTML: {
          __html: optimoleDashboardApp.strings.options_strings.lazyload_desc
        }
      }),
      checked: isLazyLoadEnabled,
      disabled: isLoading,
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
        'is-disabled': isLoading
      }),
      onChange: value => toggleOption('lazyload', value)
    }));
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: options_strings.toggle_lazyload,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.lazyload_desc
      }
    }),
    checked: isLazyLoadEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: () => setShowModal(DISABLE_OPTION_MODAL_TYPE.lazyLoad)
  }), showModal && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Modal__WEBPACK_IMPORTED_MODULE_9__["default"], {
    icon: "warning",
    variant: "warning",
    labels: {
      title: options_strings.performance_impact_alert_title,
      description: 'scale' === showModal ? options_strings.performance_impact_alert_scale_desc : options_strings.performance_impact_alert_lazy_desc,
      action: options_strings.performance_impact_alert_action_label,
      secondaryAction: options_strings.performance_impact_alert_secondary_action_label
    },
    onRequestClose: () => setShowModal(false),
    onConfirm: () => {
      window?.formbricks?.track('disable_lazy_load_feature', {
        hiddenFields: {
          feature: `${showModal}`
        }
      });
      if (DISABLE_OPTION_MODAL_TYPE.javascriptLoading === showModal) {
        toggleOption('native_lazyload', true);
      } else if (DISABLE_OPTION_MODAL_TYPE.scale === showModal) {
        toggleOption('scale', true);
      } else if (DISABLE_OPTION_MODAL_TYPE.lazyLoad === showModal) {
        toggleOption('lazyload', false);
      }
      setShowModal(false);
    },
    onSecondaryAction: () => {
      window.open(supportPrefilledContactFormUrl, '_blank');
      setShowModal(false);
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
    className: "mt-2",
    label: options_strings.lazyload_behaviour_title
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_RadioBoxes__WEBPACK_IMPORTED_MODULE_6__["default"], {
    label: '',
    options: [{
      title: options_strings.smart_loading_title,
      description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Miscellaneous__WEBPACK_IMPORTED_MODULE_10__.DescriptionWithTags, {
        text: options_strings.smart_loading_desc,
        tags: [{
          text: options_strings.viewport_detection
        }, {
          text: options_strings.placeholders_color
        }, {
          text: options_strings.auto_scaling
        }]
      }),
      value: 'disabled'
    }, {
      title: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Miscellaneous__WEBPACK_IMPORTED_MODULE_10__.TextWithWarningBadge, {
        text: options_strings.toggle_native,
        badgeLabel: options_strings.not_recommended
      }),
      description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Miscellaneous__WEBPACK_IMPORTED_MODULE_10__.DescriptionWithTags, {
        text: options_strings.native_desc,
        tags: [{
          text: options_strings.viewport_detection
        }, {
          text: options_strings.lightweight_native
        }, {
          text: options_strings.auto_scaling,
          disabled: true
        }]
      }),
      value: 'enabled'
    }],
    value: isNativeLazyLoadEnabled ? 'enabled' : 'disabled',
    onChange: value => {
      if ('disabled' === value) {
        toggleOption('native_lazyload', false);
      } else {
        setShowModal(DISABLE_OPTION_MODAL_TYPE.javascriptLoading);
      }
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsContainer, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsTitle, null, options_strings.lazyload_behaviour_title, " (", options_strings.global_option, ")"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsOption, {
    className: "flex flex-row items-center gap-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
    className: "optml-skip-lazy-load-images",
    label: options_strings.lazyload_behaviour_fixed,
    checked: isFixedSkipLazyEnabled,
    onChange: value => {
      toggleLoadingBehavior(value, 'fixed');
    },
    disabled: false,
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
    className: '',
    label: '',
    labelPosition: "side",
    value: settings['skip_lazyload_images'],
    type: "number",
    min: 0,
    onChange: value => updateValue('skip_lazyload_images', value),
    disabled: !isFixedSkipLazyEnabled,
    __nextHasNoMarginBottom: true
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsOption, {
    className: "mt-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
    label: options_strings.lazyload_behaviour_viewport,
    checked: isViewPortLoadingEnabled,
    onChange: value => {
      toggleLoadingBehavior(value, 'viewport');
    },
    disabled: false,
    __nextHasNoMarginBottom: true
  })), isFixedSkipLazyEnabled && isViewPortLoadingEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
    type: "warning",
    title: '',
    text: options_strings.viewport_skip_images_notice
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsContainer, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsTitle, null, options_strings.visual_settings), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsOption, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grow flex flex-row gap-1",
    htmlFor: "optml-lazyload-placeholder"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
    label: options_strings.enable_lazyload_placeholder_title,
    checked: isLazyLoadPlaceholderEnabled,
    onChange: value => toggleOption('lazyload_placeholder', value),
    disabled: isLoading,
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    text: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "",
      dangerouslySetInnerHTML: {
        __html: options_strings.enable_lazyload_placeholder_desc
      }
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"], {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__["default"],
    size: 18,
    className: "text-gray-400 hover:text-gray-600"
  }))), isLazyLoadPlaceholderEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative inline-block"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    disabled: isLoading,
    className: "",
    onClick: () => {
      setPhPicker(!phPicker);
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ColorIndicator, {
    colorValue: placeholderColor
  })), phPicker && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Popover, {
    placement: "bottom-end",
    variant: 'unstyled',
    className: 'shadow-md border-grayish-blue border border-solid rounded bg-white p-2',
    onFocusOutside: () => setPhPicker(false)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ColorPicker, {
    color: placeholderColor,
    onChange: setColor,
    enableAlpha: true,
    defaultValue: ""
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    isDestructive: true,
    className: 'w-full text-center flex justify-center',
    variant: 'secondary',
    onClick: () => {
      setColor('');
    }
  }, options_strings.clear)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsOption, {
    className: "mt-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
    checked: isNoScriptEnabled,
    label: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.createInterpolateElement)(options_strings.enable_noscript_title, {
      custom_component: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, "<noscript>")
    }),
    onChange: value => toggleOption('no_script', value),
    disabled: isLoading,
    __nextHasNoMarginBottom: true
  }))))), isNativeLazyLoadEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
    type: "warning",
    title: '',
    text: options_strings.native_lazy_load_warning
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: options_strings.toggle_scale,
    help: options_strings.scale_desc,
    checked: isScaleEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => {
      if (value) {
        toggleOption('scale', !value);
      } else {
        setShowModal(DISABLE_OPTION_MODAL_TYPE.scale);
      }
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsContainer, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_GroupSettingsContainer__WEBPACK_IMPORTED_MODULE_7__.GroupSettingsTitle, null, options_strings.extended_features), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: options_strings.enable_bg_lazyload_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: options_strings.enable_bg_lazyload_desc
      }
    }),
    checked: isBGReplacerEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('text-sm', {
      'is-disabled': isLoading
    }),
    onChange: value => toggleOption('bg_replacer', value)
  }), isBGReplacerEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextareaControl, {
    id: "optml-css-watchers",
    placeholder: options_strings.watch_placeholder_lazyload + '\n' + options_strings.watch_placeholder_lazyload_example,
    value: settings.watchers,
    onChange: value => updateValue('watchers', value),
    help: options_strings.watch_desc_lazyload
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: options_strings.enable_video_lazyload_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: options_strings.enable_video_lazyload_desc
      }
    }),
    checked: isVideoLazyLoadEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('mt-8', {
      'is-disabled': isLoading
    }),
    onChange: value => toggleOption('video_lazyload', value),
    __nextHasNoMarginBottom: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Lazyload);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Logs.js":
/*!***************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Logs.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/format-italic.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */



const Logs = ({
  type
}) => {
  const {
    logs
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getLogs
    } = select('optimole');
    return {
      logs: getLogs()
    };
  });
  const [show, setShow] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const interval = setInterval(() => {
      if (ref.current) {
        ref.current.innerHTML = logs[type];
        ref.current.scrollTop = ref.current.scrollHeight;
      }
    }, 15000);
    return () => clearInterval(interval);
  }, []);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full flex justify-end text-info my-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "tertiary",
    className: "py-2 px-0",
    target: "_blank",
    href: `${window.ajaxurl}?action=optml_fetch_logs&nonce=${optimoleDashboardApp.nonce}&type=${type}`
  }, optimoleDashboardApp.strings.options_strings.view_logs), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
    className: "fill-info py-2"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "tertiary",
    className: "py-2 px-0",
    onClick: () => setShow(!show)
  }, show ? optimoleDashboardApp.strings.options_strings.hide_logs : optimoleDashboardApp.strings.options_strings.show_logs)), show && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col p-6 bg-light-blue border border-blue-300 rounded-md min-h-[200px] max-h-[200px] overflow-y-scroll",
    ref: ref,
    dangerouslySetInnerHTML: {
      __html: logs[type]
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Logs);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Menu.js":
/*!***************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Menu.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);

/**
 * External dependencies.
 */



/**
 * WordPress dependencies.
 */

const {
  strings
} = optimoleDashboardApp;
const menuItems = [{
  label: strings.general_settings_menu_item,
  value: 'general'
}, {
  label: strings.image_storage,
  value: 'offload_media'
}, {
  label: strings.advanced_settings_menu_item,
  value: 'compression',
  children: [{
    label: strings.settings_watermark_menu_item,
    value: 'watermark'
  }, {
    label: strings.settings_compression_menu_item,
    value: 'compression'
  }, {
    label: strings.settings_resize_menu_item,
    value: 'resize'
  }, {
    label: strings.lazyload_settings_menu_item,
    value: 'lazyload'
  }, {
    label: strings.settings_exclusions_menu_item,
    value: 'exclusions'
  }]
}, {
  label: strings.cloud_library,
  value: 'cloud_library'
}];
const SubMenu = ({
  children,
  tab,
  setTab
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "flex flex-col gap-1 m-0 mt-1"
  }, children.map(item => {
    const {
      value,
      label
    } = item;
    const classes = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'bg-light-blue hover:text-purple-gray': tab === value,
      'bg-transparent hover:text-info': tab !== value
    }, 'w-full text-left border-0 font-normal text-base text-purple-gray cursor-pointer rounded px-4 py-2 m-0 hover:text-info');
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
      key: value
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      className: classes,
      onClick: () => setTab(value)
    }, label));
  }));
};
const Menu = ({
  tab,
  settings,
  setTab
}) => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "basis-1/5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "grid m-0 gap-1"
  }, menuItems.map(item => {
    const disabled = 'enabled' !== settings?.image_replacer && 'general' !== item.value;
    const isActive = tab === item.value || item.children && item.children.some(child => child.value === tab);
    const buttonClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      '!text-info': isActive
    }, {
      'opacity-50 pointer-events-none': disabled
    }, 'w-full bg-transparent border-0 flex items-center appearance-none not-italic font-semibold text-base text-purple-gray cursor-pointer hover:text-info py-2');
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
      key: item.value,
      className: "m-0"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      disabled: disabled,
      className: buttonClasses,
      onClick: () => setTab(item.value)
    }, item.label, item.children && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: isActive ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"] : _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
      className: "inline-block ml-2 fill-current"
    })), item.children && isActive && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(SubMenu, {
      children: item.children,
      tab: tab,
      settings: settings,
      setTab: setTab
    }));
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Menu);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/OffloadMedia.js":
/*!***********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/OffloadMedia.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _utils_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/icons */ "./assets/src/dashboard/utils/icons.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _components_Notice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/Notice */ "./assets/src/dashboard/parts/components/Notice.js");
/* harmony import */ var _components_RadioBoxes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/RadioBoxes */ "./assets/src/dashboard/parts/components/RadioBoxes.js");
/* harmony import */ var _components_ProgressTile__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/ProgressTile */ "./assets/src/dashboard/parts/components/ProgressTile.js");
/* harmony import */ var _components_Modal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/Modal */ "./assets/src/dashboard/parts/components/Modal.js");
/* harmony import */ var _Logs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Logs */ "./assets/src/dashboard/parts/connected/settings/Logs.js");

/* global optimoleDashboardApp */












const OffloadMedia = ({
  settings,
  canSave,
  setSettings,
  setCanSave
}) => {
  const {
    strings,
    cron_disabled,
    show_exceed_plan_quota_notice
  } = optimoleDashboardApp;
  const {
    conflicts,
    options_strings
  } = strings;
  const MODAL_STATE_OFFLOAD = 'offload';
  const MODAL_STATE_ROLLBACK = 'rollback';
  const MODAL_STATE_STOP_OFFLOAD = 'stopOffload';
  const MODAL_STATE_STOP_ROLLBACK = 'stopRollback';
  const MODAL_STATE_EXCEED_PLAN_QUOTA_NOTICE = 'planQuotaNotice';
  const {
    offloadConflicts,
    errorMedia,
    offloadLibraryLink,
    isLoading,
    loadingSync,
    loadingRollback,
    rollbackLibraryLink,
    queryArgs,
    totalNumberOfImages,
    processedImages,
    offloadFinishNotice,
    offloadLimitReached,
    offloadLimit,
    canUseMediaOffloadingFlag,
    canShowFreeUserWithOffloadNoticeFlag
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      getOffloadConflicts,
      getErrorMedia,
      getLoadingSync,
      getLoadingRollback,
      getOffloadLibraryLink,
      getRollbackLibraryLink,
      getTotalNumberOfImages,
      getProcessedImages,
      getQueryArgs,
      isLoading,
      getSiteSettings,
      getOffloadLimit,
      getUserData,
      canShowFreeUserWithOffloadNotice
    } = select('optimole');
    const userData = getUserData();
    return {
      offloadConflicts: getOffloadConflicts(),
      errorMedia: getErrorMedia(),
      offloadLibraryLink: getOffloadLibraryLink(),
      isLoading: isLoading(),
      loadingSync: getLoadingSync(),
      loadingRollback: getLoadingRollback(),
      rollbackLibraryLink: getRollbackLibraryLink(),
      queryArgs: getQueryArgs(),
      totalNumberOfImages: getTotalNumberOfImages(),
      processedImages: getProcessedImages(),
      offloadFinishNotice: getSiteSettings('show_offload_finish_notice'),
      offloadLimitReached: 'enabled' === getSiteSettings('offload_limit_reached'),
      offloadLimit: getOffloadLimit(),
      canUseMediaOffloadingFlag: Boolean(userData?.can_use_offloading),
      canShowFreeUserWithOffloadNoticeFlag: canShowFreeUserWithOffloadNotice()
    };
  }, []);
  const {
    setErrorMedia,
    setCheckedOffloadConflicts,
    setOffloadConflicts,
    setProcessedImages,
    setOffloadLimitReached
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('optimole');
  const [modal, setModal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  const [initialRadioValue, setInitialRadioValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  const isOffloadingInProgress = 'disabled' !== settings['offloading_status'];
  const isRollbackInProgress = 'disabled' !== settings['rollback_status'];
  const showDisabledOffloadingNotice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    return 'enabled' === settings?.['offload_media'] && !canUseMediaOffloadingFlag && canShowFreeUserWithOffloadNoticeFlag;
  }, [settings, canUseMediaOffloadingFlag, canShowFreeUserWithOffloadNoticeFlag]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (isOffloadingInProgress) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.callSync)({
        action: 'offload_images',
        refresh: true
      });
    }
    if (isRollbackInProgress) {
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.callSync)({
        action: 'rollback_images',
        refresh: true
      });
    }
  }, []);
  const onOffloadMedia = async (imageIds = []) => {
    await (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.clearOffloadErrors)();
    const nextSettings = {
      ...settings
    };
    nextSettings['show_offload_finish_notice'] = '';
    nextSettings['offloading_status'] = 'enabled';
    nextSettings['offload_media'] = 'enabled';
    setSettings(nextSettings);
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)(nextSettings, false, true, () => {
      setErrorMedia(false);
      setProcessedImages(0);
      setOffloadLimitReached(false);
      (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.callSync)({
        action: 'offload_images'
      });
      setCanSave(false);
    });
  };
  const onRollbackdMedia = (imageIds = []) => {
    setCheckedOffloadConflicts(false);
    setOffloadConflicts([]);
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.checkOffloadConflicts)(response => {
      if (0 === response.data.length) {
        const nextSettings = {
          ...settings
        };
        nextSettings['show_offload_finish_notice'] = '';
        nextSettings['rollback_status'] = 'enabled';
        nextSettings['offload_media'] = 'disabled';
        (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)(nextSettings, false, true, () => {
          setErrorMedia(false);
          setProcessedImages(0);
          (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.callSync)({
            action: 'rollback_images'
          });
          setCanSave(false);
        });
      }
    });
  };
  const radioBoxesOptions = [{
    title: options_strings.offload_radio_option_rollback_title,
    description: options_strings.offload_radio_option_rollback_desc,
    value: 'rollback'
  }, {
    title: options_strings.offload_radio_option_offload_title,
    description: options_strings.offload_radio_option_offload_desc,
    value: 'offload'
  }];
  const radioBoxValue = 'enabled' === settings['offload_media'] ? 'offload' : 'rollback';
  const updateRadioBoxValue = value => {
    setInitialRadioValue(radioBoxValue);
    const offloadEnabled = 'offload' === value;
    if (offloadEnabled) {
      setModal({
        type: show_exceed_plan_quota_notice ? MODAL_STATE_EXCEED_PLAN_QUOTA_NOTICE : MODAL_STATE_OFFLOAD,
        optionValue: value
      });
      return;
    }
    setModal({
      type: MODAL_STATE_ROLLBACK,
      optionValue: value
    });
  };
  const getModalProps = ({
    type,
    optionValue
  }) => {
    const nextSettings = {
      ...settings
    };
    const props = {
      [MODAL_STATE_OFFLOAD]: {
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.offload,
        onConfirm: () => {
          if (canUseMediaOffloadingFlag) {
            nextSettings['offload_media'] = 'offload' === optionValue ? 'enabled' : 'disabled';
            setSettings(nextSettings);
            setCanSave(true);
            onOffloadMedia();
          } else {
            window.open(optimoleDashboardApp?.offload_upgrade_url, '_blank');
          }
          setModal(null);
        },
        labels: {
          title: options_strings.offloading_start_title,
          description: options_strings.offloading_start_description,
          action: canUseMediaOffloadingFlag ? options_strings.offloading_start_action : optimoleDashboardApp.strings.upgrade.title_long
        },
        afterContentChildren: !canUseMediaOffloadingFlag && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
          type: "warning",
          text: options_strings.upgrade_to_use_offloading_notice_desc
        })
      },
      [MODAL_STATE_ROLLBACK]: {
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.rollback,
        onConfirm: () => {
          nextSettings['offload_media'] = 'offload' === optionValue ? 'enabled' : 'disabled';
          setSettings(nextSettings);
          setCanSave(true);
          onRollbackdMedia();
          setModal(null);
        },
        labels: {
          title: options_strings.rollback_start_title,
          description: options_strings.rollback_start_description,
          action: options_strings.rollback_start_action
        }
      },
      [MODAL_STATE_STOP_OFFLOAD]: {
        variant: 'warning',
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.warningAlt,
        onConfirm: () => {
          setModal(null);
          const options = settings;
          options.offloading_status = 'disabled';
          options.offload_media = 'offload' === initialRadioValue ? 'enabled' : 'disabled';
          (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)(options);
          setInitialRadioValue(null);
        },
        labels: {
          title: options_strings.offloading_stop_title,
          description: options_strings.offloading_stop_description,
          action: options_strings.offloading_stop_action
        }
      },
      [MODAL_STATE_STOP_ROLLBACK]: {
        variant: 'warning',
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.warningAlt,
        onConfirm: () => {
          setModal(null);
          const options = settings;
          options.rollback_status = 'disabled';
          options.offload_media = 'offload' === initialRadioValue ? 'enabled' : 'disabled';
          (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)(options);
          setInitialRadioValue(null);
        },
        labels: {
          title: options_strings.rollback_stop_title,
          description: options_strings.rollback_stop_description,
          action: options_strings.rollback_stop_action
        }
      },
      [MODAL_STATE_EXCEED_PLAN_QUOTA_NOTICE]: {
        variant: 'warning',
        icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.warningAlt,
        onConfirm: () => {
          nextSettings['offload_media'] = 'offload' === optionValue ? 'enabled' : 'disabled';
          setSettings(nextSettings);
          setCanSave(true);
          onOffloadMedia();
          setModal(null);
        },
        onSecondaryAction: () => {
          setModal(null);
          const options = settings;
          options.offload_media = 'disabled';
          (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)(options);

          // Remove "unsaved changes" warning
          window.onbeforeunload = null;
        },
        labels: {
          title: options_strings.exceed_plan_quota_notice_title,
          description: options_strings.exceed_plan_quota_notice_description,
          action: options_strings.exceed_plan_quota_notice_start_action,
          secondaryAction: options_strings.exceed_plan_quota_notice_secondary_action
        }
      }
    };
    return {
      onRequestClose: () => setModal(null),
      ...props[type]
    };
  };
  const isInProgress = loadingSync || loadingRollback;
  const onCancelProgress = () => {
    if (loadingSync) {
      setModal({
        type: MODAL_STATE_STOP_OFFLOAD,
        optionValue: initialRadioValue
      });
    }
    if (loadingRollback) {
      setModal({
        type: MODAL_STATE_STOP_ROLLBACK,
        optionValue: initialRadioValue
      });
    }
  };
  const handleForceSync = e => {
    e.preventDefault();
    if ('offload' === radioBoxValue) {
      setModal({
        type: show_exceed_plan_quota_notice ? MODAL_STATE_EXCEED_PLAN_QUOTA_NOTICE : MODAL_STATE_OFFLOAD,
        optionValue: radioBoxValue
      });
    }
    if ('rollback' === radioBoxValue) {
      setModal({
        type: MODAL_STATE_ROLLBACK,
        optionValue: radioBoxValue
      });
    }
  };
  const dismissFinishNotice = () => {
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_5__.saveSettings)({
      show_offload_finish_notice: ''
    }, false, true);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "text-xl font-bold"
  }, options_strings.enable_offload_media_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: options_strings.enable_offload_media_desc
    }
  }), showDisabledOffloadingNotice && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "warning",
    title: options_strings.plan_update_notice_title,
    text: options_strings.plan_update_notice_desc
  }), offloadFinishNotice && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    title: 'offload' === offloadFinishNotice ? options_strings.offloading_success : options_strings.rollback_success,
    type: "primary",
    onDismiss: dismissFinishNotice
  }), cron_disabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "error",
    text: strings.cron_error
  }), !isInProgress && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_RadioBoxes__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'opacity-50 pointer-events-none': isLoading || cron_disabled
    }),
    label: options_strings.offloading_radio_legend,
    options: radioBoxesOptions,
    value: radioBoxValue,
    onChange: updateRadioBoxValue
  }), isInProgress && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_ProgressTile__WEBPACK_IMPORTED_MODULE_8__["default"], {
    title: loadingSync ? options_strings.sync_media_progress : options_strings.rollback_media_progress,
    progress: Math.round(processedImages / totalNumberOfImages * 100),
    onCancel: onCancelProgress,
    description: 0 === totalNumberOfImages ? options_strings.calculating_estimated_time : options_strings.images_processing
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Logs__WEBPACK_IMPORTED_MODULE_10__["default"], {
    type: loadingSync ? 'offload' : 'rollback'
  })), 'offload_images' === errorMedia && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "error",
    smallTitle: true,
    title: options_strings.sync_media_error,
    text: options_strings.sync_media_error_desc
  }), 'rollback_images' === errorMedia && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "error",
    smallTitle: true,
    title: options_strings.rollback_media_error,
    text: options_strings.rollback_media_error_desc
  }), 0 < offloadConflicts.length && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "warning",
    title: options_strings.offload_conflicts_part_1
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "list-disc grid gap-3 mt-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "grid gap-1"
  }, offloadConflicts.map(conflict => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: conflict,
    className: "font-semibold text-base m-0"
  }, conflict))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0 text-sm"
  }, options_strings.offload_conflicts_part_2), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'opacity-50 pointer-events-none': isLoading
    }, 'justify-self-start font-semibold flex items-center appearance-none border border-info text-info bg-white rounded px-4 py-2 text-sm hover:text-white hover:bg-info cursor-pointer'),
    onClick: () => setOffloadConflicts([])
  }, conflicts.conflict_close))), !isInProgress && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: handleForceSync,
    disabled: isLoading || cron_disabled,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'opacity-50 pointer-events-none': isLoading || cron_disabled
    }, 'font-semibold flex items-center gap-2 appearance-none border border-info text-info bg-transparent rounded px-4 py-2 ml-auto text-sm hover:text-white hover:bg-info cursor-pointer')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"], {
    icon: _utils_icons__WEBPACK_IMPORTED_MODULE_4__.sync,
    className: "w-4 h-4"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, options_strings.sync_media)), !isInProgress && offloadLimitReached && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
    type: "warning",
    text: options_strings.offload_limit_reached.replace('#offload_limit#', offloadLimit)
  }), modal && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Modal__WEBPACK_IMPORTED_MODULE_9__["default"], {
    ...getModalProps(modal)
  }), offloadLibraryLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, options_strings.sync_media_link, " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: queryArgs.url
  }, options_strings.here)), rollbackLibraryLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, options_strings.rollback_media_link, " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: queryArgs.url
  }, optimoleDashboardApp.strings.options_strings.here)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OffloadMedia);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Resize.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Resize.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);

/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */



const Resize = ({
  settings,
  setSettings,
  setCanSave
}) => {
  const {
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isLoading
    } = select('optimole');
    return {
      isLoading: isLoading()
    };
  });
  const [width, setWidth] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [height, setHeight] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const isSmartResizeEnabled = 'disabled' !== settings['resize_smart'];
  const isLimitDimensionsEnabled = 'disabled' !== settings['limit_dimensions'];
  const updateOption = (option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data[option] = value ? 'enabled' : 'disabled';
    setSettings(data);
  };
  const updateValue = (option, value) => {
    setCanSave(true);
    const data = {
      ...settings
    };
    data[option] = value;
    setSettings(data);
  };
  const addSize = () => {
    if (!width || !height || isNaN(width) || isNaN(height)) {
      return;
    }
    const size = 'optimole_' + width + '_' + height + '_crop';
    const newSizes = {
      ...settings['defined_image_sizes'],
      [size]: {
        width,
        height
      }
    };
    setCanSave(true);
    const data = {
      ...settings
    };
    data['defined_image_sizes'] = newSizes;
    setSettings(data);
    setWidth('');
    setHeight('');
  };
  const removeSize = size => {
    const newSizes = {
      ...settings['defined_image_sizes'],
      [size]: 'remove'
    };
    setCanSave(true);
    const data = {
      ...settings
    };
    data['defined_image_sizes'] = newSizes;
    setSettings(data);
  };
  const imageSizes = Object.keys(settings['defined_image_sizes']).filter(size => 'object' === typeof settings['defined_image_sizes'][size]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_resize_smart_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.enable_resize_smart_desc
      }
    }),
    checked: isSmartResizeEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('resize_smart', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: optimoleDashboardApp.strings.options_strings.enable_limit_dimensions_title,
    help: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      dangerouslySetInnerHTML: {
        __html: optimoleDashboardApp.strings.options_strings.enable_limit_dimensions_desc
      }
    }),
    checked: isLimitDimensionsEnabled,
    disabled: isLoading,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({
      'is-disabled': isLoading
    }),
    onChange: value => updateOption('limit_dimensions', value)
  }), isLimitDimensionsEnabled && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
    label: optimoleDashboardApp.strings.options_strings.width_field,
    labelPosition: "side",
    value: settings['limit_width'],
    type: "number",
    min: 100,
    max: 10000,
    className: "basis-1/2 sm:basis-1/4",
    onChange: value => updateValue('limit_width', value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
    label: optimoleDashboardApp.strings.options_strings.height_field,
    labelPosition: "side",
    value: settings['limit_height'],
    type: "number",
    min: 100,
    max: 10000,
    className: "basis-1/2 sm:basis-1/4",
    onChange: value => updateValue('limit_height', value)
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", {
    className: "my-8 border-grayish-blue"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
    label: optimoleDashboardApp.strings.options_strings.add_image_size_desc
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "components-base-control__help mt-0",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.options_strings.image_size_notice
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col sm:flex-row p-6 bg-light-blue border border-blue-300 rounded-md items-stretch sm:items-center gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
    label: optimoleDashboardApp.strings.options_strings.width_field,
    placeholder: optimoleDashboardApp.strings.options_strings.width_field,
    hideLabelFromVision: true,
    type: "number",
    min: 1,
    value: width,
    onChange: setWidth,
    className: "optml__input sm:basis-2/5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
    label: optimoleDashboardApp.strings.options_strings.height_field,
    placeholder: optimoleDashboardApp.strings.options_strings.height_field,
    value: height,
    onChange: setHeight,
    hideLabelFromVision: true,
    type: "number",
    min: 1,
    className: "optml__input sm:basis-2/5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "primary",
    isBusy: isLoading,
    disabled: isLoading,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: addSize
  }, optimoleDashboardApp.strings.options_strings.add_image_size_button))), 0 < imageSizes.length && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
    label: optimoleDashboardApp.strings.options_strings.image_sizes_title,
    className: "pt-4"
  }, imageSizes.map(size => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: size,
    className: "flex p-3 my-3 bg-light-blue border border-blue-300 rounded-md items-center justify-between gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-wrap items-center gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0 inline-block",
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.options_strings.name
    }
  }), " ", size), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("b", null, optimoleDashboardApp.strings.options_strings.width_field), ": ", settings['defined_image_sizes'][size].width), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "m-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("b", null, optimoleDashboardApp.strings.options_strings.height_field), ": ", settings['defined_image_sizes'][size].height)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    variant: "default",
    icon: "trash",
    disabled: isLoading,
    onClick: () => removeSize(size)
  })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Resize);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/Watermark.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/Watermark.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/external.js");

/**
 * WordPress dependencies.
 */


const Watermark = () => {
  const {
    options_strings
  } = optimoleDashboardApp.strings;
  const containerStyle = {
    border: '2px solid #DCDCDC',
    borderRadius: '8px',
    padding: '16px'
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "text-xl font-bold"
  }, options_strings.watermark_media_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-gray-600 mt-2 mb-2"
  }, options_strings.watermark_media_desc)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: containerStyle
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-4 space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2 align-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-2 h-2 bg-gray-900 rounded-full flex-shrink-0"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-700 text-left"
  }, options_strings.watermark_info_1)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2 align-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-2 h-2 bg-gray-900 rounded-full flex-shrink-0"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-700 text-left "
  }, options_strings.watermark_info_2)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2 align-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-2 h-2 bg-gray-900 rounded-full flex-shrink-0"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-700 text-left"
  }, options_strings.watermark_info_3))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-4 mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    className: "bg-blue-600 text-white px-6 py-3 rounded-lg font-medium flex items-center gap-2 hover:bg-blue-700",
    target: "_blank",
    rel: "noopener noreferrer",
    href: "https://dashboard.optimole.com/watermark"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"], {
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"],
    className: "w-4 h-4"
  }), options_strings.open_optimole_dashboard), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "secondary",
    className: "border border-gray-300 text-gray-700 px-6 py-3 rounded-lg font-medium hover:bg-gray-50",
    target: "_blank",
    rel: "noopener noreferrer",
    href: "https://docs.optimole.com/article/1475-adding-watermarks-to-your-images"
  }, options_strings.learn_more)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-gray-500"
  }, options_strings.watermark_footer)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Watermark);

/***/ }),

/***/ "./assets/src/dashboard/parts/connected/settings/index.js":
/*!****************************************************************!*\
  !*** ./assets/src/dashboard/parts/connected/settings/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Menu */ "./assets/src/dashboard/parts/connected/settings/Menu.js");
/* harmony import */ var _General__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./General */ "./assets/src/dashboard/parts/connected/settings/General.js");
/* harmony import */ var _Compression__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Compression */ "./assets/src/dashboard/parts/connected/settings/Compression.js");
/* harmony import */ var _Resize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Resize */ "./assets/src/dashboard/parts/connected/settings/Resize.js");
/* harmony import */ var _Lazyload__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Lazyload */ "./assets/src/dashboard/parts/connected/settings/Lazyload.js");
/* harmony import */ var _Exclusions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Exclusions */ "./assets/src/dashboard/parts/connected/settings/Exclusions.js");
/* harmony import */ var _OffloadMedia__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./OffloadMedia */ "./assets/src/dashboard/parts/connected/settings/OffloadMedia.js");
/* harmony import */ var _CloudLibrary__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./CloudLibrary */ "./assets/src/dashboard/parts/connected/settings/CloudLibrary.js");
/* harmony import */ var _Watermark__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Watermark */ "./assets/src/dashboard/parts/connected/settings/Watermark.js");
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../utils/api */ "./assets/src/dashboard/utils/api.js");
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../utils/helpers */ "./assets/src/dashboard/utils/helpers.js");















const Settings = ({
  tab,
  setTab,
  canSave,
  setCanSave,
  settings,
  setSettings
}) => {
  const {
    siteSettings,
    isLoading,
    damEnabled
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      getSiteSettings,
      getQueryArgs,
      isLoading
    } = select('optimole');
    const siteSettings = getSiteSettings();
    return {
      siteSettings,
      damEnabled: siteSettings['cloud_images'],
      isLoading: isLoading(),
      queryArgs: getQueryArgs()
    };
  }, []);
  const [showSample, setShowSample] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const [isSampleLoading, setIsSampleLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_14__.toggleDamSidebarLink)('enabled' === damEnabled);
  }, [damEnabled]);
  const toggleShowSample = () => {
    setShowSample(!showSample);
  };
  const onSaveSettings = () => {
    (0,_utils_api__WEBPACK_IMPORTED_MODULE_13__.saveSettings)(settings, siteSettings['banner_frontend'] !== settings['banner_frontend']);
    setCanSave(false);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml-settings flex flex-col sm:flex-row bg-white p-8 border-0 rounded-lg shadow-md gap-8"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Menu__WEBPACK_IMPORTED_MODULE_4__["default"], {
    tab: tab,
    setTab: setTab,
    settings: settings
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "basis-4/5"
  }, 'general' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_General__WEBPACK_IMPORTED_MODULE_5__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  }), 'compression' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Compression__WEBPACK_IMPORTED_MODULE_6__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave,
    showSample: showSample,
    isSampleLoading: isSampleLoading,
    setIsSampleLoading: setIsSampleLoading
  }), 'resize' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Resize__WEBPACK_IMPORTED_MODULE_7__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  }), 'lazyload' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Lazyload__WEBPACK_IMPORTED_MODULE_8__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  }), 'exclusions' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Exclusions__WEBPACK_IMPORTED_MODULE_9__["default"], {
    settings: settings,
    setSettings: setSettings,
    setCanSave: setCanSave
  }), 'cloud_library' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_CloudLibrary__WEBPACK_IMPORTED_MODULE_11__["default"], {
    settings: settings,
    canSave: canSave,
    setSettings: setSettings,
    setCanSave: setCanSave,
    onSaveSettings: onSaveSettings
  }), 'offload_media' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_OffloadMedia__WEBPACK_IMPORTED_MODULE_10__["default"], {
    settings: settings,
    canSave: canSave,
    setSettings: setSettings,
    setCanSave: setCanSave,
    onSaveSettings: onSaveSettings
  }), 'watermark' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Watermark__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-start items-center gap-5 mt-8"
  }, 'watermark' !== tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "primary",
    isBusy: isLoading,
    disabled: !canSave,
    className: "optml__button flex w-full justify-center rounded font-bold min-h-40 basis-1/5",
    onClick: onSaveSettings
  }, optimoleDashboardApp.strings.options_strings.save_changes), 'disabled' === settings.autoquality && 'compression' === tab && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "default",
    disabled: isLoading,
    onClick: toggleShowSample
  }, optimoleDashboardApp.strings.options_strings.view_sample_image))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Settings);

/***/ }),

/***/ "./assets/src/dashboard/parts/connecting/index.js":
/*!********************************************************!*\
  !*** ./assets/src/dashboard/parts/connecting/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/ProgressBar */ "./assets/src/dashboard/parts/components/ProgressBar.js");

/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */

const progressMessages = [optimoleDashboardApp.strings.options_strings.connect_step_0, optimoleDashboardApp.strings.options_strings.connect_step_1, optimoleDashboardApp.strings.options_strings.connect_step_2, optimoleDashboardApp.strings.options_strings.connect_step_3];
const ConnectingLayout = () => {
  const [progress, setProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
  const [step, setStep] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
  const [timer, setTimer] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
  const maxTime = 5;
  const {
    sethasDashboardLoaded
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)('optimole');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (timer <= maxTime) {
      const timeout = setTimeout(() => {
        updateProgress();
      }, 1000);
      return () => {
        if (timeout) {
          clearTimeout(timeout);
        }
      };
    }
  }, [timer]);
  const updateProgress = () => {
    setTimer(timer + 1);
    if (timer >= maxTime) {
      sethasDashboardLoaded(true);
      setTimer(0);
      setStep(0);
      setProgress(0);
      return;
    }
    setProgress(Math.floor(timer / maxTime * 100));
    if (progress > (step + 1) * 30) {
      setStep(step + 1);
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "optml-connecting flex flex-col justify-between max-w-screen-xl mt-8 mb-5 mx-auto p-0 transition-all ease-in-out duration-700 relative bg-white text-gray-700 border-0 rounded-lg shadow-md"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col md:flex-row items-center justify-center gap-5 px-8 sm:px-0 py-24"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "max-w-full",
    src: optimoleDashboardApp.assets_url + 'img/connecting.png'
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center md:text-left"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "font-bold text-2xl"
  }, optimoleDashboardApp.strings.account_connecting_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-base"
  }, optimoleDashboardApp.strings.account_connecting_subtitle), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_ProgressBar__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: "mt-2.5 mb-1.5 mx-0 h-5 border-gray-200",
    value: timer,
    max: maxTime,
    background: "#e6e6e6"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-xs"
  }, progressMessages[step] + ' ' + '(' + progress + '%)'))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConnectingLayout);

/***/ }),

/***/ "./assets/src/dashboard/parts/disconnect/index.js":
/*!********************************************************!*\
  !*** ./assets/src/dashboard/parts/disconnect/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/api */ "./assets/src/dashboard/utils/api.js");

/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */

const DisconnectLayout = () => {
  const {
    setShowDisconnect
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('optimole');
  const {
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      isLoading
    } = select('optimole');
    return {
      isLoading: isLoading()
    };
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Modal, {
    title: optimoleDashboardApp.strings.disconnect_title,
    className: "optml__modal",
    onRequestClose: () => setShowDisconnect(false)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: optimoleDashboardApp.strings.disconnect_desc
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    variant: "default",
    className: "optml__button flex w-full justify-center rounded font-bold mt-4 min-h-40",
    onClick: () => setShowDisconnect(false)
  }, optimoleDashboardApp.strings.keep_connected), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isDestructive: true,
    className: "optml__button flex w-full justify-center rounded font-bold mt-4 min-h-40",
    isBusy: isLoading,
    disabled: isLoading,
    onClick: _utils_api__WEBPACK_IMPORTED_MODULE_3__.disconnectAccount
  }, optimoleDashboardApp.strings.disconnect_btn)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DisconnectLayout);

/***/ }),

/***/ "./assets/src/dashboard/store/actions.js":
/*!***********************************************!*\
  !*** ./assets/src/dashboard/store/actions.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const actions = {
  setAutoConnect(autoConnect) {
    return {
      type: 'SET_AUTO_CONNECT',
      autoConnect
    };
  },
  setAPIKey(apiKey) {
    return {
      type: 'SET_API_KEY',
      apiKey
    };
  },
  setAvailableApps(availableApps) {
    return {
      type: 'SET_AVAILABLE_APPS',
      availableApps
    };
  },
  setIsConnected(isConnected) {
    return {
      type: 'SET_IS_CONNECTED',
      isConnected
    };
  },
  setIsConnecting(isConnecting) {
    return {
      type: 'SET_IS_CONNECTING',
      isConnecting
    };
  },
  setIsLoading(isLoading) {
    return {
      type: 'SET_IS_LOADING',
      isLoading
    };
  },
  sethasDashboardLoaded(hasDashboardLoaded) {
    return {
      type: 'SET_HAS_DASHBOARD_LOADED',
      hasDashboardLoaded
    };
  },
  setHasRestError(hasRestError) {
    return {
      type: 'SET_HAS_REST_ERROR',
      hasRestError
    };
  },
  setHasValidKey(hasValidKey) {
    return {
      type: 'SET_HAS_VALID_KEY',
      hasValidKey
    };
  },
  setHasApplication(hasApplication) {
    return {
      type: 'SET_HAS_APPLICATION',
      hasApplication
    };
  },
  setUserData(data) {
    return {
      type: 'SET_USER_DATA',
      data
    };
  },
  setUserStatus(status) {
    return {
      type: 'SET_USER_STATUS',
      status
    };
  },
  setShowDisconnect(showDisconnect) {
    return {
      type: 'SET_SHOW_DISCONNECT',
      showDisconnect
    };
  },
  setConflicts(conflicts) {
    return {
      type: 'SET_CONFLICTS',
      conflicts
    };
  },
  setOptimizedImages(optimizedImages) {
    return {
      type: 'SET_OPTIMIZED_IMAGES',
      optimizedImages
    };
  },
  setSiteSettings(siteSettings) {
    return {
      type: 'SET_SITE_SETTINGS',
      siteSettings
    };
  },
  setExtraVisits(extraVisitsStatus) {
    return {
      type: 'SET_EXTRA_VISITS',
      extraVisitsStatus
    };
  },
  setSampleRate(sampleRate) {
    return {
      type: 'SET_SAMPLE_RATE',
      sampleRate
    };
  },
  setTotalNumberOfImages(totalNumberOfImages) {
    return {
      type: 'SET_TOTAL_NUMBER_OF_IMAGES',
      totalNumberOfImages
    };
  },
  setProcessedImages(processedImages) {
    return {
      type: 'SET_PROCESSED_IMAGES',
      processedImages
    };
  },
  setOffloadLibraryLink(offloadLibraryLink) {
    return {
      type: 'SET_OFFLOAD_LIBRARY_LINK',
      offloadLibraryLink
    };
  },
  setRollbackLibraryLink(rollbackLibraryLink) {
    return {
      type: 'SET_ROLLBACK_LIBRARY_LINK',
      rollbackLibraryLink
    };
  },
  setLoadingRollback(loadingRollback) {
    return {
      type: 'SET_LOADING_ROLLBACK',
      loadingRollback
    };
  },
  setLoadingSync(loadingSync) {
    return {
      type: 'SET_LOADING_SYNC',
      loadingSync
    };
  },
  setQueryArgs(queryArgs) {
    return {
      type: 'SET_QUERY_ARGS',
      queryArgs
    };
  },
  setErrorMedia(errorMedia) {
    return {
      type: 'SET_ERROR_MEDIA',
      errorMedia
    };
  },
  setEstimatedTime(estimatedTime) {
    return {
      type: 'SET_ESTIMATED_TIME',
      estimatedTime
    };
  },
  setCheckedOffloadConflicts(checkedOffloadConflicts) {
    return {
      type: 'SET_CHECKED_OFFLOAD_CONFLICTS',
      checkedOffloadConflicts
    };
  },
  setOffloadConflicts(offloadConflicts) {
    return {
      type: 'SET_OFFLOAD_CONFLICTS',
      offloadConflicts
    };
  },
  setLogs(logsType, logs) {
    return {
      type: 'SET_LOGS',
      logsType,
      logs
    };
  },
  setShowFinishNotice(nextVal) {
    return {
      type: 'SET_SITE_SETTINGS',
      siteSettings: {
        'show_offload_finish_notice': nextVal
      }
    };
  },
  setOffloadLimitReached(nextVal) {
    return {
      type: 'SET_SITE_SETTINGS',
      siteSettings: {
        'offload_limit_reached': nextVal
      }
    };
  },
  ensureOffloadingRollbackDisabled() {
    return {
      type: 'SET_SITE_SETTINGS',
      siteSettings: {
        'offloading_status': 'disabled',
        'rollback_status': 'disabled'
      }
    };
  },
  setOffloadLimit(nextVal) {
    return {
      type: 'SET_OFFLOAD_LIMIT',
      offloadLimit: nextVal
    };
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (actions);

/***/ }),

/***/ "./assets/src/dashboard/store/index.js":
/*!*********************************************!*\
  !*** ./assets/src/dashboard/store/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./actions */ "./assets/src/dashboard/store/actions.js");
/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reducer */ "./assets/src/dashboard/store/reducer.js");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./selectors */ "./assets/src/dashboard/store/selectors.js");
/**
 * Internal dependencies.
 */



if (undefined !== wp.data.createReduxStore) {
  const store = wp.data.createReduxStore('optimole', {
    reducer: _reducer__WEBPACK_IMPORTED_MODULE_1__["default"],
    actions: _actions__WEBPACK_IMPORTED_MODULE_0__["default"],
    selectors: _selectors__WEBPACK_IMPORTED_MODULE_2__["default"]
  });
  wp.data.register(store);
} else {
  wp.data.registerStore('optimole', {
    reducer: _reducer__WEBPACK_IMPORTED_MODULE_1__["default"],
    actions: _actions__WEBPACK_IMPORTED_MODULE_0__["default"],
    selectors: _selectors__WEBPACK_IMPORTED_MODULE_2__["default"]
  });
}

/***/ }),

/***/ "./assets/src/dashboard/store/reducer.js":
/*!***********************************************!*\
  !*** ./assets/src/dashboard/store/reducer.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* global optimoleDashboardApp */
const DEFAULT_STATE = {
  autoConnect: optimoleDashboardApp.auto_connect,
  isConnected: 'yes' === optimoleDashboardApp.connection_status,
  isConnecting: false,
  isLoading: false,
  hasRestError: false,
  hasValidKey: true,
  hasApplication: 'yes' === optimoleDashboardApp.has_application,
  apiKey: optimoleDashboardApp.api_key ? optimoleDashboardApp.api_key : '',
  userStatus: optimoleDashboardApp.user_status ? optimoleDashboardApp.user_status : 'inactive',
  userData: optimoleDashboardApp.user_data ? optimoleDashboardApp.user_data : null,
  availableApps: optimoleDashboardApp.available_apps ? optimoleDashboardApp.available_apps : null,
  hasDashboardLoaded: 'yes' === optimoleDashboardApp.connection_status,
  showDisconnect: false,
  conflicts: [],
  optimizedImages: [],
  siteSettings: optimoleDashboardApp.site_settings,
  sampleRate: {},
  totalNumberOfImages: 0,
  processedImages: 0,
  offloadLibraryLink: false,
  rollbackLibraryLink: false,
  loadingRollback: false,
  loadingSync: false,
  queryArgs: [],
  errorMedia: false,
  checkedOffloadConflicts: false,
  offloadConflicts: [],
  offloadLimit: optimoleDashboardApp.offload_limit || 50000,
  logs: {
    offload: '',
    rollback: ''
  },
  canShowFreeUserWithOffloadNotice: 'yes' === optimoleDashboardApp?.show_free_user_with_offload_notice
};
const reducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case 'SET_AUTO_CONNECT':
      return {
        ...state,
        autoConnect: action.autoConnect
      };
    case 'SET_HAS_REST_ERROR':
      return {
        ...state,
        hasRestError: action.hasRestError
      };
    case 'SET_API_KEY':
      return {
        ...state,
        apiKey: action.apiKey
      };
    case 'SET_AVAILABLE_APPS':
      return {
        ...state,
        availableApps: action.availableApps
      };
    case 'SET_IS_CONNECTED':
      return {
        ...state,
        isConnected: action.isConnected
      };
    case 'SET_IS_CONNECTING':
      return {
        ...state,
        isConnecting: action.isConnecting
      };
    case 'SET_IS_LOADING':
      return {
        ...state,
        isLoading: action.isLoading
      };
    case 'SET_HAS_DASHBOARD_LOADED':
      return {
        ...state,
        hasDashboardLoaded: action.hasDashboardLoaded
      };
    case 'SET_HAS_REST_ERROR':
      return {
        ...state,
        hasRestError: action.hasRestError
      };
    case 'SET_HAS_VALID_KEY':
      return {
        ...state,
        hasValidKey: action.hasValidKey
      };
    case 'SET_HAS_APPLICATION':
      return {
        ...state,
        hasApplication: action.hasApplication
      };
    case 'SET_USER_DATA':
      let status = 'inactive';
      const {
        data
      } = action;
      if (data && data.app_count && 1 <= data.app_count && data.cdn_key) {
        for (let app of data.available_apps) {
          if (app.key && app.key === data.cdn_key && app.status && 'active' === app.status) {
            status = 'active';
          }
        }
      }
      return {
        ...state,
        userData: action.data,
        userStatus: status
      };
    case 'SET_USER_STATUS':
      return {
        ...state,
        userStatus: action.status
      };
    case 'SET_SHOW_DISCONNECT':
      return {
        ...state,
        showDisconnect: action.showDisconnect
      };
    case 'SET_CONFLICTS':
      return {
        ...state,
        conflicts: action.conflicts
      };
    case 'SET_OPTIMIZED_IMAGES':
      return {
        ...state,
        optimizedImages: action.optimizedImages
      };
    case 'SET_SITE_SETTINGS':
      let {
        siteSettings
      } = state;
      for (let setting in action.siteSettings) {
        siteSettings[setting] = action.siteSettings[setting];
      }
      return {
        ...state,
        siteSettings
      };
    case 'SET_EXTRA_VISITS':
      {
        let {
          siteSettings
        } = state;
        siteSettings['banner_frontend'] = action.extraVisitsStatus ? 'enabled' : 'disabled';
        return {
          ...state,
          siteSettings
        };
      }
    case 'SET_SAMPLE_RATE':
      return {
        ...state,
        sampleRate: action.sampleRate
      };
    case 'SET_TOTAL_NUMBER_OF_IMAGES':
      return {
        ...state,
        totalNumberOfImages: action.totalNumberOfImages
      };
    case 'SET_PROCESSED_IMAGES':
      return {
        ...state,
        processedImages: action.processedImages
      };
    case 'SET_OFFLOAD_LIBRARY_LINK':
      return {
        ...state,
        offloadLibraryLink: action.offloadLibraryLink
      };
    case 'SET_ROLLBACK_LIBRARY_LINK':
      return {
        ...state,
        rollbackLibraryLink: action.rollbackLibraryLink
      };
    case 'SET_LOADING_ROLLBACK':
      if (Object.prototype.hasOwnProperty.call(state.queryArgs, 'optimole_action')) {
        state.rollbackLibraryLink = !action.loadingSync;
      }
      return {
        ...state,
        loadingRollback: action.loadingRollback
      };
    case 'SET_LOADING_SYNC':
      if (Object.prototype.hasOwnProperty.call(state.queryArgs, 'optimole_action')) {
        state.offloadLibraryLink = !action.loadingSync;
      }
      return {
        ...state,
        loadingSync: action.loadingSync
      };
    case 'SET_QUERY_ARGS':
      return {
        ...state,
        queryArgs: action.queryArgs
      };
    case 'SET_ERROR_MEDIA':
      return {
        ...state,
        errorMedia: action.errorMedia
      };
    case 'SET_CHECKED_OFFLOAD_CONFLICTS':
      return {
        ...state,
        checkedOffloadConflicts: action.checkedOffloadConflicts
      };
    case 'SET_OFFLOAD_CONFLICTS':
      return {
        ...state,
        offloadConflicts: action.offloadConflicts
      };
    case 'SET_LOGS':
      let {
        logs
      } = state;
      logs[action.logsType] = action.logs;
      return {
        ...state,
        logs
      };
    case 'SET_OFFLOAD_LIMIT':
      return {
        ...state,
        offloadLimit: action.offloadLimit
      };
    default:
      return state;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reducer);

/***/ }),

/***/ "./assets/src/dashboard/store/selectors.js":
/*!*************************************************!*\
  !*** ./assets/src/dashboard/store/selectors.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const selectors = {
  getAutoConnect(state) {
    return state.autoConnect;
  },
  getAPIKey(state) {
    return state.apiKey;
  },
  getAvailableApps(state) {
    return state.availableApps;
  },
  hasRestError(state) {
    return state.hasRestError;
  },
  hasValidKey(state) {
    return state.hasValidKey;
  },
  hasApplication(state) {
    return state.hasApplication;
  },
  hasDashboardLoaded(state) {
    return state.hasDashboardLoaded;
  },
  getUserData(state) {
    return state.userData;
  },
  getUserStatus(state) {
    return state.userStatus;
  },
  isConnected(state) {
    return state.isConnected;
  },
  isConnecting(state) {
    return state.isConnecting;
  },
  isLoading(state) {
    return state.isLoading;
  },
  showDisconnect(state) {
    return state.showDisconnect;
  },
  getConflicts(state) {
    return state.conflicts;
  },
  getOptimizedImages(state) {
    return state.optimizedImages;
  },
  getSiteSettings(state, setting = undefined) {
    if (setting) {
      return undefined !== state.siteSettings[setting] ? state.siteSettings[setting] : undefined;
    }
    return state.siteSettings;
  },
  getSampleRate(state) {
    return state.sampleRate;
  },
  getTotalNumberOfImages(state) {
    return state.totalNumberOfImages;
  },
  getProcessedImages(state) {
    return state.processedImages;
  },
  getOffloadLibraryLink(state) {
    return state.offloadLibraryLink;
  },
  getRollbackLibraryLink(state) {
    return state.rollbackLibraryLink;
  },
  getLoadingRollback(state) {
    return state.loadingRollback;
  },
  getLoadingSync(state) {
    return state.loadingSync;
  },
  getQueryArgs(state) {
    return state.queryArgs;
  },
  getErrorMedia(state) {
    return state.errorMedia;
  },
  getCheckedOffloadConflicts(state) {
    return state.checkedOffloadConflicts;
  },
  getOffloadConflicts(state) {
    return state.offloadConflicts;
  },
  getOffloadLimit(state) {
    return state.offloadLimit;
  },
  getLogs(state, type = undefined) {
    if (type) {
      return undefined !== state.logs[type] ? state.logs[type] : undefined;
    }
    return state.logs;
  },
  isSubApiKey(state) {
    return state.apiKey && state.apiKey.startsWith('optml-s');
  },
  canShowFreeUserWithOffloadNotice(state) {
    return Boolean(state?.canShowFreeUserWithOffloadNotice);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (selectors);

/***/ }),

/***/ "./assets/src/dashboard/utils/api.js":
/*!*******************************************!*\
  !*** ./assets/src/dashboard/utils/api.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addNotice: () => (/* binding */ addNotice),
/* harmony export */   callSync: () => (/* binding */ callSync),
/* harmony export */   checkOffloadConflicts: () => (/* binding */ checkOffloadConflicts),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   clearOffloadErrors: () => (/* binding */ clearOffloadErrors),
/* harmony export */   connectAccount: () => (/* binding */ connectAccount),
/* harmony export */   disconnectAccount: () => (/* binding */ disconnectAccount),
/* harmony export */   dismissConflict: () => (/* binding */ dismissConflict),
/* harmony export */   dismissNotice: () => (/* binding */ dismissNotice),
/* harmony export */   registerAccount: () => (/* binding */ registerAccount),
/* harmony export */   requestStatsUpdate: () => (/* binding */ requestStatsUpdate),
/* harmony export */   retrieveConflicts: () => (/* binding */ retrieveConflicts),
/* harmony export */   retrieveOptimizedImages: () => (/* binding */ retrieveOptimizedImages),
/* harmony export */   sampleRate: () => (/* binding */ sampleRate),
/* harmony export */   saveSettings: () => (/* binding */ saveSettings),
/* harmony export */   selectDomain: () => (/* binding */ selectDomain),
/* harmony export */   sendOnboardingImages: () => (/* binding */ sendOnboardingImages)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/notices */ "@wordpress/notices");
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_notices__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./helpers */ "./assets/src/dashboard/utils/helpers.js");
/**
 * WordPress dependencies.
 */





const {
  setIsConnected,
  setIsConnecting,
  setIsLoading,
  setHasRestError,
  setHasValidKey,
  setHasApplication,
  setAPIKey,
  setUserData,
  setAvailableApps,
  sethasDashboardLoaded,
  setShowDisconnect,
  setConflicts,
  setOptimizedImages,
  setSiteSettings,
  setSampleRate,
  setCheckedOffloadConflicts,
  setOffloadConflicts,
  setLoadingSync,
  setLoadingRollback,
  setTotalNumberOfImages,
  setProcessedImages,
  setErrorMedia,
  setOffloadLibraryLink,
  setRollbackLibraryLink,
  setExtraVisits,
  setLogs,
  setShowFinishNotice,
  setOffloadLimitReached,
  ensureOffloadingRollbackDisabled,
  setOffloadLimit
} = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.dispatch)('optimole');
const {
  getOptimizedImages,
  getQueryArgs,
  getTotalNumberOfImages,
  getSiteSettings
} = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.select)('optimole');
const {
  createNotice
} = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.dispatch)(_wordpress_notices__WEBPACK_IMPORTED_MODULE_3__.store);
const sendOnboardingImages = (data = {}) => {
  data.offset = undefined !== data.offset ? data.offset : 0;
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['upload_onboard_images'],
    method: 'POST',
    data
  }).then(response => {
    if (false === response.data && 1000 > data.offset) {
      sendOnboardingImages({
        offset: data.offset + 100
      });
    }
    if ('success' === response.code) {
      console.log('%c Images Crawled.', 'color: #59B278');
    }
  }).catch(error => {
    console.log('Error while crawling images', error);
    return error.data;
  });
};
const registerAccount = (data, callback = () => {}) => {
  setIsConnecting(true);
  setIsLoading(true);
  setHasRestError(false);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['register_service'],
    method: 'POST',
    data,
    parse: false
  }).then(response => response.json()).then(response => {
    setIsConnecting(false);
    setIsLoading(false);
    if ('success' === response.code) {
      setIsConnected(true);
      setHasValidKey(true);
      setHasApplication(true);
      setAPIKey(response.data.api_key);
      setUserData(response.data);
      setAvailableApps(response.data);
      sendOnboardingImages();
      (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.toggleDashboardSidebarSubmenu)(true);
    }
    if (callback) {
      callback(response);
    }
    return response.data;
  }).catch(error => {
    setIsConnecting(false);
    setIsLoading(false);
    setHasRestError(true);
    return error.data;
  });
};
const connectAccount = (data, callback = () => {}) => {
  setIsConnecting(true);
  setIsLoading(true);
  setHasRestError(false);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes.connect,
    method: 'POST',
    data,
    parse: false
  }).then(response => response.json()).then(response => {
    setIsConnecting(false);
    setIsLoading(false);
    if ('success' === response.code) {
      setIsConnected(true);
      setHasValidKey(true);
      setAPIKey(response.data.api_key);
      if (response.data['app_count'] !== undefined && 1 < response.data['app_count']) {
        setAvailableApps(response.data);
      } else {
        setHasApplication(true);
        setUserData(response.data);
      }
      sendOnboardingImages();
      (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.toggleDashboardSidebarSubmenu)(true);
      console.log('%c Optimole API connection successful.', 'color: #59B278');
    } else {
      setHasValidKey(false);
      console.log('%c Invalid API Key.', 'color: #E7602A');
    }
    if (callback) {
      callback(response);
    }
    return response.data;
  }).catch(error => {
    setIsConnecting(false);
    setIsLoading(false);
    setHasRestError(true);
    return error.data;
  });
};
const disconnectAccount = () => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes.disconnect,
    method: 'GET',
    parse: false
  }).then(response => {
    setIsLoading(false);
    setHasApplication(false);
    setAPIKey('');
    setUserData(null);
    setAvailableApps(null);
    if (response.ok) {
      setIsConnected(false);
      sethasDashboardLoaded(false);
      setShowDisconnect(false);
      (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.toggleDashboardSidebarSubmenu)(false);
      console.log('%c Disconnected from Optimole API.', 'color: #59B278');
    } else {
      console.error(response);
    }
  });
};
const selectDomain = (data, callback = () => {}) => {
  setIsConnecting(true);
  setHasRestError(false);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['select_application'],
    method: 'POST',
    data
  }).then(response => {
    setIsConnecting(false);
    setIsLoading(false);
    if ('success' === response.code) {
      setHasValidKey(true);
      setHasApplication(true);
      setAPIKey(response.data.api_key);
      setUserData(response.data);
      setAvailableApps(response.data);
      console.log('%c Optimole API connection successful.', 'color: #59B278');
    } else {
      setHasValidKey(false);
      console.log('%c Invalid API Key.', 'color: #E7602A');
    }
    if (callback) {
      callback(response);
    }
  }).catch(error => {
    setIsConnecting(false);
    setHasRestError(true);
    return error.data;
  });
};
const requestStatsUpdate = () => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['request_update'],
    method: 'GET',
    parse: false
  }).then(response => {
    if (200 <= response.status && 300 > response.status) {
      return response.json();
    } else {
      console.log(`%c Request failed with status ${response.status}`, 'color: #E7602A');
      return Promise.resolve();
    }
  }).then(response => {
    setIsLoading(false);
    if (!response) {
      return;
    }
    setUserData(response.data);
    if (response?.data?.extra_visits !== undefined) {
      setExtraVisits(response.data.extra_visits);
    }
    if ('disconnected' === response.code) {
      setIsConnected(false);
      sethasDashboardLoaded(false);
      console.log('%c Disconnected from Optimole API.', 'color: #59B278');
    }
  });
};
const retrieveConflicts = () => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['poll_conflicts'],
    method: 'GET',
    parse: false
  }).then(response => {
    if (200 <= response.status && 300 > response.status) {
      return response.json();
    } else {
      console.log(`%c Request failed with status ${response.status}`, 'color: #E7602A');
      return Promise.resolve();
    }
  }).then(response => {
    setIsLoading(false);
    if (!response) {
      return;
    }
    setConflicts(response.data);
  });
};
const dismissConflict = (conflictID, callback = () => {}) => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['dismiss_conflict'],
    method: 'POST',
    data: {
      conflictID
    }
  }).then(response => {
    setIsLoading(false);
    if ('success' === response.code) {
      setConflicts(response.data);
    }
    if (callback) {
      callback(response);
    }
  });
};
const retrieveOptimizedImages = (callback = () => {}) => {
  const optimizedImages = getOptimizedImages();
  if (0 < optimizedImages.length) {
    console.log('%c Images already exist.', 'color: #59B278');
    if (callback) {
      callback();
    }
    return false;
  }
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['poll_optimized_images'],
    method: 'GET'
  }).then(response => {
    if ('success' === response.code) {
      setOptimizedImages(response.data);
      console.log('%c Images Fetched.', 'color: #59B278');
    } else {
      console.log('%c No images available.', 'color: #E7602A');
    }
    if (callback) {
      callback(response);
    }
  }).catch(error => {
    console.log('Error while polling images', error);
    return error.data;
  });
};
const saveSettings = (settings, refreshStats = false, skipNotice = false, callback = () => {}) => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['update_option'],
    method: 'POST',
    data: {
      settings
    }
  }).then(response => {
    setIsLoading(false);
    if ('success' === response.code) {
      setSiteSettings(response.data);
      if (!skipNotice) {
        addNotice(optimoleDashboardApp.strings.options_strings.settings_saved);
      }
      console.log('%c Settings Saved.', 'color: #59B278');
    }
  }).then(() => {
    if (!refreshStats) {
      return;
    }
    requestStatsUpdate();
  }).then(() => {
    callback();
  }).catch(error => {
    setIsLoading(false);
    addNotice(optimoleDashboardApp.strings.options_strings.settings_saved_error);
    console.log('Error while saving settings', error);
    return error.data;
  });
};
const clearCache = type => {
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['clear_cache_request'],
    method: 'POST',
    data: {
      type
    },
    parse: false
  }).then(response => {
    setIsLoading(false);
    if (200 <= response.status && 300 > response.status) {
      addNotice(optimoleDashboardApp.strings.options_strings.cache_cleared);
      console.log('%c New cache token generated.', 'color: #59B278');
      return;
    } else {
      addNotice(optimoleDashboardApp.strings.options_strings.cache_cleared_error);
      console.log('%c Could not generate cache token.', 'color: #E7602A');
      return;
    }
  });
};
const sampleRate = (data, callback = () => {}) => {
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.addQueryArgs)(optimoleDashboardApp.routes['get_sample_rate'], {
      quality: data.quality,
      force: data?.force || 'no'
    }),
    method: 'POST'
  }).then(response => {
    if ('success' === response.code) {
      setSampleRate(response.data);
    }
    if (callback) {
      callback(response);
    }
  });
};
const checkOffloadConflicts = (callback = () => {}) => {
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['get_offload_conflicts'],
    method: 'GET'
  }).then(response => {
    setCheckedOffloadConflicts(true);
    if (0 !== response.data.length) {
      setOffloadConflicts(response.data);
    }
    if (callback) {
      callback(response);
    }
  });
};
const updateLogs = type => {
  jQuery.ajax({
    type: 'POST',
    url: window.ajaxurl,
    data: {
      action: 'optml_fetch_logs',
      nonce: optimoleDashboardApp.nonce,
      type
    },
    success: response => {
      setLogs(type, response);
    }
  });
};
const callSync = data => {
  const queryArgs = getQueryArgs();
  if ('offload_images' === data.action) {
    if (Object.prototype.hasOwnProperty.call(queryArgs, 'optimole_action')) {
      setOffloadLibraryLink(false);
    }
    setLoadingSync(true);
  }
  if ('rollback_images' === data.action) {
    if (Object.prototype.hasOwnProperty.call(queryArgs, 'optimole_action')) {
      setRollbackLibraryLink(false);
    }
    setLoadingRollback(true);
  }
  setIsLoading(true);
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['number_of_images_and_pages'],
    method: 'POST',
    data: {
      action: data.action,
      refresh: data.refresh || false
    },
    parse: false
  }).then(response => {
    if (200 <= response.status && 300 > response.status) {
      return response.json();
    } else {
      if ('offload_images' === data.action) {
        setLoadingSync(false);
        setIsLoading(false);
      }
      if ('rollback_images' === data.action) {
        setLoadingRollback(false);
        setIsLoading(false);
      }
    }
  }).then(response => {
    if (!response.data.count || 0 === response.data.count || false === response.data.status) {
      console.log('%c No images available.', 'color: #E7602A');
      setLoadingSync(false);
      setLoadingRollback(false);
      setIsLoading(false);
      if (0 === response.data.count) {
        setOffloadLimitReached('disabled');
        setShowFinishNotice(response.data.action);
      }
      if (response.data.reached_limit) {
        setOffloadLimitReached(response.data.reached_limit ? 'enabled' : 'disabled');
      }
      if (response.data.offload_limit) {
        setOffloadLimit(response.data.offload_limit);
      }
      ensureOffloadingRollbackDisabled();
      saveSettings(getSiteSettings(), false);
      if ('offload_images' === data.action) {
        if (Object.prototype.hasOwnProperty.call(queryArgs, 'optimole_action')) {
          setOffloadLibraryLink(true);
        }
      }
      if ('rollback_images' === data.action) {
        if (Object.prototype.hasOwnProperty.call(queryArgs, 'optimole_action')) {
          setRollbackLibraryLink(true);
        }
      }
      return;
    }
    let images = getTotalNumberOfImages();
    if (data.refresh) {
      setProcessedImages(0 !== images ? Math.abs(images - response.data.count) : 0);
      if (0 !== response.data.count && 0 === images) {
        setTotalNumberOfImages(response.data.count);
      }
    } else {
      setTotalNumberOfImages(response.data.count);
    }
    setTimeout(() => {
      callSync({
        action: data.action,
        refresh: true
      });
    }, 10000);
  }).finally(() => {
    updateLogs('offload_images' === data.action ? 'offload' : 'rollback');
  }).catch(error => {
    setErrorMedia(data.action);
    setLoadingSync(false);
    setLoadingRollback(false);
  });
};
const clearOffloadErrors = async () => {
  try {
    return await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: optimoleDashboardApp.routes['clear_offload_errors'],
      method: 'GET'
    });
  } catch (error) {
    console.log(error);
  }
};
const addNotice = text => {
  createNotice('info', text, {
    isDismissible: true,
    type: 'snackbar'
  });
};
const dismissNotice = (key, callback = () => {}) => {
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
    path: optimoleDashboardApp.routes['dismiss_notice'],
    method: 'POST',
    data: {
      key
    }
  }).then(response => {
    if ('success' !== response.code) {
      addNotice(response?.data?.error || optimoleDashboardApp.strings.options_strings.settings_saved_error);
      return;
    }
    if (callback) {
      callback(response);
    }
  }).catch(err => {
    addNotice(optimoleDashboardApp.strings.options_strings.settings_saved_error);
  });
};

/***/ }),

/***/ "./assets/src/dashboard/utils/helpers.js":
/*!***********************************************!*\
  !*** ./assets/src/dashboard/utils/helpers.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   highlightSidebarLink: () => (/* binding */ highlightSidebarLink),
/* harmony export */   toggleDamSidebarLink: () => (/* binding */ toggleDamSidebarLink),
/* harmony export */   toggleDashboardSidebarSubmenu: () => (/* binding */ toggleDashboardSidebarSubmenu)
/* harmony export */ });
const links = window.optimoleDashboardApp.submenu_links;
const toggleDamSidebarLink = (show = true) => {
  const {
    dam_url,
    strings
  } = window.optimoleDashboardApp;
  const {
    cloud_library
  } = strings;
  const existingPage = document.querySelector('a[href*="page=optimole-dam"]');

  // Bail on first call when dashboard is loaded.
  if (!show && !existingPage) {
    return;
  }

  // Remove the DAM link.
  if (!show) {
    if (!existingPage) {
      return;
    }
    existingPage.style.display = 'none';
    return;
  }
  if (existingPage) {
    existingPage.style = {};
    return;
  }

  // Create a new link and add it to the menu.
  const li = document.createElement('li');
  const a = document.createElement('a');
  li.appendChild(a);
  a.href = dam_url;
  a.innerHTML = cloud_library;
  const existingSubmenu = document.querySelector('#toplevel_page_optimole ul');
  if (!existingSubmenu) {
    return;
  }
  existingSubmenu.insertBefore(li, existingSubmenu.firstChild);
};
const highlightSidebarLink = () => {
  links.forEach(link => {
    const existingLink = document.querySelector(`a[href="${link.href}"]`);
    if (!existingLink) {
      return;
    }
    const parent = existingLink.parentNode;
    if (link.hash && link.hash === window.location.hash) {
      existingLink.classList.add('current');
      parent.classList.add('current');
      return;
    }
    existingLink.classList.remove('current');
    parent.classList.remove('current');
  });
};
const toggleDashboardSidebarSubmenu = (show = true) => {
  const topLevel = document.querySelector('li#toplevel_page_optimole');
  let existingList = document.querySelector('li#toplevel_page_optimole .wp-submenu');
  if (!existingList) {
    existingList = document.createElement('ul');
    existingList.classList.add('wp-submenu', 'wp-submenu-wrap');
    topLevel.classList.add('wp-has-submenu', 'wp-has-current-submenu', 'wp-menu-open');
    topLevel.appendChild(existingList);
  }

  // Hiding it - display: none;
  if (!show) {
    existingList.style.display = 'none';
    return;
  }
  links.forEach(link => {
    const existingLink = document.querySelector(`li#toplevel_page_optimole a[href="${link.href}"]`);
    if (existingLink) {
      return;
    }
    const li = document.createElement('li');
    const a = document.createElement('a');
    a.href = link.href;
    a.innerHTML = link.text;
    li.appendChild(a);
    if (link.hash && link.hash === window.location.hash) {
      li.classList.add('current');
      a.classList.add('current');
    }
    existingList.appendChild(li);
  });
  existingList.style.display = 'block';
};


/***/ }),

/***/ "./assets/src/dashboard/utils/icons.js":
/*!*********************************************!*\
  !*** ./assets/src/dashboard/utils/icons.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrowDownToLine: () => (/* binding */ arrowDownToLine),
/* harmony export */   bolt: () => (/* binding */ bolt),
/* harmony export */   chartBarDecreasing: () => (/* binding */ chartBarDecreasing),
/* harmony export */   checkmark: () => (/* binding */ checkmark),
/* harmony export */   cloudDownload: () => (/* binding */ cloudDownload),
/* harmony export */   compressionPercentage: () => (/* binding */ compressionPercentage),
/* harmony export */   connected: () => (/* binding */ connected),
/* harmony export */   disconnected: () => (/* binding */ disconnected),
/* harmony export */   globe: () => (/* binding */ globe),
/* harmony export */   imagesNumber: () => (/* binding */ imagesNumber),
/* harmony export */   offload: () => (/* binding */ offload),
/* harmony export */   offloadImage: () => (/* binding */ offloadImage),
/* harmony export */   quota: () => (/* binding */ quota),
/* harmony export */   rollback: () => (/* binding */ rollback),
/* harmony export */   savedSize: () => (/* binding */ savedSize),
/* harmony export */   settings: () => (/* binding */ settings),
/* harmony export */   sync: () => (/* binding */ sync),
/* harmony export */   traffic: () => (/* binding */ traffic),
/* harmony export */   update: () => (/* binding */ update),
/* harmony export */   user: () => (/* binding */ user),
/* harmony export */   warning: () => (/* binding */ warning),
/* harmony export */   warningAlt: () => (/* binding */ warningAlt)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const disconnected = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "21",
  height: "20",
  viewBox: "0 0 21 20",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M17.357 2.92894C16.9664 2.53842 16.3333 2.53842 15.9427 2.92894C15.5522 3.31946 15.5522 3.95263 15.9427 4.34315L17.357 2.92894ZM16.6499 16.364L15.9427 17.0711H15.9427L16.6499 16.364ZM14.5285 5.75737C14.138 5.36684 13.5048 5.36684 13.1143 5.75737C12.7238 6.14789 12.7238 6.78106 13.1143 7.17158L14.5285 5.75737ZM13.8214 13.5355L13.1143 14.2426L13.1143 14.2427L13.8214 13.5355ZM6.04325 14.2427C6.43377 14.6332 7.06694 14.6332 7.45746 14.2427C7.84799 13.8521 7.84799 13.219 7.45746 12.8284L6.04325 14.2427ZM6.32586 10.5662C6.24822 10.0194 5.74201 9.63905 5.19521 9.71669C4.64841 9.79434 4.26808 10.3005 4.34573 10.8473L6.32586 10.5662ZM3.21482 17.0711C3.60535 17.4616 4.23851 17.4616 4.62903 17.0711C5.01956 16.6806 5.01956 16.0474 4.62903 15.6569L3.21482 17.0711ZM2.70292 7.44452C2.87885 6.921 2.59707 6.354 2.07355 6.17807C1.55004 6.00215 0.98303 6.28393 0.807105 6.80744L2.70292 7.44452ZM1.993 0.292893C1.60247 -0.0976311 0.969306 -0.0976311 0.578782 0.292893C0.188258 0.683417 0.188258 1.31658 0.578782 1.70711L1.993 0.292893ZM18.5788 19.7071C18.9693 20.0976 19.6025 20.0976 19.993 19.7071C20.3835 19.3166 20.3835 18.6834 19.993 18.2929L18.5788 19.7071ZM15.9427 4.34315C19.0669 7.46735 19.0669 12.5327 15.9427 15.6569L17.357 17.0711C21.2622 13.1658 21.2622 6.83418 17.357 2.92894L15.9427 4.34315ZM13.1143 7.17158C14.6764 8.73368 14.6764 11.2663 13.1143 12.8284L14.5285 14.2427C16.8717 11.8995 16.8717 8.10051 14.5285 5.75737L13.1143 7.17158ZM10.2859 10H12.2859C12.2859 8.89544 11.3905 8.00001 10.2859 8.00001V10ZM7.45746 12.8284C6.81978 12.1908 6.44341 11.394 6.32586 10.5662L4.34573 10.8473C4.52209 12.0894 5.08876 13.2882 6.04325 14.2427L7.45746 12.8284ZM4.62903 15.6569C2.40899 13.4368 1.76507 10.2354 2.70292 7.44452L0.807105 6.80744C-0.363267 10.2902 0.43743 14.2937 3.21482 17.0711L4.62903 15.6569ZM10.2859 10L10.2859 10V8.00001C9.73388 8.00001 9.23252 8.22496 8.87168 8.58578L10.2859 10ZM0.578782 1.70711L8.87168 10L10.2859 8.58579L1.993 0.292893L0.578782 1.70711ZM8.87168 10L10.2859 11.4142L11.7001 10L10.2859 8.58579L8.87168 10ZM10.2859 11.4142L13.1143 14.2426L14.5285 12.8284L11.7001 10L10.2859 11.4142ZM13.1143 14.2427L15.9427 17.0711L17.357 15.6569L14.5285 12.8284L13.1143 14.2427ZM15.9427 17.0711L18.5788 19.7071L19.993 18.2929L17.357 15.6569L15.9427 17.0711ZM10.2859 10L10.2859 10L11.7001 11.4142C12.0609 11.0534 12.2859 10.552 12.2859 10H10.2859Z",
  fill: "#E77777"
}));
const connected = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "21",
  height: "16",
  viewBox: "0 0 21 16",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M4.00127 14.3639C0.486555 10.8492 0.486555 5.15071 4.00127 1.63599M16.7292 1.63599C20.2439 5.15071 20.2439 10.8492 16.7292 14.3639M6.8297 11.5355C4.87708 9.58286 4.87708 6.41704 6.8297 4.46441M13.9008 4.46441C15.8534 6.41704 15.8534 9.58286 13.9008 11.5355M11.3652 7.99995C11.3652 8.55223 10.9175 8.99995 10.3652 8.99995C9.81295 8.99995 9.36523 8.55223 9.36523 7.99995C9.36523 7.44766 9.81295 6.99995 10.3652 6.99995C10.9175 6.99995 11.3652 7.44766 11.3652 7.99995Z",
  stroke: "#6D955A",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const quota = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "55",
  height: "55",
  viewBox: "0 0 55 55",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M46.6215 21.757C44.6278 22.9074 43.5209 25.0684 43.5415 27.3692C43.5415 27.4128 43.5415 27.4563 43.5415 27.4999C43.5415 27.5434 43.5415 27.5892 43.5415 27.6328C43.5209 29.9336 44.6278 32.0947 46.6215 33.2451L46.6399 33.2565C47.9943 34.038 49.7565 33.2657 50.043 31.728C50.5678 28.9047 50.5426 26.0378 50.0178 23.2717C49.7268 21.7386 47.9713 20.9778 46.6215 21.757V21.757Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M19.8137 13.4291C19.6052 13.5437 19.3989 13.6629 19.195 13.7866C17.2906 14.9462 14.8958 14.9256 12.9639 13.8096C11.621 13.035 11.385 11.1421 12.5583 10.1291C14.701 8.27747 17.1875 6.8131 19.9145 5.85518C21.3812 5.33955 22.912 6.48997 22.912 8.04372V8.06205C22.912 10.2781 21.7547 12.3635 19.8137 13.4291V13.4291Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M19.8137 13.4291C19.6052 13.5437 19.3989 13.6629 19.195 13.7866C17.2906 14.9462 14.8958 14.9256 12.9639 13.8096C11.621 13.035 11.385 11.1421 12.5583 10.1291C14.701 8.27747 17.1875 6.8131 19.9145 5.85518C21.3812 5.33955 22.912 6.48997 22.912 8.04372V8.06205C22.912 10.2781 21.7547 12.3635 19.8137 13.4291V13.4291Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M35.2025 41.5616C35.4065 41.4493 35.6081 41.3325 35.8075 41.211C37.7119 40.0514 40.1067 40.0721 42.0386 41.1881C43.3815 41.9627 43.6175 43.8556 42.4442 44.8685C40.3015 46.7202 37.815 48.1846 35.0879 49.1448C33.6213 49.6627 32.0881 48.5123 32.0881 46.9562C32.0881 44.731 33.2523 42.6364 35.2025 41.5616V41.5616Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M8.37836 33.243C7.02857 34.0221 5.27315 33.2613 4.98211 31.7305C4.45732 28.9644 4.43211 26.0953 4.9569 23.2719C5.24336 21.7342 7.00336 20.9619 8.35773 21.7434L8.37836 21.7548C10.3721 22.9053 11.479 25.0663 11.4584 27.3671C11.4584 27.4107 11.4584 27.4565 11.4584 27.5001C11.4584 27.5436 11.4584 27.5871 11.4584 27.6307C11.479 29.9315 10.3721 32.0926 8.37836 33.243V33.243Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M8.37836 33.243C7.02857 34.0221 5.27315 33.2613 4.98211 31.7305C4.45732 28.9644 4.43211 26.0953 4.9569 23.2719C5.24336 21.7342 7.00336 20.9619 8.35773 21.7434L8.37836 21.7548C10.3721 22.9053 11.479 25.0663 11.4584 27.3671C11.4584 27.4107 11.4584 27.4565 11.4584 27.5001C11.4584 27.5436 11.4584 27.5871 11.4584 27.6307C11.479 29.9315 10.3721 32.0926 8.37836 33.243V33.243Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M32.0881 8.06439C32.0881 6.50605 33.6258 5.36709 35.0948 5.88043C37.7531 6.80855 40.2511 8.22022 42.435 10.0902C43.6221 11.1077 43.4113 13.0167 42.0569 13.7981L42.0363 13.8096C40.1044 14.9233 37.7119 14.9463 35.8075 13.7867C35.6036 13.6629 35.3973 13.5415 35.1865 13.4269C33.2454 12.3636 32.0881 10.2781 32.0881 8.06439V8.06439Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M32.0881 8.06439C32.0881 6.50605 33.6258 5.36709 35.0948 5.88043C37.7531 6.80855 40.2511 8.22022 42.435 10.0902C43.6221 11.1077 43.4113 13.0167 42.0569 13.7981L42.0363 13.8096C40.1044 14.9233 37.7119 14.9463 35.8075 13.7867C35.6036 13.6629 35.3973 13.5415 35.1865 13.4269C33.2454 12.3636 32.0881 10.2781 32.0881 8.06439V8.06439Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M22.9122 46.9357C22.9122 48.494 21.3745 49.633 19.9055 49.1196C17.2472 48.1915 14.7493 46.7798 12.5653 44.9098C11.3782 43.8923 11.5891 41.9834 12.9434 41.2019C14.8868 40.079 17.2953 40.0607 19.2157 41.2248C19.4128 41.344 19.6122 41.4609 19.8161 41.5709C21.7549 42.6365 22.9122 44.7219 22.9122 46.9357V46.9357Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M27.5 20.6256L34.3755 27.5011L27.5 34.3766L20.6245 27.5011L27.5 20.6256Z",
  stroke: "#577BF9",
  strokeWidth: "1.91406",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const imagesNumber = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "55",
  height: "55",
  viewBox: "0 0 55 55",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M42.0235 45.3568L45.0279 46.6928C46.5427 47.3666 48.25 46.2574 48.25 44.5982V10.402C48.25 8.74281 46.5427 7.63364 45.0279 8.30739L42.0235 9.64343C32.8569 13.718 22.3931 13.718 13.2265 9.64343L10.2221 8.30739C8.70729 7.63364 7 8.74281 7 10.402V44.5982C7 46.2574 8.70729 47.3666 10.2221 46.6928L13.2265 45.3568C22.3931 41.2845 32.8569 41.2845 42.0235 45.3568Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M34.5002 35.5209H20.7502C19.4852 35.5209 18.4585 34.4942 18.4585 33.2292V21.7709C18.4585 20.5059 19.4852 19.4792 20.7502 19.4792H34.5002C35.7652 19.4792 36.7918 20.5059 36.7918 21.7709V33.2292C36.7918 34.4942 35.7652 35.5209 34.5002 35.5209Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M30.9707 25.0939L36.7915 29.8376",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M30.9711 25.0939L26.0669 30.2043",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M26.0665 30.2043L23.3853 28.4167",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M23.3856 28.4167L18.4585 32.5647",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const savedSize = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "56",
  height: "55",
  viewBox: "0 0 56 55",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M36.681 6.875H13.7643C8.70203 6.875 4.59766 10.9794 4.59766 16.0417C4.59766 21.104 8.70203 25.2083 13.7643 25.2083H36.681C41.7433 25.2083 45.8477 21.104 45.8477 16.0417C45.8477 10.9794 41.7433 6.875 36.681 6.875Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M13.7643 25.2084C8.70203 25.2084 4.59766 29.3127 4.59766 34.375C4.59766 39.4373 8.70203 43.5417 13.7643 43.5417H29.806",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M22.9307 16.0416H36.6807",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M13.845 15.9606C13.8898 16.0053 13.8898 16.0779 13.845 16.1226C13.8003 16.1674 13.7277 16.1674 13.683 16.1226C13.6382 16.0779 13.6382 16.0053 13.683 15.9606C13.7277 15.9158 13.8003 15.9158 13.845 15.9606Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M22.9307 34.375H27.7432",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M13.845 34.2938C13.8898 34.3386 13.8898 34.4111 13.845 34.4559C13.8003 34.5006 13.7277 34.5006 13.683 34.4559C13.6382 34.4111 13.6382 34.3386 13.683 34.2938C13.7277 34.2491 13.8003 34.2491 13.845 34.2938Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M38.9725 48.125C32.6452 48.125 27.5142 42.994 27.5142 36.6667C27.5142 30.3394 32.6452 25.2084 38.9725 25.2084C45.3021 25.2084 50.4308 30.3394 50.4308 36.6667C50.4308 42.994 45.3021 48.125 38.9725 48.125Z",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M40.2465 31.5745L36.4263 35.3924L41.5184 37.9407L37.6981 41.7586",
  stroke: "#577BF9",
  strokeWidth: "1.875",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const compressionPercentage = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "55",
  height: "55",
  viewBox: "0 0 55 55",
  fill: "none"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M43.5418 32.0833C41.0095 32.0833 38.9585 30.0323 38.9585 27.5C38.9585 24.9677 41.0095 22.9166 43.5418 22.9166C46.0741 22.9166 48.1252 24.9677 48.1252 27.5C48.1252 30.0323 46.0741 32.0833 43.5418 32.0833Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M32.0832 43.5417C32.0832 46.074 30.0321 48.1251 27.4998 48.1251C24.9675 48.1251 22.9165 46.074 22.9165 43.5417C22.9165 41.0094 24.9675 38.9584 27.4998 38.9584C30.0321 38.9584 32.0832 41.0094 32.0832 43.5417Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M43.5418 48.1251C41.0095 48.1251 38.9585 46.074 38.9585 43.5417C38.9585 41.0094 41.0095 38.9584 43.5418 38.9584C46.0741 38.9584 48.1252 41.0094 48.1252 43.5417C48.1252 46.074 46.0741 48.1251 43.5418 48.1251Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M27.4998 16.0417C24.9675 16.0417 22.9165 13.9906 22.9165 11.4583C22.9165 8.92604 24.9675 6.875 27.4998 6.875C30.0321 6.875 32.0832 8.92604 32.0832 11.4583C32.0832 13.9906 30.0321 16.0417 27.4998 16.0417Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M38.9585 11.4583C38.9585 8.92604 41.0095 6.875 43.5418 6.875C46.0741 6.875 48.1252 8.92604 48.1252 11.4583C48.1252 13.9906 46.0741 16.0417 43.5418 16.0417C41.0095 16.0417 38.9585 13.9906 38.9585 11.4583Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M30.7314 40.3104L40.3106 30.7312",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M14.6895 40.3104L24.2686 30.7312",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M30.7314 24.2687L40.3106 14.6896",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M22.9165 27.5C22.9165 24.9677 24.9675 22.9166 27.4998 22.9166C30.0321 22.9166 32.0832 24.9677 32.0832 27.5C32.0832 30.0323 30.0321 32.0833 27.4998 32.0833C24.9675 32.0833 22.9165 30.0323 22.9165 27.5Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M14.6895 24.2687L24.2686 14.6896",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M11.4583 32.0833C8.92604 32.0833 6.875 30.0323 6.875 27.5C6.875 24.9677 8.92604 22.9166 11.4583 22.9166C13.9906 22.9166 16.0417 24.9677 16.0417 27.5C16.0417 30.0323 13.9906 32.0833 11.4583 32.0833Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M16.0417 43.5417C16.0417 46.074 13.9906 48.1251 11.4583 48.1251C8.92604 48.1251 6.875 46.074 6.875 43.5417C6.875 41.0094 8.92604 38.9584 11.4583 38.9584C13.9906 38.9584 16.0417 41.0094 16.0417 43.5417Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M11.4583 16.0417C8.92604 16.0417 6.875 13.9906 6.875 11.4583C6.875 8.92604 8.92604 6.875 11.4583 6.875C13.9906 6.875 16.0417 8.92604 16.0417 11.4583C16.0417 13.9906 13.9906 16.0417 11.4583 16.0417Z",
  stroke: "#577BF9",
  strokeWidth: "1.97917",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const traffic = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "55",
  height: "55",
  viewBox: "0 0 64 64",
  fill: "none",
  stroke: "currentColor",
  xmlns: "http://www.w3.org/2000/svg",
  "svg-inline": "",
  role: "presentation",
  focusable: "false"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 28c0 2.947-4.178 5.333-9.333 5.333S5.334 30.944 5.334 28",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 28c0 2.947-4.178 5.333-9.333 5.333S5.334 30.944 5.334 28",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 28c0 2.947-4.178 5.333-9.333 5.333S5.334 30.944 5.334 28",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M23.997 36c0 2.947-4.178 5.333-9.333 5.333S5.334 38.944 5.334 36",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M50.667 56H40a5.332 5.332 0 01-5.333-5.333V13.333A5.332 5.332 0 0140 8h10.667A5.332 5.332 0 0156 13.333v37.334A5.332 5.332 0 0150.667 56z",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M50.667 56H40a5.332 5.332 0 01-5.333-5.333V13.333A5.332 5.332 0 0140 8h10.667A5.332 5.332 0 0156 13.333v37.334A5.332 5.332 0 0150.667 56z",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M50.667 56H40a5.332 5.332 0 01-5.333-5.333V13.333A5.332 5.332 0 0140 8h10.667A5.332 5.332 0 0156 13.333v37.334A5.332 5.332 0 0150.667 56z",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M24 32h10.667M24 32h10.667",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M24 32h10.667",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 16H48M42.667 16H48",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 16H48",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 26.667H48M42.667 26.667H48",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 26.667H48",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 37.333H48M42.667 37.333H48",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 37.333H48",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 48H48M42.667 48H48",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M42.667 48H48",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c0 2.947 4.179 5.333 9.334 5.333C19.82 25.333 24 22.947 24 20",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c0 2.947 4.179 5.333 9.334 5.333C19.82 25.333 24 22.947 24 20",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c0 2.947 4.179 5.333 9.334 5.333C19.82 25.333 24 22.947 24 20",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c.003-2.944 4.182-5.333 9.334-5.333 5.152 0 9.333 2.386 9.33 5.333v24c0 2.947-4.178 5.333-9.333 5.333S5.334 46.944 5.334 44V20v0z",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c.003-2.944 4.182-5.333 9.334-5.333 5.152 0 9.333 2.386 9.33 5.333v24c0 2.947-4.178 5.333-9.333 5.333S5.334 46.944 5.334 44V20v0z",
  stroke: "#EDF0FF",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  "data-v-767b24d4": "",
  d: "M5.333 20c.003-2.944 4.182-5.333 9.334-5.333 5.152 0 9.333 2.386 9.33 5.333v24c0 2.947-4.178 5.333-9.333 5.333S5.334 46.944 5.334 44V20v0z",
  stroke: "#577BF9",
  strokeWidth: "2.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const warning = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "18",
  height: "16",
  viewBox: "0 0 18 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M8.9581 0C13.5192 0 17.2136 3.58 17.2136 8C17.2136 12.42 13.5192 16 8.9581 16C4.39696 16 0.702637 12.42 0.702637 8C0.702637 3.58 4.39696 0 8.9581 0ZM10.6558 9L11.0219 3H7.92606L8.29211 9H10.6558ZM11.0219 11.5115C11.0219 11.9809 10.8811 12.3473 10.6213 12.6107C10.3507 12.874 9.97188 13 9.48478 13C8.99768 13 8.61882 12.874 8.33739 12.6107C8.06677 12.3473 7.92606 11.9809 7.92606 11.5115C7.92606 11.0305 8.05595 10.6641 8.32656 10.4008C8.59717 10.1374 8.97603 10 9.48478 10C9.99353 10 10.3724 10.1374 10.6322 10.4008C10.892 10.6641 11.0219 11.0305 11.0219 11.5115Z",
  fill: "#AF3535"
}));
const sync = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M17.25 8.25H21V4.5",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M3 12C3 7.029 7.029 3 12 3C15.63 3 18.751 5.154 20.174 8.25",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M6.75 15.75H3V19.5",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M21 12C21 16.971 16.971 21 12 21C8.37 21 5.249 18.846 3.826 15.75",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const checkmark = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "44",
  height: "44",
  viewBox: "0 0 44 44",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M35.8621 13.647L22.0095 27.4996L15.085 20.5733",
  fill: "none",
  stroke: "white",
  strokeWidth: "2.75",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M38.5 22C38.5 31.1135 31.1135 38.5 22 38.5C12.8865 38.5 5.5 31.1135 5.5 22C5.5 12.8865 12.8865 5.5 22 5.5C24.6638 5.5 27.1718 6.14717 29.3993 7.26733",
  fill: "none",
  stroke: "white",
  strokeWidth: "2.75",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const offload = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "20",
  height: "22",
  viewBox: "0 0 20 22",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M5 15C2.79086 15 1 13.2091 1 11C1 9.09295 2.33457 7.4976 4.12071 7.09695C4.04169 6.74395 4 6.37684 4 6C4 3.23858 6.23858 1 9 1C11.4193 1 13.4373 2.71825 13.9002 5.00098C13.9334 5.00033 13.9666 5 14 5C16.7614 5 19 7.23858 19 10C19 12.419 17.2822 14.4367 15 14.9M13 12L10 9M10 9L7 12M10 9L10 21",
  stroke: "#577BF9",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const rollback = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "20",
  height: "22",
  viewBox: "0 0 20 22",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M5 15C2.79086 15 1 13.2091 1 11C1 9.09295 2.33457 7.4976 4.12071 7.09695C4.04169 6.74395 4 6.37684 4 6C4 3.23858 6.23858 1 9 1C11.4193 1 13.4373 2.71825 13.9002 5.00098C13.9334 5.00033 13.9666 5 14 5C16.7614 5 19 7.23858 19 10C19 12.419 17.2822 14.4367 15 14.9M7 18L10 21M10 21L13 18M10 21V9",
  stroke: "#577BF9",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const warningAlt = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  width: "20",
  height: "18",
  viewBox: "0 0 20 22",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M10.0015 8V10M10.0015 14H10.0115M3.0733 18H16.9297C18.4693 18 19.4316 16.3333 18.6618 15L11.7336 3C10.9637 1.66667 9.03925 1.66667 8.26945 3L1.34125 15C0.571445 16.3333 1.5337 18 3.0733 18Z",
  stroke: "#DE9F0C",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const bolt = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "#577BF9",
  xmlns: "http://www.w3.org/2000/svg",
  "svg-inline": "",
  className: "absolute w-16 h-16 text-o-blue outline-none",
  role: "presentation",
  focusable: "false",
  tabIndex: "-1"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M6.08998 13.28H9.17998V20.48C9.17998 22.16 10.09 22.5 11.2 21.24L18.77 12.64C19.7 11.59 19.31 10.72 17.9 10.72H14.81V3.52002C14.81 1.84002 13.9 1.50002 12.79 2.76002L5.21998 11.36C4.29998 12.42 4.68998 13.28 6.08998 13.28Z",
  stroke: "#577BF9",
  strokeWidth: "1.5",
  strokeMiterlimit: "10",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const update = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "#577BF9",
  xmlns: "http://www.w3.org/2000/svg",
  "svg-inline": "",
  className: "absolute w-16 h-16 text-o-blue outline-none",
  role: "presentation",
  focusable: "false",
  tabIndex: "-1"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M3 12C3 16.9706 7.02944 21 12 21C14.3051 21 16.4077 20.1334 18 18.7083L21 16M21 12C21 7.02944 16.9706 3 12 3C9.69494 3 7.59227 3.86656 6 5.29168L3 8M21 21V16M21 16H16M3 3V8M3 8H8",
  stroke: "#577BF9",
  strokeWidth: "1.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const offloadImage = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 512 512",
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  stroke: "#577BF9",
  "svg-inline": "",
  className: "absolute w-16 h-16 text-o-blue outline-none",
  role: "presentation",
  focusable: "false",
  tabIndex: "-1"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("polyline", {
  points: "336 176 225.2 304 176 255.8",
  stroke: "#577BF9",
  strokeWidth: "30.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M463.1,112.37C373.68,96.33,336.71,84.45,256,48,175.29,84.45,138.32,96.33,48.9,112.37,32.7,369.13,240.58,457.79,256,464,271.42,457.79,479.3,369.13,463.1,112.37Z",
  stroke: "#577BF9",
  strokeWidth: "30.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const settings = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "#577BF9",
  xmlns: "http://www.w3.org/2000/svg",
  "svg-inline": "",
  className: "absolute w-16 h-16 text-o-blue outline-none",
  role: "presentation",
  focusable: "false",
  tabIndex: "-1"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M10.65 3L9.93163 3.53449L9.32754 5.54812L7.47651 4.55141L6.5906 4.68143L4.68141 6.59062L4.55139 7.47652L5.5481 9.32755L3.53449 9.93163L3 10.65V13.35L3.53449 14.0684L5.54811 14.6725L4.55142 16.5235L4.68144 17.4094L6.59063 19.3186L7.47653 19.4486L9.32754 18.4519L9.93163 20.4655L10.65 21H13.35L14.0684 20.4655L14.6725 18.4519L16.5235 19.4486L17.4094 19.3185L19.3186 17.4094L19.4486 16.5235L18.4519 14.6724L20.4655 14.0684L21 13.35V10.65L20.4655 9.93163L18.4519 9.32754L19.4486 7.47654L19.3186 6.59063L17.4094 4.68144L16.5235 4.55142L14.6725 5.54812L14.0684 3.53449L13.35 3H10.65Z",
  stroke: "#577BF9",
  strokeWidth: "1.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
  cx: "12",
  cy: "12",
  r: "3.75",
  stroke: "#577BF9",
  strokeWidth: "1.5",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}));
const globe = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
  cx: "12",
  cy: "12",
  r: "10"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M2 12h20"
}));
const user = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
  cx: "12",
  cy: "7",
  r: "4"
}));
const arrowDownToLine = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M12 17V3"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "m6 11 6 6 6-6"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M19 21H5"
}));
const cloudDownload = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M12 13v8l-4-4"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "m12 21 4-4"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M4.393 15.269A7 7 0 1 1 15.71 8h1.79a4.5 4.5 0 0 1 2.436 8.284"
}));
const chartBarDecreasing = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: "2",
  strokeLinecap: "round",
  strokeLinejoin: "round"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M3 3v16a2 2 0 0 0 2 2h16"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M7 11h8"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M7 16h3"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
  d: "M7 6h12"
}));

/***/ }),

/***/ "./assets/src/dashboard/utils/plugin-install.js":
/*!******************************************************!*\
  !*** ./assets/src/dashboard/utils/plugin-install.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   activatePlugin: () => (/* binding */ activatePlugin),
/* harmony export */   installPlugin: () => (/* binding */ installPlugin)
/* harmony export */ });
const installPlugin = slug => {
  return new Promise(resolve => {
    wp.updates.ajax('install-plugin', {
      slug,
      success: () => {
        resolve({
          success: true
        });
      },
      error: err => {
        resolve({
          success: false,
          code: err.errorCode
        });
      }
    });
  });
};
const activatePlugin = url => {
  return new Promise(resolve => {
    fetch(url).then(() => {
      resolve({
        success: true
      });
    }).catch(() => {
      resolve({
        success: false
      });
    });
  });
};


/***/ }),

/***/ "./node_modules/classnames/index.js":
/*!******************************************!*\
  !*** ./node_modules/classnames/index.js ***!
  \******************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;
	var nativeCodeString = '[native code]';

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
					classes.push(arg.toString());
					continue;
				}

				for (var key in arg) {
					if (hasOwn.call(arg, key) && arg[key]) {
						classes.push(key);
					}
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ "./assets/src/dashboard/style.scss":
/*!*****************************************!*\
  !*** ./assets/src/dashboard/style.scss ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/react-compare-image/dist/bundle.js":
/*!*********************************************************!*\
  !*** ./node_modules/react-compare-image/dist/bundle.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

(()=>{"use strict";var e={n:t=>{var r=t&&t.__esModule?()=>t.default:()=>t;return e.d(r,{a:r}),r},d:(t,r)=>{for(var o in r)e.o(r,o)&&!e.o(t,o)&&Object.defineProperty(t,o,{enumerable:!0,get:r[o]})},o:(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r:e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})}},t={};e.r(t),e.d(t,{default:()=>l});const r=__webpack_require__(/*! react */ "react");var o=e.n(r);function n(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);t&&(o=o.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,o)}return r}function i(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?n(Object(r),!0).forEach((function(t){a(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):n(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function a(e,t,r){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var r=e[Symbol.toPrimitive];if(void 0!==r){var o=r.call(e,t);if("object"!=typeof o)return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}const l=e=>{const{aspectRatio:t="taller",handle:n=null,handleSize:a=40,hover:l=!1,leftImage:s,leftImageAlt:u="",leftImageCss:c={},leftImageLabel:d=null,onSliderPositionChange:p=(()=>{}),rightImage:g,rightImageAlt:m="",rightImageCss:f={},rightImageLabel:h=null,skeleton:b=null,sliderLineColor:v="#ffffff",sliderLineWidth:x=2,sliderPositionPercentage:w=.5,vertical:y=!1}=e,E=!y,[L,O]=(0,r.useState)(w),[$,j]=(0,r.useState)(0),[S,P]=(0,r.useState)(0),[C,I]=(0,r.useState)(!1),[R,k]=(0,r.useState)(!1),[D,z]=(0,r.useState)(!1),A=(0,r.useRef)(null),M=(0,r.useRef)(null),_=(0,r.useRef)(null);(0,r.useEffect)((()=>{const e=A.current,t=new ResizeObserver((e=>{let[t,...r]=e;const o=t.target.getBoundingClientRect().width;j(o)}));return t.observe(e),()=>t.disconnect()}),[]),(0,r.useEffect)((()=>(_.current.complete&&I(!0),()=>{I(!1)})),[s]),(0,r.useEffect)((()=>(M.current.complete&&k(!0),()=>{k(!1)})),[g]);const F=R&&C;(0,r.useEffect)((()=>{const e=e=>{const t=e||window.event,r=t.touches?t.touches[0].pageX:t.pageX,o=t.touches?t.touches[0].pageY:t.pageY,n=r-window.pageXOffset,i=o-window.pageYOffset,a=M.current.getBoundingClientRect();let l=E?n-a.left:i-a.top;const s=0+x/2,u=E?$-x/2:S-x/2;l<s&&(l=s),l>u&&(l=u),O(E?l/$:l/S),p&&p(E?l/$:l/S)},r=t=>{z(!0),"touches"in t||t.preventDefault(),e(t),window.addEventListener("mousemove",e),window.addEventListener("touchmove",e)},o=()=>{z(!1),window.removeEventListener("mousemove",e),window.removeEventListener("touchmove",e)},n=A.current;if(F){n.addEventListener("touchstart",r),window.addEventListener("touchend",o),l?(n.addEventListener("mousemove",e),n.addEventListener("mouseleave",o)):(n.addEventListener("mousedown",r),window.addEventListener("mouseup",o));const i=_.current.naturalHeight/_.current.naturalWidth,a=M.current.naturalHeight/M.current.naturalWidth,s="taller"===t?Math.max(i,a):Math.min(i,a);P($*s)}return()=>{n.removeEventListener("touchstart",r),window.removeEventListener("touchend",o),n.removeEventListener("mousemove",e),n.removeEventListener("mouseleave",o),n.removeEventListener("mousedown",r),window.removeEventListener("mouseup",o),window.removeEventListener("mousemove",e),window.removeEventListener("touchmove",e)}}),[F,t,S,$,E,l,x,y]);const T={container:{boxSizing:"border-box",position:"relative",width:"100%",height:`${S}px`,overflow:"hidden"},rightImage:i({clip:E?`rect(auto, auto, auto, ${$*L}px)`:`rect(${S*L}px, auto, auto, auto)`,display:"block",height:"100%",objectFit:"cover",position:"absolute",width:"100%"},f),leftImage:i({clip:E?`rect(auto, ${$*L}px, auto, auto)`:`rect(auto, auto, ${S*L}px, auto)`,display:"block",height:"100%",objectFit:"cover",position:"absolute",width:"100%"},c),slider:{alignItems:"center",cursor:!l&&E?"ew-resize":!l&&!E&&"ns-resize",display:"flex",flexDirection:E?"column":"row",height:E?"100%":`${a}px`,justifyContent:"center",left:E?$*L-a/2+"px":0,position:"absolute",top:E?0:S*L-a/2+"px",width:E?`${a}px`:"100%"},line:{background:v,boxShadow:"0px 3px 1px -2px rgba(0, 0, 0, 0.2), 0px 2px 2px 0px rgba(0, 0, 0, 0.14), 0px 1px 5px 0px rgba(0, 0, 0, 0.12)",flex:"0 1 auto",height:E?"100%":`${x}px`,width:E?`${x}px`:"100%"},handleCustom:{alignItems:"center",boxSizing:"border-box",display:"flex",flex:"1 0 auto",height:"auto",justifyContent:"center",width:"auto"},handleDefault:{alignItems:"center",border:`${x}px solid ${v}`,borderRadius:"100%",boxShadow:"0px 3px 1px -2px rgba(0, 0, 0, 0.2), 0px 2px 2px 0px rgba(0, 0, 0, 0.14), 0px 1px 5px 0px rgba(0, 0, 0, 0.12)",boxSizing:"border-box",display:"flex",flex:"1 0 auto",height:`${a}px`,justifyContent:"center",width:`${a}px`,transform:E?"none":"rotate(90deg)"},leftArrow:{border:`inset ${.15*a}px rgba(0,0,0,0)`,borderRight:`${.15*a}px solid ${v}`,height:"0px",marginLeft:`-${.25*a}px`,marginRight:.25*a+"px",width:"0px"},rightArrow:{border:`inset ${.15*a}px rgba(0,0,0,0)`,borderLeft:`${.15*a}px solid ${v}`,height:"0px",marginRight:`-${.25*a}px`,width:"0px"},leftLabel:{background:"rgba(0, 0, 0, 0.5)",color:"white",left:E?"5%":"50%",opacity:D?0:1,padding:"10px 20px",position:"absolute",top:E?"50%":"3%",transform:E?"translate(0,-50%)":"translate(-50%, 0)",transition:"opacity 0.1s ease-out"},rightLabel:{background:"rgba(0, 0, 0, 0.5)",color:"white",opacity:D?0:1,padding:"10px 20px",position:"absolute",left:E?null:"50%",right:E?"5%":null,top:E?"50%":null,bottom:E?null:"3%",transform:E?"translate(0,-50%)":"translate(-50%, 0)",transition:"opacity 0.1s ease-out"},leftLabelContainer:{clip:E?`rect(auto, ${$*L}px, auto, auto)`:`rect(auto, auto, ${S*L}px, auto)`,height:"100%",position:"absolute",width:"100%"},rightLabelContainer:{clip:E?`rect(auto, auto, auto, ${$*L}px)`:`rect(${S*L}px, auto, auto, auto)`,height:"100%",position:"absolute",width:"100%"}};return o().createElement(o().Fragment,null,b&&!F&&o().createElement("div",{style:i({},T.container)},b),o().createElement("div",{style:i(i({},T.container),{},{display:F?"block":"none"}),ref:A,"data-testid":"container"},o().createElement("img",{onLoad:()=>k(!0),alt:m,"data-testid":"right-image",ref:M,src:g,style:T.rightImage}),o().createElement("img",{onLoad:()=>I(!0),alt:u,"data-testid":"left-image",ref:_,src:s,style:T.leftImage}),o().createElement("div",{style:T.slider},o().createElement("div",{style:T.line}),n?o().createElement("div",{style:T.handleCustom},n):o().createElement("div",{style:T.handleDefault},o().createElement("div",{style:T.leftArrow}),o().createElement("div",{style:T.rightArrow})),o().createElement("div",{style:T.line})),d&&o().createElement("div",{style:T.leftLabelContainer},o().createElement("div",{style:T.leftLabel},d)),h&&o().createElement("div",{style:T.rightLabelContainer},o().createElement("div",{style:T.rightLabel},h))))};module.exports=t})();

/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/index.js":
/*!****************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useBoolean: () => (/* reexport safe */ _useBoolean_useBoolean__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   useClickAnyWhere: () => (/* reexport safe */ _useClickAnyWhere_useClickAnyWhere__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   useCopyToClipboard: () => (/* reexport safe */ _useCopyToClipboard_useCopyToClipboard__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   useCountdown: () => (/* reexport safe */ _useCountdown_useCountdown__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   useCounter: () => (/* reexport safe */ _useCounter_useCounter__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   useDarkMode: () => (/* reexport safe */ _useDarkMode_useDarkMode__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   useDebounce: () => (/* reexport safe */ _useDebounce_useDebounce__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   useDocumentTitle: () => (/* reexport safe */ _useDocumentTitle_useDocumentTitle__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   useEffectOnce: () => (/* reexport safe */ _useEffectOnce_useEffectOnce__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   useElementSize: () => (/* reexport safe */ _useElementSize_useElementSize__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   useEventCallback: () => (/* reexport safe */ _useEventCallback_useEventCallback__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   useEventListener: () => (/* reexport safe */ _useEventListener_useEventListener__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   useFetch: () => (/* reexport safe */ _useFetch_useFetch__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   useHover: () => (/* reexport safe */ _useHover_useHover__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   useImageOnLoad: () => (/* reexport safe */ _useImageOnLoad_useImageOnLoad__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   useIntersectionObserver: () => (/* reexport safe */ _useIntersectionObserver_useIntersectionObserver__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   useInterval: () => (/* reexport safe */ _useInterval_useInterval__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   useIsClient: () => (/* reexport safe */ _useIsClient_useIsClient__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   useIsFirstRender: () => (/* reexport safe */ _useIsFirstRender_useIsFirstRender__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   useIsMounted: () => (/* reexport safe */ _useIsMounted_useIsMounted__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   useIsomorphicLayoutEffect: () => (/* reexport safe */ _useIsomorphicLayoutEffect_useIsomorphicLayoutEffect__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   useLocalStorage: () => (/* reexport safe */ _useLocalStorage_useLocalStorage__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   useLockedBody: () => (/* reexport safe */ _useLockedBody_useLockedBody__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   useMap: () => (/* reexport safe */ _useMap_useMap__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   useMediaQuery: () => (/* reexport safe */ _useMediaQuery_useMediaQuery__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   useOnClickOutside: () => (/* reexport safe */ _useOnClickOutside_useOnClickOutside__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   useReadLocalStorage: () => (/* reexport safe */ _useReadLocalStorage_useReadLocalStorage__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   useScreen: () => (/* reexport safe */ _useScreen_useScreen__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   useScript: () => (/* reexport safe */ _useScript_useScript__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   useSessionStorage: () => (/* reexport safe */ _useSessionStorage_useSessionStorage__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   useSsr: () => (/* reexport safe */ _useSsr_useSsr__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   useStep: () => (/* reexport safe */ _useStep_useStep__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   useTernaryDarkMode: () => (/* reexport safe */ _useTernaryDarkMode_useTernaryDarkMode__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   useTimeout: () => (/* reexport safe */ _useTimeout_useTimeout__WEBPACK_IMPORTED_MODULE_33__["default"]),
/* harmony export */   useToggle: () => (/* reexport safe */ _useToggle_useToggle__WEBPACK_IMPORTED_MODULE_34__["default"]),
/* harmony export */   useUpdateEffect: () => (/* reexport safe */ _useUpdateEffect_useUpdateEffect__WEBPACK_IMPORTED_MODULE_35__["default"]),
/* harmony export */   useWindowSize: () => (/* reexport safe */ _useWindowSize_useWindowSize__WEBPACK_IMPORTED_MODULE_36__["default"])
/* harmony export */ });
/* harmony import */ var _useBoolean_useBoolean__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useBoolean/useBoolean */ "./node_modules/usehooks-ts/dist/esm/useBoolean/useBoolean.js");
/* harmony import */ var _useClickAnyWhere_useClickAnyWhere__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useClickAnyWhere/useClickAnyWhere */ "./node_modules/usehooks-ts/dist/esm/useClickAnyWhere/useClickAnyWhere.js");
/* harmony import */ var _useCopyToClipboard_useCopyToClipboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useCopyToClipboard/useCopyToClipboard */ "./node_modules/usehooks-ts/dist/esm/useCopyToClipboard/useCopyToClipboard.js");
/* harmony import */ var _useCountdown_useCountdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./useCountdown/useCountdown */ "./node_modules/usehooks-ts/dist/esm/useCountdown/useCountdown.js");
/* harmony import */ var _useCounter_useCounter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./useCounter/useCounter */ "./node_modules/usehooks-ts/dist/esm/useCounter/useCounter.js");
/* harmony import */ var _useDarkMode_useDarkMode__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./useDarkMode/useDarkMode */ "./node_modules/usehooks-ts/dist/esm/useDarkMode/useDarkMode.js");
/* harmony import */ var _useDebounce_useDebounce__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./useDebounce/useDebounce */ "./node_modules/usehooks-ts/dist/esm/useDebounce/useDebounce.js");
/* harmony import */ var _useDocumentTitle_useDocumentTitle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useDocumentTitle/useDocumentTitle */ "./node_modules/usehooks-ts/dist/esm/useDocumentTitle/useDocumentTitle.js");
/* harmony import */ var _useEffectOnce_useEffectOnce__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./useEffectOnce/useEffectOnce */ "./node_modules/usehooks-ts/dist/esm/useEffectOnce/useEffectOnce.js");
/* harmony import */ var _useElementSize_useElementSize__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./useElementSize/useElementSize */ "./node_modules/usehooks-ts/dist/esm/useElementSize/useElementSize.js");
/* harmony import */ var _useEventCallback_useEventCallback__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./useEventCallback/useEventCallback */ "./node_modules/usehooks-ts/dist/esm/useEventCallback/useEventCallback.js");
/* harmony import */ var _useEventListener_useEventListener__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./useEventListener/useEventListener */ "./node_modules/usehooks-ts/dist/esm/useEventListener/useEventListener.js");
/* harmony import */ var _useFetch_useFetch__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./useFetch/useFetch */ "./node_modules/usehooks-ts/dist/esm/useFetch/useFetch.js");
/* harmony import */ var _useHover_useHover__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./useHover/useHover */ "./node_modules/usehooks-ts/dist/esm/useHover/useHover.js");
/* harmony import */ var _useImageOnLoad_useImageOnLoad__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./useImageOnLoad/useImageOnLoad */ "./node_modules/usehooks-ts/dist/esm/useImageOnLoad/useImageOnLoad.js");
/* harmony import */ var _useIntersectionObserver_useIntersectionObserver__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./useIntersectionObserver/useIntersectionObserver */ "./node_modules/usehooks-ts/dist/esm/useIntersectionObserver/useIntersectionObserver.js");
/* harmony import */ var _useInterval_useInterval__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./useInterval/useInterval */ "./node_modules/usehooks-ts/dist/esm/useInterval/useInterval.js");
/* harmony import */ var _useIsClient_useIsClient__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./useIsClient/useIsClient */ "./node_modules/usehooks-ts/dist/esm/useIsClient/useIsClient.js");
/* harmony import */ var _useIsFirstRender_useIsFirstRender__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./useIsFirstRender/useIsFirstRender */ "./node_modules/usehooks-ts/dist/esm/useIsFirstRender/useIsFirstRender.js");
/* harmony import */ var _useIsMounted_useIsMounted__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./useIsMounted/useIsMounted */ "./node_modules/usehooks-ts/dist/esm/useIsMounted/useIsMounted.js");
/* harmony import */ var _useIsomorphicLayoutEffect_useIsomorphicLayoutEffect__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./useIsomorphicLayoutEffect/useIsomorphicLayoutEffect */ "./node_modules/usehooks-ts/dist/esm/useIsomorphicLayoutEffect/useIsomorphicLayoutEffect.js");
/* harmony import */ var _useLocalStorage_useLocalStorage__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./useLocalStorage/useLocalStorage */ "./node_modules/usehooks-ts/dist/esm/useLocalStorage/useLocalStorage.js");
/* harmony import */ var _useLockedBody_useLockedBody__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./useLockedBody/useLockedBody */ "./node_modules/usehooks-ts/dist/esm/useLockedBody/useLockedBody.js");
/* harmony import */ var _useMap_useMap__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./useMap/useMap */ "./node_modules/usehooks-ts/dist/esm/useMap/useMap.js");
/* harmony import */ var _useMediaQuery_useMediaQuery__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./useMediaQuery/useMediaQuery */ "./node_modules/usehooks-ts/dist/esm/useMediaQuery/useMediaQuery.js");
/* harmony import */ var _useOnClickOutside_useOnClickOutside__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./useOnClickOutside/useOnClickOutside */ "./node_modules/usehooks-ts/dist/esm/useOnClickOutside/useOnClickOutside.js");
/* harmony import */ var _useReadLocalStorage_useReadLocalStorage__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./useReadLocalStorage/useReadLocalStorage */ "./node_modules/usehooks-ts/dist/esm/useReadLocalStorage/useReadLocalStorage.js");
/* harmony import */ var _useScreen_useScreen__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./useScreen/useScreen */ "./node_modules/usehooks-ts/dist/esm/useScreen/useScreen.js");
/* harmony import */ var _useScript_useScript__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./useScript/useScript */ "./node_modules/usehooks-ts/dist/esm/useScript/useScript.js");
/* harmony import */ var _useSessionStorage_useSessionStorage__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./useSessionStorage/useSessionStorage */ "./node_modules/usehooks-ts/dist/esm/useSessionStorage/useSessionStorage.js");
/* harmony import */ var _useSsr_useSsr__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./useSsr/useSsr */ "./node_modules/usehooks-ts/dist/esm/useSsr/useSsr.js");
/* harmony import */ var _useStep_useStep__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./useStep/useStep */ "./node_modules/usehooks-ts/dist/esm/useStep/useStep.js");
/* harmony import */ var _useTernaryDarkMode_useTernaryDarkMode__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./useTernaryDarkMode/useTernaryDarkMode */ "./node_modules/usehooks-ts/dist/esm/useTernaryDarkMode/useTernaryDarkMode.js");
/* harmony import */ var _useTimeout_useTimeout__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./useTimeout/useTimeout */ "./node_modules/usehooks-ts/dist/esm/useTimeout/useTimeout.js");
/* harmony import */ var _useToggle_useToggle__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./useToggle/useToggle */ "./node_modules/usehooks-ts/dist/esm/useToggle/useToggle.js");
/* harmony import */ var _useUpdateEffect_useUpdateEffect__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./useUpdateEffect/useUpdateEffect */ "./node_modules/usehooks-ts/dist/esm/useUpdateEffect/useUpdateEffect.js");
/* harmony import */ var _useWindowSize_useWindowSize__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./useWindowSize/useWindowSize */ "./node_modules/usehooks-ts/dist/esm/useWindowSize/useWindowSize.js");












































































/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useBoolean/useBoolean.js":
/*!********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useBoolean/useBoolean.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useBoolean(defaultValue) {
    const [value, setValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!!defaultValue);
    const setTrue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => setValue(true), []);
    const setFalse = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => setValue(false), []);
    const toggle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => setValue(x => !x), []);
    return { value, setValue, setTrue, setFalse, toggle };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useBoolean);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useClickAnyWhere/useClickAnyWhere.js":
/*!********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useClickAnyWhere/useClickAnyWhere.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");

function useClickAnyWhere(handler) {
    (0,___WEBPACK_IMPORTED_MODULE_0__.useEventListener)('click', event => {
        handler(event);
    });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useClickAnyWhere);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useCopyToClipboard/useCopyToClipboard.js":
/*!************************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useCopyToClipboard/useCopyToClipboard.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

function useCopyToClipboard() {
    const [copiedText, setCopiedText] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const copy = (text) => __awaiter(this, void 0, void 0, function* () {
        if (!(navigator === null || navigator === void 0 ? void 0 : navigator.clipboard)) {
            console.warn('Clipboard not supported');
            return false;
        }
        try {
            yield navigator.clipboard.writeText(text);
            setCopiedText(text);
            return true;
        }
        catch (error) {
            console.warn('Copy failed', error);
            setCopiedText(null);
            return false;
        }
    });
    return [copiedText, copy];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useCopyToClipboard);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useCountdown/useCountdown.js":
/*!************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useCountdown/useCountdown.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useCountdown(countdownOption) {
    let isDeprecated = false;
    let countStart, intervalMs, isIncrement, countStop;
    if ('seconds' in countdownOption) {
        console.warn('[useCountdown:DEPRECATED] new interface is already available (see https://usehooks-ts.com/react-hook/use-countdown), the old version will retire on usehooks-ts@3.');
        isDeprecated = true;
        countStart = countdownOption.seconds;
        intervalMs = countdownOption.interval;
        isIncrement = countdownOption.isIncrement;
    }
    else {
        ;
        ({ countStart, intervalMs, isIncrement, countStop } = countdownOption);
    }
    intervalMs = intervalMs !== null && intervalMs !== void 0 ? intervalMs : 1000;
    isIncrement = isIncrement !== null && isIncrement !== void 0 ? isIncrement : false;
    countStop = countStop !== null && countStop !== void 0 ? countStop : 0;
    const { count, increment, decrement, reset: resetCounter, } = (0,___WEBPACK_IMPORTED_MODULE_1__.useCounter)(countStart);
    const { value: isCountdownRunning, setTrue: startCountdown, setFalse: stopCountdown, } = (0,___WEBPACK_IMPORTED_MODULE_1__.useBoolean)(false);
    const resetCountdown = () => {
        stopCountdown();
        resetCounter();
    };
    const countdownCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (count === countStop) {
            stopCountdown();
            return;
        }
        if (isIncrement) {
            increment();
        }
        else {
            decrement();
        }
    }, [count, countStop, decrement, increment, isIncrement, stopCountdown]);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useInterval)(countdownCallback, isCountdownRunning ? intervalMs : null);
    return isDeprecated
        ? [
            count,
            {
                start: startCountdown,
                stop: stopCountdown,
                reset: resetCountdown,
            },
        ]
        : [
            count,
            {
                startCountdown,
                stopCountdown,
                resetCountdown,
            },
        ];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useCountdown);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useCounter/useCounter.js":
/*!********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useCounter/useCounter.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useCounter(initialValue) {
    const [count, setCount] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue || 0);
    const increment = () => setCount(x => x + 1);
    const decrement = () => setCount(x => x - 1);
    const reset = () => setCount(initialValue || 0);
    return {
        count,
        increment,
        decrement,
        reset,
        setCount,
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useCounter);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useDarkMode/useDarkMode.js":
/*!**********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useDarkMode/useDarkMode.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");

const COLOR_SCHEME_QUERY = '(prefers-color-scheme: dark)';
function useDarkMode(defaultValue) {
    var _a;
    const isDarkOS = (0,___WEBPACK_IMPORTED_MODULE_0__.useMediaQuery)(COLOR_SCHEME_QUERY);
    const [isDarkMode, setDarkMode] = (0,___WEBPACK_IMPORTED_MODULE_0__.useLocalStorage)('usehooks-ts-dark-mode', (_a = defaultValue !== null && defaultValue !== void 0 ? defaultValue : isDarkOS) !== null && _a !== void 0 ? _a : false);
    (0,___WEBPACK_IMPORTED_MODULE_0__.useUpdateEffect)(() => {
        setDarkMode(isDarkOS);
    }, [isDarkOS]);
    return {
        isDarkMode,
        toggle: () => setDarkMode(prev => !prev),
        enable: () => setDarkMode(true),
        disable: () => setDarkMode(false),
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDarkMode);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useDebounce/useDebounce.js":
/*!**********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useDebounce/useDebounce.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useDebounce(value, delay) {
    const [debouncedValue, setDebouncedValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const timer = setTimeout(() => setDebouncedValue(value), delay || 500);
        return () => {
            clearTimeout(timer);
        };
    }, [value, delay]);
    return debouncedValue;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDebounce);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useDocumentTitle/useDocumentTitle.js":
/*!********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useDocumentTitle/useDocumentTitle.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");

function useDocumentTitle(title) {
    (0,___WEBPACK_IMPORTED_MODULE_0__.useIsomorphicLayoutEffect)(() => {
        window.document.title = title;
    }, [title]);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDocumentTitle);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useEffectOnce/useEffectOnce.js":
/*!**************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useEffectOnce/useEffectOnce.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useEffectOnce(effect) {
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(effect, []);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useEffectOnce);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useElementSize/useElementSize.js":
/*!****************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useElementSize/useElementSize.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useElementSize() {
    const [ref, setRef] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
    const [size, setSize] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
        width: 0,
        height: 0,
    });
    const handleSize = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        setSize({
            width: (ref === null || ref === void 0 ? void 0 : ref.offsetWidth) || 0,
            height: (ref === null || ref === void 0 ? void 0 : ref.offsetHeight) || 0,
        });
    }, [ref === null || ref === void 0 ? void 0 : ref.offsetHeight, ref === null || ref === void 0 ? void 0 : ref.offsetWidth]);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('resize', handleSize);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        handleSize();
    }, [ref === null || ref === void 0 ? void 0 : ref.offsetHeight, ref === null || ref === void 0 ? void 0 : ref.offsetWidth]);
    return [setRef, size];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useElementSize);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useEventCallback/useEventCallback.js":
/*!********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useEventCallback/useEventCallback.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useEventCallback)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useEventCallback(fn) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(() => {
        throw new Error('Cannot call an event handler while rendering.');
    });
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        ref.current = fn;
    }, [fn]);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((...args) => ref.current(...args), [ref]);
}


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useEventListener/useEventListener.js":
/*!********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useEventListener/useEventListener.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useEventListener(eventName, handler, element, options) {
    const savedHandler = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(handler);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        savedHandler.current = handler;
    }, [handler]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        var _a;
        const targetElement = (_a = element === null || element === void 0 ? void 0 : element.current) !== null && _a !== void 0 ? _a : window;
        if (!(targetElement && targetElement.addEventListener))
            return;
        const listener = event => savedHandler.current(event);
        targetElement.addEventListener(eventName, listener, options);
        return () => {
            targetElement.removeEventListener(eventName, listener, options);
        };
    }, [eventName, element, options]);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useEventListener);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useFetch/useFetch.js":
/*!****************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useFetch/useFetch.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

function useFetch(url, options) {
    const cache = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({});
    const cancelRequest = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    const initialState = {
        error: undefined,
        data: undefined,
    };
    const fetchReducer = (state, action) => {
        switch (action.type) {
            case 'loading':
                return Object.assign({}, initialState);
            case 'fetched':
                return Object.assign(Object.assign({}, initialState), { data: action.payload });
            case 'error':
                return Object.assign(Object.assign({}, initialState), { error: action.payload });
            default:
                return state;
        }
    };
    const [state, dispatch] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(fetchReducer, initialState);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!url)
            return;
        cancelRequest.current = false;
        const fetchData = () => __awaiter(this, void 0, void 0, function* () {
            dispatch({ type: 'loading' });
            if (cache.current[url]) {
                dispatch({ type: 'fetched', payload: cache.current[url] });
                return;
            }
            try {
                const response = yield fetch(url, options);
                if (!response.ok) {
                    throw new Error(response.statusText);
                }
                const data = (yield response.json());
                cache.current[url] = data;
                if (cancelRequest.current)
                    return;
                dispatch({ type: 'fetched', payload: data });
            }
            catch (error) {
                if (cancelRequest.current)
                    return;
                dispatch({ type: 'error', payload: error });
            }
        });
        void fetchData();
        return () => {
            cancelRequest.current = true;
        };
    }, [url]);
    return state;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useFetch);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useHover/useHover.js":
/*!****************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useHover/useHover.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useHover(elementRef) {
    const [value, setValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const handleMouseEnter = () => setValue(true);
    const handleMouseLeave = () => setValue(false);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('mouseenter', handleMouseEnter, elementRef);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('mouseleave', handleMouseLeave, elementRef);
    return value;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useHover);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useImageOnLoad/useImageOnLoad.js":
/*!****************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useImageOnLoad/useImageOnLoad.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useImageOnLoad() {
    const [isLoaded, setIsLoaded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const handleImageOnLoad = () => {
        setIsLoaded(true);
    };
    const css = {
        thumbnail: {
            visibility: isLoaded ? 'hidden' : 'visible',
            filter: 'blur(8px)',
            transition: 'visibility 0ms ease-out 500ms',
        },
        fullSize: {
            opacity: isLoaded ? 1 : 0,
            transition: 'opacity 500ms ease-in 0ms',
        },
    };
    return { handleImageOnLoad, css };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useImageOnLoad);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useIntersectionObserver/useIntersectionObserver.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useIntersectionObserver/useIntersectionObserver.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useIntersectionObserver(elementRef, { threshold = 0, root = null, rootMargin = '0%', freezeOnceVisible = false, }) {
    const [entry, setEntry] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const frozen = (entry === null || entry === void 0 ? void 0 : entry.isIntersecting) && freezeOnceVisible;
    const updateEntry = ([entry]) => {
        setEntry(entry);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const node = elementRef === null || elementRef === void 0 ? void 0 : elementRef.current;
        const hasIOSupport = !!window.IntersectionObserver;
        if (!hasIOSupport || frozen || !node)
            return;
        const observerParams = { threshold, root, rootMargin };
        const observer = new IntersectionObserver(updateEntry, observerParams);
        observer.observe(node);
        return () => observer.disconnect();
    }, [elementRef === null || elementRef === void 0 ? void 0 : elementRef.current, JSON.stringify(threshold), root, rootMargin, frozen]);
    return entry;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIntersectionObserver);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useInterval/useInterval.js":
/*!**********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useInterval/useInterval.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useInterval(callback, delay) {
    const savedCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(callback);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        savedCallback.current = callback;
    }, [callback]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!delay && delay !== 0) {
            return;
        }
        const id = setInterval(() => savedCallback.current(), delay);
        return () => clearInterval(id);
    }, [delay]);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useInterval);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useIsClient/useIsClient.js":
/*!**********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useIsClient/useIsClient.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useIsClient() {
    const [isClient, setClient] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        setClient(true);
    }, []);
    return isClient;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIsClient);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useIsFirstRender/useIsFirstRender.js":
/*!********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useIsFirstRender/useIsFirstRender.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useIsFirstRender() {
    const isFirst = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(true);
    if (isFirst.current) {
        isFirst.current = false;
        return true;
    }
    return isFirst.current;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIsFirstRender);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useIsMounted/useIsMounted.js":
/*!************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useIsMounted/useIsMounted.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useIsMounted() {
    const isMounted = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        isMounted.current = true;
        return () => {
            isMounted.current = false;
        };
    }, []);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => isMounted.current, []);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIsMounted);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useIsomorphicLayoutEffect/useIsomorphicLayoutEffect.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useIsomorphicLayoutEffect/useIsomorphicLayoutEffect.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const useIsomorphicLayoutEffect = typeof window !== 'undefined' ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIsomorphicLayoutEffect);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useLocalStorage/useLocalStorage.js":
/*!******************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useLocalStorage/useLocalStorage.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useLocalStorage(key, initialValue) {
    const readValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (typeof window === 'undefined') {
            return initialValue;
        }
        try {
            const item = window.localStorage.getItem(key);
            return item ? parseJSON(item) : initialValue;
        }
        catch (error) {
            console.warn(`Error reading localStorage key “${key}”:`, error);
            return initialValue;
        }
    }, [initialValue, key]);
    const [storedValue, setStoredValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(readValue);
    const setValue = (0,___WEBPACK_IMPORTED_MODULE_1__.useEventCallback)(value => {
        if (typeof window === 'undefined') {
            console.warn(`Tried setting localStorage key “${key}” even though environment is not a client`);
        }
        try {
            const newValue = value instanceof Function ? value(storedValue) : value;
            window.localStorage.setItem(key, JSON.stringify(newValue));
            setStoredValue(newValue);
            window.dispatchEvent(new Event('local-storage'));
        }
        catch (error) {
            console.warn(`Error setting localStorage key “${key}”:`, error);
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        setStoredValue(readValue());
    }, []);
    const handleStorageChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((event) => {
        if ((event === null || event === void 0 ? void 0 : event.key) && event.key !== key) {
            return;
        }
        setStoredValue(readValue());
    }, [key, readValue]);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('storage', handleStorageChange);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('local-storage', handleStorageChange);
    return [storedValue, setValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useLocalStorage);
function parseJSON(value) {
    try {
        return value === 'undefined' ? undefined : JSON.parse(value !== null && value !== void 0 ? value : '');
    }
    catch (_a) {
        console.log('parsing error on', { value });
        return undefined;
    }
}


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useLockedBody/useLockedBody.js":
/*!**************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useLockedBody/useLockedBody.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useLockedBody(initialLocked = false, rootId = '___gatsby') {
    const [locked, setLocked] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialLocked);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        if (!locked) {
            return;
        }
        const originalOverflow = document.body.style.overflow;
        const originalPaddingRight = document.body.style.paddingRight;
        document.body.style.overflow = 'hidden';
        const root = document.getElementById(rootId);
        const scrollBarWidth = root ? root.offsetWidth - root.scrollWidth : 0;
        if (scrollBarWidth) {
            document.body.style.paddingRight = `${scrollBarWidth}px`;
        }
        return () => {
            document.body.style.overflow = originalOverflow;
            if (scrollBarWidth) {
                document.body.style.paddingRight = originalPaddingRight;
            }
        };
    }, [locked]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (locked !== initialLocked) {
            setLocked(initialLocked);
        }
    }, [initialLocked]);
    return [locked, setLocked];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useLockedBody);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useMap/useMap.js":
/*!************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useMap/useMap.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useMap(initialState = new Map()) {
    const [map, setMap] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(new Map(initialState));
    const actions = {
        set: (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((key, value) => {
            setMap(prev => {
                const copy = new Map(prev);
                copy.set(key, value);
                return copy;
            });
        }, []),
        setAll: (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(entries => {
            setMap(() => new Map(entries));
        }, []),
        remove: (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(key => {
            setMap(prev => {
                const copy = new Map(prev);
                copy.delete(key);
                return copy;
            });
        }, []),
        reset: (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
            setMap(() => new Map());
        }, []),
    };
    return [map, actions];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useMap);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useMediaQuery/useMediaQuery.js":
/*!**************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useMediaQuery/useMediaQuery.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useMediaQuery(query) {
    const getMatches = (query) => {
        if (typeof window !== 'undefined') {
            return window.matchMedia(query).matches;
        }
        return false;
    };
    const [matches, setMatches] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(getMatches(query));
    function handleChange() {
        setMatches(getMatches(query));
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const matchMedia = window.matchMedia(query);
        handleChange();
        if (matchMedia.addListener) {
            matchMedia.addListener(handleChange);
        }
        else {
            matchMedia.addEventListener('change', handleChange);
        }
        return () => {
            if (matchMedia.removeListener) {
                matchMedia.removeListener(handleChange);
            }
            else {
                matchMedia.removeEventListener('change', handleChange);
            }
        };
    }, [query]);
    return matches;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useMediaQuery);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useOnClickOutside/useOnClickOutside.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useOnClickOutside/useOnClickOutside.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");

function useOnClickOutside(ref, handler, mouseEvent = 'mousedown') {
    (0,___WEBPACK_IMPORTED_MODULE_0__.useEventListener)(mouseEvent, event => {
        const el = ref === null || ref === void 0 ? void 0 : ref.current;
        if (!el || el.contains(event.target)) {
            return;
        }
        handler(event);
    });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useOnClickOutside);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useReadLocalStorage/useReadLocalStorage.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useReadLocalStorage/useReadLocalStorage.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useReadLocalStorage(key) {
    const readValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (typeof window === 'undefined') {
            return null;
        }
        try {
            const item = window.localStorage.getItem(key);
            return item ? JSON.parse(item) : null;
        }
        catch (error) {
            console.warn(`Error reading localStorage key “${key}”:`, error);
            return null;
        }
    }, [key]);
    const [storedValue, setStoredValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(readValue);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        setStoredValue(readValue());
    }, []);
    const handleStorageChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((event) => {
        if ((event === null || event === void 0 ? void 0 : event.key) && event.key !== key) {
            return;
        }
        setStoredValue(readValue());
    }, [key, readValue]);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('storage', handleStorageChange);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('local-storage', handleStorageChange);
    return storedValue;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useReadLocalStorage);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useScreen/useScreen.js":
/*!******************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useScreen/useScreen.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useScreen() {
    const getScreen = () => {
        if (typeof window !== 'undefined' && window.screen) {
            return window.screen;
        }
        return undefined;
    };
    const [screen, setScreen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(getScreen());
    function handleSize() {
        setScreen(getScreen());
    }
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('resize', handleSize);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        handleSize();
    }, []);
    return screen;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useScreen);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useScript/useScript.js":
/*!******************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useScript/useScript.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const cachedScriptStatuses = {};
function getScriptNode(src) {
    const node = document.querySelector(`script[src="${src}"]`);
    const status = node === null || node === void 0 ? void 0 : node.getAttribute('data-status');
    return {
        node,
        status,
    };
}
function useScript(src, options) {
    const [status, setStatus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
        var _a;
        if (!src || (options === null || options === void 0 ? void 0 : options.shouldPreventLoad)) {
            return 'idle';
        }
        if (typeof window === 'undefined') {
            return 'loading';
        }
        return (_a = cachedScriptStatuses[src]) !== null && _a !== void 0 ? _a : 'loading';
    });
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        var _a, _b;
        if (!src || (options === null || options === void 0 ? void 0 : options.shouldPreventLoad)) {
            return;
        }
        const cachedScriptStatus = cachedScriptStatuses[src];
        if (cachedScriptStatus === 'ready' || cachedScriptStatus === 'error') {
            setStatus(cachedScriptStatus);
            return;
        }
        const script = getScriptNode(src);
        let scriptNode = script.node;
        if (!scriptNode) {
            scriptNode = document.createElement('script');
            scriptNode.src = src;
            scriptNode.async = true;
            scriptNode.setAttribute('data-status', 'loading');
            document.body.appendChild(scriptNode);
            const setAttributeFromEvent = (event) => {
                const scriptStatus = event.type === 'load' ? 'ready' : 'error';
                scriptNode === null || scriptNode === void 0 ? void 0 : scriptNode.setAttribute('data-status', scriptStatus);
            };
            scriptNode.addEventListener('load', setAttributeFromEvent);
            scriptNode.addEventListener('error', setAttributeFromEvent);
        }
        else {
            setStatus((_b = (_a = script.status) !== null && _a !== void 0 ? _a : cachedScriptStatus) !== null && _b !== void 0 ? _b : 'loading');
        }
        const setStateFromEvent = (event) => {
            const newStatus = event.type === 'load' ? 'ready' : 'error';
            setStatus(newStatus);
            cachedScriptStatuses[src] = newStatus;
        };
        scriptNode.addEventListener('load', setStateFromEvent);
        scriptNode.addEventListener('error', setStateFromEvent);
        return () => {
            if (scriptNode) {
                scriptNode.removeEventListener('load', setStateFromEvent);
                scriptNode.removeEventListener('error', setStateFromEvent);
            }
            if (scriptNode && (options === null || options === void 0 ? void 0 : options.removeOnUnmount)) {
                scriptNode.remove();
            }
        };
    }, [src, options === null || options === void 0 ? void 0 : options.shouldPreventLoad, options === null || options === void 0 ? void 0 : options.removeOnUnmount]);
    return status;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useScript);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useSessionStorage/useSessionStorage.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useSessionStorage/useSessionStorage.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useSessionStorage(key, initialValue) {
    const readValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (typeof window === 'undefined') {
            return initialValue;
        }
        try {
            const item = window.sessionStorage.getItem(key);
            return item ? parseJSON(item) : initialValue;
        }
        catch (error) {
            console.warn(`Error reading sessionStorage key “${key}”:`, error);
            return initialValue;
        }
    }, [initialValue, key]);
    const [storedValue, setStoredValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(readValue);
    const setValue = (0,___WEBPACK_IMPORTED_MODULE_1__.useEventCallback)(value => {
        if (typeof window == 'undefined') {
            console.warn(`Tried setting sessionStorage key “${key}” even though environment is not a client`);
        }
        try {
            const newValue = value instanceof Function ? value(storedValue) : value;
            window.sessionStorage.setItem(key, JSON.stringify(newValue));
            setStoredValue(newValue);
            window.dispatchEvent(new Event('session-storage'));
        }
        catch (error) {
            console.warn(`Error setting sessionStorage key “${key}”:`, error);
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        setStoredValue(readValue());
    }, []);
    const handleStorageChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((event) => {
        if ((event === null || event === void 0 ? void 0 : event.key) && event.key !== key) {
            return;
        }
        setStoredValue(readValue());
    }, [key, readValue]);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('storage', handleStorageChange);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('session-storage', handleStorageChange);
    return [storedValue, setValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSessionStorage);
function parseJSON(value) {
    try {
        return value === 'undefined' ? undefined : JSON.parse(value !== null && value !== void 0 ? value : '');
    }
    catch (_a) {
        console.log('parsing error on', { value });
        return undefined;
    }
}


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useSsr/useSsr.js":
/*!************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useSsr/useSsr.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function useSsr() {
    const isDOM = typeof window !== 'undefined' &&
        window.document &&
        window.document.documentElement;
    return {
        isBrowser: isDOM,
        isServer: !isDOM,
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSsr);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useStep/useStep.js":
/*!**************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useStep/useStep.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useStep(maxStep) {
    const [currentStep, setCurrentStep] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1);
    const canGoToNextStep = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => currentStep + 1 <= maxStep, [currentStep, maxStep]);
    const canGoToPrevStep = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => currentStep - 1 >= 1, [currentStep]);
    const setStep = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(step => {
        const newStep = step instanceof Function ? step(currentStep) : step;
        if (newStep >= 1 && newStep <= maxStep) {
            setCurrentStep(newStep);
            return;
        }
        throw new Error('Step not valid');
    }, [maxStep, currentStep]);
    const goToNextStep = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (canGoToNextStep) {
            setCurrentStep(step => step + 1);
        }
    }, [canGoToNextStep]);
    const goToPrevStep = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (canGoToPrevStep) {
            setCurrentStep(step => step - 1);
        }
    }, [canGoToPrevStep]);
    const reset = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        setCurrentStep(1);
    }, []);
    return [
        currentStep,
        {
            goToNextStep,
            goToPrevStep,
            canGoToNextStep,
            canGoToPrevStep,
            setStep,
            reset,
        },
    ];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStep);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useTernaryDarkMode/useTernaryDarkMode.js":
/*!************************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useTernaryDarkMode/useTernaryDarkMode.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


const COLOR_SCHEME_QUERY = '(prefers-color-scheme: dark)';
function useTernaryDarkMode() {
    const isDarkOS = (0,___WEBPACK_IMPORTED_MODULE_1__.useMediaQuery)(COLOR_SCHEME_QUERY);
    const [ternaryDarkMode, setTernaryDarkMode] = (0,___WEBPACK_IMPORTED_MODULE_1__.useLocalStorage)('usehooks-ts-ternary-dark-mode', 'system');
    const [isDarkMode, setDarkMode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(isDarkOS);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useUpdateEffect)(() => {
        if (ternaryDarkMode === 'system') {
            setDarkMode(isDarkOS);
        }
    }, [isDarkOS]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        switch (ternaryDarkMode) {
            case 'light':
                setDarkMode(false);
                break;
            case 'system':
                setDarkMode(isDarkOS);
                break;
            case 'dark':
                setDarkMode(true);
                break;
        }
    }, [ternaryDarkMode, isDarkOS]);
    function toggleTernaryDarkMode() {
        const toggleDict = {
            light: 'system',
            system: 'dark',
            dark: 'light',
        };
        setTernaryDarkMode(prevMode => toggleDict[prevMode]);
    }
    return {
        isDarkMode,
        ternaryDarkMode,
        setTernaryDarkMode,
        toggleTernaryDarkMode,
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useTernaryDarkMode);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useTimeout/useTimeout.js":
/*!********************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useTimeout/useTimeout.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useTimeout(callback, delay) {
    const savedCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(callback);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        savedCallback.current = callback;
    }, [callback]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!delay && delay !== 0) {
            return;
        }
        const id = setTimeout(() => savedCallback.current(), delay);
        return () => clearTimeout(id);
    }, [delay]);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useTimeout);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useToggle/useToggle.js":
/*!******************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useToggle/useToggle.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function useToggle(defaultValue) {
    const [value, setValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!!defaultValue);
    const toggle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => setValue(x => !x), []);
    return [value, toggle, setValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useToggle);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useUpdateEffect/useUpdateEffect.js":
/*!******************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useUpdateEffect/useUpdateEffect.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useUpdateEffect(effect, deps) {
    const isFirst = (0,___WEBPACK_IMPORTED_MODULE_1__.useIsFirstRender)();
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!isFirst) {
            return effect();
        }
    }, deps);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useUpdateEffect);


/***/ }),

/***/ "./node_modules/usehooks-ts/dist/esm/useWindowSize/useWindowSize.js":
/*!**************************************************************************!*\
  !*** ./node_modules/usehooks-ts/dist/esm/useWindowSize/useWindowSize.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/usehooks-ts/dist/esm/index.js");


function useWindowSize() {
    const [windowSize, setWindowSize] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
        width: 0,
        height: 0,
    });
    const handleSize = () => {
        setWindowSize({
            width: window.innerWidth,
            height: window.innerHeight,
        });
    };
    (0,___WEBPACK_IMPORTED_MODULE_1__.useEventListener)('resize', handleSize);
    (0,___WEBPACK_IMPORTED_MODULE_1__.useIsomorphicLayoutEffect)(() => {
        handleSize();
    }, []);
    return windowSize;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useWindowSize);


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = window["lodash"];

/***/ }),

/***/ "@wordpress/api-fetch":
/*!**********************************!*\
  !*** external ["wp","apiFetch"] ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["apiFetch"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/compose":
/*!*********************************!*\
  !*** external ["wp","compose"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["compose"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "@wordpress/notices":
/*!*********************************!*\
  !*** external ["wp","notices"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["notices"];

/***/ }),

/***/ "@wordpress/primitives":
/*!************************************!*\
  !*** external ["wp","primitives"] ***!
  \************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["primitives"];

/***/ }),

/***/ "@wordpress/url":
/*!*****************************!*\
  !*** external ["wp","url"] ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["url"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"index": 0,
/******/ 			"./style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkoptimole_wp"] = globalThis["webpackChunkoptimole_wp"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["./style-index"], () => (__webpack_require__("./assets/src/dashboard/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map