(()=>{"use strict";const e={isDebug:function(){return new URLSearchParams(location.search).has("optml_debug")||null!==localStorage.getItem("optml_debug")},log:function(e,...t){this.isDebug()&&console[e]("[Optimole]",...t)},info:function(...e){this.log("info",...e)},warn:function(...e){this.log("warn",...e)},error:function(...e){this.log("error",...e)},table:function(e){this.isDebug()&&(console.log("[Optimole] Table:"),console.table(e))}},t={getKey:function(e,t){return`optml_pp_${e}_${t}`},isProcessed:function(t,n){try{const e=this.getKey(t,n),i=sessionStorage.getItem(e);return!!i&&(parseInt(i,10),Date.now(),!0)}catch(t){return e.error("Error checking sessionStorage:",t),!1}},markProcessed:function(t,n){try{const e=this.getKey(t,n);sessionStorage.setItem(e,Date.now().toString())}catch(t){e.error("Error setting sessionStorage:",t)}}},n={DEVICE_TYPES:{MOBILE:1,DESKTOP:2},MOBILE_BREAKPOINT:600,getDeviceType:function(){const t=window.innerWidth;return t<=this.MOBILE_BREAKPOINT?(e.info("Device detected as mobile based on width:",t),this.DEVICE_TYPES.MOBILE):(e.info("Device detected as desktop based on width:",t),this.DEVICE_TYPES.DESKTOP)},isMobile:function(){return this.getDeviceType()===this.DEVICE_TYPES.MOBILE},isDesktop:function(){return this.getDeviceType()===this.DEVICE_TYPES.DESKTOP}},i={sendToRestApi:function(n){const{restUrl:i}=window.optimoleDataOptimizer||{};if(!i)return void e.error("REST API URL not available");const o=i+"/optimizations",r=new Blob([JSON.stringify(n)],{type:"application/json"});navigator.sendBeacon(o,r)?(e.info("Data sent successfully using sendBeacon"),t.markProcessed(n.u,n.d)):(e.error("Failed to send data using sendBeacon"),this._sendWithFetch(o,n))},_sendWithFetch:function(n,i){fetch(n,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(i)}).then((e=>{if(!e.ok)throw new Error("Network response was not ok");return e.json()})).then((n=>{e.info("Data sent successfully using fetch fallback:",n),t.markProcessed(i.u,i.d)})).catch((t=>{e.error("Error sending data using fetch fallback:",t)}))}},o={debounce:function(e,t){let n;return function(){clearTimeout(n),n=setTimeout((()=>e.apply(this,arguments)),t)}},getUniqueSelector:function(e){if(!e||e===document.body)return"body";if(e.id)return`#${e.id}`;const t=e.tagName.toLowerCase();let n="";e.className&&"string"==typeof e.className&&(n=e.className.includes("optml-bg-lazyloaded")?"."+e.className.trim().split(/\s+/).filter((e=>"optml-bg-lazyloaded"!==e)).join("."):"."+e.className.trim().replace(/\s+/g,"."));const i=e.parentElement;if(!i||i===document.body)return`body > ${t}${n}`;let o="";const r=i.children;let s=0,a=0;for(let t=0;t<r.length;t++)r[t].tagName===e.tagName&&(s++,r[t]===e&&(a=s));return s>1&&(o=`:nth-of-type(${a})`),`${i.id?`#${i.id}`:this.getUniqueSelector(i)} > ${t}${n}${o}`},hasBackgroundImage:function(e,t=!1){const n=window.getComputedStyle(e).backgroundImage;return!(!n||"none"===n||!n.includes("url("))&&(!t||n)},extractUrlsFromBgImage:function(e){if(!e)return null;const t=[],n=/url\(['"]?(.*?)['"]?\)/g;let i;for(;null!==(i=n.exec(e));)i[1]&&t.push(i[1]);return t.length>0?t:null},checkPageConditions:function(){return{hasValidViewport:window.innerWidth>0&&window.innerHeight>0,isVisible:"hidden"!==document.visibilityState||document.prerendering,isComplete:"complete"===document.readyState}},waitForPageLoad:function(){return"complete"===document.readyState?Promise.resolve():new Promise((e=>{window.addEventListener("load",e,{once:!0})}))},waitForIdleTime:function(){return new Promise((e=>{"function"==typeof requestIdleCallback?requestIdleCallback(e):setTimeout(e,200)}))},waitForViewportImages:function(e=1e3){return new Promise((t=>{"complete"!==document.readyState?window.addEventListener("load",(()=>{setTimeout(t,e)}),{once:!0}):setTimeout(t,e)}))}},r={setupBackgroundImageObservation:function(t,n,i,r){const s=new MutationObserver((t=>{for(const n of t)if("attributes"===n.type&&"class"===n.attributeName){const t=n.target;if(t.classList.contains("optml-bg-lazyloaded")&&o.hasBackgroundImage(t)){r.observe(t),s.disconnect(t);const n=t.getAttribute("data-optml-specific-selector");e.info(`Background element "${n}" is now observable`)}}})),a=[];return t.forEach((e=>{const t=o.getUniqueSelector(e);e.setAttribute("data-optml-bg-selector",n),e.setAttribute("data-optml-specific-selector",t),e.classList.contains("optml-bg-lazyloaded")&&o.hasBackgroundImage(e)?r.observe(e):a.push(e)})),a.length>0&&(a.forEach((e=>{s.observe(e,{attributes:!0,attributeFilter:["class"]})})),setTimeout((()=>{s.disconnect(),e.info(`Stopped waiting for lazyload on ${n} elements`)}),5e3)),a.length},extractBackgroundImageUrls:function(t){const n=new Map;return t&&Array.isArray(t)?(t.forEach((t=>{const i=new Map;n.set(t,i);try{document.querySelectorAll(t).forEach((t=>{if(t.classList.contains("optml-bg-lazyloaded")){const n=o.hasBackgroundImage(t,!0);if(!1===n)return;const r=o.getUniqueSelector(t);if(!r)return;const s=o.extractUrlsFromBgImage(n);s&&s.length>0&&(i.set(r,s),e.info(`Found background image URL(s) for "${r}":`,s))}}))}catch(n){e.error("Error extracting background URLs for selector:",t,n)}})),n):n},processBackgroundSelectors:function(t,n){const i=new Map;let o=0;return t&&Array.isArray(t)&&0!==t.length?(e.info("Processing background selectors:",t),t.forEach((t=>{try{const r=document.querySelectorAll(t);if(0===r.length)return void e.warn("No elements found for background selector:",t);i.set(t,[]),o+=this.setupBackgroundImageObservation(Array.from(r),t,i,n),e.info(`Processed ${r.length} elements for background selector: ${t}`)}catch(n){e.error("Error processing background selector:",t,n)}})),{selectorMap:i,pendingElements:o}):{selectorMap:i,pendingElements:o}}},s={detectLcpElement:async function(){const t={element:null,imageId:null,bgSelector:null,bgUrls:null};if(!PerformanceObserver.supportedEntryTypes.includes("largest-contentful-paint"))return e.info("LCP detection not supported in this browser"),t;const n=performance.getEntriesByType("largest-contentful-paint");if(n&&n.length>0){const i=n[n.length-1];i&&i.element&&(t.element=i.element,e.info("LCP element found from existing entries:",t.element),this._processLcpElement(i.element,t))}else e.info("Setting up LCP observer"),await new Promise((n=>{const i=new PerformanceObserver((o=>{const r=o.getEntries();if(0===r.length)return;const s=r[r.length-1];s&&s.element&&(t.element=s.element,e.info("LCP element detected:",t.element),this._processLcpElement(s.element,t)),i.disconnect(),n()}));i.observe({type:"largest-contentful-paint",buffered:!0}),setTimeout((()=>{i.disconnect(),n()}),1500)}));return t},_processLcpElement:function(t,n){if(t)if("IMG"===t.tagName){const i=t.getAttribute("data-opt-id");i&&(n.imageId=parseInt(i,10),e.info("LCP element is an Optimole image with ID:",n.imageId))}else{const i=o.hasBackgroundImage(t,!0);!1!==i&&(n.bgSelector=o.getUniqueSelector(t),n.bgUrls=o.extractUrlsFromBgImage(i),e.info("LCP element has background image:",n.bgSelector,n.bgUrls))}}},a={DEVICE_BREAKPOINTS:{MOBILE_SMALL:320,MOBILE_MEDIUM:375,MOBILE_LARGE:425,TABLET_SMALL:768,TABLET_LARGE:1024,DESKTOP_SMALL:1200,DESKTOP_MEDIUM:1440,DESKTOP_LARGE:1920,DESKTOP_XL:2560},DPR_MULTIPLIERS:[1,2],CONFIG:{MIN_SIZE:200,MAX_VARIATIONS:8,SIZE_TOLERANCE:50},configure:function(t){t.minSize&&(this.CONFIG.MIN_SIZE=t.minSize),t.maxVariations&&(this.CONFIG.MAX_VARIATIONS=t.maxVariations),t.sizeTolerance&&(this.CONFIG.SIZE_TOLERANCE=t.sizeTolerance),e.info("Srcset detector configured:",this.CONFIG)},_waitForImagesToLoad:function(t){const n=Array.from(t).map((t=>new Promise((n=>{if(t.complete&&t.naturalWidth>0)return void n(t);const i=()=>{t.removeEventListener("load",i),t.removeEventListener("error",o),n(t)},o=()=>{t.removeEventListener("load",i),t.removeEventListener("error",o),e.warn("Image failed to load:",t.src),n(t)};t.addEventListener("load",i),t.addEventListener("error",o),setTimeout((()=>{t.removeEventListener("load",i),t.removeEventListener("error",o),e.warn("Image load timeout:",t.src),n(t)}),5e3)}))));return Promise.all(n)},detectMissingSrcsets:async function(){const t={},n={},i=document.querySelectorAll("img[data-opt-id]");if(0===i.length)return e.info("No Optimole images found for srcset analysis"),{srcset:t,crop:n};e.info(`Found ${i.length} Optimole images, waiting for them to load...`);const o=await this._waitForImagesToLoad(i);return e.info(`Loaded ${o.length} images, analyzing srcset requirements...`),o.forEach((i=>{try{const o=parseInt(i.getAttribute("data-opt-id"),10);if(isNaN(o))return;const r=i.hasAttribute("data-opt-src"),s=i.hasAttribute("data-opt-lazy-loaded");if(!r||r&&s){const s=r?"lazyload completed (has data-opt-lazy-loaded)":"not using lazyload";e.info(`Image ${o} ${s}, analyzing srcset requirements`);const a=this._analyzeSrcsetRequirements(i,o);a&&a.srcset&&a.srcset.length>0&&(t[o]=a.srcset,n[o]=a.requiresCropping)}}catch(t){e.error("Error analyzing image for srcset:",i,t)}})),e.info("Images requiring srcset variations:",Object.keys(t).length),e.info("Images with crop status:",Object.keys(n).length),{srcset:t,crop:n}},_analyzeSrcsetRequirements:function(t,i){const o=t.offsetWidth||t.clientWidth,r=t.offsetHeight||t.clientHeight,s=t.naturalWidth||0,a=t.naturalHeight||0;if(!(o&&r&&s&&a))return e.warn(`Skipping image ${i}: insufficient dimension data`),null;e.info(`Analyzing image ${i}:`,{current:`${o}x${r}`,natural:`${s}x${a}`});const c=s/a,l=o/r,d=Math.abs(c-l),u=this._requiresCropping(t,d,c,l),g=n.getDeviceType(),m=u?l:c,f=this._calculateRequiredSizes(o,r,m,g,s,a),p=t.getAttribute("srcset"),h=this._parseExistingSrcset(p),w=this._findMissingSizes(f,h);return 0===w.length?(e.info(`Image ${i} already has adequate srcset coverage`),null):(e.info(`Image ${i} srcset analysis:`,{currentSize:{w:o,h:r},naturalSize:{w:s,h:a},requiredSizes:f,naturalAspectRatio:Math.round(1e3*c)/1e3,currentAspectRatio:Math.round(1e3*l)/1e3,aspectRatioDifference:Math.round(1e3*d)/1e3,requiresCropping:u,aspectRatioForSizing:Math.round(1e3*m)/1e3,deviceType:g,missingSizes:w,existingSrcset:p||null}),e.info(`[Optimole Debug] Image ${i} aspect ratio analysis:`,{natural:`${s}x${a} (${Math.round(1e3*c)/1e3}:1)`,current:`${o}x${r} (${Math.round(1e3*l)/1e3}:1)`,difference:Math.round(1e3*d)/1e3,requiresCropping:u,aspectRatioForSizing:Math.round(1e3*m)/1e3,reason:u?"Aspect ratio significantly different":"Aspect ratios match within tolerance"}),{srcset:w.map((e=>({w:e.w,h:e.h,d:e.dpr,s:e.descriptor,b:e.breakpoint}))),requiresCropping:u})},_requiresCropping:function(t,n,i,o){let r=!1;try{r="cover"===window.getComputedStyle(t).objectFit,r&&e.info("Image has object-fit: cover")}catch(t){e.warn("Could not get computed style for object-fit check:",t)}if(n<=.05)return!1;let s=!1;s=n>=.15||Math.abs(o-i)/i>.1;const a=r&&s;return a&&e.info(`Image requires cropping: object-fit cover=${r}, aspect ratio=${s}`),a},_calculateRequiredSizes:function(t,n,i,o,r,s){const a=[];this._generateResponsiveSizes(t,n,i,r,s).forEach((e=>{a.push(e)}));const c=this._removeDuplicateSizes(a).sort(((e,t)=>e.w-t.w));return c.length>this.CONFIG.MAX_VARIATIONS?(e.info(`Limiting srcset variations from ${c.length} to ${this.CONFIG.MAX_VARIATIONS}`),this._selectBestVariations(c,this.CONFIG.MAX_VARIATIONS)):c},_parseExistingSrcset:function(e){if(!e)return[];const t=[];return e.split(",").map((e=>e.trim())).forEach((e=>{const n=e.split(/\s+/);if(n.length>=2){const e=n[n.length-1];if(e.endsWith("w")){const i=parseInt(e.slice(0,-1),10);isNaN(i)||t.push({w:i,descriptor:e,url:n.slice(0,-1).join(" ")})}}})),t},_generateResponsiveSizes:function(t,n,i,o,r){const s=[],a=window.innerWidth,c=Math.min(t/a,1);return e.info(`Generating srcset for current ratio: ${Math.round(100*c)}% of viewport`),Object.entries(this.DEVICE_BREAKPOINTS).map((([e,t])=>({viewport:t,label:e.toLowerCase().replace("_","-"),dpr:this.DPR_MULTIPLIERS}))).forEach((e=>{const n=Math.round(e.viewport*c);n<this.CONFIG.MIN_SIZE||n>1.2*o||e.dpr.forEach((a=>{const l=Math.round(n*a),d=Math.round(l/i);1===a&&l>t||this._isValidSize(l,d,o,r)&&l>=this.CONFIG.MIN_SIZE&&s.push({w:l,h:d,dpr:a,breakpoint:e.viewport,descriptor:`${l}w`,source:"responsive",category:`${e.label}-${Math.round(100*c)}`,label:`${e.label}-${l}w${a>1?`-${a}x`:""}`})}))})),!s.some((e=>Math.abs(e.w-t)<=this.CONFIG.SIZE_TOLERANCE))&&this._isValidSize(t,n,o,r)&&s.push({w:t,h:n,dpr:1,breakpoint:window.innerWidth,descriptor:`${t}w`,source:"current",category:"current",label:"current-size"}),s},_isValidSize:function(e,t,n,i){return e>=this.CONFIG.MIN_SIZE&&t>=this.CONFIG.MIN_SIZE&&e<=n&&t<=i},_findMissingSizes:function(e,t){const n=new Set(t.map((e=>e.w))),i=this.CONFIG.SIZE_TOLERANCE;return e.filter((e=>!Array.from(n).some((t=>Math.abs(t-e.w)<=i))))},_selectBestVariations:function(e,t){if(e.length<=t)return e;const n=e.filter((e=>1===e.dpr)),i=e.filter((e=>2===e.dpr)),o=[],r=Math.min(n.length,Math.ceil(.75*t)),s=t-r;if(n.length>0)if(n.length<=r)o.push(...n);else{const e=(n.length-1)/(r-1);for(let t=0;t<r;t++){const i=Math.round(t*e);o.push(n[i])}}if(s>0&&i.length>0)if(i.length<=s)o.push(...i);else{const e=i.sort(((e,t)=>e.w-t.w)),t=Math.floor(e.length/4),n=Math.ceil(3*e.length/4),r=e.slice(t,n),a=Math.max(1,Math.floor(r.length/s));for(let e=0;e<s&&e*a<r.length;e++)o.push(r[e*a])}return o.filter(((e,t,n)=>n.findIndex((t=>t.w===e.w))===t)).sort(((e,t)=>e.w-t.w))},_removeDuplicateSizes:function(e){const t=new Set;return e.filter((e=>{const n=`${e.w}x${e.h}`;return!t.has(n)&&(t.add(n),!0)}))},getSrcsetAnalysisSummary:function(){const e=document.querySelectorAll("img[data-opt-id]");let t=0,i=0,o=0,r=0;return e.forEach((e=>{const n=e.hasAttribute("data-opt-src"),s=e.hasAttribute("data-opt-lazy-loaded");!n||n&&s?(t++,n?s&&o++:r++):i++})),{totalOptimoleImages:e.length,includedImages:t,skippedImages:i,nonLazyloadImages:r,lazyLoadedImages:o,currentDeviceType:n.getDeviceType(),viewportSize:{w:window.innerWidth,h:window.innerHeight}}}},c={runProfiling:async function(){const c=o.checkPageConditions();if(!c.hasValidViewport)return e.info("Window must have non-zero dimensions for image detection."),null;if(!c.isVisible)return e.info("Page opened in background tab so image detection is not performed."),null;const{pageProfileId:l,missingDevices:d,bgSelectors:u}=window.optimoleDataOptimizer||{},g=n.getDeviceType(),m=l,f=d?d.split(","):[];if(e.info("Device Type:",g),e.info("Missing Devices:",f),e.info("Profile ID:",l),e.info("Background Selectors:",u||"None provided"),!f.includes(g.toString()))return e.info("Skipping device type, data already exists:",g),null;if(t.isProcessed(m,g))return e.info("Skipping detection, already processed this device/URL combination"),null;if(0!==window.pageYOffset&&0!==document.documentElement.scrollTop)return e.info("User is not at the top of the page, skipping image detection"),null;!c.isComplete&&window.optmlDomUtils&&(e.info("Waiting for page to fully load..."),await o.waitForPageLoad(),e.info("Page fully loaded, proceeding with detection")),e.info("Waiting for viewport images to load..."),await o.waitForViewportImages(1500),e.info("Viewport images loaded, proceeding with detection"),await o.waitForIdleTime();const p=await s.detectLcpElement();let h="hidden"!==document.visibilityState,w=!1;const b=o.debounce((()=>{w=!0,e.info("Window resized during detection, results may be affected")}),100),I=()=>{h="hidden"!==document.visibilityState,e.info("Page visibility changed:",h?"visible":"hidden")};window.addEventListener("resize",b,{passive:!0}),document.addEventListener("visibilitychange",I);const E=[];let S=new Map;const y=function(t,n){return new IntersectionObserver((i=>{i.forEach((i=>{if(i.isIntersecting){const o=i.target;if("IMG"===o.tagName){const e=parseInt(o.getAttribute("data-opt-id"),10);isNaN(e)||t.includes(e)||t.push(e)}else if(o.hasAttribute("data-optml-bg-selector")){const t=o.getAttribute("data-optml-bg-selector"),i=o.getAttribute("data-optml-specific-selector");if(t&&i&&n.has(t)){const o=n.get(t);o.includes(i)||(o.push(i),e.info(`Element with selector "${i}" is above the fold`))}}}}))}),{threshold:.1})}(E,S),{allOptimoleImages:v}=function(t){const n=document.querySelectorAll("img[data-opt-id]"),i=new Map;return n.forEach((n=>{const o=parseInt(n.getAttribute("data-opt-id"),10);isNaN(o)?e.warn("Invalid data-opt-id:",n.getAttribute("data-opt-id")):(i.set(n,o),t.observe(n))})),{allOptimoleImages:n,observedElements:i}}(y),A=function(t){const n={};return t.forEach((t=>{try{const i=parseInt(t.getAttribute("data-opt-id"),10);if(isNaN(i))return;const o=t.hasAttribute("data-opt-src"),r=t.hasAttribute("data-opt-lazy-loaded");if(o&&r){const o=parseInt(t.getAttribute("data-opt-optimized-width"),10),r=parseInt(t.getAttribute("data-opt-optimized-height"),10);if(!isNaN(o)&&!isNaN(r)&&o>0&&r>0)return n[i]={w:o,h:r},void e.info(`Image ${i} using optimized dimensions:`,{optimizedDimensions:`${o}x${r}`})}const s=t.hasAttribute("width")&&""!==t.getAttribute("width"),a=t.hasAttribute("height")&&""!==t.getAttribute("height");if(!s||!a){const o=t.naturalWidth||0,r=t.naturalHeight||0;o>0&&r>0&&(n[i]={w:o,h:r},e.info(`Image ${i} missing dimensions:`,{missingWidth:!s,missingHeight:!a,naturalDimensions:`${o}x${r}`}))}}catch(n){e.error("Error detecting dimensions for image:",t,n)}})),n}(v);e.info("Images with missing dimensions found:",Object.keys(A).length);const O=await a.detectMissingSrcsets(),L=O.srcset,M=O.crop;e.info("Images requiring srcset variations found:",Object.keys(L).length),e.info("Images with crop status found:",Object.keys(M).length);let _=new Map,N=0;if(u&&Array.isArray(u)&&u.length>0){const t=r.processBackgroundSelectors(u,y);S=t.selectorMap,N=t.pendingElements,_=r.extractBackgroundImageUrls(u);const n=N>0?600:300;e.info(`Waiting ${n}ms for ${N} pending background elements`),await new Promise((e=>setTimeout(e,n)))}else await new Promise((e=>setTimeout(e,300)));if(y.disconnect(),window.removeEventListener("resize",b),document.removeEventListener("visibilitychange",I),document.querySelectorAll("[data-optml-bg-selector]").forEach((e=>{e.removeAttribute("data-optml-bg-selector"),e.removeAttribute("data-optml-specific-selector")})),w&&e.warn("Window was resized during detection, results may not be accurate"),h||e.warn("Page became hidden during detection, results may not be accurate"),e.info("Above the fold images with data-opt-id:",E),e.info("Background selectors:",S),E.length>0||S.size>0||p.imageId||p.bgSelector||Object.keys(A).length>0||Object.keys(L).length>0){const t=this._processBackgroundSelectors(S,_),n={d:g,a:E,b:t,u:m,t:window.optimoleDataOptimizer?window.optimoleDataOptimizer._t:null,h:window.optimoleDataOptimizer?window.optimoleDataOptimizer.hmac:null,pu:window.optimoleDataOptimizer?window.optimoleDataOptimizer.pageProfileUrl:null,l:{i:p.imageId,s:p.bgSelector,u:p.bgUrls},m:A,s:L,c:M};return e.info("Sending data with LCP information:",{lcpImageId:p.imageId,lcpBgSelector:p.bgSelector,lcpBgUrls:p.bgUrls}),e.info("Sending background selectors:",t),e.info("Sending dimension data for images:",A),e.info("Sending srcset data for images:",L),e.info("Sending crop status data for images:",M),i.sendToRestApi(n),n}return e.info("No above-the-fold images, background elements, LCP elements, dimension data, or srcset data found"),null},_processBackgroundSelectors:function(e,t){const n={};return e.forEach(((e,i)=>{n[i]={},e.forEach((e=>{n[i][e]=null,t.has(i)&&t.get(i).has(e)&&(n[i][e]=t.get(i).get(e))}))})),n}};!function(){function e(){c&&c.runProfiling?c.runProfiling():console.error("[Optimole] Main module not available")}"loading"===document.readyState?document.addEventListener("DOMContentLoaded",e):e()}()})();