/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/frontend/popup/popup.ts":
/*!********************************************!*\
  !*** ./src/blocks/frontend/popup/popup.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
class PopupBlock {
  canLock = false;
  constructor(element) {
    this.element = element;
    this.happened = false;
    this.storageKey = 'otter-popup-dismiss';
    const {
      dismiss = 0,
      anchor
    } = element.dataset;
    if (this.isItemDismissed() && 0 <= dismiss && !anchor && !Boolean(window.themeisleGutenberg?.isPreview)) {
      return;
    }
    this.canLock = Boolean(this.element.dataset.lockScrolling);
    if (!this.isDisabled()) {
      this.init();
    }
  }
  init() {
    this.bindOpen();
    this.bindClose();
    this.bindEscClose();
  }
  isDisabled() {
    const {
      disableOn
    } = this.element.dataset;
    return 'mobile' === disableOn && window.matchMedia('(max-width: 600px)').matches;
  }
  openModal() {
    this.element.classList.add('active');
    this.happened = true;
    this.lockScrolling();
  }
  closeModal() {
    this.element.classList.remove('active');
    this.dismissModal();
    this.unlockScrolling();
  }
  dismissModal() {
    var _localStorage$getItem;
    const {
      dismiss = 0,
      anchor
    } = this.element.dataset;
    const {
      id
    } = this.element;
    if (dismiss <= 0 || !id || anchor) {
      return false;
    }
    const now = new Date();
    const cache = JSON.parse((_localStorage$getItem = localStorage.getItem(this.storageKey)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '[]') || [];
    const exists = cache.some(entry => entry.modalID === id);
    if (exists) {
      return false;
    }
    const ttl = 1000 * 60 * 60 * 24 * parseInt(dismiss);
    const item = {
      expiry: now.getTime() + ttl,
      modalID: id
    };
    localStorage.setItem(this.storageKey, JSON.stringify([...cache, item]));
  }
  isItemDismissed() {
    var _localStorage$getItem2;
    const {
      id
    } = this.element;
    const {
      dismiss = 0
    } = this.element.dataset;
    const cache = JSON.parse((_localStorage$getItem2 = localStorage.getItem(this.storageKey)) !== null && _localStorage$getItem2 !== void 0 ? _localStorage$getItem2 : '[]') || [];
    const inCache = cache.filter(entry => entry.modalID === id);
    if (0 === inCache.length) {
      return false;
    }
    if (0 === parseInt(dismiss) && 0 < inCache.length) {
      return true;
    }
    const item = inCache[0];
    const now = new Date();
    if (item.expiry > now.getTime()) {
      return true;
    }
    const newCache = cache.filter(i => {
      return i !== inCache[0];
    });
    localStorage.setItem(this.storageKey, JSON.stringify(newCache));
    return false;
  }
  bindOpen() {
    const {
      open
    } = this.element.dataset;
    switch (open) {
      case 'onClick':
        this.bindAnchors();
        break;
      case 'onScroll':
        this.bindOpenAfterScroll();
        break;
      case 'onExit':
        this.bindExitIntent();
        break;
      case 'none':
        // Do nothing
        break;
      default:
      case 'onLoad':
        this.bindOnLoad();
        break;
    }
  }
  bindAnchors() {
    const {
      anchor
    } = this.element.dataset;
    if (!anchor) {
      return false;
    }
    const buttons = document.querySelectorAll(`a[href='#${anchor}'], #${anchor}`);
    buttons.forEach(button => {
      button.addEventListener('click', e => {
        // do not prevent default if href is a URL
        if (e.target?.href === `#${anchor}`) {
          e.preventDefault();
        }
        this.openModal();
      });
    });
  }
  bindOpenAfterScroll() {
    window.document.addEventListener('scroll', () => {
      if (this.happened) {
        return false;
      }
      const {
        offset
      } = this.element.dataset;
      if (parseInt(offset !== null && offset !== void 0 ? offset : '0') >= this.getScrolledPercent()) {
        return false;
      }
      this.openModal();
    });
  }
  bindOnLoad() {
    const {
      time
    } = this.element.dataset;
    setTimeout(() => {
      this.openModal();
    }, parseInt(time !== null && time !== void 0 ? time : '0') * 1000);
  }
  bindExitIntent() {
    document.body.addEventListener('mouseleave', e => {
      if (this.happened) {
        return false;
      }
      if (0 > e.clientY) {
        this.openModal();
      }
    });
  }
  getScrolledPercent() {
    const height = document.documentElement;
    const {
      body
    } = document;
    const st = 'scrollTop';
    const sh = 'scrollHeight';
    return (height[st] || body[st]) / ((height[sh] || body[sh]) - height.clientHeight) * 100;
  }
  bindClose() {
    this.bindCloseButtons();
    this.bindAnchorClose();
    this.bindOverlayClosing();
  }
  bindAnchorClose() {
    const {
      anchorclose
    } = this.element.dataset;
    if (!anchorclose) {
      return false;
    }
    const buttons = document.querySelectorAll(`a[href='#${anchorclose}'], #${anchorclose}`);
    buttons.forEach(button => {
      button.addEventListener('click', e => {
        // do not prevent default if href is a URL
        if (e.target?.href === `#${anchorclose}`) {
          e.preventDefault();
        }
        this.closeModal();
      });
    });
  }
  bindCloseButtons() {
    const modal = this.element;
    const closes = modal.querySelectorAll('.otter-popup__modal_header .components-button');
    closes.forEach(close => {
      close.addEventListener('click', () => {
        this.closeModal();
      });
    });
  }
  bindOverlayClosing() {
    const {
      outside
    } = this.element.dataset;
    if (!outside) {
      return false;
    }
    const overlay = this.element.querySelector('.otter-popup__modal_wrap_overlay');
    overlay?.addEventListener('click', () => {
      this.closeModal();
    });
  }
  lockScrolling() {
    if (this.canLock) {
      document.body.classList.add('o-lock-body');
    }
  }
  unlockScrolling() {
    if (this.canLock) {
      document.body.classList.remove('o-lock-body');
    }
  }
  bindEscClose() {
    document.addEventListener('keydown', event => {
      if ('Escape' === event.key && this.happened) {
        this.closeModal();
      }
    });
  }
}
/* harmony default export */ __webpack_exports__["default"] = (PopupBlock);

/***/ }),

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!********************************************!*\
  !*** ./src/blocks/frontend/popup/index.js ***!
  \********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./popup */ "./src/blocks/frontend/popup/popup.ts");
/**
 * Internal dependencies
 */


(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const popups = document.querySelectorAll('.wp-block-themeisle-blocks-popup, .wp-block-themeisle-blocks-modal');
  if (!popups.length) {
    return;
  }
  popups.forEach(block => new _popup__WEBPACK_IMPORTED_MODULE_1__["default"](block));
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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