/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/frontend/form/captcha.js":
/*!*********************************************!*\
  !*** ./src/blocks/frontend/form/captcha.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addCaptchaOnPage: function() { return /* binding */ addCaptchaOnPage; }
/* harmony export */ });
const addCaptchaOnPage = forms => {
  if (!window.hasOwnProperty('grecaptcha') && window?.themeisleGutenbergForm?.reRecaptchaSitekey) {
    const script = document.createElement('script');
    script.id = 'recaptcha';
    document.body.appendChild(script);
    script.addEventListener('load', () => {
      const tryRenderCaptcha = setInterval(() => {
        if (window.hasOwnProperty('grecaptcha') && window.grecaptcha.hasOwnProperty('render')) {
          forms.forEach(form => {
            if (form?.classList?.contains('has-captcha')) {
              renderCapthcaOn(form);
            }
          });
          clearInterval(tryRenderCaptcha);
        }
      }, 200);
    });
    script.src = window?.themeisleGutenbergForm?.reRecaptchaAPIURL;
  }
};

/**
 * Render the captcha component on form
 *
 * @param {HTMLDivElement} form The form container
 */
const renderCapthcaOn = form => {
  if (!window.hasOwnProperty('grecaptcha')) {
    return;
  }
  const {
    id
  } = form;
  const captchaNode = document.createElement('div');
  const container = form.querySelector('.otter-form__container');
  container?.insertBefore(captchaNode, container.lastChild);
  const captcha = window.grecaptcha?.render(captchaNode, {
    sitekey: window?.themeisleGutenbergForm?.reRecaptchaSitekey,
    callback: token => {
      if (!window.themeisleGutenberg) {
        window.themeisleGutenberg = {};
      }
      if (!window.themeisleGutenberg?.tokens) {
        window.themeisleGutenberg.tokens = {};
      }
      window.themeisleGutenberg.tokens[id] = {
        token,
        reset: () => window.grecaptcha?.reset(captcha)
      };
    },
    'expired-callback': () => {
      if (!window.themeisleGutenberg?.tokens) {
        window.themeisleGutenberg = {};
        window.themeisleGutenberg.tokens = {};
      }
      window.themeisleGutenberg.tokens[id] = {
        token: null,
        reset: () => null
      };
    }
  });
  return captcha;
};

/***/ }),

/***/ "./src/blocks/frontend/form/message.js":
/*!*********************************************!*\
  !*** ./src/blocks/frontend/form/message.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
class DisplayFormMessage {
  /**
   * The construct
   * @param {HTMLDivElement} form The form.
   */
  constructor(form) {
    this.form = form;
    this.anchor = form.querySelector('.wp-block-button');
    this.anchor?.classList.add('has-submit-msg');
    this.msgElem = document.createElement('div');
    this.msgElem.classList.add('o-form-server-response');
    this.anchor.appendChild(this.msgElem);
    this.isVisible = false;
    this.visibilityTimeout = undefined;
    this.visibilityDuration = 12_000; // ms
  }

  /**
   * Toggle the visibility of the message.
   * @param {boolean} value
   */
  toggle(value) {
    this.isVisible = undefined !== value ? value : !this.isVisible;
    this.msgElem.style.display = this.isVisible ? 'block' : 'none';
  }

  /**
   * Get the message from global themeisleGutenbergForm?.messages
   * @param {string} msgSlug
   * @return {*|string}
   */
  getMsgBySlug(msgSlug) {
    return window?.themeisleGutenbergForm?.messages[msgSlug] || 'Messages are missing!';
  }

  /**
   * Set the message from global themeisleGutenbergForm?.messages
   * @param {string}                      msgSlug
   * @param {'error'|'warning'|'success'} type
   * @return {DisplayFormMessage}
   */
  pullMsg(msgSlug, type) {
    return this.setMsg(this.getMsgBySlug(msgSlug), type);
  }

  /**
   * Set the message.
   * @param {string}                      msg
   * @param {'error'|'warning'|'success'} type
   * @return {DisplayFormMessage}
   */
  setMsg(msg, type = '') {
    this.msgElem.innerHTML = msg;
    this.clean();
    switch (type) {
      case 'error':
        this.msgElem.classList.toggle('o-error', true);
        break;
      case 'warning':
        this.msgElem.classList.toggle('o-warning', true);
        break;
      default:
        this.msgElem.classList.toggle('o-success', true);
    }
    return this;
  }

  /**
   * Show the message for a limited amount of time.
   * @param {number?} durationMS
   */
  show(durationMS) {
    clearTimeout(this.visibilityTimeout);
    this.toggle(true);
    this.visibilityTimeout = setTimeout(() => {
      this.toggle(false);
    }, durationMS || this.visibilityDuration);
  }

  /**
   * Clean the CSS classes.
   */
  clean() {
    this.msgElem.classList.toggle('o-error', false);
    this.msgElem.classList.toggle('o-warning', false);
    this.msgElem.classList.toggle('o-success', false);
  }
}
/* harmony default export */ __webpack_exports__["default"] = (DisplayFormMessage);

/***/ }),

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*******************************************!*\
  !*** ./src/blocks/frontend/form/index.js ***!
  \*******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _captcha_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./captcha.js */ "./src/blocks/frontend/form/captcha.js");
/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message.js */ "./src/blocks/frontend/form/message.js");
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies.
 */



let startTimeAntiBot = null;
const METADATA_VERSION = 1;
let saveMode = 'permanent';
const hasStripeConfirmation = () => {
  const urlParams = new URLSearchParams(window.location.search);
  return urlParams.has('stripe_checkout');
};
const confirmRecord = async () => {
  // Get the record id from the URL
  const urlParams = new URLSearchParams(window.location.search);
  const stripeSessionId = urlParams.get('stripe_checkout');
  const formURlEndpoint = (window?.themeisleGutenbergForm?.root || window.location.origin + '/wp-json/') + 'otter/v1/form/confirm';
  return await fetch(formURlEndpoint + `?stripe_checkout=${stripeSessionId}`, {
    method: 'GET',
    credentials: 'include'
  });
};

/**
 * Get the form fields.
 * @param {HTMLDivElement} form The form.
 * @return {HTMLDivElement[]} The form fields.
 */
const getFormFieldInputs = form => {
  /** @type {Array.<HTMLDivElement>} */
  const innerForms = [...form?.querySelectorAll(':scope > .otter-form__container .wp-block-themeisle-blocks-form')];

  /**
   * Remove the field from the inner forms.
   *
   * @type {Array.<HTMLDivElement>}
   */
  return [...form?.querySelectorAll(':scope > .otter-form__container .wp-block-themeisle-blocks-form-input, :scope > .otter-form__container .wp-block-themeisle-blocks-form-textarea, :scope > .otter-form__container .wp-block-themeisle-blocks-form-multiple-choice, :scope > .otter-form__container .wp-block-themeisle-blocks-form-file, :scope > .otter-form__container .wp-block-themeisle-blocks-form-hidden-field, :scope > .otter-form__container .wp-block-themeisle-blocks-form-stripe-field')].filter(input => {
    return !innerForms?.some(innerForm => innerForm?.contains(input));
  });
};

/**
 * Get the fields with their value from the form.
 *
 * @param {HTMLDivElement} form The form.
 * @return {Promise<{formFieldsData: import('./types').FormFieldData[]}>}
 */
const extractFormFields = async form => {
  /** @type {Array.<import('./types').FormFieldData>} */
  const formFieldsData = [{
    label: window?.themeisleGutenbergForm?.messages['form-submission'] || 'Form submission from',
    value: window.location.href,
    metadata: {
      position: 0
    }
  }];

  /**
   * All input fields that belong to the current form. Fields from inner forms are removed.
   *
   * @type {Array.<HTMLDivElement>}
   */
  const allInputs = getFormFieldInputs(form);
  allInputs?.forEach((input, index) => {
    const labelContainer = input.querySelector('.otter-form-input-label');
    const labelElem = (labelContainer !== null && labelContainer !== void 0 ? labelContainer : input).querySelector('.otter-form-input-label__label, .otter-form-textarea-label__label');
    let label = `${(labelElem !== null && labelElem !== void 0 ? labelElem : labelContainer)?.innerHTML?.replace(/<[^>]*>?/gm, '')}`;
    let value;
    let fieldType;
    let mappedName;
    let metadata = {};
    const {
      id
    } = input;
    const valueElem = input.querySelector('.otter-form-input:not([type="checkbox"], [type="radio"], [type="file"], [type="hidden"]), .otter-form-textarea-input');
    if (null !== valueElem) {
      value = valueElem?.value;
      fieldType = valueElem?.type;
      mappedName = valueElem?.name;
    } else {
      const select = input.querySelector('select');
      mappedName = select?.name;

      /** @type {HTMLInputElement} */
      const fileInput = input.querySelector('input[type="file"]');
      const hiddenInput = input.querySelector('input[type="hidden"]');
      const stripeField = input.classList.contains('wp-block-themeisle-blocks-form-stripe-field');
      if (fileInput) {
        const files = fileInput?.files;
        const mappedName = fileInput?.name;
        for (let i = 0; i < files.length; i++) {
          formFieldsData.push({
            label,
            value: `${files[i].name} (${(files[i].size / (1024 * 1024)).toFixed(4)} MB)`,
            type: fileInput.type,
            id,
            metadata: {
              version: METADATA_VERSION,
              name: files[i].name,
              size: files[i].size,
              file: files[i],
              fieldOptionName: fileInput?.dataset?.fieldOptionName,
              position: index + 1,
              mappedName
            }
          });
        }
      } else if (select) {
        value = [...select.selectedOptions].map(o => o?.label)?.filter(l => Boolean(l)).join(', ');
        fieldType = 'multiple-choice';
      } else if (hiddenInput) {
        const paramName = hiddenInput?.dataset?.paramName;
        mappedName = hiddenInput?.name;

        // Extract the value from the URL.
        if (paramName) {
          const urlParams = new URLSearchParams(window.location.search);
          if (urlParams.has(paramName)) {
            hiddenInput.value = urlParams.get(paramName);
          }
        }
        if (hiddenInput?.value) {
          // eslint-disable-next-line prefer-destructuring
          value = hiddenInput.value;
          fieldType = 'hidden';
        }
      } else if (stripeField) {
        // Find more proper selectors instead of h3 and h5
        label = `${input.querySelector('.o-stripe-checkout-description h3')?.innerHTML?.replace(/<[^>]*>?/gm, '')}`;
        value = input.querySelector('.o-stripe-checkout-description h5')?.innerHTML?.replace(/<[^>]*>?/gm, '');
        fieldType = 'stripe-field';
        mappedName = input.name;
        metadata = {
          fieldOptionName: input?.dataset?.fieldOptionName
        };
        saveMode = 'temporary';
      } else {
        const labels = input.querySelectorAll('.o-form-multiple-choice-field > label');
        const valuesElem = input.querySelectorAll('.o-form-multiple-choice-field > input');
        mappedName = valuesElem[0]?.name;
        value = [...labels].filter((label, index) => valuesElem[index]?.checked).map(label => label.innerHTML).join(', ');
        fieldType = 'multiple-choice';
      }
    }
    if (value) {
      formFieldsData.push({
        label: label || '(No label)',
        value,
        type: fieldType,
        id,
        metadata: {
          ...metadata,
          version: METADATA_VERSION,
          position: index + 1,
          mappedName
        }
      });
    }
  });
  return {
    formFieldsData
  };
};

/**
 * Get the nonce value from the form.
 * @param {HTMLDivElement} form The form.
 * @return {string}
 */
function extractNonceValue(form) {
  const query = `.protection #${form.id || ''}_nonce_field`;
  return form.querySelector(query)?.value;
}

/**
 * Validate the inputs from the form.
 *
 * @param {HTMLDivElement} form The form.
 * @return
 */
function validateInputs(form) {
  let result = true;
  const inputFields = getFormFieldInputs(form);
  for (const field of inputFields) {
    if (field.classList.contains('wp-block-themeisle-blocks-form-input')) {
      const input = field.querySelector('input');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-textarea')) {
      const input = field.querySelector('textarea');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-multiple-choice')) {
      const select = field.querySelector('select');
      if (select?.hasAttribute('required') && !select?.checkValidity()) {
        select?.reportValidity();
        result = false;
        break;
      }

      // Check if it is required and at least one is checked.
      const radios = field.querySelectorAll('.o-form-multiple-choice-field input[type="radio"]');
      if (radios?.length && radios[0]?.hasAttribute('required') && ![...radios].some(radio => radio.checked)) {
        // radios[0]?.setCustomValidity( 'Please select one option.' );
        radios[0]?.reportValidity();
        result = false;
        break;
      }
      const checkboxes = field.querySelectorAll('.o-form-multiple-choice-field input[type="checkbox"]');
      if (checkboxes?.length && checkboxes[0]?.hasAttribute('required') && ![...checkboxes].some(checkbox => checkbox.checked)) {
        checkboxes[0]?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-file')) {
      const input = field.querySelector('input');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    }
  }
  return result;
}

/**
 * Make a FormData object from the form fields data.
 * Strip binary data into separate keys.
 *
 * @param {import('./types').FormDataStructure} data
 */
const createFormData = data => {
  const formData = new FormData();

  /**
   * For simple data, we will encode them as JSON in 'form_data' key.
   * This gives the flexibility to have the same data shape like in backend without creating complex serializers.
   * For complex data like files, we will use FormData way to handle them.
   */
  data?.payload?.formInputsData?.forEach((field, index) => {
    if ('file' === field.type) {
      const key = 'file__' + field.metadata.position + '_' + index;
      formData.append(key, field.metadata.file);
      data.payload.formInputsData[index].metadata.file = undefined;
      data.payload.formInputsData[index].metadata.data = key; // Create a link with the file which will be used in backend via $_FILES.
    }
  });
  formData.append('form_data', JSON.stringify(data));
  return formData;
};

/**
 * Try to get the current post id from body class.
 * @return {number}
 */
const getCurrentPostId = () => {
  const body = document.querySelector('body');
  const classes = body?.classList?.value?.split(' ');
  const postClass = classes?.find(c => c.includes('postid-') || c.includes('page-id-'));
  if (postClass) {
    const postId = postClass.split('-').pop();
    if (postId) {
      return parseInt(postId);
    }
  }
  return 0;
};

/**
 * Handle the response after the form is submitted.
 *
 * @param {Promise<Response>}                                                                     request
 * @param {DisplayFormMessage}                                                                    displayMsg
 * @param {(response: import('./types.js').IFormResponse, displayMsg:DisplayFormMessage) => void} onSuccess
 * @param {(response: import('./types.js').IFormResponse, displayMsg:DisplayFormMessage) => void} onFail
 * @param {() => void}                                                                            onCleanUp
 */
const handleAfterSubmit = (request, displayMsg, onSuccess, onFail, onCleanUp) => {
  request.then(r => r.json()).then(response => {
    /**
     * @type {import('./types.js').IFormResponse} The response from the server.
     */
    const res = response;
    if ('0' === res?.code || '1' === res?.code || res?.success) {
      onSuccess?.(res, displayMsg);
    } else {
      let errorMsgSlug = '';

      // TODO: Write pattern to display a more useful error message.
      if ('110' === res.code) {
        displayMsg.setMsg(res?.reasons?.join(''), 'error').show();
      } else if ('12' === res.code || '13' === res.code) {
        displayMsg.pullMsg('invalid-file', 'error').show();
      } else if (0 < res?.displayError?.length) {
        errorMsgSlug = res?.displayError;
        displayMsg.setMsg(errorMsgSlug, 'error').show();
      } else {
        displayMsg.setMsg(res?.reasons?.join(''), 'error').show();
      }
      onFail?.(res, displayMsg);

      // eslint-disable-next-line no-console
      console.error(`(${res?.code}) ${res?.reasons?.join('')}`);
    }

    /**
     * Reset the form.
     */

    onCleanUp?.();
  })?.catch(error => {
    console.error(error);
    displayMsg.pullMsg('try-again', 'error').show();
    onFail?.(error, displayMsg);
  });
};
const makeSpinner = anchor => {
  const spinner = document.createElement('span');
  spinner.classList.add('spinner');
  return {
    show: () => {
      anchor.appendChild(spinner);
    },
    hide: () => {
      if (anchor.contains(spinner)) {
        anchor.removeChild(spinner);
      }
    }
  };
};

/**
 * Send the date from the form to the server
 *
 * @param {HTMLDivElement}     form       The element that contains all the inputs
 * @param {HTMLButtonElement}  btn        The submit button
 * @param {DisplayFormMessage} displayMsg The display message utility
 */
const collectAndSendInputFormData = async (form, btn, displayMsg) => {
  const id = form?.id;
  const payload = {};

  // Get the data from the form fields.
  const {
    formFieldsData
  } = await extractFormFields(form);
  const formIsEmpty = 2 > formFieldsData?.length;
  const hasCaptcha = form?.classList?.contains('has-captcha');
  const hasValidToken = id && window.themeisleGutenberg?.tokens?.[id]?.token;
  const spinner = makeSpinner(btn);
  const isValidationSuccessful = validateInputs(form);
  if (formIsEmpty || !isValidationSuccessful) {
    btn.disabled = false;
    spinner.hide();
    return;
  }
  const nonceFieldValue = extractNonceValue(form);
  if (hasCaptcha && !hasValidToken) {
    const msg = !window.hasOwnProperty('grecaptcha') ? 'captcha-not-loaded' : 'check-captcha';
    displayMsg.pullMsg(msg, 'error').show();
  }
  if (!isValidationSuccessful || hasCaptcha && !hasValidToken) {
    btn.disabled = false;
    spinner.hide();
  } else {
    var _form$querySelector$c;
    payload.formInputsData = formFieldsData;
    if (hasValidToken) {
      payload.token = window.themeisleGutenberg?.tokens?.[id].token;
    }

    /**
     * +---------------- Extract the essential data. ----------------+
     */
    if ('' !== form?.dataset?.emailSubject) {
      payload.emailSubject = form?.dataset?.emailSubject;
    }
    if (form?.dataset?.optionName) {
      payload.formOption = form?.dataset?.optionName;
    }
    if (form?.id) {
      payload.formId = form?.id;
    }
    if (nonceFieldValue) {
      payload.nonceValue = nonceFieldValue;
    }
    payload.antiSpamTime = Date.now() - (startTimeAntiBot !== null && startTimeAntiBot !== void 0 ? startTimeAntiBot : Date.now());
    payload.antiSpamHoneyPot = Boolean((_form$querySelector$c = form.querySelector(':scope > .otter-form__container > .protection .o-anti-bot')?.checked) !== null && _form$querySelector$c !== void 0 ? _form$querySelector$c : false);

    /*
    * the URL is no longer relevant if permalink structure is changed, that's why
    * we try to also send the id taken from the body class.
    */
    payload.postUrl = window.location.href;
    payload.postId = getCurrentPostId();

    /**
     * Get the consent
     */
    if (form.classList.contains('can-submit-and-subscribe')) {
      payload.action = 'submit-subscribe';
      payload.consent = form.querySelector('.otter-form-consent input')?.checked || false;
    }
    const formURlEndpoint = (window?.themeisleGutenbergForm?.root || window.location.origin + '/wp-json/') + 'otter/v1/form/frontend';
    const formData = createFormData({
      handler: 'submit',
      payload
    });
    try {
      const request = fetch(formURlEndpoint, {
        method: 'POST',
        headers: {
          'X-WP-Nonce': window?.themeisleGutenbergForm?.nonce,
          'O-Form-Save-Mode': saveMode
        },
        credentials: 'include',
        body: formData
      });
      spinner.show();
      handleAfterSubmit(request, displayMsg, (res, displayMsg) => {
        if (0 < res?.frontend_external_confirmation_url?.length) {
          // Redirect to the external confirmation URL in a new tab.
          window.open(res.frontend_external_confirmation_url, '_blank');
          return;
        }
        const msg = res?.submitMessage ? res.submitMessage : 'Success';
        displayMsg.setMsg(msg).show();
        form?.querySelector('form')?.reset();
        if (0 < res?.redirectLink?.length) {
          form.setAttribute('data-redirect', res.redirectLink);
          setTimeout(() => {
            window.location.href = res.redirectLink;
          }, 1000);
        }
      }, (res, displayMsg) => {}, () => {
        if (window.themeisleGutenberg?.tokens?.[id].reset) {
          window.themeisleGutenberg?.tokens?.[id].reset();
        }
        btn.disabled = false;
        spinner.hide();
      });
    } catch (e) {
      console.error(e);
      displayMsg.pullMsg('try-again', 'error').show();
      btn.disabled = false;
      spinner.hide();
    }
  }
};

/**
 * Render a checkbox for consent
 *
 * @param {HTMLDivElement} form
 */
const renderConsentCheckbox = form => {
  const container = form.querySelector('.otter-form__container');
  const button = form.querySelector('.wp-block-button');
  const inputContainer = document.createElement('div');
  inputContainer.classList.add('otter-form-consent');
  container.insertBefore(inputContainer, button);
  const input = document.createElement('input');
  input.type = 'checkbox';
  input.name = 'o-consent';
  input.id = 'o-consent';
  const label = document.createElement('label');
  label.innerHTML = window?.themeisleGutenbergForm?.messages?.privacy || 'I have read and agree to the privacy statement.';
  label.htmlFor = 'o-consent';
  inputContainer.appendChild(input);
  inputContainer.appendChild(label);
};
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__.domReady)(() => {
  const forms = document.querySelectorAll('.wp-block-themeisle-blocks-form');
  (0,_captcha_js__WEBPACK_IMPORTED_MODULE_0__.addCaptchaOnPage)(forms);
  startTimeAntiBot = Date.now();
  forms.forEach(form => {
    if (form.classList.contains('can-submit-and-subscribe')) {
      renderConsentCheckbox(form);
    }
    const sendBtn = form.querySelector('button');
    const displayMsg = new _message_js__WEBPACK_IMPORTED_MODULE_1__["default"](form);
    if (hasStripeConfirmation()) {
      sendBtn.disabled = true;
      const btnText = sendBtn.innerHTML;
      sendBtn.innerHTML = displayMsg.getMsgBySlug('confirmingSubmission');
      const spinner = makeSpinner(sendBtn);
      spinner.show();
      handleAfterSubmit(confirmRecord(), displayMsg, (res, displayMsg) => {
        const msg = res?.submitMessage ? res.submitMessage : 'Success';
        displayMsg.setMsg(msg).show();
        if (0 < res?.redirectLink?.length) {
          form.setAttribute('data-redirect', res.redirectLink);
          setTimeout(() => {
            window.location.href = res.redirectLink;
          }, 1000);
        }
      }, () => {}, () => {
        sendBtn.disabled = false;
        spinner.hide();
        sendBtn.innerHTML = btnText;
      });
    }
    if (form.querySelector(':scope > form > button[type="submit"]')) {
      form?.addEventListener('submit', event => {
        event.preventDefault();
        if (!sendBtn.disabled) {
          sendBtn.disabled = true;
          collectAndSendInputFormData(form, sendBtn, displayMsg);
        }
      }, false);
    } else {
      // legacy
      sendBtn?.addEventListener('click', event => {
        event.preventDefault();
        if (!sendBtn.disabled) {
          sendBtn.disabled = true;
          collectAndSendInputFormData(form, sendBtn, displayMsg);
        }
      }, false);
    }
  });
  forms.forEach(form => {
    const fields = getFormFieldInputs(form);
    fields.forEach(field => {
      const input = field.querySelector('input');
      if ('file' === input?.type) {
        const {
          maxFilesNumber,
          maxFileSize
        } = input.dataset;
        input.addEventListener('change', event => {
          let isValidationSuccessful = true;
          const {
            files
          } = event.target;
          if (maxFilesNumber && files.length > maxFilesNumber) {
            input.setCustomValidity(window.themeisleGutenbergForm?.messages?.['too-many-files'] + maxFilesNumber);
            isValidationSuccessful = false;
          }
          if (isValidationSuccessful && maxFileSize) {
            for (const file of files) {
              if (file.size > maxFileSize * 1024 * 1024) {
                input.setCustomValidity(window.themeisleGutenbergForm?.messages?.['big-file'] + ' ' + maxFileSize + 'MB.');
                isValidationSuccessful = false;
                break;
              }
            }
          }
          if (!isValidationSuccessful) {
            input.reportValidity();
            input.value = '';
          } else {
            input.setCustomValidity('');
          }
        });
      }
    });
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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