/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/frontend/form/captcha.js":
/*!*********************************************!*\
  !*** ./src/blocks/frontend/form/captcha.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addCaptchaOnPage: function() { return /* binding */ addCaptchaOnPage; }
/* harmony export */ });
const addCaptchaOnPage = forms => {
  if (!window.hasOwnProperty('grecaptcha') && window?.themeisleGutenbergForm?.reRecaptchaSitekey) {
    const script = document.createElement('script');
    script.id = 'recaptcha';
    document.body.appendChild(script);
    script.addEventListener('load', () => {
      const tryRenderCaptcha = setInterval(() => {
        if (window.hasOwnProperty('grecaptcha') && window.grecaptcha.hasOwnProperty('render')) {
          forms.forEach(form => {
            if (form?.classList?.contains('has-captcha')) {
              renderCapthcaOn(form);
            }
          });
          clearInterval(tryRenderCaptcha);
        }
      }, 200);
    });
    script.src = window?.themeisleGutenbergForm?.reRecaptchaAPIURL;
  }
};

/**
 * Render the captcha component on form
 *
 * @param {HTMLDivElement} form The form container
 */
const renderCapthcaOn = form => {
  if (!window.hasOwnProperty('grecaptcha')) {
    return;
  }
  const {
    id
  } = form;
  const captchaNode = document.createElement('div');
  const container = form.querySelector('.otter-form__container');
  container?.insertBefore(captchaNode, container.lastChild);
  const captcha = window.grecaptcha?.render(captchaNode, {
    sitekey: window?.themeisleGutenbergForm?.reRecaptchaSitekey,
    callback: token => {
      if (!window.themeisleGutenberg) {
        window.themeisleGutenberg = {};
      }
      if (!window.themeisleGutenberg?.tokens) {
        window.themeisleGutenberg.tokens = {};
      }
      window.themeisleGutenberg.tokens[id] = {
        token,
        reset: () => window.grecaptcha?.reset(captcha)
      };
    },
    'expired-callback': () => {
      if (!window.themeisleGutenberg?.tokens) {
        window.themeisleGutenberg = {};
        window.themeisleGutenberg.tokens = {};
      }
      window.themeisleGutenberg.tokens[id] = {
        token: null,
        reset: () => null
      };
    }
  });
  return captcha;
};

/***/ }),

/***/ "./src/blocks/frontend/form/message.js":
/*!*********************************************!*\
  !*** ./src/blocks/frontend/form/message.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
class DisplayFormMessage {
  /**
   * The construct
   * @param {HTMLDivElement} form The form.
   */
  constructor(form) {
    this.form = form;
    this.anchor = form.querySelector('.wp-block-button');
    this.anchor?.classList.add('has-submit-msg');
    this.msgElem = document.createElement('div');
    this.msgElem.classList.add('o-form-server-response');
    this.anchor.appendChild(this.msgElem);
    this.isVisible = false;
    this.visibilityTimeout = undefined;
    this.visibilityDuration = 12_000; // ms
  }

  /**
   * Toggle the visibility of the message.
   * @param {boolean} value
   */
  toggle(value) {
    this.isVisible = undefined !== value ? value : !this.isVisible;
    this.msgElem.style.display = this.isVisible ? 'block' : 'none';
  }

  /**
   * Get the message from global themeisleGutenbergForm?.messages
   * @param {string} msgSlug
   * @return {*|string}
   */
  getMsgBySlug(msgSlug) {
    return window?.themeisleGutenbergForm?.messages[msgSlug] || 'Messages are missing!';
  }

  /**
   * Set the message from global themeisleGutenbergForm?.messages
   * @param {string}                      msgSlug
   * @param {'error'|'warning'|'success'} type
   * @return {DisplayFormMessage}
   */
  pullMsg(msgSlug, type) {
    return this.setMsg(this.getMsgBySlug(msgSlug), type);
  }

  /**
   * Set the message.
   * @param {string}                      msg
   * @param {'error'|'warning'|'success'} type
   * @return {DisplayFormMessage}
   */
  setMsg(msg, type = '') {
    this.msgElem.innerHTML = msg;
    this.clean();
    switch (type) {
      case 'error':
        this.msgElem.classList.toggle('o-error', true);
        break;
      case 'warning':
        this.msgElem.classList.toggle('o-warning', true);
        break;
      default:
        this.msgElem.classList.toggle('o-success', true);
    }
    return this;
  }

  /**
   * Show the message for a limited amount of time.
   * @param {number?} durationMS
   */
  show(durationMS) {
    clearTimeout(this.visibilityTimeout);
    this.toggle(true);
    this.visibilityTimeout = setTimeout(() => {
      this.toggle(false);
    }, durationMS || this.visibilityDuration);
  }

  /**
   * Clean the CSS classes.
   */
  clean() {
    this.msgElem.classList.toggle('o-error', false);
    this.msgElem.classList.toggle('o-warning', false);
    this.msgElem.classList.toggle('o-success', false);
  }
}
/* harmony default export */ __webpack_exports__["default"] = (DisplayFormMessage);

/***/ }),

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*******************************************!*\
  !*** ./src/blocks/frontend/form/index.js ***!
  \*******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _captcha_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./captcha.js */ "./src/blocks/frontend/form/captcha.js");
/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message.js */ "./src/blocks/frontend/form/message.js");
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies.
 */



let startTimeAntiBot = null;
const METADATA_VERSION = 1;
let saveMode = 'permanent';
const hasStripeConfirmation = () => {
  const urlParams = new URLSearchParams(window.location.search);
  return urlParams.has('stripe_checkout');
};
const confirmRecord = async () => {
  // Get the record id from the URL
  const urlParams = new URLSearchParams(window.location.search);
  const stripeSessionId = urlParams.get('stripe_checkout');
  const formURlEndpoint = (window?.themeisleGutenbergForm?.root || window.location.origin + '/wp-json/') + 'otter/v1/form/confirm';
  return await fetch(formURlEndpoint + `?stripe_checkout=${stripeSessionId}`, {
    method: 'GET',
    credentials: 'include'
  });
};

/**
 * Get the form fields.
 * @param {HTMLDivElement} form The form.
 * @return {HTMLDivElement[]} The form fields.
 */
const getFormFieldInputs = form => {
  /** @type {Array.<HTMLDivElement>} */
  const innerForms = [...form?.querySelectorAll(':scope > .otter-form__container .wp-block-themeisle-blocks-form')];

  /**
   * Remove the field from the inner forms.
   *
   * @type {Array.<HTMLDivElement>}
   */
  return [...form?.querySelectorAll(':scope > .otter-form__container .wp-block-themeisle-blocks-form-input, :scope > .otter-form__container .wp-block-themeisle-blocks-form-textarea, :scope > .otter-form__container .wp-block-themeisle-blocks-form-multiple-choice, :scope > .otter-form__container .wp-block-themeisle-blocks-form-file, :scope > .otter-form__container .wp-block-themeisle-blocks-form-hidden-field, :scope > .otter-form__container .wp-block-themeisle-blocks-form-stripe-field')].filter(input => {
    return !innerForms?.some(innerForm => innerForm?.contains(input));
  });
};

/**
 * Get the fields with their value from the form.
 *
 * @param {HTMLDivElement} form The form.
 * @return {Promise<{formFieldsData: import('./types').FormFieldData[]}>}
 */
const extractFormFields = async form => {
  /** @type {Array.<import('./types').FormFieldData>} */
  const formFieldsData = [{
    label: window?.themeisleGutenbergForm?.messages['form-submission'] || 'Form submission from',
    value: window.location.href,
    metadata: {
      position: 0
    }
  }];

  /**
   * All input fields that belong to the current form. Fields from inner forms are removed.
   *
   * @type {Array.<HTMLDivElement>}
   */
  const allInputs = getFormFieldInputs(form);
  allInputs?.forEach((input, index) => {
    const labelContainer = input.querySelector('.otter-form-input-label');
    const labelElem = (labelContainer !== null && labelContainer !== void 0 ? labelContainer : input).querySelector('.otter-form-input-label__label, .otter-form-textarea-label__label');
    let label = `${(labelElem !== null && labelElem !== void 0 ? labelElem : labelContainer)?.innerHTML?.replace(/<[^>]*>?/gm, '')}`;
    let value;
    let fieldType;
    let mappedName;
    let metadata = {};
    const {
      id
    } = input;
    const valueElem = input.querySelector('.otter-form-input:not([type="checkbox"], [type="radio"], [type="file"], [type="hidden"]), .otter-form-textarea-input');
    if (null !== valueElem) {
      value = valueElem?.value;
      fieldType = valueElem?.type;
      mappedName = valueElem?.name;
    } else {
      const select = input.querySelector('select');
      mappedName = select?.name;

      /** @type {HTMLInputElement} */
      const fileInput = input.querySelector('input[type="file"]');
      const hiddenInput = input.querySelector('input[type="hidden"]');
      const stripeField = input.classList.contains('wp-block-themeisle-blocks-form-stripe-field');
      if (fileInput) {
        const files = fileInput?.files;
        const mappedName = fileInput?.name;
        for (let i = 0; i < files.length; i++) {
          formFieldsData.push({
            label,
            value: `${files[i].name} (${(files[i].size / (1024 * 1024)).toFixed(4)} MB)`,
            type: fileInput.type,
            id,
            metadata: {
              version: METADATA_VERSION,
              name: files[i].name,
              size: files[i].size,
              file: files[i],
              fieldOptionName: fileInput?.dataset?.fieldOptionName,
              position: index + 1,
              mappedName
            }
          });
        }
      } else if (select) {
        value = [...select.selectedOptions].map(o => o?.label)?.filter(l => Boolean(l)).join(', ');
        fieldType = 'multiple-choice';
      } else if (hiddenInput) {
        const paramName = hiddenInput?.dataset?.paramName;
        mappedName = hiddenInput?.name;

        // Extract the value from the URL.
        if (paramName) {
          const urlParams = new URLSearchParams(window.location.search);
          if (urlParams.has(paramName)) {
            hiddenInput.value = urlParams.get(paramName);
          }
        }
        if (hiddenInput?.value) {
          // eslint-disable-next-line prefer-destructuring
          value = hiddenInput.value;
          fieldType = 'hidden';
        }
      } else if (stripeField) {
        // Find more proper selectors instead of h3 and h5
        label = `${input.querySelector('.o-stripe-checkout-description h3')?.innerHTML?.replace(/<[^>]*>?/gm, '')}`;
        value = input.querySelector('.o-stripe-checkout-description h5')?.innerHTML?.replace(/<[^>]*>?/gm, '');
        fieldType = 'stripe-field';
        mappedName = input.name;
        metadata = {
          fieldOptionName: input?.dataset?.fieldOptionName
        };
        saveMode = 'temporary';
      } else {
        const labels = input.querySelectorAll('.o-form-multiple-choice-field > label');
        const valuesElem = input.querySelectorAll('.o-form-multiple-choice-field > input');
        mappedName = valuesElem[0]?.name;
        value = [...labels].filter((label, index) => valuesElem[index]?.checked).map(label => label.innerHTML).join(', ');
        fieldType = 'multiple-choice';
      }
    }
    if (value) {
      formFieldsData.push({
        label: label || '(No label)',
        value,
        type: fieldType,
        id,
        metadata: {
          ...metadata,
          version: METADATA_VERSION,
          position: index + 1,
          mappedName
        }
      });
    }
  });
  return {
    formFieldsData
  };
};

/**
 * Get the nonce value from the form.
 * @param {HTMLDivElement} form The form.
 * @return {string}
 */
function extractNonceValue(form) {
  const query = `.protection #${form.id || ''}_nonce_field`;
  return form.querySelector(query)?.value;
}

/**
 * Validate the inputs from the form.
 *
 * @param {HTMLDivElement} form The form.
 * @return
 */
function validateInputs(form) {
  let result = true;
  const inputFields = getFormFieldInputs(form);
  for (const field of inputFields) {
    if (field.classList.contains('wp-block-themeisle-blocks-form-input')) {
      const input = field.querySelector('input');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-textarea')) {
      const input = field.querySelector('textarea');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-multiple-choice')) {
      const select = field.querySelector('select');
      if (select?.hasAttribute('required') && !select?.checkValidity()) {
        select?.reportValidity();
        result = false;
        break;
      }

      // Check if it is required and at least one is checked.
      const radios = field.querySelectorAll('.o-form-multiple-choice-field input[type="radio"]');
      if (radios?.length && radios[0]?.hasAttribute('required') && ![...radios].some(radio => radio.checked)) {
        // radios[0]?.setCustomValidity( 'Please select one option.' );
        radios[0]?.reportValidity();
        result = false;
        break;
      }
      const checkboxes = field.querySelectorAll('.o-form-multiple-choice-field input[type="checkbox"]');
      if (checkboxes?.length && checkboxes[0]?.hasAttribute('required') && ![...checkboxes].some(checkbox => checkbox.checked)) {
        checkboxes[0]?.reportValidity();
        result = false;
        break;
      }
    } else if (field.classList.contains('wp-block-themeisle-blocks-form-file')) {
      const input = field.querySelector('input');
      if (!input?.checkValidity()) {
        input?.reportValidity();
        result = false;
        break;
      }
    }
  }
  return result;
}

/**
 * Make a FormData object from the form fields data.
 * Strip binary data into separate keys.
 *
 * @param {import('./types').FormDataStructure} data
 */
const createFormData = data => {
  const formData = new FormData();

  /**
   * For simple data, we will encode them as JSON in 'form_data' key.
   * This gives the flexibility to have the same data shape like in backend without creating complex serializers.
   * For complex data like files, we will use FormData way to handle them.
   */
  data?.payload?.formInputsData?.forEach((field, index) => {
    if ('file' === field.type) {
      const key = 'file__' + field.metadata.position + '_' + index;
      formData.append(key, field.metadata.file);
      data.payload.formInputsData[index].metadata.file = undefined;
      data.payload.formInputsData[index].metadata.data = key; // Create a link with the file which will be used in backend via $_FILES.
    }
  });
  formData.append('form_data', JSON.stringify(data));
  return formData;
};

/**
 * Try to get the current post id from body class.
 * @return {number}
 */
const getCurrentPostId = () => {
  const body = document.querySelector('body');
  const classes = body?.classList?.value?.split(' ');
  const postClass = classes?.find(c => c.includes('postid-') || c.includes('page-id-'));
  if (postClass) {
    const postId = postClass.split('-').pop();
    if (postId) {
      return parseInt(postId);
    }
  }
  return 0;
};

/**
 * Handle the response after the form is submitted.
 *
 * @param {Promise<Response>}                                                                     request
 * @param {DisplayFormMessage}                                                                    displayMsg
 * @param {(response: import('./types.js').IFormResponse, displayMsg:DisplayFormMessage) => void} onSuccess
 * @param {(response: import('./types.js').IFormResponse, displayMsg:DisplayFormMessage) => void} onFail
 * @param {() => void}                                                                            onCleanUp
 */
const handleAfterSubmit = (request, displayMsg, onSuccess, onFail, onCleanUp) => {
  request.then(r => r.json()).then(response => {
    /**
     * @type {import('./types.js').IFormResponse} The response from the server.
     */
    const res = response;
    if ('0' === res?.code || '1' === res?.code || res?.success) {
      onSuccess?.(res, displayMsg);
    } else {
      let errorMsgSlug = '';

      // TODO: Write pattern to display a more useful error message.
      if ('110' === res.code) {
        displayMsg.setMsg(res?.reasons?.join(''), 'error').show();
      } else if ('12' === res.code || '13' === res.code) {
        displayMsg.pullMsg('invalid-file', 'error').show();
      } else if (0 < res?.displayError?.length) {
        errorMsgSlug = res?.displayError;
        displayMsg.setMsg(errorMsgSlug, 'error').show();
      } else {
        displayMsg.setMsg(res?.reasons?.join(''), 'error').show();
      }
      onFail?.(res, displayMsg);

      // eslint-disable-next-line no-console
      console.error(`(${res?.code}) ${res?.reasons?.join('')}`);
    }

    /**
     * Reset the form.
     */

    onCleanUp?.();
  })?.catch(error => {
    console.error(error);
    displayMsg.pullMsg('try-again', 'error').show();
    onFail?.(error, displayMsg);
  });
};
const makeSpinner = anchor => {
  const spinner = document.createElement('span');
  spinner.classList.add('spinner');
  return {
    show: () => {
      anchor.appendChild(spinner);
    },
    hide: () => {
      if (anchor.contains(spinner)) {
        anchor.removeChild(spinner);
      }
    }
  };
};

/**
 * Send the date from the form to the server
 *
 * @param {HTMLDivElement}     form       The element that contains all the inputs
 * @param {HTMLButtonElement}  btn        The submit button
 * @param {DisplayFormMessage} displayMsg The display message utility
 */
const collectAndSendInputFormData = async (form, btn, displayMsg) => {
  const id = form?.id;
  const payload = {};

  // Get the data from the form fields.
  const {
    formFieldsData
  } = await extractFormFields(form);
  const formIsEmpty = 2 > formFieldsData?.length;
  const hasCaptcha = form?.classList?.contains('has-captcha');
  const hasValidToken = id && window.themeisleGutenberg?.tokens?.[id]?.token;
  const spinner = makeSpinner(btn);
  if (formIsEmpty) {
    btn.disabled = false;
    spinner.hide();
    return;
  }
  const nonceFieldValue = extractNonceValue(form);
  const isValidationSuccessful = validateInputs(form);
  if (hasCaptcha && !hasValidToken) {
    const msg = !window.hasOwnProperty('grecaptcha') ? 'captcha-not-loaded' : 'check-captcha';
    displayMsg.pullMsg(msg, 'error').show();
  }
  if (!isValidationSuccessful || hasCaptcha && !hasValidToken) {
    btn.disabled = false;
    btn.removeChild(spinner);
  } else {
    var _form$querySelector$c;
    payload.formInputsData = formFieldsData;
    if (hasValidToken) {
      payload.token = window.themeisleGutenberg?.tokens?.[id].token;
    }

    /**
     * +---------------- Extract the essential data. ----------------+
     */
    if ('' !== form?.dataset?.emailSubject) {
      payload.emailSubject = form?.dataset?.emailSubject;
    }
    if (form?.dataset?.optionName) {
      payload.formOption = form?.dataset?.optionName;
    }
    if (form?.id) {
      payload.formId = form?.id;
    }
    if (nonceFieldValue) {
      payload.nonceValue = nonceFieldValue;
    }
    payload.antiSpamTime = Date.now() - (startTimeAntiBot !== null && startTimeAntiBot !== void 0 ? startTimeAntiBot : Date.now());
    payload.antiSpamHoneyPot = Boolean((_form$querySelector$c = form.querySelector(':scope > .otter-form__container > .protection .o-anti-bot')?.checked) !== null && _form$querySelector$c !== void 0 ? _form$querySelector$c : false);

    /*
    * the URL is no longer relevant if permalink structure is changed, that's why
    * we try to also send the id taken from the body class.
    */
    payload.postUrl = window.location.href;
    payload.postId = getCurrentPostId();

    /**
     * Get the consent
     */
    if (form.classList.contains('can-submit-and-subscribe')) {
      payload.action = 'submit-subscribe';
      payload.consent = form.querySelector('.otter-form-consent input')?.checked || false;
    }
    const formURlEndpoint = (window?.themeisleGutenbergForm?.root || window.location.origin + '/wp-json/') + 'otter/v1/form/frontend';
    const formData = createFormData({
      handler: 'submit',
      payload
    });
    try {
      const request = fetch(formURlEndpoint, {
        method: 'POST',
        headers: {
          'X-WP-Nonce': window?.themeisleGutenbergForm?.nonce,
          'O-Form-Save-Mode': saveMode
        },
        credentials: 'include',
        body: formData
      });
      spinner.show();
      handleAfterSubmit(request, displayMsg, (res, displayMsg) => {
        if (0 < res?.frontend_external_confirmation_url?.length) {
          // Redirect to the external confirmation URL in a new tab.
          window.open(res.frontend_external_confirmation_url, '_blank');
          return;
        }
        const msg = res?.submitMessage ? res.submitMessage : 'Success';
        displayMsg.setMsg(msg).show();
        form?.querySelector('form')?.reset();
        if (0 < res?.redirectLink?.length) {
          form.setAttribute('data-redirect', res.redirectLink);
          setTimeout(() => {
            window.location.href = res.redirectLink;
          }, 1000);
        }
      }, (res, displayMsg) => {}, () => {
        if (window.themeisleGutenberg?.tokens?.[id].reset) {
          window.themeisleGutenberg?.tokens?.[id].reset();
        }
        btn.disabled = false;
        spinner.hide();
      });
    } catch (e) {
      console.error(e);
      displayMsg.pullMsg('try-again', 'error').show();
      btn.disabled = false;
      spinner.hide();
    }
  }
};

/**
 * Render a checkbox for consent
 *
 * @param {HTMLDivElement} form
 */
const renderConsentCheckbox = form => {
  const container = form.querySelector('.otter-form__container');
  const button = form.querySelector('.wp-block-button');
  const inputContainer = document.createElement('div');
  inputContainer.classList.add('otter-form-consent');
  container.insertBefore(inputContainer, button);
  const input = document.createElement('input');
  input.type = 'checkbox';
  input.name = 'o-consent';
  input.id = 'o-consent';
  const label = document.createElement('label');
  label.innerHTML = window?.themeisleGutenbergForm?.messages?.privacy || 'I have read and agree to the privacy statement.';
  label.htmlFor = 'o-consent';
  inputContainer.appendChild(input);
  inputContainer.appendChild(label);
};
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__.domReady)(() => {
  const forms = document.querySelectorAll('.wp-block-themeisle-blocks-form');
  (0,_captcha_js__WEBPACK_IMPORTED_MODULE_0__.addCaptchaOnPage)(forms);
  startTimeAntiBot = Date.now();
  forms.forEach(form => {
    if (form.classList.contains('can-submit-and-subscribe')) {
      renderConsentCheckbox(form);
    }
    const sendBtn = form.querySelector('button');
    const displayMsg = new _message_js__WEBPACK_IMPORTED_MODULE_1__["default"](form);
    if (hasStripeConfirmation()) {
      sendBtn.disabled = true;
      const btnText = sendBtn.innerHTML;
      sendBtn.innerHTML = displayMsg.getMsgBySlug('confirmingSubmission');
      const spinner = makeSpinner(sendBtn);
      spinner.show();
      handleAfterSubmit(confirmRecord(), displayMsg, (res, displayMsg) => {
        const msg = res?.submitMessage ? res.submitMessage : 'Success';
        displayMsg.setMsg(msg).show();
        if (0 < res?.redirectLink?.length) {
          form.setAttribute('data-redirect', res.redirectLink);
          setTimeout(() => {
            window.location.href = res.redirectLink;
          }, 1000);
        }
      }, () => {}, () => {
        sendBtn.disabled = false;
        spinner.hide();
        sendBtn.innerHTML = btnText;
      });
    }
    if (form.querySelector(':scope > form > button[type="submit"]')) {
      form?.addEventListener('submit', event => {
        event.preventDefault();
        if (!sendBtn.disabled) {
          sendBtn.disabled = true;
          collectAndSendInputFormData(form, sendBtn, displayMsg);
        }
      }, false);
    } else {
      // legacy
      sendBtn?.addEventListener('click', event => {
        event.preventDefault();
        if (!sendBtn.disabled) {
          sendBtn.disabled = true;
          collectAndSendInputFormData(form, sendBtn, displayMsg);
        }
      }, false);
    }
  });
  forms.forEach(form => {
    const fields = getFormFieldInputs(form);
    fields.forEach(field => {
      const input = field.querySelector('input');
      if ('file' === input?.type) {
        const {
          maxFilesNumber,
          maxFileSize
        } = input.dataset;
        input.addEventListener('change', event => {
          let isValidationSuccessful = true;
          const {
            files
          } = event.target;
          if (maxFilesNumber && files.length > maxFilesNumber) {
            input.setCustomValidity(window.themeisleGutenbergForm?.messages?.['too-many-files'] + maxFilesNumber);
            isValidationSuccessful = false;
          }
          if (isValidationSuccessful && maxFileSize) {
            for (const file of files) {
              if (file.size > maxFileSize * 1024 * 1024) {
                input.setCustomValidity(window.themeisleGutenbergForm?.messages?.['big-file'] + ' ' + maxFileSize + 'MB.');
                isValidationSuccessful = false;
                break;
              }
            }
          }
          if (!isValidationSuccessful) {
            input.reportValidity();
            input.value = '';
          } else {
            input.setCustomValidity('');
          }
        });
      }
    });
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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