/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/detect-loading.js":
/*!**********************************************!*\
  !*** ./src/blocks/helpers/detect-loading.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   detectLoading: function() { return /* binding */ detectLoading; }
/* harmony export */ });
/**
 * Trigger a function after loading the elements mentioned in the plugins.
 * @param {Function} onLoaded  The callback function.
 * @param {string[]} plugins   The plugins.
 * @param {number}   timeLimit The time limit to do the detection.
 */
const detectLoading = (onLoaded, plugins, timeLimit = 50) => {
  let loaded = 0;
  let trigger = true;
  if (0 === plugins.length) {
    onLoaded?.();
    return;
  }
  const triggerWhenLimitExpire = setTimeout(() => {
    if (trigger) {
      onLoaded?.();
    }
  }, timeLimit * 1000);
  const load = () => {
    loaded += 1;
    if (loaded >= plugins.length && trigger) {
      trigger = false;
      clearTimeout(triggerWhenLimitExpire);
      onLoaded?.();
    }
  };
  plugins.forEach(plugins => {
    switch (plugins) {
      case 'lottie':
        detectLottieLoading(load);
        break;
    }
  });
};
const detectLottieLoading = onLoaded => {
  const lottiePlayers = document.querySelectorAll('lottie-player');
  if (0 === lottiePlayers.length) {
    onLoaded?.();
    return;
  }
  const totalPlayers = lottiePlayers.length;
  const loaded = Array(lottiePlayers.length).fill(0);
  const totalLoaded = () => loaded.reduce((acc, x) => acc + x, 0);
  let trigger = true;
  const events = ['load', 'loop', 'ready', 'complete', 'loop', 'rendered', 'error'];
  lottiePlayers.forEach((player, index) => {
    let checkingTime = 150;
    const checkHTML = () => {
      if (player?.shadowRoot?.querySelector('svg') || player?.shadowRoot?.querySelector('.error')) {
        loaded[index] = 1;
        if (totalLoaded() >= totalPlayers) {
          if (trigger) {
            trigger = false;
            onLoaded?.();
          }
        }
      } else {
        checkingTime += checkingTime * (0.5 + Math.random());
        setTimeout(checkHTML, checkingTime);
      }
    };
    const inter = setTimeout(checkHTML, checkingTime);
    events.forEach(eventName => {
      const listener = () => {
        loaded[index] = 1;
        player.removeEventListener(eventName, listener);
        clearTimeout(inter);
        if (totalLoaded() >= totalPlayers) {
          if (trigger) {
            trigger = false;
            onLoaded?.();
          }
        }
      };
      player.addEventListener(eventName, listener);
    });
  });
};

/***/ }),

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*********************************************!*\
  !*** ./src/blocks/frontend/sticky/index.ts ***!
  \*********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_detect_loading_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/detect-loading.js */ "./src/blocks/helpers/detect-loading.js");
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies.
 */



// Testing purpose
// We can make elem sticky in browser for testing various scenario with different blocks
// @ts-ignore
window.debugSticky = false;

/**
 * Check if the element can be a sticky container.
 *
 * @param parent     The parent element to check.
 * @param cssClasses The CSS classes to check.
 * @return
 */
const isParentContainerValid = (parent, cssClasses) => {
  return cssClasses.some(c => parent.classList.contains(c));
};

/**
 * Get the container for the given element
 * @param elem  The sticky element
 * @param scope
 * @return The parent container. Return `body` as default
 */
const getStickyContainer = (elem, scope) => {
  let parent = elem?.parentElement;
  const sections = [];
  while (parent) {
    if (isParentContainerValid(parent, ['wp-block-themeisle-blocks-advanced-column', 'wp-block-group', 'wp-block-column']) && 'o-sticky-scope-parent' === scope) {
      return parent;
    }
    if (isParentContainerValid(parent, ['wp-block-themeisle-blocks-advanced-columns', 'wp-block-group', 'wp-block-columns'])) {
      if ('o-sticky-scope-section' === scope) {
        return parent;
      } else if ('o-sticky-scope-main-area' === scope) {
        /**
         * For determining the main area, we need to up through the hierarchy to get the root parent.
         */
        sections.push(parent);
      }
    }
    parent = parent.parentElement;
  }
  return 'o-sticky-scope-main-area' === scope && 0 < sections.length ? sections.pop() : document.body;
};
/**
 * Get the configuration options
 * @param elem The sticky element
 * @return The configuration
 */
const getConfigOptions = elem => {
  return Array.from(elem.classList).reduce((config, cssClass) => {
    if (cssClass.includes('o-sticky-pos-bottom')) {
      config.position = 'bottom';
    } else if (cssClass.includes('o-sticky-offset')) {
      var _cssClass$split$pop;
      config.offset = parseInt((_cssClass$split$pop = cssClass.split('-')?.pop()) !== null && _cssClass$split$pop !== void 0 ? _cssClass$split$pop : '40');
    } else if (cssClass.includes('o-sticky-scope')) {
      config.scope = cssClass;
    } else if (cssClass.includes('o-sticky-bhvr')) {
      config.behaviour = cssClass;
    } else if (cssClass.includes('o-sticky-use-mobile')) {
      config.useOnMobile = true;
    } else if (cssClass.includes('o-sticky-float')) {
      config.isFloatMode = true;
    } else if (cssClass.includes('o-sticky-width')) {
      config.width = cssClass.split('-').pop();
    } else if (cssClass.includes('o-sticky-opt-side-offset')) {
      config.sideOffset = cssClass.split('-').pop();
    } else if (cssClass.includes('o-sticky-side-right')) {
      config.side = 'right';
    } else if (cssClass.includes('o-sticky-header-space')) {
      config.fitInHeader = true;
    } else if (cssClass.includes('o-sticky-header-gap')) {
      config.headerGap = cssClass.split('-').pop();
    }
    return config;
  }, {
    position: 'top',
    offset: 40,
    scope: 'o-sticky-scope-main-area',
    behaviour: 'o-sticky-bhvr-keep',
    useOnMobile: false,
    isFloatMode: false,
    width: '100%',
    sideOffset: '20px',
    side: 'left',
    fitInHeader: false,
    headerGap: ''
  });
};
const positions = {
  NONE: 'none',
  TOP: 'top',
  BOTTOM: 'bottom',
  CONSTRAIN_TOP: 'constrain-top',
  CONSTRAIN_BOTTOM: 'constrain-bottom'
};
let stickyId = 0;
class StickyData {
  /**
   * Create the sticky data container for the element.
   *
   * @param selector          The selector for the sticky data container.
   * @param config            The configuration for the sticky data container.
   * @param containerSelector The container selector for the sticky data container.
   * @return
   */
  constructor(selector, config, containerSelector) {
    this.index = stickyId++;
    this.config = config;
    this.selector = selector;
    this.containerSelector = containerSelector;
    this.orderInPage = -1;
    this.isActive = false;
    this.isDormant = true;
    this.positionStatus = positions.NONE;
    this.status = 'inactive';
    this.triggerLimit = 'bottom' === config?.position ? window.innerHeight - this.offset : 0;

    // Get node reference for the element and the container
    this.elem = 'string' === typeof selector ? document.querySelector(selector) : selector;
    this.container = 'string' === typeof containerSelector ? document.querySelector(containerSelector) : containerSelector;

    // Calculate the element position in the page
    this.scrollTop = window.pageYOffset || document.documentElement.scrollTop;
    this.scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
    const {
      top,
      left,
      height,
      width
    } = this.elem.getBoundingClientRect();
    this.width = width;
    this.height = height;
    this.elemTopPositionInPage = top + this.scrollTop;
    this.elemLeftPositionInPage = left + this.scrollLeft;
    this.elemBottomPositionInPage = this.elemTopPositionInPage + height;

    // Calculate the container positions in the page
    this.containerHeight = this.container?.getBoundingClientRect()?.height || 0;
    this.containerTopPosition = this.container ? this.container?.getBoundingClientRect()?.top + this.scrollTop : 0;
    this.containerBottomPosition = this.containerTopPosition + (this.container?.getBoundingClientRect()?.height || 0);

    // The new positions on the screen when the sticky mod is active
    this.offsetY = this.offset;

    // We need to activate the sticky mode early for smooth transition
    this.activationOffset = this.offset + 20;

    /**
     * By making the element sticky, we use 'fixed' positioning which removes the element from the document workflow.
     * We need to put a placeholder with the same height and width as the element, so we can keep layout flow.
     */
    this.placeholder = document.createElement('div');
    this.placeholder.style.height = height + 'px';
    this.placeholder.style.width = width + 'px';

    // Styling
    this.elem.classList.remove('o-sticky-float');
    this.stylingNodeName = `o-sticky-node-${this.index}`;
    this.stylingNode = document.createElement('style');
    document.head.appendChild(this.stylingNode);
    if (config.fitInHeader && 'top' === config.position) {
      document.body.style.marginTop = config.headerGap ? config.headerGap : this.height + 'px';
    }
  }
  recalculatePositions() {
    if (this.config.isFloatMode) {
      return;
    }

    // Calculate the element position in the page
    this.scrollTop = window.pageYOffset || document.documentElement.scrollTop;
    this.scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
    const {
      top,
      left,
      height,
      width
    } = this.elem.getBoundingClientRect();
    this.width = width;
    this.height = height;
    this.elemTopPositionInPage = top + this.scrollTop;
    this.elemLeftPositionInPage = left + this.scrollLeft;
    this.elemBottomPositionInPage = this.elemTopPositionInPage + height;

    // Calculate the container positions in the page
    this.containerHeight = this.container?.getBoundingClientRect()?.height || 0;
    this.containerTopPosition = this.container ? this.container?.getBoundingClientRect()?.top + this.scrollTop : 0;
    this.containerBottomPosition = this.containerTopPosition + (this.container?.getBoundingClientRect()?.height || 0);

    // The new positions on the screen when the sticky mod is active
    this.offsetY = this.offset;

    // We need to activate the sticky mode early for smooth transition
    this.activationOffset = this.offset + 20;

    /**
     * By making the element sticky, we use 'fixed' positioning which removes the element from the document workflow.
     * We need to put a placeholder with the same height and width as the element, so we can keep layout flow.
     */
    // this.placeholder.style.height = height + 'px';
    // this.placeholder.style.width = width + 'px';
  }
  get canBeRun() {
    return this.elemBottomPositionInPage > this.triggerLimit;
  }
  get position() {
    return this.config.position || 'top';
  }
  get offset() {
    return this.config?.offset !== undefined ? this.config.offset : 40;
  }
  get side() {
    var _this$config$side;
    return (_this$config$side = this.config?.side) !== null && _this$config$side !== void 0 ? _this$config$side : 'left';
  }
  get sideOffset() {
    return this.config.sideOffset;
  }
  get displayWidth() {
    return this.config?.isFloatMode ? this.config.width : this.width + 'px';
  }
  set styling(content) {
    this.stylingNode.innerHTML = `
		.${this.stylingNodeName} {
			word-break: break-all;
			${content}
		}
	`;
  }
}
class StickyRunner {
  /**
   * The id will be used to uniquely identify the sticky elements and their order in page.
   */

  constructor() {
    this.orderInPageCounter = 0;
    this.items = [];
  }

  /**
   * Register a new sticky element.
   *
   * @param stickyElem The sticky element to register.
   */
  register(stickyElem) {
    if (!stickyElem.elem) {
      return;
    }
    if (!stickyElem.canBeRun) {
      console.groupCollapsed('Sticky Warning');
      console.warn(stickyElem.elem, 'This element needs to be position lower in the page when using position \'Bottom\'. You can use position \'Top\' as an alternative.');
      console.groupEnd();
      return;
    }
    this.bindCloseButton(stickyElem);
    stickyElem.orderInPage = this.orderInPageCounter;
    this.items.push(stickyElem);
    this.orderInPageCounter++;
  }

  /**
   * Run all the processes.
   */
  run() {
    this.items.forEach(s => s.elem && this.update(s));
    this.items.forEach(s => s.elem && this.align(s));
    this.toggleGlobalClass(0 < this.active.length);
  }

  /**
   * Update the data for the sticky elements.
   *
   * @param sticky The sticky element to update.
   */
  update(sticky) {
    // DEBUG
    // @ts-ignore
    if (window?.debugSticky) {
      if (sticky.container) {
        sticky.container.style.border = '1px dashed black';
      }
      sticky.elem.style.border = '1px dashed red';
    }
    if ('hidden' === sticky.status) {
      return;
    }
    sticky.status = 'inactive';

    /**
     * Check for early activation
     *
     * A dormant sticky element is an element that is going to be activated very soon.
     * This is used for making additional preparation before the other will become active, like calculation the opacity for the fade effect (the element will go transparent before the next element is activated).
     */
    if (this.getCurrentPosition(sticky, this.calculateEarlyActivation(sticky))) {
      sticky.status = 'dormant';
    }

    // Check if the scroll with the activation offset has passed the top of the element
    sticky.positionStatus = this.getCurrentPosition(sticky, 'o-sticky-bhvr-stack' === sticky.config.behaviour ? this.calculateGap(sticky) : 0);
    if (sticky.positionStatus !== positions.NONE) {
      sticky.status = 'active';
    }
  }

  /**
   * Align the sticky element.
   *
   * @param sticky The sticky element to align.
   */
  align(sticky) {
    if (800 > window.innerWidth && !sticky.config.useOnMobile) {
      return;
    }
    const cssStyling = [];
    if ('inactive' === sticky.status) {
      cssStyling.push('position: relative !important');
      cssStyling.push(`z-index: ${(9999 + (sticky.orderInPage || 0)).toString()}`);
    }
    if ('active' === sticky.status) {
      // Make de element sticky
      sticky.elem.classList.add('o-is-sticky');
      if (!sticky.config.isFloatMode) {
        cssStyling.push('transition: transform 2s');
      }
      cssStyling.push(`width: ${sticky.displayWidth} !important`);
      cssStyling.push('position: fixed !important');

      // Make the container height to be fixed
      if (sticky.container && 'BODY' !== sticky.container.tagName) {
        sticky.container.style.height = 0 < sticky.containerHeight ? sticky.containerHeight + 'px' : '';
      }

      // Calculate the gap for stacked elements
      const gap = 'o-sticky-bhvr-stack' === sticky.config.behaviour ? this.calculateGap(sticky) : 0;

      // Get the scroll values
      const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
      const scrollBottom = scrollTop + window.innerHeight;

      /**
       * Align on vertical axis
       */
      if (sticky.config.isFloatMode) {
        let offset = sticky.sideOffset;
        if (sticky.elem.classList.contains('alignfull') && sticky.displayWidth.includes('100%')) {
          offset = '';

          // Execeptions
          if ('neve_body' === document.body.id) {
            offset = offset = '0px';
          }
        }
        if ('' !== offset) {
          if ('left' === sticky.side) {
            cssStyling.push(`left: ${sticky.sideOffset}`);
          } else {
            cssStyling.push(`right: ${sticky.sideOffset}`);
          }
        }
      } else {
        cssStyling.push(`left: ${sticky.elemLeftPositionInPage}px`);
      }

      /**
       * Align on vertical axis.
       */
      switch (sticky.positionStatus) {
        case positions.TOP:
          cssStyling.push('top: 0px');
          cssStyling.push(`transform: translateY(${sticky.offsetY + gap}px)`);
          break;
        case positions.BOTTOM:
          cssStyling.push(`bottom: ${sticky.offsetY + gap}px`);
          cssStyling.push('transform: unset');
          break;
        case positions.CONSTRAIN_TOP:
          cssStyling.push('top: 0px');
          cssStyling.push(`transform: translateY(${sticky.containerBottomPosition - sticky.height - scrollTop}px)`);
          break;
        case positions.CONSTRAIN_BOTTOM:
          cssStyling.push('bottom: 0px');
          cssStyling.push('transform-origin: left bottom');
          cssStyling.push(`transform: translateY(${sticky.containerBottomPosition - scrollBottom}px)`);
          break;
        default:
          console.warn('Unknown position', sticky.positionStatus);
      }
      this.insertPlaceholder(sticky);
      if ('o-sticky-bhvr-hide' === sticky.config.behaviour) {
        cssStyling.push(`opacity: ${(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_1__.easeOutQuad)(this.calculateOpacity(sticky)).toString()}`);
      }
    } else {
      sticky.isActive = false;

      // Clean up the sticky option from the element when is not active
      sticky.elem.classList.remove('o-is-sticky');
      this.removePlaceholder(sticky);
    }
    sticky.styling = cssStyling.join(';\n');
    if (sticky.isActive || sticky.isDormant) {
      sticky.elem.classList.add(sticky.stylingNodeName);
    } else {
      sticky.elem.classList.remove(sticky.stylingNodeName);
    }
  }

  /**
   * Update the left position of the sticky element.
   */
  resize() {
    for (const sticky of this.items) {
      sticky.elemLeftPositionInPage = (sticky.isActive ? sticky.placeholder : sticky.elem).getBoundingClientRect().left + sticky.scrollLeft;
    }
  }

  /**
   * Insert the placeholder.
   *
   * @param sticky The sticky element to insert placeholder.
   */
  insertPlaceholder(sticky) {
    if (!sticky.config.isFloatMode && !sticky.elem?.parentElement?.contains(sticky.placeholder)) {
      sticky.elem?.parentElement?.insertBefore(sticky.placeholder, sticky.elem);
    }
  }

  /**
   * Remove the placeholder.
   *
   * @param sticky The sticky element to remove placeholder.
   */
  removePlaceholder(sticky) {
    if (!sticky.config.isFloatMode && sticky.elem?.parentElement?.contains(sticky.placeholder)) {
      sticky.elem.parentElement.removeChild(sticky.placeholder);
    }
  }

  /**
   * Get the sticky element current position.
   *
   * @param sticky          The sticky element.
   * @param earlyActivation Add on offset to activate early in case of multiple sticky elements.
   * @return
   */
  getCurrentPosition(sticky, earlyActivation = 0) {
    const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
    const scrollBottom = scrollTop + window.innerHeight;
    if ('top' === sticky.position && (scrollTop + sticky.activationOffset + earlyActivation > sticky.elemTopPositionInPage && (!sticky.container || scrollTop + sticky.activationOffset + sticky.height + earlyActivation < sticky.containerBottomPosition) || sticky.config.isFloatMode)) {
      return positions.TOP;
    }
    if ('bottom' === sticky.position && (scrollBottom - sticky.activationOffset - earlyActivation > sticky.elemBottomPositionInPage && (!sticky.container || scrollBottom - sticky.activationOffset - earlyActivation < sticky.containerBottomPosition) || sticky.config.isFloatMode)) {
      return positions.BOTTOM;
    }
    if (sticky.container) {
      if ('top' === sticky.position && (scrollTop + sticky.activationOffset + sticky.height + earlyActivation > sticky.containerBottomPosition || sticky.config.isFloatMode)) {
        return positions.CONSTRAIN_TOP;
      }
      if ('bottom' === sticky.position && (scrollBottom - sticky.activationOffset - earlyActivation >= sticky.containerBottomPosition || sticky.config.isFloatMode)) {
        return positions.CONSTRAIN_BOTTOM;
      }
    }
    return positions.NONE;
  }

  /**
   *
   * Calculate the gap between sticky element and the other that are before him in the same container.
   *
   * @param sticky The sticky element.
   */
  calculateGap(sticky) {
    let gap = 0;
    const blockWidth = sticky.elem.getBoundingClientRect()?.width || 0;
    for (const other of this.active) {
      if (other.orderInPage !== sticky.orderInPage && other.container === sticky.container) {
        if (other.orderInPage < sticky.orderInPage) {
          if ('o-sticky-bhvr-stack' === other.config?.behaviour && blockWidth > Math.abs(sticky.elemLeftPositionInPage - other.elemLeftPositionInPage)) {
            gap += other.offset + other?.elem.getBoundingClientRect()?.height || 0;
          }
        }
      }
    }
    return gap;
  }

  /**
   * Calculate the gap between the sticky element and other before him that are active.
   *
   * @param sticky The sticky element.
   * @return
   */
  calculateEarlyActivation(sticky) {
    let gap = 0;
    for (const other of this.active) {
      if (other.orderInPage !== sticky.orderInPage) {
        if (other.orderInPage < sticky.orderInPage) {
          gap += other.activationOffset + (other.elem?.getBoundingClientRect()?.height || 0);
        }
      }
    }
    return gap;
  }

  /**
   * Calculate the opacity for the fade effect.
   *
   * @param sticky The sticky element to calculate the opacity.
   * @return
   */
  calculateOpacity(sticky) {
    let opacity = 1;
    const blockHeight = sticky.elem.getBoundingClientRect()?.height || 0;
    const blockWidth = sticky.elem.getBoundingClientRect()?.width || 0;
    const currentBottomPosInPage = blockHeight + sticky.config.offset + (window.pageYOffset || document.documentElement.scrollTop);
    for (const other of [...this.dormant, ...this.active]) {
      if (other.orderInPage === sticky.orderInPage) {
        continue;
      }
      if (sticky.container === other.container) {
        if (other.orderInPage > sticky.orderInPage) {
          const otherBlockHeight = other.elem.getBoundingClientRect()?.height || 0;

          // Check if the blocks collide / Check if the block in on top, and not left or right.
          if (blockWidth > Math.abs(sticky.elemLeftPositionInPage - other.elemLeftPositionInPage)) {
            const height = Math.min(blockHeight, otherBlockHeight);
            opacity = Math.min(1, Math.max(0, other.elemTopPositionInPage + height - currentBottomPosInPage) / height);
            return opacity;
          }
        }
      }
    }
    return opacity;
  }
  updateTriggers() {
    this.items.forEach(item => item.recalculatePositions());
  }
  toggleGlobalClass(value) {
    document.body.classList.toggle('o-sticky-is-active', value);
  }
  bindCloseButton(sticky) {
    if (!sticky.config.isFloatMode) {
      return;
    }
    const classes = sticky.elem.querySelectorAll('.o-sticky-close');
    const anchors = sticky.elem.querySelectorAll('a[href=\'#o-sticky-close\']');
    [...Array.from(classes), ...Array.from(anchors)].forEach(elm => {
      elm.addEventListener('click', e => {
        e.preventDefault();
        sticky.status = 'hidden';
        sticky.elem.classList.add('o-is-close');
        if (sticky.config.fitInHeader) {
          document.body.style.marginTop = '';
        }
      });
    });
  }

  /**
   * Get the active sticky elements.
   *
   * @return
   */
  get active() {
    return this.items.filter(stickyElem => 'active' === stickyElem.status);
  }

  /**
   * Get the dormant sticky elements.
   *
   * @return
   */
  get dormant() {
    return this.items.filter(stickyElem => 'dormant' === stickyElem.status);
  }
  get isEmpty() {
    return 0 === this.items.length;
  }
}
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_1__.domReady)(() => {
  const elems = document.querySelectorAll('.o-sticky');
  let styles = `
		.o-is-sticky {
			position: fixed;
			z-index: 9999;
		}
		.o-is-close {
			display: none !important;
		}
	`;
  styles = styles.replace(/(\r\n|\n|\r|\t)/gm, '');
  let hasStyles = false;
  (0,_helpers_detect_loading_js__WEBPACK_IMPORTED_MODULE_0__.detectLoading)(() => {
    const runner = new StickyRunner();
    elems.forEach(elem => {
      try {
        if (!hasStyles) {
          const styleSheet = document.createElement('style');
          styleSheet.innerText = styles;
          styleSheet.id = 'o-stycky-css-gen';
          document.head.appendChild(styleSheet);
          hasStyles = true;
        }
        const config = getConfigOptions(elem);
        const container = getStickyContainer(elem, config.scope);
        runner.register(new StickyData(elem, config, container));
      } catch (error) {
        console.error(error);
      }
    });
    if (!runner.isEmpty) {
      runner.run();
      window.addEventListener('scroll', () => {
        runner.run();
      });
      window.addEventListener('resize', () => {
        runner.resize();
      });

      // create an Observer instance
      const resizeObserver = new ResizeObserver(entries => {
        if (entries?.[0]?.target.clientHeight) {
          runner.updateTriggers();
        }
      });

      // start observing a DOM node
      resizeObserver.observe(document.body);
    }
  }, ['lottie']);
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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