/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*******************************************!*\
  !*** ./src/blocks/frontend/tabs/index.js ***!
  \*******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const tabs = document.querySelectorAll('.wp-block-themeisle-blocks-tabs');
  const hash = window.location.hash.substring(1);
  tabs.forEach(tab => {
    const items = Array.from(tab.querySelectorAll(':scope > .wp-block-themeisle-blocks-tabs__content > .wp-block-themeisle-blocks-tabs-item'));
    const header = document.createElement('div');
    header.classList.add('wp-block-themeisle-blocks-tabs__header');
    tab.prepend(header);
    let openedTab = false;
    const closedTabs = [];
    items.forEach((item, index) => {
      const content = item.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__content');
      content.setAttribute('role', 'tabpanel');
      const headerMobile = item.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__header');
      headerMobile.setAttribute('role', 'tab');
      const headerItem = document.createElement('div');
      headerItem.classList.add('wp-block-themeisle-blocks-tabs__header_item');
      headerItem.tabIndex = 0;
      const tabTitle = headerMobile.cloneNode(true);
      tabTitle.classList.remove('wp-block-themeisle-blocks-tabs-item__header');
      headerItem.appendChild(tabTitle);
      if (item?.id) {
        headerItem.setAttribute('for', item.id);
      }
      if ('true' === item.dataset.defaultOpen && !openedTab) {
        headerItem.classList.add('active');
        content.classList.add('active');
        headerMobile.classList.add('active');
        openedTab = true;
      } else {
        closedTabs.push({
          headerItem,
          content,
          headerMobile
        });
      }
      const toggleTabs = (tabItem, tabIndex) => {
        const tabContent = tabItem.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__content');
        const tabHeaderMobile = tabItem.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__header');
        tabContent.classList.toggle('active', tabIndex === index);
        tabContent.classList.toggle('hidden', tabIndex !== index);
        tabHeaderMobile.classList.toggle('active', tabIndex === index);
        tabHeaderMobile.setAttribute('aria-selected', tabIndex === index);
        const headerItems = Array.from(header.childNodes);
        headerItems.forEach((headerElement, headerIndex) => {
          headerElement.classList.toggle('active', headerIndex === index);
          headerElement.classList.toggle('hidden', headerIndex !== index);
          headerElement.setAttribute('aria-selected', headerIndex === index);
        });
        if (tabIndex === index && tabHeaderMobile) {
          (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.scrollIntoViewIfNeeded)(tabHeaderMobile);
        }
      };
      headerItem.addEventListener('click', () => items.forEach(toggleTabs));
      headerItem.addEventListener('keyup', event => {
        if ('Enter' === event.code) {
          event.preventDefault();
          items.forEach(toggleTabs);
        }
      });
      headerMobile.addEventListener('click', () => items.forEach(toggleTabs));
      headerMobile.addEventListener('keyup', event => {
        if ('Enter' === event.code) {
          event.preventDefault();
          items.forEach(toggleTabs);
        }
      });
      header.appendChild(headerItem);
      if (hash) {
        const targetTab = item.id === hash;
        if (targetTab) {
          toggleTabs(item, index);
          openedTab = true;
          (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.scrollIntoViewIfNeeded)(headerItem);
        }
      }
    });

    /**
     * If no tab is set to open, open the first closed tab.
     */
    if (!openedTab) {
      closedTabs?.[0]?.headerItem.classList.add('active');
      closedTabs?.[0]?.content.classList.add('active');
      closedTabs?.[0]?.headerMobile.classList.add('active');
    }
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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