/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/frontend/live-search/icons.js":
/*!**************************************************!*\
  !*** ./src/blocks/frontend/live-search/icons.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generic: function() { return /* binding */ generic; },
/* harmony export */   page: function() { return /* binding */ page; },
/* harmony export */   post: function() { return /* binding */ post; },
/* harmony export */   product: function() { return /* binding */ product; }
/* harmony export */ });
const page = () => {
  return '<svg width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11 3.75H3V5.25H11V3.75Z" fill="#1E1E1E"/><path d="M3 7H11V8.5H3V7Z" fill="#1E1E1E"/><path d="M9 10.25H3V11.75H9V10.25Z" fill="#1E1E1E"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12 0H2C0.895431 0 0 0.895431 0 2V14C0 15.1046 0.89543 16 2 16H12C13.1046 16 14 15.1046 14 14V2C14 0.895431 13.1046 0 12 0ZM2 1.5H12C12.2761 1.5 12.5 1.72386 12.5 2V14C12.5 14.2761 12.2761 14.5 12 14.5H2C1.72386 14.5 1.5 14.2761 1.5 14V2C1.5 1.72386 1.72386 1.5 2 1.5Z" fill="#1E1E1E"/></svg>';
};
const post = () => {
  return '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M14 1.5H2C1.72386 1.5 1.5 1.72386 1.5 2V14C1.5 14.2761 1.72386 14.5 2 14.5H14C14.2761 14.5 14.5 14.2761 14.5 14V2C14.5 1.72386 14.2761 1.5 14 1.5ZM2 0H14C15.1046 0 16 0.895431 16 2V14C16 15.1046 15.1046 16 14 16H2C0.895431 16 0 15.1046 0 14V2C0 0.895431 0.895431 0 2 0ZM3 5H5V7H3V5ZM5 9H3V11H5V9ZM6 5H13V7H6V5ZM13 9H6V11H13V9Z" fill="#1E1E1E"/></svg>';
};
const product = () => {
  return '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.3126 2.34369L13.6563 4.68737L11.3126 7.03106L8.96894 4.68737L11.3126 2.34369ZM4.96894 2.7412V6.05383H1.65631V2.7412H4.96894ZM13.2505 11.0228V14.3354H9.93789V11.0228H13.2505ZM4.96894 11.0228V14.3354H1.65631V11.0228H4.96894ZM11.3126 0L6.62526 4.67909L11.3126 9.36646L16 4.67909L11.3126 0ZM6.62526 1.08489H0V7.71014H6.62526V1.08489ZM14.9068 9.36646H8.28157V15.9917H14.9068V9.36646ZM6.62526 9.36646H0V15.9917H6.62526V9.36646Z" fill="#1E1E1E"/></svg>';
};
const generic = () => {
  return '<svg width="12" height="16" viewBox="0 0 12 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.5571 3.0619L8.93575 0.440539C8.65456 0.159344 8.27338 0 7.87659 0H1.49971C0.671744 0.00312439 0 0.674868 0 1.50283V14.5003C0 15.3283 0.671744 16 1.49971 16H10.4979C11.3259 16 11.9977 15.3283 11.9977 14.5003V4.12419C11.9977 3.7274 11.8383 3.3431 11.5571 3.0619ZM10.3761 4.00234H7.99844V1.62468L10.3761 4.00234ZM1.49971 14.5003V1.50283H6.49873V4.7522C6.49873 5.16774 6.83304 5.50205 7.24858 5.50205H10.4979V14.5003H1.49971Z" fill="#1E1E1E"/></svg>';
};

/***/ }),

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!**************************************************!*\
  !*** ./src/blocks/frontend/live-search/index.ts ***!
  \**************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./icons */ "./src/blocks/frontend/live-search/icons.js");
/**
 * Internal dependencies
 */


/**
 * Returns an icon component based on the post type.
 * @param type - The post type.
 * @return The icon component.
 */
const getPostIcon = type => {
  switch (type) {
    case 'post':
      return (0,_icons__WEBPACK_IMPORTED_MODULE_1__.post)();
    case 'page':
      return (0,_icons__WEBPACK_IMPORTED_MODULE_1__.page)();
    case 'product':
      return (0,_icons__WEBPACK_IMPORTED_MODULE_1__.product)();
    default:
      return (0,_icons__WEBPACK_IMPORTED_MODULE_1__.generic)();
  }
};

/**
 * Returns a div element containing meta information for a given ResultsEntry object.
 * @param entry - The ResultsEntry object to generate meta information for.
 * @return A div element containing the meta information.
 */
const getMeta = entry => {
  const meta = document.createElement('div');
  switch (entry.type) {
    case 'post':
      {
        meta.innerHTML = `${entry.date} / by ${entry.author}${entry.parent ? ' / ' + entry.parent : ''}`;
        break;
      }
    case 'page':
      {
        var _entry$parent;
        meta.innerHTML = (_entry$parent = entry.parent) !== null && _entry$parent !== void 0 ? _entry$parent : '';
        break;
      }
    case 'product':
      {
        var _entry$price;
        meta.innerHTML = (_entry$price = entry.price) !== null && _entry$price !== void 0 ? _entry$price : '';
        break;
      }
    default:
      return null;
  }
  meta.classList.add('meta');
  return meta;
};
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const CONTAINER_CLASS = 'search-results';
  const {
    nonce,
    restUrl,
    strings
  } = window.liveSearchData;
  const liveSearch = document.querySelectorAll('.o-live-search');
  const loadingIcon = '<svg class="spinner" viewBox="0 0 100 100" width="16" height="16" xmlns="http://www.w3.org/2000/svg" focusable="false" style="width: calc(16px); height: calc(16px);"><circle cx="50" cy="50" r="50" vector-effect="non-scaling-stroke" class="main-circle"></circle><path d="m 50 0 a 50 50 0 0 1 50 50" vector-effect="non-scaling-stroke" class="moving-circle"></path></svg>';

  /**
   * Get the post search from our endpoint.
   *
   * @param search    - The search query string.
   * @param queryData - The query data to send to the REST API.
   * @return A Promise that resolves to the JSON response from the REST API.
   */
  const requestData = async (search, queryData) => {
    const options = {
      method: 'GET',
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json',
        'x-wp-nonce': nonce
      }
    };
    let query = `s=${search}`;
    if (queryData?.cat) {
      query = query + `&cat=${queryData.cat}`;
    }
    const params = queryData?.postTypes.reduce((p, type) => p + `&post_type[]=${type}`, query);

    // use '&' for plain permalinks
    const symbol = 0 < window.liveSearchData.permalinkStructure.length ? '?' : '&';
    const response = await fetch(`${restUrl}${symbol}${params}`, options).catch(error => {
      console.error(error.message);
      return error;
    });
    return response.json();
  };
  const initializeLiveSearch = element => {
    const inputElement = element.querySelector('input.wp-block-search__input');
    if (!inputElement) {
      return;
    }
    inputElement.value = '';
    inputElement.setAttribute('autocomplete', 'off');
    const form = element.querySelector('form');
    const block = element.querySelector('.wp-block-search__inside-wrapper');

    // Create this variable to cache the results
    let resultsContainer;
    const {
      postTypes,
      cat
    } = element.dataset;
    const postTypesArray = postTypes ? JSON.parse(postTypes) : [];
    const queryData = {
      postTypes: postTypesArray,
      cat: cat ? cat : ''
    };
    const inputStyle = getComputedStyle(inputElement);
    const parentStyle = inputElement.parentElement ? getComputedStyle(inputElement.parentElement) : null;

    /**
     * Create result search area.
     */
    const wrap = document.createElement('div');
    wrap.classList.add('container-wrap');
    wrap.style.width = inputElement.offsetWidth + 'px';
    wrap.style.borderRadius = inputStyle.borderRadius;
    wrap.style.backgroundColor = inputStyle.backgroundColor;
    const inputEndPageDistance = document.documentElement.scrollHeight - (inputElement.getBoundingClientRect().bottom + window.scrollY);
    let inputEdgeDistance = inputEndPageDistance;
    if (300 < inputEndPageDistance) {
      wrap.style.top = `calc( ${inputStyle.height} + ${parentStyle?.paddingTop} + ${parentStyle?.paddingBottom} + ${parentStyle?.borderBottomWidth} )`;
    } else {
      wrap.style.bottom = `calc( ${inputStyle.height} + ${parentStyle?.paddingTop} + ${parentStyle?.paddingBottom} + ${parentStyle?.borderBottomWidth} )`;
      inputEdgeDistance = inputElement.getBoundingClientRect().top + window.scrollY;
    }
    wrap.style.maxHeight = Math.min(500, inputEdgeDistance - 20) + 'px';

    /**
     * Request data from the server. Debounce the request to avoid flooding the server.
     */
    const debouncedSearchRequest = (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.debounce)(searchValue => {
      addLoadingIcon(resultsContainer);
      requestData(searchValue, queryData).then(r => {
        removeLoadingIcon(block);
        if (!r.success) {
          console.error(r.message);
          resultsContainer = removeResultsContainer(block, resultsContainer, false);
          return;
        }
        const {
          results
        } = r;
        updateResults(searchValue, block, results, inputElement);
      });
    }, 300);

    // When pressing the Enter key, the default behavior should pe prevented
    // so that the page can get redirected to the highlighted result
    form?.addEventListener('keypress', event => {
      if ('Enter' === event.key && resultsContainer) {
        const highlighted = resultsContainer.querySelector('.highlight > a');
        if (!highlighted) {
          return;
        }
        event.preventDefault();
        window.location = highlighted?.href;
      }
    });

    // Fires when the input value is changed
    inputElement.addEventListener('input', event => {
      const searchValue = event.target?.value;
      if (0 === searchValue.length) {
        resultsContainer = removeResultsContainer(block, resultsContainer, false);
        return;
      }
      if (!block?.querySelector('.container-wrap')) {
        resultsContainer = createResultsContainer(wrap, resultsContainer, block, inputStyle);
      }
      debouncedSearchRequest(searchValue);
    });

    // Open the results container when the input is focused
    inputElement.addEventListener('focusin', () => {
      const searchValue = inputElement.value;
      if (0 !== searchValue.length) {
        resultsContainer = createResultsContainer(wrap, resultsContainer, block, inputStyle);
        if (resultsContainer && !resultsContainer.querySelector('.search-results > :not(.spinner-container):not(.no-results)')) {
          debouncedSearchRequest(inputElement.value);
        }
      }
    });

    // Navigate through the results with the arrow keys.
    inputElement.addEventListener('keydown', event => {
      if (!resultsContainer || !resultsContainer.parentElement) {
        return;
      }
      const keyEvent = event;
      const keys = ['ArrowDown', 'ArrowUp', 'Escape'];
      if (!keys.includes(keyEvent.key)) {
        return;
      }
      if ('Escape' === keyEvent.key) {
        inputElement.blur();
        resultsContainer = removeResultsContainer(block, resultsContainer);
        return;
      }
      const highlighted = resultsContainer?.querySelector('.highlight');
      if (!highlighted) {
        highlight(resultsContainer.children[0], inputElement);
        return;
      }
      const containerDimensions = resultsContainer.parentElement.getBoundingClientRect();
      if ('ArrowDown' === keyEvent.key && highlighted.nextElementSibling) {
        removeHighlight(highlighted);
        highlight(highlighted.nextElementSibling, inputElement);
        const dimensions = highlighted.nextElementSibling.getBoundingClientRect();
        if (dimensions.bottom > containerDimensions.bottom) {
          resultsContainer.parentElement.scrollBy(0, dimensions.height);
        }
        return;
      }
      if ('ArrowUp' === keyEvent.key && highlighted.previousElementSibling) {
        removeHighlight(highlighted);
        highlight(highlighted.previousElementSibling, inputElement);
        const dimensions = highlighted.previousElementSibling.getBoundingClientRect();
        if (dimensions.top < containerDimensions.top) {
          resultsContainer.parentElement.scrollBy(0, -dimensions.height);
        }
      }
    });

    // Detect clicks outside the search block and close the results container
    window.addEventListener('click', event => {
      if (null === event?.target?.closest(`#${inputElement.id}`)) {
        // if the click was outside .wp-block-search__inside-wrapper
        resultsContainer = removeResultsContainer(block, resultsContainer);
      }
    });
  };

  // Initialize the live search for each block on the page when it becomes visible.
  const observer = new IntersectionObserver((entries, observer) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        initializeLiveSearch(entry.target);
        observer.unobserve(entry.target);
      }
    });
  });
  liveSearch.forEach(element => observer.observe(element));

  /**
   * Creates a container for search results and appends it to the provided wrap element.
   * If a resultsContainer is provided and a search_results element is not found in the block, the resultsContainer is appended to the wrap element.
   * Otherwise, a new container is created and appended to the wrap element.
   * @param wrap             - The element to which the results container will be appended.
   * @param resultsContainer - The pre-existing results container to be appended to the wrap element if a search_results element is not found in the block.
   * @param block            - The block element to which the wrap element will be appended.
   * @param inputStyle       - The CSSStyleDeclaration object containing the style properties of the input element.
   * @return The created results container.
   */
  const createResultsContainer = (wrap, resultsContainer, block, inputStyle) => {
    wrap.innerHTML = '';
    if (resultsContainer && !block?.querySelector('.search_results')) {
      wrap.appendChild(resultsContainer);
      block?.appendChild(wrap);
      return resultsContainer;
    }
    const container = document.createElement('div');
    container.classList.add(CONTAINER_CLASS);
    container.setAttribute('role', 'list');
    container.style.fontSize = `max( calc( ${inputStyle.fontSize} - 4px ), 14px )`;
    container.style.color = inputStyle.color;
    addLoadingIcon(container);
    wrap.appendChild(container);
    block?.appendChild(wrap);
    return container;
  };

  /**
   * Removes the results container from the given block element.
   *
   * @param block            - The block element to remove the results container from.
   * @param resultsContainer - The results container to remove.
   * @param cache            - Whether to cache the removed container for later use.
   * @return The removed container if `cache` is `true`, otherwise `null`.
   */
  const removeResultsContainer = (block, resultsContainer, cache = true) => {
    const tmpResultsContainer = block?.querySelector('.container-wrap');
    if (!tmpResultsContainer) {
      return;
    }
    if (cache) {
      const wrap = block?.removeChild(tmpResultsContainer);
      return wrap?.querySelector(`.${CONTAINER_CLASS}`);
    }
    block?.removeChild(tmpResultsContainer);
    return null;
  };

  /**
   * Updates the search results in the specified block with the given search value and results.
   *
   * @param searchValue  - The search value to use for filtering the results.
   * @param block        - The block element to update the results in.
   * @param results      - The array of results to display.
   * @param inputElement - The input element used for the search.
   */
  const updateResults = (searchValue, block, results, inputElement) => {
    const container = block?.querySelector(`.${CONTAINER_CLASS}`);
    if (!container) {
      return;
    }

    // Delete previous content
    container.innerHTML = '';
    if (0 === results.length) {
      const option = document.createElement('div');
      option.classList.add(`${CONTAINER_CLASS}__row`, 'no-results');
      option.innerHTML = strings.noResults + ` "<b>${searchValue}</b>"`;
      container?.appendChild(option);
      return;
    }
    results.forEach((result, index) => {
      const option = getResultElement(result, index, inputElement);
      option.addEventListener('mouseover', () => {
        const highlighted = container.querySelector('.highlight');
        if (highlighted) {
          removeHighlight(highlighted);
        }
        highlight(option, inputElement);
      });
      container?.appendChild(option);
    });
  };

  /**
   * Adds a loading icon to the specified results container.
   *
   * @param container - The container to add the loading icon to.
   */
  const addLoadingIcon = container => {
    if (!container || container.querySelector('.spinner-container')) {
      return;
    }
    const loading = document.createElement('div');
    loading.classList.add(`${CONTAINER_CLASS}__row`, 'spinner-container');
    loading.innerHTML = loadingIcon;
    container.innerHTML = '';
    container?.appendChild(loading);
  };

  /**
   * Removes the loading icon from the specified block element.
   *
   * @param block - The block element to remove the loading icon from.
   */
  const removeLoadingIcon = block => {
    const container = block?.querySelector(`.${CONTAINER_CLASS}`);
    if (!container) {
      return;
    }
    const loading = container.querySelector('.spinner-container');
    if (loading) {
      container.removeChild(loading);
    }
  };

  /**
   * Highlights the given element with a background color based on the input element's background color.
   * @param element - The element to highlight.
   * @param input   - The input element to get the background color from.
   */
  const highlight = (element, input) => {
    // Determine the background color for a light/dark theme
    const inputBackground = getComputedStyle(input).backgroundColor;
    const [,, lightness] = (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.rgb2hsl)(inputBackground);
    const isDark = 50 >= lightness;
    element.classList.add('highlight');
    element.style.backgroundColor = isDark ? 'rgba(255, 255, 255, 0.12)' : 'rgba(49, 50, 51, 0.12)';
  };

  /**
   * Removes the 'highlight' class and 'style' attribute from the given element.
   * @param element - The element to remove the 'highlight' class and 'style' attribute from.
   */
  const removeHighlight = element => {
    element.classList.remove('highlight');
    element.removeAttribute('style');
  };

  /**
   * Returns a DOM element representing a search result.
   * @param entry        - The search result entry.
   * @param index        - The index of the search result.
   * @param inputElement - The input element used for the search.
   * @return A DOM element representing the search result.
   */
  const getResultElement = (entry, index, inputElement) => {
    const optionWrap = document.createElement('div');
    const option = document.createElement('a');
    optionWrap.classList.add(`${CONTAINER_CLASS}__row`, `is-type-${entry.type}`, `is-id-${entry.id}`);
    optionWrap.setAttribute('role', 'option');
    option.href = entry.link;
    const icon = document.createElement('div');
    icon.classList.add(`${CONTAINER_CLASS}__row-left`);
    if (entry?.featured_image) {
      const img = document.createElement('img');
      img.src = entry.featured_image;
      img.alt = entry.title;
      img.title = entry.title;
      icon.appendChild(img);
    } else {
      icon.innerHTML = getPostIcon(entry.type);
    }
    const data = document.createElement('div');
    data.classList.add(`${CONTAINER_CLASS}__row-right`);
    const title = document.createElement('p');
    title.classList.add('post-title');
    title.setAttribute('title', entry.title);
    title.innerText = 0 < entry.title.length ? entry.title : strings.noTitle;
    data.appendChild(title);
    const meta = getMeta(entry);
    if (meta) {
      const inputFontSize = getComputedStyle(inputElement).fontSize;
      meta.style.fontSize = `max( calc( ${inputFontSize} - 6px ), 12px )`;
      data.appendChild(meta);
    }
    option.appendChild(icon);
    option.appendChild(data);
    optionWrap.appendChild(option);
    return optionWrap;
  };
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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