/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*********************************************!*\
  !*** ./src/blocks/frontend/slider/index.js ***!
  \*********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

const leftLabel = window.themeisleGutenbergSlider.isRTL ? window.themeisleGutenbergSlider.next : window.themeisleGutenbergSlider.prev;
const rightLabel = window.themeisleGutenbergSlider.isRTL ? window.themeisleGutenbergSlider.prev : window.themeisleGutenbergSlider.next;
const SliderArrows = '<div class="glide__arrows" data-glide-el="controls"><button class="glide__arrow glide__arrow--left" data-glide-dir="<" aria-label="' + leftLabel + '"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewbox="0 0 100 100" role="img" aria-hidden="true"><path d="M 10,50 L 60,100 L 70,90 L 30,50  L 70,10 L 60,0 Z"></path></svg></button><button class="glide__arrow glide__arrow--right" data-glide-dir="&gt;" aria-label="' + rightLabel + '"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewbox="0 0 100 100" role="img" aria-hidden="true"><path d="M 10,50 L 60,100 L 70,90 L 30,50  L 70,10 L 60,0 Z"></path></svg></button></div>';
const init = () => {
  const sliders = document.querySelectorAll('.wp-block-themeisle-blocks-slider');
  const options = {
    root: null,
    rootMargin: '0px',
    threshold: [0.0]
  };
  sliders.forEach(slider => {
    const track = slider.querySelector('.glide__slides');
    if (!Boolean(track.childElementCount)) {
      return false;
    }
    Object.keys(options).map(option => options[option] = Number(options[option]));
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting && 0 <= entry.intersectionRect.height) {
          const autoplay = 'false' === slider.dataset.autoplay ? false : 'true' === slider.dataset.autoplay ? 2000 : slider.dataset.autoplay;
          const hideArrows = 'true' === slider.dataset.hideArrows;
          if (!hideArrows) {
            const el = document.createElement('div');
            el.innerHTML = SliderArrows;
            slider.appendChild(el.firstElementChild);
          }
          new window.Glide(slider, {
            ...slider.dataset,
            type: 'carousel',
            keyboard: true,
            autoplay,
            hoverpause: true,
            animationTimingFunc: slider.dataset?.transition || 'ease',
            direction: window.themeisleGutenbergSlider.isRTL ? 'rtl' : 'ltr',
            breakpoints: {
              800: {
                perView: 1,
                peek: 0,
                gap: 0
              }
            }
          }).mount();
          if (track) {
            track.style.height = slider.dataset.height;
          }
          observer.unobserve(slider);
        }
      }, options);
    });
    observer.observe(slider);
  });
};
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const t = setInterval(() => {
    if (window?.Glide !== undefined) {
      clearInterval(t);
      init();
    }
  }, 500);
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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