/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*****************************************************!*\
  !*** ./src/blocks/frontend/circle-counter/index.js ***!
  \*****************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const progressBars = document.querySelectorAll('.wp-block-themeisle-blocks-circle-counter');
  Array.from(progressBars).forEach(progressBar => {
    /*
    	Dataset
    */
    const duration = progressBar.dataset.duration * 1000;
    const {
      percentage
    } = progressBar.dataset;
    const size = progressBar.dataset.height;
    const {
      strokeWidth
    } = progressBar.dataset;
    const fontSize = progressBar.dataset.fontSizePercent;
    const {
      backgroundStroke
    } = progressBar.dataset;
    const {
      progressStroke
    } = progressBar.dataset;
    const center = size / 2;
    const radius = center - strokeWidth / 2;
    const circumference = 2 * Math.PI * radius;
    if (0 > radius) {
      return;
    }

    /*
    	Create SVG
    */
    const parent = progressBar.querySelector('.wp-block-themeisle-blocks-circle-counter__bar');
    parent.style.height = size + 'px';
    parent.style.width = size + 'px';
    const container = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    container.classList.add('wp-block-themeisle-blocks-circle-counter-container');
    container.setAttribute('height', size);
    container.setAttribute('width', size);
    const backgroundCircle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
    backgroundCircle.classList.add('wp-block-themeisle-blocks-circle-counter-bg');
    backgroundCircle.setAttribute('cx', center);
    backgroundCircle.setAttribute('cy', center);
    backgroundCircle.setAttribute('r', radius);
    backgroundCircle.style.stroke = backgroundStroke;
    backgroundCircle.style.strokeWidth = strokeWidth;
    const progressCircle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
    progressCircle.classList.add('wp-block-themeisle-blocks-circle-counter-progress');
    progressCircle.setAttribute('cx', center);
    progressCircle.setAttribute('cy', center);
    progressCircle.setAttribute('r', radius);
    progressCircle.style.stroke = progressStroke;
    progressCircle.style.strokeWidth = strokeWidth;
    progressCircle.style.strokeDasharray = circumference;
    const value = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    value.classList.add('wp-block-themeisle-blocks-circle-counter-text');
    value.setAttribute('x', '50%');
    value.setAttribute('y', '50%');
    value.style.fill = progressStroke;
    value.style.fontSize = fontSize + 'px';

    /*
    	Add to page
    */
    container.appendChild(backgroundCircle);
    container.appendChild(progressCircle);
    container.appendChild(value);
    parent.appendChild(container);

    /*
    	Add animation
    */
    if (!duration) {
      progressCircle.style.strokeDashoffset = (100 - percentage) / 100 * circumference;
      value.innerHTML = percentage + '%';
    } else {
      progressCircle.style.strokeDashoffset = circumference;
      value.innerText = '0%';
      const options = {
        root: null,
        rootMargin: '0px',
        threshold: [0.6]
      };
      let interval;
      const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            if (0 >= entry.intersectionRect.height) {
              progressCircle.style.strokeDashoffset = (100 - percentage) / 100 * circumference;
              value.innerHTML = percentage + '%';
              return;
            }
            if (interval) {
              clearInterval(interval);
            }
            const step = 20; // for a more smother animation, decrease the value
            const totalPercent = parseInt(percentage);
            const percentPerTime = (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.range)(0, duration, step).map(x => (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.linear)(x / duration) * totalPercent).reverse();
            interval = setInterval(() => {
              const valuePercent = Math.round(percentPerTime.pop());
              progressCircle.style.strokeDashoffset = (100 - valuePercent) / 100 * circumference;
              value.innerHTML = valuePercent + '%';
              if (!percentPerTime.length) {
                observer.unobserve(progressBar);
                clearInterval(interval);
              }
            }, step);
          }
        });
      }, options);
      setTimeout(() => observer.observe(progressBar), 100);
    }
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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