/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!**************************************************!*\
  !*** ./src/blocks/frontend/leaflet-map/index.js ***!
  \**************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

const createPopupContent = markerProps => {
  /**
   * The Popup can take a string or a HTMLElement
   * For simple use, a string is enough.
   * But we need interaction, in our case, to remove the marker.
   * So, creating an HTMLElement will allow us to bind function very easily.
   */
  const container = document.createElement('div');
  const title = document.createElement('h6');
  const content = document.createElement('div');
  const description = document.createElement('p');
  title.innerHTML = markerProps.title;
  description.innerHTML = markerProps.description;
  container.classList.add('wp-block-themeisle-blocks-leaflet-map-overview');
  content.classList.add('wp-block-themeisle-blocks-leaflet-map-overview-content');
  title.classList.add('wp-block-themeisle-blocks-leaflet-map-overview-title');
  container.appendChild(title);
  container.appendChild(content);
  content.appendChild(description);
  return container;
};
const createMarker = markerProps => {
  const markerMap = window.L.marker([markerProps.latitude, markerProps.longitude]);
  markerMap.bindTooltip(markerProps.title, {
    direction: 'auto'
  });
  markerMap.bindPopup(createPopupContent(markerProps));
  return markerMap;
};
const createLeafletMap = (container, attributes) => {
  if (!container) {
    console.warn(`The placeholder for the leaflet map block with id: ${container} does not exist!`);
    return;
  }

  // Add the height of the map first
  container.classList.add('wp-block-themeisle-leaflet-blocks-map');

  // Create the map
  const map = window.L.map(container, {
    zoomControl: attributes.zoomControl,
    dragging: attributes.draggable,
    gestureHandling: attributes.draggable,
    gestureHandlingOptions: {
      text: {
        touch: 'Use two fingers to move the map',
        scroll: 'Use ctrl + scroll to zoom the map',
        scrollMac: 'Use \u2318 + scroll to zoom the map'
      }
    }
  });
  window.L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>',
    subdomains: ['a', 'b', 'c']
  }).addTo(map);

  // Set the view
  map.setView([attributes.latitude, attributes.longitude], attributes.zoom || 15);

  // Add the markers
  attributes.markers.map(markerProps => createMarker(markerProps)).forEach(marker => {
    map.addLayer(marker);
  });
  const resizeObserver = new ResizeObserver(() => {
    map.invalidateSize();
  });
  resizeObserver.observe(container);
};
(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  if (!window.themeisleLeafletMaps) {
    console.warn('The leaflet map attributes did not load on the page!');
    return;
  }
  document.querySelectorAll('.wp-block-themeisle-blocks-leaflet-map').forEach(mapElem => {
    mapElem.style.margin = '20px 0';
    mapElem.style.backgroundColor = '#ccc';
  });
  const checker = setInterval(() => {
    if (!window.L) {
      console.warn('The leaflet script did not load on the page! Waiting for loading.');
      return;
    }
    clearInterval(checker);
    const idAttrMapping = Array.from(window.themeisleLeafletMaps).reduce((acc, x) => {
      acc[x.container] = x.attributes;
      return acc;
    }, {});
    document.querySelectorAll('.wp-block-themeisle-blocks-leaflet-map').forEach(mapElem => {
      if (idAttrMapping[mapElem.id] !== undefined) {
        createLeafletMap(mapElem, idAttrMapping[mapElem.id]);
        mapElem.style.removeProperty('margin');
        mapElem.style.removeProperty('background-color');
      }
    });
  }, 2_000);
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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