/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/css/editor.js":
/*!***************************!*\
  !*** ./src/css/editor.js ***!
  \***************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
/**
 * WordPress dependencies.
 */





let inputTimeout = null;
window.otterCSSLintIgnored = [];
const CSSEditor = ({
  attributes,
  setAttributes,
  clientId
}) => {
  const editorRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
  const [errors, setErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [editorValue, setEditorValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  const getClassName = () => {
    // remove the ticss class if custom CSS is empty.
    if (editorValue?.replace(/\s+/g, '') === 'selector {\n}\n'.replace(/\s+/g, '')) {
      return attributes.className ? attributes.className.split(' ').filter(className => !className.includes('ticss-')).join(' ') : attributes.className;
    }
    const uniqueId = clientId.substring(0, 8);
    const {
      className
    } = attributes;
    return className ? !className.includes('ticss-') ? [...className.trim().split(' '), `ticss-${uniqueId}`].join(' ') : className : `ticss-${uniqueId}`;
  };
  const checkInput = (editor, ignoreErrors = false) => {
    let editorErrors = editor?.state?.lint?.marked?.filter(({
      __annotation
    }) => 'error' === __annotation?.severity)?.map(({
      __annotation
    }) => __annotation?.message);
    if (ignoreErrors && 0 < editorErrors?.length) {
      window.otterCSSLintIgnored = editorErrors;
    }
    editorErrors = editorErrors?.filter(error => !window.otterCSSLintIgnored.includes(error));
    setErrors(editorErrors);
    if (!ignoreErrors && 0 < editorErrors?.length) {
      return;
    }
    setEditorValue(editor?.getValue());
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const classes = attributes.customCSS && attributes.className?.includes('ticss-') ? attributes.className.split(' ').find(i => i.includes('ticss')) : null;
    let initialValue = 'selector {\n}\n';
    if (attributes.customCSS) {
      const regex = new RegExp('.' + classes, 'g');
      initialValue = attributes.customCSS.replace(regex, 'selector');
    }
    editorRef.current = wp.CodeMirror(document.getElementById('o-css-editor'), {
      value: initialValue,
      autoCloseBrackets: true,
      continueComments: true,
      lineNumbers: true,
      lineWrapping: true,
      matchBrackets: true,
      lint: true,
      gutters: ['CodeMirror-lint-markers'],
      styleActiveLine: true,
      styleActiveSelected: true,
      mode: 'css',
      extraKeys: {
        'Ctrl-Space': 'autocomplete',
        'Alt-F': 'findPersistent',
        'Cmd-F': 'findPersistent'
      }
    });
    const onChange = () => {
      window?.oTrk?.add({
        feature: 'custom-css',
        featureComponent: 'used'
      });
      clearTimeout(inputTimeout);
      inputTimeout = setTimeout(() => {
        checkInput(editorRef.current);
      }, 500);
    };
    editorRef.current.on('change', onChange);
    return () => {
      editorRef.current.off('change', onChange);
    };
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const regex = new RegExp('selector', 'g');
    const className = getClassName();
    const customClass = className?.split(' ').find(i => i.includes('ticss'));
    const customCSS = customClass ? editorValue?.replace(regex, `.${customClass}`) : editorValue;
    if ('selector {\n}\n'.replace(/\s+/g, '') === customCSS?.replace(/\s+/g, '')) {
      setAttributes({
        customCSS: undefined,
        className
      });
    } else if (customCSS) {
      setAttributes({
        customCSS,
        hasCustomCSS: true,
        className
      });
    }
  }, [editorValue]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [!Boolean(window?.blocksCSS?.hasOtter) && !!(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/edit-site') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Notice, {
      status: "info",
      isDismissible: false,
      children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Blocks CSS is not fully compatible with the Site Editor. We recommend installing Otter for Site Builder compatibility.', "otter-blocks"), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        variant: "primary",
        href: window?.blocksCSS?.installOtter,
        target: "_blank",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Install Otter', "otter-blocks")
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Add your custom CSS.', "otter-blocks")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      id: "o-css-editor",
      className: "o-css-editor"
    }), 0 < errors?.length && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "o-css-errors",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Notice, {
        status: "error",
        isDismissible: false,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Attention needed! We found following errors with your code:', "otter-blocks")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("pre", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          children: errors.map((e, i) => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
              children: e
            }, i);
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        variant: "secondary",
        onClick: () => checkInput(editorRef.current, true),
        style: {
          width: 'max-content',
          marginBottom: '20px'
        },
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Override', "otter-blocks")
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
      children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Use', "otter-blocks"), " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("code", {
        children: "selector"
      }), " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('to target block wrapper.', "otter-blocks")]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Example:', "otter-blocks")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("pre", {
      className: "o-css-editor-help",
      children: 'selector {\n    background: #000;\n}\n\nselector img {\n    border-radius: 100%;\n}'
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can also use other CSS syntax here, such as media queries.', "otter-blocks")
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.memo)(CSSEditor));

/***/ }),

/***/ "./src/css/editor.scss":
/*!*****************************!*\
  !*** ./src/css/editor.scss ***!
  \*****************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/css/inject-css.js":
/*!*******************************!*\
  !*** ./src/css/inject-css.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   onDeselect: function() { return /* binding */ onDeselect; }
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/**
 * WordPress dependencies.
 */



let isInitialCall = true;
const addStyle = style => {
  const iFrame = window.parent.document.querySelector('iframe[name="editor-canvas"]')?.contentWindow;
  if (isInitialCall && iFrame) {
    iFrame.addEventListener('DOMContentLoaded', function () {
      setTimeout(() => {
        // A small delay for the iFrame to properly initialize.
        addStyle(style);
      }, 500);
    });
    isInitialCall = false;
    return;
  }
  const anchor = iFrame?.document.head || document.head;
  let element = anchor.querySelector('#o-css-editor-styles');
  if (null === element) {
    element = document.createElement('style');
    element.setAttribute('type', 'text/css');
    element.setAttribute('id', 'o-css-editor-styles');
    anchor?.appendChild(element);
  }
  if (element.textContent === style) {
    return null;
  }
  return element.textContent = style;
};

/*
	This function will get the `customCss` value from all the blocks and its children
*/
const getCustomCssFromBlocks = (blocks, reusableBlocks) => {
  if (!blocks) {
    return '';
  }

  // Return the children of the block. The result is an array deeply nested that match the structure of the block in the editor.
  const getChildrenFromBlock = block => {
    const children = [];
    if ('core/block' === block.name && null !== reusableBlocks) {
      const reBlocks = reusableBlocks.find(i => block.attributes.ref === i.id);
      if (reBlocks && reBlocks.content) {
        const content = reBlocks.content.hasOwnProperty('raw') ? reBlocks.content.raw : reBlocks.content;
        children.push((0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.parse)(content).map(child => [child, getChildrenFromBlock(child)]));
      }
    }
    if (undefined !== block.innerBlocks && 0 < block.innerBlocks.length) {
      children.push(block.innerBlocks.map(child => [child, getChildrenFromBlock(child)]));
    }
    return children;
  };

  // Get all the blocks and their children
  const allBlocks = blocks.map(block => {
    return [block, getChildrenFromBlock(block)];
  });

  // Transform the deply nested array in a simple one and then get the `customCss` value where it is the case
  const extractCustomCss = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.flattenDeep)(allBlocks).map(block => {
    if (block.attributes && block.attributes.hasCustomCSS) {
      if (block.attributes.customCSS && null !== block.attributes.customCSS) {
        return block.attributes.customCSS + '\n';
      }
    }
    return '';
  });

  // Build the global style
  const style = extractCustomCss.reduce((acc, localStyle) => acc + localStyle, '');
  return style;
};
let previousBlocks = [];
let previewView = false;
const onDeselect = () => {
  const {
    getBlocks
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core/block-editor');
  const blocks = getBlocks();
  const reusableBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core').getEntityRecords('postType', 'wp_block', {
    context: 'view'
  });
  const blocksStyle = getCustomCssFromBlocks(blocks, reusableBlocks);
  addStyle(blocksStyle);
};

// Create a debounced version of the subscription callback
const debouncedSubscription = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(() => {
  const {
    getBlocks,
    isTyping
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core/block-editor');
  const isTypingNow = isTyping();
  if (isTypingNow) {
    return;
  }
  const __experimentalGetPreviewDeviceType = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core/edit-post') ? (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core/edit-post').__experimentalGetPreviewDeviceType() : false;
  const blocks = getBlocks();
  const reusableBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.select)('core').getEntityRecords('postType', 'wp_block', {
    context: 'view'
  });
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)(previousBlocks, blocks) || previewView !== __experimentalGetPreviewDeviceType) {
    const blocksStyle = getCustomCssFromBlocks(blocks, reusableBlocks);
    if (blocksStyle) {
      if (previewView !== __experimentalGetPreviewDeviceType && 'Desktop' === previewView) {
        setTimeout(() => {
          addStyle(blocksStyle);
        }, 500);
      } else {
        addStyle(blocksStyle);
      }
    }
    previousBlocks = blocks;
    previewView = __experimentalGetPreviewDeviceType;
  }
}, 300); // Adjust debounce time as necessary

// Use the debounced function in your subscribe call
(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.subscribe)(debouncedSubscription);

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ (function(module) {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ (function(module) {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/compose":
/*!*********************************!*\
  !*** external ["wp","compose"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["compose"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/hooks":
/*!*******************************!*\
  !*** external ["wp","hooks"] ***!
  \*******************************/
/***/ (function(module) {

module.exports = window["wp"]["hooks"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ (function(module) {

module.exports = window["lodash"];

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ (function(module) {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!**************************!*\
  !*** ./src/css/index.js ***!
  \**************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./editor.scss */ "./src/css/editor.scss");
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./editor.js */ "./src/css/editor.js");
/* harmony import */ var _inject_css_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./inject-css.js */ "./src/css/inject-css.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
/**
 * WordPress dependencies.
 */










/**
 * Internal dependencies.
 */



/* eslint-disable no-duplicate-imports */



const addAttribute = settings => {
  if ((0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.hasBlockSupport)(settings, 'customClassName', true)) {
    settings.attributes = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.assign)(settings.attributes, {
      hasCustomCSS: {
        type: 'boolean',
        default: false
      },
      customCSS: {
        type: 'string'
      }
    });
  }
  return settings;
};
const Edit = ({
  clientId,
  setAttributes,
  attributes
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Custom CSS', "otter-blocks"),
    initialOpen: false,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_editor_js__WEBPACK_IMPORTED_MODULE_10__["default"], {
      clientId: clientId,
      setAttributes: setAttributes,
      attributes: attributes
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "o-fp-wrap",
      children: [(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('otter.feedback', '', 'custom-css'), (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('otter.poweredBy', '')]
    })]
  });
};
const BlockCSSWrapper = (el, props) => {
  if ((0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.hasBlockSupport)(props.name, 'customClassName', true)) {
    var _select$get;
    const showAsDefault = Boolean((_select$get = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.select)('core/preferences')?.get('themeisle/otter-blocks', 'show-custom-css')) !== null && _select$get !== void 0 ? _select$get : true);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
      children: [el, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__.__experimentalToolsPanelItem, {
        hasValue: () => Boolean(props.attributes?.hasCustomCSS),
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Custom CSS', "otter-blocks"),
        onDeselect: () => {
          props.setAttributes({
            hasCustomCSS: false,
            customCSS: undefined
          });
          (0,_inject_css_js__WEBPACK_IMPORTED_MODULE_11__.onDeselect)();
        },
        isShownByDefault: showAsDefault,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(Edit, {
          ...props
        })
      })]
    });
  }
  return el;
};
const withInspectorControls = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__.createHigherOrderComponent)(BlockEdit => {
  return props => {
    const hasCustomClassName = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.hasBlockSupport)(props.name, 'customClassName', true);
    if (hasCustomClassName && props.isSelected) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(BlockEdit, {
          ...props
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.InspectorControls, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(Edit, {
            ...props
          })
        })]
      });
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(BlockEdit, {
      ...props
    });
  };
}, 'withInspectorControl');
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.addFilter)('blocks.registerBlockType', 'themeisle-custom-css/attribute', addAttribute);
if (Boolean(window?.blocksCSS?.hasOtter)) {
  (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.addFilter)('otter.blockTools', 'themeisle-custom-css/with-inspector-controls', BlockCSSWrapper, 2);
} else {
  (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.addFilter)('editor.BlockEdit', 'themeisle-custom-css/with-inspector-controls', withInspectorControls);
}
}();
/******/ })()
;
//# sourceMappingURL=index.js.map