/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!**********************************************!*\
  !*** ./src/blocks/frontend/masonry/index.js ***!
  \**********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const galleries = document.getElementsByClassName('otter-masonry');
  const options = {
    root: null,
    rootMargin: '0px',
    threshold: [0.0]
  };
  Array.from(galleries).forEach(gallery => {
    const checker = setInterval(() => {
      const container = gallery.querySelector('.wp-block-gallery');
      if (window?.Macy) {
        const targetContainer = gallery.querySelector('.blocks-gallery-grid') || container;
        const observer = new IntersectionObserver(entries => {
          entries.forEach(entry => {
            if (entry.isIntersecting && 0 <= entry.intersectionRect.height) {
              const pattern = /columns-(\d)/;
              const margin = gallery.dataset.margin !== undefined ? Number(gallery.dataset.margin) : 10;
              let columns = Array.from(container.classList).find(className => {
                const res = pattern.exec(className);
                return null !== res;
              });
              columns = pattern.exec(columns);
              columns = columns ? Number(columns[1]) : 3;
              container.removeAttribute('class');
              window.Macy({
                container: targetContainer,
                trueOrder: false,
                waitForImages: false,
                margin,
                columns,
                breakAt: {
                  1200: Math.min(columns, 4),
                  840: Math.min(columns, 3),
                  740: Math.min(columns, 2),
                  640: Math.min(columns, 1)
                }
              });
              observer.unobserve(targetContainer);
            }
          });
        }, options);
        observer.observe(targetContainer);
        clearInterval(checker);
      }
    }, 1_500);
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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