/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!************************************************!*\
  !*** ./src/blocks/frontend/countdown/index.ts ***!
  \************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */


/**
 * Simple base64 encoding. This is used to hash the url to prevent reusable blocks from accessing and changing the same data --> making them unique per page.
 * @param str The string.
 * @return
 */
const toBase64 = str => {
  return window.btoa(unescape(encodeURIComponent(str)));
};

// Time constants
const _MS_PER_SECONDS = 1000;
const _MS_PER_MINUTES = _MS_PER_SECONDS * 60;
const _MS_PER_HOURS = _MS_PER_MINUTES * 60;
const _MS_PER_DAY = _MS_PER_HOURS * 24;

// Local storage locations for saving information about user interaction with the page.
const LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE = `o-countdown-last-visit-${toBase64(window.location.pathname)}-`;
const TIMER_VALUE_FROM_LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE = `o-countdown-last-visit-time-${toBase64(window.location.pathname)}-`;
const TIMER_TIMEZONE_FROM_LAST_VISIT_ON_SITE = `o-countdown-last-visit-timezone-${toBase64(window.location.pathname)}-`;
let indexGenerator = 0;
class CountdownData {
  constructor(elem) {
    var _ref, _localStorage$getItem, _localStorage$getItem2, _window$themeisleGute, _window$themeisleGute2, _window$themeisleGute3;
    this.id = indexGenerator++;
    this.elem = elem;
    this.elem.classList.add('ready');
    const {
      date,
      bhv,
      mode,
      timer,
      redirectLink,
      intvEnd,
      intvStart,
      onEndAction
    } = elem.dataset;

    // Extract the data.
    this.rawData = date !== null && date !== void 0 ? date : '';
    this.behavior = (_ref = bhv) !== null && _ref !== void 0 ? _ref : 'default';
    this.mode = mode;
    this.timer = timer !== null && timer !== void 0 ? timer : '0';
    this.redirectLink = redirectLink;
    this.startInterval = intvStart;
    this.endInterval = intvEnd;
    this.hideTime = 0;
    this.onEndAction = onEndAction;

    /**
     * Add checks that helps the control logic.
     */
    this.checks = {
      'show': false // Used by Interval mode. Once the countdown is shown, we no longer need to check the display condition.
    };
    this.currentTime = Date.now();

    /**
     * Get the references to value and label HTML for each time component.
     */
    this.components = {};
    ['second', 'minute', 'hour', 'day'].forEach(componentName => {
      const _elem = elem.querySelector(`div[name=${componentName}]`);
      if (_elem) {
        const labelElem = _elem.querySelector('.otter-countdown__label');
        const valueElem = _elem.querySelector('.otter-countdown__value');
        this.components[componentName] = {
          label: labelElem !== null && labelElem !== void 0 ? labelElem : undefined,
          value: valueElem !== null && valueElem !== void 0 ? valueElem : undefined
        };
      }
    });

    // Add the default End events callbacks.
    this.onEndEvents = [() => this.activateBehavior(), () => this.activateActions()];

    /**
     * Modes
     * - Evergreen: acts like a timer that reset when it is finished.
     * - Interval: display only in the given interval.
     * - Default: display until the given date.
     */
    switch (this.mode) {
      case 'timer':
        // Record when the user was last time on this page.
        const lastVisitTimeRecord = (_localStorage$getItem = localStorage.getItem(`${LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE}-${this.elem.id}`)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '0';

        // Record with the timer value.
        const timerValueRecorded = localStorage.getItem(`${TIMER_VALUE_FROM_LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE}-${this.elem.id}`);

        // Record with the timezone
        const timezoneRecorded = (_localStorage$getItem2 = localStorage.getItem(`${TIMER_TIMEZONE_FROM_LAST_VISIT_ON_SITE}-${this.elem.id}`)) !== null && _localStorage$getItem2 !== void 0 ? _localStorage$getItem2 : '0';

        // Set the deadline based on the last visit.
        this.deadline = parseInt(lastVisitTimeRecord) + parseInt(this.timer);

        /**
         * Reset conditions:
         * - the user is first time on the page
         * - the timer has reach the deadline
         * - the deadline time was changed
         * - the timezone has changed
         */
        if (!lastVisitTimeRecord || 0 > parseInt(lastVisitTimeRecord) + parseInt(this.timer) - Date.now() || timerValueRecorded !== this.timer || timezoneRecorded !== new Date().getTimezoneOffset().toString()) {
          // Record the current visit and timer time. Set a new deadline.
          localStorage.setItem(`${LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE}-${this.elem.id}`, Date.now().toString());
          localStorage.setItem(`${TIMER_VALUE_FROM_LAST_TIME_VISIT_ON_SITE_RECORD_SOURCE}-${this.elem.id}`, this.timer);
          localStorage.setItem(`${TIMER_TIMEZONE_FROM_LAST_VISIT_ON_SITE}-${this.elem.id}`, new Date().getTimezoneOffset().toString());
          this.deadline = Date.now() + parseInt(this.timer);
        }
        break;
      case 'interval':
        this.deadline = this.endInterval ? new Date(this.endInterval + ((_window$themeisleGute = window?.themeisleGutenbergCountdown?.timezone) !== null && _window$themeisleGute !== void 0 ? _window$themeisleGute : '')).getTime() : 0;
        this.hideTime = this.startInterval ? new Date(this.startInterval + ((_window$themeisleGute2 = window?.themeisleGutenbergCountdown?.timezone) !== null && _window$themeisleGute2 !== void 0 ? _window$themeisleGute2 : '')).getTime() : 0;
        break;
      default:
        this.deadline = this.rawData ? new Date(this.rawData + ((_window$themeisleGute3 = window?.themeisleGutenbergCountdown?.timezone) !== null && _window$themeisleGute3 !== void 0 ? _window$themeisleGute3 : '')).getTime() : Date.now();
    }
    this.hideOrShow(this.isStopped && 'hide' === this.behavior || this.mustBeHidden);
  }

  /**
   * Update the displayed time based on the given state.
   * @param states The state
   */
  update(states) {
    // Check if the countdown (in Interval Mode) is ready to show up.
    if ('interval' === this.mode && !this.checks.show) {
      this.hideOrShow(this.mustBeHidden);
    }
    states.forEach(state => {
      if (this.components?.[state.tag]?.label && this.components[state.tag]?.label?.innerHTML !== state.label) {
        var _state$label;
        this.components[state.tag].label.innerHTML = (_state$label = state.label) !== null && _state$label !== void 0 ? _state$label : '';
      }
      if (this.components?.[state.tag]?.value) {
        this.components[state.tag].value.innerHTML = state.value;
      }
    });
  }

  /**
   * Add a callback function that will be called the the timer is over.
   * @param f Callback function
   */
  onEnd(f) {
    this.onEndEvents.push(f);
  }

  /**
   * Trigger all the end function and dispatch a custom event (can be used for integration by third-party).
   */
  end() {
    // This can be used by other scripts to see when the countdown ends.
    const event = new CustomEvent('o-countdown-stop', {
      bubbles: true,
      detail: {
        countdown: this
      }
    });
    this.elem.dispatchEvent(event);
    this.onEndEvents.forEach(f => f());
  }

  /**
   * Activate the behavior of the countdown when it ends.
   */
  activateBehavior() {
    switch (this.behavior) {
      case 'default':
        break;
      case 'hide':
        this.hide();
        break;
      case 'redirectLink':
        if (this.redirectLink) {
          window.location.replace(this.redirectLink);
        }
        break;
    }
  }

  /**
   * Activate the actions of the countdown when it ends.
   * @return {void}
   */
  activateActions() {
    const blockSelectorId = this.connectedBlocksSelector;
    if (!blockSelectorId) {
      return;
    }
    switch (this.onEndAction) {
      case 'all':
        document.querySelectorAll(`${blockSelectorId}.o-cntdn-bhv-hide`).forEach(blockElem => blockElem.classList.add('o-cntdn-hide'));
        document.querySelectorAll(`${blockSelectorId}.o-cntdn-bhv-show`).forEach(blockElem => blockElem.classList.remove('o-cntdn-bhv-show'));
        break;
      default:
        break;
    }
  }

  /**
   * Hide or show up the countdown.
   * @param isHidden The value.
   */
  hideOrShow(isHidden) {
    if (isHidden) {
      this.hide();
    } else {
      this.checks.show = true;
      this.show();
      document.querySelectorAll(`${this.connectedBlocksSelector}.o-cntdn-bhv-hide`).forEach(blockElem => {
        blockElem.classList.add('o-cntdn-ready');
      });
    }
  }

  /**
   * Hide the countdown.
   */
  hide() {
    this.elem.classList.add('o-hide');
  }

  /**
   * Show the countdown and mark it as ready.
   */
  show() {
    this.elem.classList.add('o-cntdn-ready');
    this.elem.classList.remove('o-hide');
  }

  /**
   * Get the blocks that are connected to the countdown End actions.
   */
  get connectedBlocksSelector() {
    if (this.elem.id === undefined) {
      return null;
    }
    return `.o-countdown-trigger-on-end-${this.elem.id.split('-').pop()}`;
  }

  /**
   * Get the remaining time.
   */
  get remainingTime() {
    return this.deadline - this.currentTime;
  }

  /**
   * Check if the countdown has stopped.
   */
  get isStopped() {
    return 0 >= this.remainingTime;
  }

  /**
   * Check the countdown must reaming hidden - used the Interval mode.
   */
  get mustBeHidden() {
    return this.startInterval !== undefined && 0 <= this.hideTime - this.currentTime;
  }

  /**
   * Set the current time of the countdown.
   */
  set time(time) {
    this.currentTime = time;
  }
}

/**
 * The purpose of this class is to act like a centralized clock that update the Countdown by using the same time value.
 * Instead of having time interval for each Countdown, we use a global one, thus reducing the page lag from multiple `setInterval`.
 */
class CountdownRunner {
  constructor() {
    this.countdowns = {};
    this.running = new Set();
    this.stopped = new Set();
  }

  /**
   * Register a countdown.
   * @param countdown The countdown data.
   */
  register(countdown) {
    if (countdown) {
      countdown.onEnd(() => {
        this.running.delete(countdown.id);
        this.stopped.add(countdown.id);
      });
      this.countdowns[countdown.id] = countdown;
      this.running.add(countdown.id);
    }
  }

  /**
   * Start the global timer.
   * @param interval The interval time.
   */
  startTimer(interval = 300) {
    this.timer = setInterval(() => {
      this.update();
    }, interval);
  }

  /**
   * Update he countdown using the current time.
   */
  update() {
    const currentTime = Date.now();
    this.running.forEach(countdown => {
      this.updateCountdown(this.countdowns[countdown], currentTime);
    });
    if (0 === this.running.size) {
      this.stopTimer();
    }
  }

  /**
   * Stop the timer.
   */
  stopTimer() {
    clearInterval(this.timer);
  }

  /**
   * Update the countdown based on the given time.
   * @param countdown   The countdown.
   * @param currentTime The time that needs to be displayed,
   */
  updateCountdown(countdown, currentTime) {
    const {
      id
    } = countdown;
    countdown.time = currentTime;
    try {
      const {
        remainingTime
      } = countdown;

      // Compute the time components
      const days = Math.floor(remainingTime / _MS_PER_DAY);
      const hours = Math.floor(remainingTime / _MS_PER_HOURS % 24);
      const minutes = Math.floor(remainingTime / _MS_PER_MINUTES % 60);
      const seconds = Math.floor(remainingTime / _MS_PER_SECONDS % 60);
      const {
        i18n
      } = window.themeisleGutenbergCountdown;

      // Bind the components with position and label
      const timeComponents = [{
        tag: 'day',
        label: 1 < days ? i18n.days : i18n.day,
        value: days
      }, {
        tag: 'hour',
        label: 1 < hours ? i18n.hours : i18n.hour,
        value: hours
      }, {
        tag: 'minute',
        label: 1 < minutes ? i18n.minutes : i18n.minute,
        value: minutes
      }, {
        tag: 'second',
        label: 1 < seconds ? i18n.seconds : i18n.second,
        value: seconds
      }].filter(({
        tag
      }) => !countdown.settings?.exclude?.includes(tag)).map(obj => {
        return {
          ...obj,
          value: !countdown.settings?.keepNeg ? Math.max(0, obj.value).toString() : obj.value.toString()
        };
      });
      countdown.update(timeComponents);
      if (countdown.isStopped) {
        countdown.end();
      }
    } catch (error) {
      /**
       * If if we have problem with a countdown, we eliminate it from the flow.
       */
      console.error(error);
      this.running.delete(id);
    }
  }
}
(0,_helpers_frontend_helper_functions__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const countdowns = document.querySelectorAll('.wp-block-themeisle-blocks-countdown');
  const runner = new CountdownRunner();
  countdowns.forEach(countdown => {
    const c = new CountdownData(countdown);
    runner.register(c);
  });
  runner.update();
  runner.startTimer();
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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