/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*********************************************!*\
  !*** ./src/blocks/frontend/lottie/index.js ***!
  \*********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * WordPress dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const lottieAmin = document.querySelectorAll('lottie-player.wp-block-themeisle-blocks-lottie');
  const dotLottieAnim = document.querySelectorAll('dotlottie-player.wp-block-themeisle-blocks-lottie');
  const initAnimation = animation => {
    if ('false' === animation.dataset.loop) {
      animation.setLooping(false);
    }
    if (-1 === animation.__direction) {
      animation.seek('100%');
    }
    if (Boolean(animation.__count)) {
      animation.__count = animation.__count - 1;
    }
    if (-1 === animation.__direction && 'true' === animation.dataset.loop) {
      animation.setLooping(true);
      if (Boolean(animation.__count)) {
        animation.addEventListener('frame', e => {
          if (e.target.getLottie().playCount === animation.__count && e.target.getLottie().currentFrame) {
            animation.stop();
          }
        });
      }
    }
  };
  const eventAnim = animation => {
    const trigger = animation.getAttribute('trigger');
    if ('scroll' === trigger) {
      return window.LottieInteractivity.create({
        mode: 'scroll',
        player: animation.getLottie(),
        container: animation,
        actions: [{
          visibility: [0, 1],
          type: 'seek',
          frames: [0, animation.getLottie().totalFrames]
        }]
      });
    }
    if ('hover' === trigger) {
      animation.addEventListener('mouseover', () => {
        animation.play();
      });
      animation.addEventListener('mouseout', () => {
        animation.stop();
      });
      initAnimation(animation);
      return -1 === animation.__direction ? animation.pause() : animation.stop();
    }
    if ('click' === trigger) {
      animation.addEventListener('click', () => {
        animation.play();
      });
      animation.addEventListener('complete', () => animation.stop());
      initAnimation(animation);
      return -1 === animation.__direction ? animation.pause() : animation.stop();
    }
    return initAnimation(animation);
  };
  const addStyle = animation => {
    if (animation.getAttribute('width')) {
      animation.style.height = 'auto';
      const width = animation.getAttribute('width');
      if ('%' === width.toString().slice(-1)) {
        animation.style.maxWidth = width;
      } else {
        animation.style.width = 'px' !== width.toString().slice(-2) ? `${width}px` : width;
      }
    }
  };
  lottieAmin.forEach(animation => {
    animation.addEventListener('load', e => {
      const animation = e.target;
      eventAnim(animation);
    });
    addStyle(animation);
  });
  dotLottieAnim.forEach(animation => {
    const interval = setInterval(() => {
      if (animation.load) {
        animation.load(animation.dataset.src)?.then(() => {
          eventAnim(animation);
        });
        addStyle(animation);
        clearInterval(interval);
      }
    }, 0);
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG90dGllLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU1BLEtBQUssR0FBR0EsQ0FBRUMsS0FBSyxFQUFFQyxHQUFHLEVBQUVDLElBQUksS0FBTTtFQUM1QyxNQUFNSCxLQUFLLEdBQUcsRUFBRTtFQUNoQixNQUFNSSxXQUFXLEdBQUcsT0FBT0gsS0FBSztFQUNoQyxNQUFNSSxTQUFTLEdBQUcsT0FBT0gsR0FBRztFQUU1QixJQUFLLENBQUMsS0FBS0MsSUFBSSxFQUFHO0lBQ2pCLE1BQU1HLFNBQVMsQ0FBRSxzQkFBdUIsQ0FBQztFQUMxQztFQUVBLElBQUtDLFNBQVMsS0FBS0gsV0FBVyxJQUFJRyxTQUFTLEtBQUtGLFNBQVMsRUFBRztJQUMzRCxNQUFNQyxTQUFTLENBQUUsb0NBQXFDLENBQUM7RUFDeEQsQ0FBQyxNQUFNLElBQUtGLFdBQVcsS0FBS0MsU0FBUyxFQUFHO0lBQ3ZDLE1BQU1DLFNBQVMsQ0FBRSwrQ0FBZ0QsQ0FBQztFQUNuRTtFQUVBLElBQUssV0FBVyxLQUFLLE9BQU9ILElBQUksRUFBRztJQUNsQ0EsSUFBSSxHQUFHLENBQUM7RUFDVDtFQUVBLElBQUtELEdBQUcsR0FBR0QsS0FBSyxFQUFHO0lBQ2xCRSxJQUFJLEdBQUcsQ0FBQ0EsSUFBSTtFQUNiO0VBRUEsSUFBSyxRQUFRLEtBQUtDLFdBQVcsRUFBRztJQUMvQixPQUFRLENBQUMsR0FBR0QsSUFBSSxHQUFHRCxHQUFHLElBQUlELEtBQUssR0FBR0MsR0FBRyxJQUFJRCxLQUFLLEVBQUc7TUFDaERELEtBQUssQ0FBQ1EsSUFBSSxDQUFFUCxLQUFNLENBQUM7TUFDbkJBLEtBQUssSUFBSUUsSUFBSTtJQUNkO0VBQ0QsQ0FBQyxNQUFNLElBQUssUUFBUSxLQUFLQyxXQUFXLEVBQUc7SUFDdEMsSUFBSyxDQUFDLEtBQUtILEtBQUssQ0FBQ1EsTUFBTSxJQUFJLENBQUMsS0FBS1AsR0FBRyxDQUFDTyxNQUFNLEVBQUc7TUFDN0MsTUFBTUgsU0FBUyxDQUFFLGdEQUFpRCxDQUFDO0lBQ3BFO0lBRUFMLEtBQUssR0FBR0EsS0FBSyxDQUFDUyxVQUFVLENBQUUsQ0FBRSxDQUFDO0lBQzdCUixHQUFHLEdBQUdBLEdBQUcsQ0FBQ1EsVUFBVSxDQUFFLENBQUUsQ0FBQztJQUV6QixPQUFRLENBQUMsR0FBR1AsSUFBSSxHQUFHRCxHQUFHLElBQUlELEtBQUssR0FBR0MsR0FBRyxJQUFJRCxLQUFLLEVBQUc7TUFDaERELEtBQUssQ0FBQ1EsSUFBSSxDQUFFRyxNQUFNLENBQUNDLFlBQVksQ0FBRVgsS0FBTSxDQUFFLENBQUM7TUFDMUNBLEtBQUssSUFBSUUsSUFBSTtJQUNkO0VBQ0QsQ0FBQyxNQUFNO0lBQ04sTUFBTUcsU0FBUyxDQUFFLDRDQUE2QyxDQUFDO0VBQ2hFO0VBRUEsT0FBT04sS0FBSztBQUNiLENBQUM7O0FBRUQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTWEsTUFBTSxHQUFLQyxDQUFDLElBQU07RUFDOUIsT0FBT0EsQ0FBQztBQUNULENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTUMsVUFBVSxHQUFLRCxDQUFDLElBQU07RUFDbEMsT0FBTyxDQUFDLEdBQUdFLElBQUksQ0FBQ0MsR0FBRyxDQUFJSCxDQUFDLEdBQUdFLElBQUksQ0FBQ0UsRUFBRSxHQUFLLENBQUUsQ0FBQztBQUMzQyxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU1DLFdBQVcsR0FBS0wsQ0FBQyxJQUFNO0VBQ25DLE9BQU9FLElBQUksQ0FBQ0ksR0FBRyxDQUFJTixDQUFDLEdBQUdFLElBQUksQ0FBQ0UsRUFBRSxHQUFLLENBQUUsQ0FBQztBQUN2QyxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNRyxhQUFhLEdBQUtQLENBQUMsSUFBTTtFQUNyQyxPQUFPLEVBQUdFLElBQUksQ0FBQ0MsR0FBRyxDQUFFRCxJQUFJLENBQUNFLEVBQUUsR0FBR0osQ0FBRSxDQUFDLEdBQUcsQ0FBQyxDQUFFLEdBQUcsQ0FBQztBQUM1QyxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNUSxXQUFXLEdBQUtSLENBQUMsSUFBTTtFQUNuQyxPQUFPLENBQUMsR0FBRyxDQUFFLENBQUMsR0FBR0EsQ0FBQyxLQUFPLENBQUMsR0FBR0EsQ0FBQyxDQUFFO0FBQ2pDLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTVMsUUFBUSxHQUFLQyxRQUFRLElBQU07RUFDdkMsSUFBSyxXQUFXLEtBQUssT0FBT0MsUUFBUSxFQUFHO0lBQ3RDO0VBQ0Q7RUFFQSxJQUNDLFVBQVUsS0FBS0EsUUFBUSxDQUFDQyxVQUFVO0VBQUk7RUFDdEMsYUFBYSxLQUFLRCxRQUFRLENBQUNDLFVBQVUsQ0FBQztFQUFBLEVBQ3JDO0lBQ0QsT0FBTyxLQUFLRixRQUFRLENBQUMsQ0FBQztFQUN2Qjs7RUFFQTtFQUNBQyxRQUFRLENBQUNFLGdCQUFnQixDQUFFLGtCQUFrQixFQUFFSCxRQUFTLENBQUM7QUFDMUQsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU1JLFFBQVEsR0FBR0EsQ0FBRUMsSUFBSSxFQUFFQyxPQUFPLEdBQUcsR0FBRyxLQUFNO0VBQ2xELElBQUlDLEtBQUs7RUFDVCxPQUFPLENBQUUsR0FBR0MsSUFBSSxLQUFNO0lBQ3JCQyxZQUFZLENBQUVGLEtBQU0sQ0FBQztJQUNyQkEsS0FBSyxHQUFHRyxVQUFVLENBQUUsTUFBTTtNQUN6QkwsSUFBSSxDQUFDTSxLQUFLLENBQUUsU0FBSSxFQUFFSCxJQUFLLENBQUM7SUFDekIsQ0FBQyxFQUFFRixPQUFRLENBQUM7RUFDYixDQUFDO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU1NLE9BQU8sR0FBR0EsQ0FBRUMsS0FBSyxFQUFFQyxPQUFPLEdBQUcsSUFBSSxLQUFNO0VBQ25ELE1BQU1DLEdBQUcsR0FBR0YsS0FBSyxDQUFDRyxTQUFTLENBQUUsQ0FBQyxFQUFFSCxLQUFLLENBQUM1QixNQUFNLEdBQUcsQ0FBRSxDQUFDLENBQ2hEZ0MsT0FBTyxDQUFFLElBQUksRUFBRSxFQUFHLENBQUMsQ0FDbkJDLEtBQUssQ0FBRSxHQUFJLENBQUM7RUFFZCxNQUFNQyxDQUFDLEdBQUdDLFVBQVUsQ0FBRUwsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRztFQUNuQyxNQUFNTSxDQUFDLEdBQUdELFVBQVUsQ0FBRUwsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRztFQUNuQyxNQUFNTyxDQUFDLEdBQUdGLFVBQVUsQ0FBRUwsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRztFQUVuQyxNQUFNUSxHQUFHLEdBQUcvQixJQUFJLENBQUMrQixHQUFHLENBQUVKLENBQUMsRUFBRUUsQ0FBQyxFQUFFQyxDQUFFLENBQUM7RUFDL0IsTUFBTUUsR0FBRyxHQUFHaEMsSUFBSSxDQUFDZ0MsR0FBRyxDQUFFTCxDQUFDLEVBQUVFLENBQUMsRUFBRUMsQ0FBRSxDQUFDO0VBRS9CLElBQUlHLENBQUMsRUFBRUMsQ0FBQztFQUNSLE1BQU1DLENBQUMsR0FBRyxDQUFFSixHQUFHLEdBQUdDLEdBQUcsSUFBSyxDQUFDO0VBRTNCLElBQUtELEdBQUcsS0FBS0MsR0FBRyxFQUFHO0lBQ2xCQyxDQUFDLEdBQUdDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztFQUNaLENBQUMsTUFBTTtJQUNOLE1BQU1FLENBQUMsR0FBR0wsR0FBRyxHQUFHQyxHQUFHO0lBQ25CRSxDQUFDLEdBQUcsR0FBRyxHQUFHQyxDQUFDLEdBQUdDLENBQUMsSUFBSyxDQUFDLEdBQUdMLEdBQUcsR0FBR0MsR0FBRyxDQUFFLEdBQUdJLENBQUMsSUFBS0wsR0FBRyxHQUFHQyxHQUFHLENBQUU7SUFFdkQsUUFBU0QsR0FBRztNQUNaLEtBQUtKLENBQUM7UUFBRU0sQ0FBQyxHQUFHLENBQUVKLENBQUMsR0FBR0MsQ0FBQyxJQUFLTSxDQUFDLElBQUtQLENBQUMsR0FBR0MsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUU7UUFBRTtNQUMvQyxLQUFLRCxDQUFDO1FBQUVJLENBQUMsR0FBRyxDQUFFSCxDQUFDLEdBQUdILENBQUMsSUFBS1MsQ0FBQyxHQUFHLENBQUM7UUFBRTtNQUMvQixLQUFLTixDQUFDO1FBQUVHLENBQUMsR0FBRyxDQUFFTixDQUFDLEdBQUdFLENBQUMsSUFBS08sQ0FBQyxHQUFHLENBQUM7UUFBRTtJQUMvQjtJQUVBSCxDQUFDLElBQUksQ0FBQztFQUNQO0VBRUEsSUFBS1gsT0FBTyxFQUFHO0lBQ2QsT0FBTyxDQUFFVyxDQUFDLEdBQUcsR0FBRyxFQUFFQyxDQUFDLEdBQUcsR0FBRyxFQUFFQyxDQUFDLEdBQUcsR0FBRyxDQUFFO0VBQ3JDO0VBRUEsT0FBTyxRQUFRRixDQUFDLEdBQUcsR0FBRyxLQUFLQyxDQUFDLEdBQUcsR0FBRyxLQUFLQyxDQUFDLEdBQUcsR0FBRyxJQUFJO0FBQ25ELENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTUUsc0JBQXNCLEdBQUdBLENBQUVDLE9BQU8sRUFBRUMsT0FBTyxHQUFHLENBQUMsQ0FBQyxLQUFLO0VBQ2pFLElBQUssQ0FBRUQsT0FBTyxFQUFHO0lBQ2hCO0VBQ0Q7RUFFQSxNQUFNRSxJQUFJLEdBQUdGLE9BQU8sQ0FBQ0cscUJBQXFCLENBQUMsQ0FBQztFQUM1QyxNQUFNQyxjQUFjLEdBQ25CLENBQUMsSUFBSUYsSUFBSSxDQUFDRyxHQUFHLElBQ2IsQ0FBQyxJQUFJSCxJQUFJLENBQUNJLElBQUksSUFDZEosSUFBSSxDQUFDSyxNQUFNLEtBQU1DLE1BQU0sQ0FBQ0MsV0FBVyxJQUFJdEMsUUFBUSxDQUFDdUMsZUFBZSxDQUFDQyxZQUFZLENBQUUsSUFDOUVULElBQUksQ0FBQ1UsS0FBSyxLQUFNSixNQUFNLENBQUNLLFVBQVUsSUFBSTFDLFFBQVEsQ0FBQ3VDLGVBQWUsQ0FBQ0ksV0FBVyxDQUN6RTtFQUVELElBQUssQ0FBRVYsY0FBYyxFQUFHO0lBQ3ZCSixPQUFPLENBQUNlLGNBQWMsQ0FBRWQsT0FBUSxDQUFDO0VBQ2xDO0FBQ0QsQ0FBQzs7Ozs7O1VDbE5EO1VBQ0E7O1VBRUE7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7O1VBRUE7VUFDQTs7VUFFQTtVQUNBO1VBQ0E7Ozs7O1dDdEJBO1dBQ0E7V0FDQTtXQUNBO1dBQ0EseUNBQXlDLHdDQUF3QztXQUNqRjtXQUNBO1dBQ0E7Ozs7O1dDUEEsOENBQThDOzs7OztXQ0E5QztXQUNBO1dBQ0E7V0FDQSx1REFBdUQsaUJBQWlCO1dBQ3hFO1dBQ0EsZ0RBQWdELGFBQWE7V0FDN0Q7Ozs7Ozs7Ozs7OztBQ05BO0FBQ0E7QUFDQTtBQUNzRTtBQUV0RWhDLCtFQUFRLENBQUUsTUFBTTtFQUNmLE1BQU0rQyxVQUFVLEdBQUc3QyxRQUFRLENBQUM4QyxnQkFBZ0IsQ0FBRSxnREFBaUQsQ0FBQztFQUNoRyxNQUFNQyxhQUFhLEdBQUcvQyxRQUFRLENBQUM4QyxnQkFBZ0IsQ0FBRSxtREFBb0QsQ0FBQztFQUV0RyxNQUFNRSxhQUFhLEdBQUdDLFNBQVMsSUFBSTtJQUNsQyxJQUFLLE9BQU8sS0FBS0EsU0FBUyxDQUFDQyxPQUFPLENBQUNDLElBQUksRUFBRztNQUN6Q0YsU0FBUyxDQUFDRyxVQUFVLENBQUUsS0FBTSxDQUFDO0lBQzlCO0lBRUEsSUFBSyxDQUFDLENBQUMsS0FBS0gsU0FBUyxDQUFDSSxXQUFXLEVBQUc7TUFDbkNKLFNBQVMsQ0FBQ0ssSUFBSSxDQUFFLE1BQU8sQ0FBQztJQUN6QjtJQUVBLElBQUtDLE9BQU8sQ0FBRU4sU0FBUyxDQUFDTyxPQUFRLENBQUMsRUFBRztNQUNuQ1AsU0FBUyxDQUFDTyxPQUFPLEdBQUdQLFNBQVMsQ0FBQ08sT0FBTyxHQUFHLENBQUM7SUFDMUM7SUFFQSxJQUFLLENBQUMsQ0FBQyxLQUFLUCxTQUFTLENBQUNJLFdBQVcsSUFBSSxNQUFNLEtBQUtKLFNBQVMsQ0FBQ0MsT0FBTyxDQUFDQyxJQUFJLEVBQUc7TUFDeEVGLFNBQVMsQ0FBQ0csVUFBVSxDQUFFLElBQUssQ0FBQztNQUU1QixJQUFLRyxPQUFPLENBQUVOLFNBQVMsQ0FBQ08sT0FBUSxDQUFDLEVBQUc7UUFDbkNQLFNBQVMsQ0FBQy9DLGdCQUFnQixDQUFFLE9BQU8sRUFBRXVELENBQUMsSUFBSTtVQUN6QyxJQUFLQSxDQUFDLENBQUNDLE1BQU0sQ0FBQ0MsU0FBUyxDQUFDLENBQUMsQ0FBQ0MsU0FBUyxLQUFLWCxTQUFTLENBQUNPLE9BQU8sSUFBSUMsQ0FBQyxDQUFDQyxNQUFNLENBQUNDLFNBQVMsQ0FBQyxDQUFDLENBQUNFLFlBQVksRUFBRztZQUNoR1osU0FBUyxDQUFDYSxJQUFJLENBQUMsQ0FBQztVQUNqQjtRQUNELENBQUMsQ0FBQztNQUNIO0lBQ0Q7RUFDRCxDQUFDO0VBRUQsTUFBTUMsU0FBUyxHQUFHZCxTQUFTLElBQUk7SUFDOUIsTUFBTWUsT0FBTyxHQUFHZixTQUFTLENBQUNnQixZQUFZLENBQUUsU0FBVSxDQUFDO0lBQ25ELElBQUssUUFBUSxLQUFLRCxPQUFPLEVBQUc7TUFDM0IsT0FBTzNCLE1BQU0sQ0FBQzZCLG1CQUFtQixDQUFDQyxNQUFNLENBQUM7UUFDeENDLElBQUksRUFBRSxRQUFRO1FBQ2RDLE1BQU0sRUFBRXBCLFNBQVMsQ0FBQ1UsU0FBUyxDQUFDLENBQUM7UUFDN0JXLFNBQVMsRUFBRXJCLFNBQVM7UUFDcEJzQixPQUFPLEVBQUUsQ0FBQztVQUNUQyxVQUFVLEVBQUUsQ0FBRSxDQUFDLEVBQUUsQ0FBQyxDQUFFO1VBQ3BCQyxJQUFJLEVBQUUsTUFBTTtVQUNaQyxNQUFNLEVBQUUsQ0FBRSxDQUFDLEVBQUV6QixTQUFTLENBQUNVLFNBQVMsQ0FBQyxDQUFDLENBQUNnQixXQUFXO1FBQy9DLENBQUM7TUFDRixDQUFDLENBQUM7SUFDSDtJQUVBLElBQUssT0FBTyxLQUFLWCxPQUFPLEVBQUc7TUFDMUJmLFNBQVMsQ0FBQy9DLGdCQUFnQixDQUFFLFdBQVcsRUFBRSxNQUFNO1FBQzlDK0MsU0FBUyxDQUFDMkIsSUFBSSxDQUFDLENBQUM7TUFDakIsQ0FBQyxDQUFDO01BRUYzQixTQUFTLENBQUMvQyxnQkFBZ0IsQ0FBRSxVQUFVLEVBQUUsTUFBTTtRQUM3QytDLFNBQVMsQ0FBQ2EsSUFBSSxDQUFDLENBQUM7TUFDakIsQ0FBQyxDQUFDO01BRUZkLGFBQWEsQ0FBRUMsU0FBVSxDQUFDO01BQzFCLE9BQU8sQ0FBQyxDQUFDLEtBQUtBLFNBQVMsQ0FBQ0ksV0FBVyxHQUFHSixTQUFTLENBQUM0QixLQUFLLENBQUMsQ0FBQyxHQUFHNUIsU0FBUyxDQUFDYSxJQUFJLENBQUMsQ0FBQztJQUMzRTtJQUVBLElBQUssT0FBTyxLQUFLRSxPQUFPLEVBQUc7TUFDMUJmLFNBQVMsQ0FBQy9DLGdCQUFnQixDQUFFLE9BQU8sRUFBRSxNQUFNO1FBQzFDK0MsU0FBUyxDQUFDMkIsSUFBSSxDQUFDLENBQUM7TUFDakIsQ0FBQyxDQUFDO01BRUYzQixTQUFTLENBQUMvQyxnQkFBZ0IsQ0FBRSxVQUFVLEVBQUUsTUFBTStDLFNBQVMsQ0FBQ2EsSUFBSSxDQUFDLENBQUUsQ0FBQztNQUNoRWQsYUFBYSxDQUFFQyxTQUFVLENBQUM7TUFDMUIsT0FBTyxDQUFDLENBQUMsS0FBS0EsU0FBUyxDQUFDSSxXQUFXLEdBQUdKLFNBQVMsQ0FBQzRCLEtBQUssQ0FBQyxDQUFDLEdBQUc1QixTQUFTLENBQUNhLElBQUksQ0FBQyxDQUFDO0lBQzNFO0lBRUEsT0FBT2QsYUFBYSxDQUFFQyxTQUFVLENBQUM7RUFDbEMsQ0FBQztFQUVELE1BQU02QixRQUFRLEdBQUc3QixTQUFTLElBQUk7SUFDN0IsSUFBS0EsU0FBUyxDQUFDZ0IsWUFBWSxDQUFFLE9BQVEsQ0FBQyxFQUFHO01BQ3hDaEIsU0FBUyxDQUFDOEIsS0FBSyxDQUFDQyxNQUFNLEdBQUcsTUFBTTtNQUUvQixNQUFNQyxLQUFLLEdBQUdoQyxTQUFTLENBQUNnQixZQUFZLENBQUUsT0FBUSxDQUFDO01BQy9DLElBQUssR0FBRyxLQUFLZ0IsS0FBSyxDQUFDQyxRQUFRLENBQUMsQ0FBQyxDQUFDQyxLQUFLLENBQUUsQ0FBQyxDQUFFLENBQUMsRUFBRztRQUMzQ2xDLFNBQVMsQ0FBQzhCLEtBQUssQ0FBQ0ssUUFBUSxHQUFHSCxLQUFLO01BQ2pDLENBQUMsTUFBTTtRQUNOaEMsU0FBUyxDQUFDOEIsS0FBSyxDQUFDRSxLQUFLLEdBQUssSUFBSSxLQUFLQSxLQUFLLENBQUNDLFFBQVEsQ0FBQyxDQUFDLENBQUNDLEtBQUssQ0FBRSxDQUFDLENBQUUsQ0FBQyxHQUFLLEdBQUdGLEtBQUssSUFBSSxHQUFHQSxLQUFLO01BQ3pGO0lBQ0Q7RUFDRCxDQUFDO0VBRURwQyxVQUFVLENBQUN3QyxPQUFPLENBQUVwQyxTQUFTLElBQUk7SUFDaENBLFNBQVMsQ0FBQy9DLGdCQUFnQixDQUFFLE1BQU0sRUFBRXVELENBQUMsSUFBSTtNQUN4QyxNQUFNUixTQUFTLEdBQUdRLENBQUMsQ0FBQ0MsTUFBTTtNQUMxQkssU0FBUyxDQUFFZCxTQUFVLENBQUM7SUFDdkIsQ0FBQyxDQUFDO0lBRUY2QixRQUFRLENBQUU3QixTQUFVLENBQUM7RUFDdEIsQ0FBQyxDQUFDO0VBRUZGLGFBQWEsQ0FBQ3NDLE9BQU8sQ0FBRXBDLFNBQVMsSUFBSTtJQUNuQyxNQUFNcUMsUUFBUSxHQUFHQyxXQUFXLENBQUUsTUFBTTtNQUNuQyxJQUFLdEMsU0FBUyxDQUFDdUMsSUFBSSxFQUFHO1FBQ3JCdkMsU0FBUyxDQUFDdUMsSUFBSSxDQUFFdkMsU0FBUyxDQUFDQyxPQUFPLENBQUN1QyxHQUFJLENBQUMsRUFBRUMsSUFBSSxDQUFFLE1BQU07VUFDcEQzQixTQUFTLENBQUVkLFNBQVUsQ0FBQztRQUN2QixDQUFDLENBQUM7UUFFRjZCLFFBQVEsQ0FBRTdCLFNBQVUsQ0FBQztRQUNyQjBDLGFBQWEsQ0FBRUwsUUFBUyxDQUFDO01BQzFCO0lBQ0QsQ0FBQyxFQUFFLENBQUUsQ0FBQztFQUNQLENBQUMsQ0FBQztBQUNILENBQUMsQ0FBQyxDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vb3R0ZXItYmxvY2tzLy4vc3JjL2Jsb2Nrcy9oZWxwZXJzL2Zyb250ZW5kLWhlbHBlci1mdW5jdGlvbnMuanMiLCJ3ZWJwYWNrOi8vb3R0ZXItYmxvY2tzL3dlYnBhY2svYm9vdHN0cmFwIiwid2VicGFjazovL290dGVyLWJsb2Nrcy93ZWJwYWNrL3J1bnRpbWUvZGVmaW5lIHByb3BlcnR5IGdldHRlcnMiLCJ3ZWJwYWNrOi8vb3R0ZXItYmxvY2tzL3dlYnBhY2svcnVudGltZS9oYXNPd25Qcm9wZXJ0eSBzaG9ydGhhbmQiLCJ3ZWJwYWNrOi8vb3R0ZXItYmxvY2tzL3dlYnBhY2svcnVudGltZS9tYWtlIG5hbWVzcGFjZSBvYmplY3QiLCJ3ZWJwYWNrOi8vb3R0ZXItYmxvY2tzLy4vc3JjL2Jsb2Nrcy9mcm9udGVuZC9sb3R0aWUvaW5kZXguanMiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDcmVhdGUgYSBsaXN0IHdpdGggbnVtYmVycyBmcm9tIGludGVydmFsIFtzdGFydCwgZW5kXS5cbiAqXG4gKiBAcGFyYW0ge251bWJlcn0gc3RhcnQgVGhlIHN0YXJ0LlxuICogQHBhcmFtIHtudW1iZXJ9IGVuZCAgIFRoZSBlbmQuXG4gKiBAcGFyYW0ge251bWJlcn0gc3RlcCAgVGhlIHN0ZXAuXG4gKiBAcmV0dXJuIHsqW119XG4gKi9cbmV4cG9ydCBjb25zdCByYW5nZSA9ICggc3RhcnQsIGVuZCwgc3RlcCApID0+IHtcblx0Y29uc3QgcmFuZ2UgPSBbXTtcblx0Y29uc3QgdHlwZW9mU3RhcnQgPSB0eXBlb2Ygc3RhcnQ7XG5cdGNvbnN0IHR5cGVvZkVuZCA9IHR5cGVvZiBlbmQ7XG5cblx0aWYgKCAwID09PSBzdGVwICkge1xuXHRcdHRocm93IFR5cGVFcnJvciggJ1N0ZXAgY2Fubm90IGJlIHplcm8uJyApO1xuXHR9XG5cblx0aWYgKCB1bmRlZmluZWQgPT09IHR5cGVvZlN0YXJ0IHx8IHVuZGVmaW5lZCA9PT0gdHlwZW9mRW5kICkge1xuXHRcdHRocm93IFR5cGVFcnJvciggJ011c3QgcGFzcyBzdGFydCBhbmQgZW5kIGFyZ3VtZW50cy4nICk7XG5cdH0gZWxzZSBpZiAoIHR5cGVvZlN0YXJ0ICE9PSB0eXBlb2ZFbmQgKSB7XG5cdFx0dGhyb3cgVHlwZUVycm9yKCAnU3RhcnQgYW5kIGVuZCBhcmd1bWVudHMgbXVzdCBiZSBvZiBzYW1lIHR5cGUuJyApO1xuXHR9XG5cblx0aWYgKCAndW5kZWZpbmVkJyA9PT0gdHlwZW9mIHN0ZXAgKSB7XG5cdFx0c3RlcCA9IDE7XG5cdH1cblxuXHRpZiAoIGVuZCA8IHN0YXJ0ICkge1xuXHRcdHN0ZXAgPSAtc3RlcDtcblx0fVxuXG5cdGlmICggJ251bWJlcicgPT09IHR5cGVvZlN0YXJ0ICkge1xuXHRcdHdoaWxlICggMCA8IHN0ZXAgPyBlbmQgPj0gc3RhcnQgOiBlbmQgPD0gc3RhcnQgKSB7XG5cdFx0XHRyYW5nZS5wdXNoKCBzdGFydCApO1xuXHRcdFx0c3RhcnQgKz0gc3RlcDtcblx0XHR9XG5cdH0gZWxzZSBpZiAoICdzdHJpbmcnID09PSB0eXBlb2ZTdGFydCApIHtcblx0XHRpZiAoIDEgIT09IHN0YXJ0Lmxlbmd0aCB8fCAxICE9PSBlbmQubGVuZ3RoICkge1xuXHRcdFx0dGhyb3cgVHlwZUVycm9yKCAnT25seSBzdHJpbmdzIHdpdGggb25lIGNoYXJhY3RlciBhcmUgc3VwcG9ydGVkLicgKTtcblx0XHR9XG5cblx0XHRzdGFydCA9IHN0YXJ0LmNoYXJDb2RlQXQoIDAgKTtcblx0XHRlbmQgPSBlbmQuY2hhckNvZGVBdCggMCApO1xuXG5cdFx0d2hpbGUgKCAwIDwgc3RlcCA/IGVuZCA+PSBzdGFydCA6IGVuZCA8PSBzdGFydCApIHtcblx0XHRcdHJhbmdlLnB1c2goIFN0cmluZy5mcm9tQ2hhckNvZGUoIHN0YXJ0ICkgKTtcblx0XHRcdHN0YXJ0ICs9IHN0ZXA7XG5cdFx0fVxuXHR9IGVsc2Uge1xuXHRcdHRocm93IFR5cGVFcnJvciggJ09ubHkgc3RyaW5nIGFuZCBudW1iZXIgdHlwZXMgYXJlIHN1cHBvcnRlZCcgKTtcblx0fVxuXG5cdHJldHVybiByYW5nZTtcbn07XG5cbi8vIEVhc2luZyBmdW5jdGlvbnMgZm9yIGFuaW1hdGlvblxuXG4vKipcbiAqIExpbmVhclxuICpcbiAqIEBwYXJhbSB7bnVtYmVyfSB4XG4gKiBAcmV0dXJuIHtudW1iZXJ9XG4gKi9cbmV4cG9ydCBjb25zdCBsaW5lYXIgPSAoIHggKSA9PiB7XG5cdHJldHVybiB4O1xufTtcblxuLyoqXG4gKiBFYXNlIEluIFNpbmVcbiAqXG4gKiBAcGFyYW0ge251bWJlcn0geFxuICogQHJldHVybiB7bnVtYmVyfVxuICovXG5leHBvcnQgY29uc3QgZWFzZUluU2luZSA9ICggeCApID0+IHtcblx0cmV0dXJuIDEgLSBNYXRoLmNvcyggKCB4ICogTWF0aC5QSSApIC8gMiApO1xufTtcblxuLyoqXG4gKiBFYXNlIE91dCBTaW5lXG4gKlxuICogQHBhcmFtIHtudW1iZXJ9IHhcbiAqIEByZXR1cm4ge251bWJlcn1cbiAqL1xuZXhwb3J0IGNvbnN0IGVhc2VPdXRTaW5lID0gKCB4ICkgPT4ge1xuXHRyZXR1cm4gTWF0aC5zaW4oICggeCAqIE1hdGguUEkgKSAvIDIgKTtcbn07XG5cbi8qKlxuICogRWFzZSBJbiBPdXQgU1NpbmVcbiAqIEBwYXJhbSB7bnVtYmVyfSB4XG4gKiBAcmV0dXJuIHtudW1iZXJ9XG4gKi9cbmV4cG9ydCBjb25zdCBlYXNlSW5PdXRTaW5lID0gKCB4ICkgPT4ge1xuXHRyZXR1cm4gLSggTWF0aC5jb3MoIE1hdGguUEkgKiB4ICkgLSAxICkgLyAyO1xufTtcblxuLyoqXG4gKiBFYXNlIE91dCBRdWFkXG4gKiBAcGFyYW0ge251bWJlcn0geFxuICogQHJldHVybiB7bnVtYmVyfVxuICovXG5leHBvcnQgY29uc3QgZWFzZU91dFF1YWQgPSAoIHggKSA9PiB7XG5cdHJldHVybiAxIC0gKCAxIC0geCApICogKCAxIC0geCApO1xufTtcblxuLyoqXG4gKiBTcGVjaWZ5IGEgZnVuY3Rpb24gdG8gZXhlY3V0ZSB3aGVuIHRoZSBET00gaXMgZnVsbHkgbG9hZGVkLlxuICpcbiAqIEBwYXJhbSB7Q2FsbGJhY2t9IGNhbGxiYWNrIEEgZnVuY3Rpb24gdG8gZXhlY3V0ZSBhZnRlciB0aGUgRE9NIGlzIHJlYWR5LlxuICogQHJldHVybiB7dm9pZH1cbiAqL1xuZXhwb3J0IGNvbnN0IGRvbVJlYWR5ID0gKCBjYWxsYmFjayApID0+IHtcblx0aWYgKCAndW5kZWZpbmVkJyA9PT0gdHlwZW9mIGRvY3VtZW50ICkge1xuXHRcdHJldHVybjtcblx0fVxuXG5cdGlmIChcblx0XHQnY29tcGxldGUnID09PSBkb2N1bWVudC5yZWFkeVN0YXRlIHx8IC8vIERPTUNvbnRlbnRMb2FkZWQgKyBJbWFnZXMvU3R5bGVzL2V0YyBsb2FkZWQsIHNvIHdlIGNhbGwgZGlyZWN0bHkuXG5cdFx0J2ludGVyYWN0aXZlJyA9PT0gZG9jdW1lbnQucmVhZHlTdGF0ZSAvLyBET01Db250ZW50TG9hZGVkIGZpcmVzIGF0IHRoaXMgcG9pbnQsIHNvIHdlIGNhbGwgZGlyZWN0bHkuXG5cdCkge1xuXHRcdHJldHVybiB2b2lkIGNhbGxiYWNrKCk7XG5cdH1cblxuXHQvLyBET01Db250ZW50TG9hZGVkIGhhcyBub3QgZmlyZWQgeWV0LCBkZWxheSBjYWxsYmFjayB1bnRpbCB0aGVuLlxuXHRkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCAnRE9NQ29udGVudExvYWRlZCcsIGNhbGxiYWNrICk7XG59O1xuXG4vKipcbiAqIERlYm91bmNlIGZ1bmN0aW9uXG4gKlxuICogQHBhcmFtICBmdW5jICAgIFRoZSBmdW5jdGlvbiB0byBhcHBseS5cbiAqIEBwYXJhbSAgdGltZW91dFxuICogQHJldHVybiB7KGZ1bmN0aW9uKC4uLlsqXSk6IHZvaWQpfCp9XG4gKi9cbmV4cG9ydCBjb25zdCBkZWJvdW5jZSA9ICggZnVuYywgdGltZW91dCA9IDUwMCApID0+IHtcblx0bGV0IHRpbWVyO1xuXHRyZXR1cm4gKCAuLi5hcmdzICkgPT4ge1xuXHRcdGNsZWFyVGltZW91dCggdGltZXIgKTtcblx0XHR0aW1lciA9IHNldFRpbWVvdXQoICgpID0+IHtcblx0XHRcdGZ1bmMuYXBwbHkoIHRoaXMsIGFyZ3MgKTtcblx0XHR9LCB0aW1lb3V0ICk7XG5cdH07XG59O1xuXG4vKipcbiAqIENvbnZlcnRzIEhFWCBjb2xvcnMgdG8gSFNMLlxuICpcbiAqIEBwYXJhbSAgY29sb3JcbiAqIEBwYXJhbSAgYXNBcnJheVxuICogQHJldHVybiB7c3RyaW5nIHwgQXJyYXl9XG4gKi9cbmV4cG9ydCBjb25zdCByZ2IyaHNsID0gKCBjb2xvciwgYXNBcnJheSA9IHRydWUgKSA9PiB7XG5cdGNvbnN0IHJnYiA9IGNvbG9yLnN1YnN0cmluZyggNCwgY29sb3IubGVuZ3RoIC0gMSApXG5cdFx0LnJlcGxhY2UoIC8gL2csICcnIClcblx0XHQuc3BsaXQoICcsJyApO1xuXG5cdGNvbnN0IHIgPSBwYXJzZUZsb2F0KCByZ2JbMF0pIC8gMjU1O1xuXHRjb25zdCBnID0gcGFyc2VGbG9hdCggcmdiWzFdKSAvIDI1NTtcblx0Y29uc3QgYiA9IHBhcnNlRmxvYXQoIHJnYlsyXSkgLyAyNTU7XG5cblx0Y29uc3QgbWF4ID0gTWF0aC5tYXgoIHIsIGcsIGIgKTtcblx0Y29uc3QgbWluID0gTWF0aC5taW4oIHIsIGcsIGIgKTtcblxuXHRsZXQgaCwgcztcblx0Y29uc3QgbCA9ICggbWF4ICsgbWluICkgLyAyO1xuXG5cdGlmICggbWF4ID09PSBtaW4gKSB7XG5cdFx0aCA9IHMgPSAwOyAvLyBhY2hyb21hdGljXG5cdH0gZWxzZSB7XG5cdFx0Y29uc3QgZCA9IG1heCAtIG1pbjtcblx0XHRzID0gMC41IDwgbCA/IGQgLyAoIDIgLSBtYXggLSBtaW4gKSA6IGQgLyAoIG1heCArIG1pbiApO1xuXG5cdFx0c3dpdGNoICggbWF4ICkge1xuXHRcdGNhc2UgcjogaCA9ICggZyAtIGIgKSAvIGQgKyAoIGcgPCBiID8gNiA6IDAgKTsgYnJlYWs7XG5cdFx0Y2FzZSBnOiBoID0gKCBiIC0gciApIC8gZCArIDI7IGJyZWFrO1xuXHRcdGNhc2UgYjogaCA9ICggciAtIGcgKSAvIGQgKyA0OyBicmVhaztcblx0XHR9XG5cblx0XHRoIC89IDY7XG5cdH1cblxuXHRpZiAoIGFzQXJyYXkgKSB7XG5cdFx0cmV0dXJuIFsgaCAqIDM2MCwgcyAqIDEwMCwgbCAqIDEwMCBdO1xuXHR9XG5cblx0cmV0dXJuIGBoc2woICR7aCAqIDM2MH0sICR7cyAqIDEwMH0sICR7bCAqIDEwMH0gKWA7XG59O1xuXG4vKipcbiAqXHRTY3JvbGxzIHRoZSBlbGVtZW50IGludG8gdmlldyBpZiBpdCdzIG5vdCBmdWxseSB2aXNpYmxlLlxuICpcbiAqIEBwYXJhbSB7SFRNTEVsZW1lbnR9IGVsZW1lbnQgVGhlIGVsZW1lbnQgdG8gc2Nyb2xsIGludG8gdmlldy5cbiAqIEBwYXJhbSB7Kn0gICAgICAgICAgIG9wdGlvbnMgVGhlIG9wdGlvbnMgZm9yIHRoZSBzY3JvbGxJbnRvVmlldyBtZXRob2QuXG4gKi9cbmV4cG9ydCBjb25zdCBzY3JvbGxJbnRvVmlld0lmTmVlZGVkID0gKCBlbGVtZW50LCBvcHRpb25zID0ge30pID0+IHtcblx0aWYgKCAhIGVsZW1lbnQgKSB7XG5cdFx0cmV0dXJuO1xuXHR9XG5cblx0Y29uc3QgcmVjdCA9IGVsZW1lbnQuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7XG5cdGNvbnN0IGlzRnVsbHlWaXNpYmxlID0gKFxuXHRcdDAgPD0gcmVjdC50b3AgJiZcblx0XHQwIDw9IHJlY3QubGVmdCAmJlxuXHRcdHJlY3QuYm90dG9tIDw9ICggd2luZG93LmlubmVySGVpZ2h0IHx8IGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5jbGllbnRIZWlnaHQgKSAmJlxuXHRcdHJlY3QucmlnaHQgPD0gKCB3aW5kb3cuaW5uZXJXaWR0aCB8fCBkb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuY2xpZW50V2lkdGggKVxuXHQpO1xuXG5cdGlmICggISBpc0Z1bGx5VmlzaWJsZSApIHtcblx0XHRlbGVtZW50LnNjcm9sbEludG9WaWV3KCBvcHRpb25zICk7XG5cdH1cbn07XG4iLCIvLyBUaGUgbW9kdWxlIGNhY2hlXG52YXIgX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fID0ge307XG5cbi8vIFRoZSByZXF1aXJlIGZ1bmN0aW9uXG5mdW5jdGlvbiBfX3dlYnBhY2tfcmVxdWlyZV9fKG1vZHVsZUlkKSB7XG5cdC8vIENoZWNrIGlmIG1vZHVsZSBpcyBpbiBjYWNoZVxuXHR2YXIgY2FjaGVkTW9kdWxlID0gX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fW21vZHVsZUlkXTtcblx0aWYgKGNhY2hlZE1vZHVsZSAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIGNhY2hlZE1vZHVsZS5leHBvcnRzO1xuXHR9XG5cdC8vIENyZWF0ZSBhIG5ldyBtb2R1bGUgKGFuZCBwdXQgaXQgaW50byB0aGUgY2FjaGUpXG5cdHZhciBtb2R1bGUgPSBfX3dlYnBhY2tfbW9kdWxlX2NhY2hlX19bbW9kdWxlSWRdID0ge1xuXHRcdC8vIG5vIG1vZHVsZS5pZCBuZWVkZWRcblx0XHQvLyBubyBtb2R1bGUubG9hZGVkIG5lZWRlZFxuXHRcdGV4cG9ydHM6IHt9XG5cdH07XG5cblx0Ly8gRXhlY3V0ZSB0aGUgbW9kdWxlIGZ1bmN0aW9uXG5cdF9fd2VicGFja19tb2R1bGVzX19bbW9kdWxlSWRdKG1vZHVsZSwgbW9kdWxlLmV4cG9ydHMsIF9fd2VicGFja19yZXF1aXJlX18pO1xuXG5cdC8vIFJldHVybiB0aGUgZXhwb3J0cyBvZiB0aGUgbW9kdWxlXG5cdHJldHVybiBtb2R1bGUuZXhwb3J0cztcbn1cblxuIiwiLy8gZGVmaW5lIGdldHRlciBmdW5jdGlvbnMgZm9yIGhhcm1vbnkgZXhwb3J0c1xuX193ZWJwYWNrX3JlcXVpcmVfXy5kID0gZnVuY3Rpb24oZXhwb3J0cywgZGVmaW5pdGlvbikge1xuXHRmb3IodmFyIGtleSBpbiBkZWZpbml0aW9uKSB7XG5cdFx0aWYoX193ZWJwYWNrX3JlcXVpcmVfXy5vKGRlZmluaXRpb24sIGtleSkgJiYgIV9fd2VicGFja19yZXF1aXJlX18ubyhleHBvcnRzLCBrZXkpKSB7XG5cdFx0XHRPYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywga2V5LCB7IGVudW1lcmFibGU6IHRydWUsIGdldDogZGVmaW5pdGlvbltrZXldIH0pO1xuXHRcdH1cblx0fVxufTsiLCJfX3dlYnBhY2tfcmVxdWlyZV9fLm8gPSBmdW5jdGlvbihvYmosIHByb3ApIHsgcmV0dXJuIE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChvYmosIHByb3ApOyB9IiwiLy8gZGVmaW5lIF9fZXNNb2R1bGUgb24gZXhwb3J0c1xuX193ZWJwYWNrX3JlcXVpcmVfXy5yID0gZnVuY3Rpb24oZXhwb3J0cykge1xuXHRpZih0eXBlb2YgU3ltYm9sICE9PSAndW5kZWZpbmVkJyAmJiBTeW1ib2wudG9TdHJpbmdUYWcpIHtcblx0XHRPYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgU3ltYm9sLnRvU3RyaW5nVGFnLCB7IHZhbHVlOiAnTW9kdWxlJyB9KTtcblx0fVxuXHRPYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgJ19fZXNNb2R1bGUnLCB7IHZhbHVlOiB0cnVlIH0pO1xufTsiLCIvKipcbiAqIFdvcmRQcmVzcyBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgZG9tUmVhZHkgfSBmcm9tICcuLi8uLi9oZWxwZXJzL2Zyb250ZW5kLWhlbHBlci1mdW5jdGlvbnMuanMnO1xuXG5kb21SZWFkeSggKCkgPT4ge1xuXHRjb25zdCBsb3R0aWVBbWluID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvckFsbCggJ2xvdHRpZS1wbGF5ZXIud3AtYmxvY2stdGhlbWVpc2xlLWJsb2Nrcy1sb3R0aWUnICk7XG5cdGNvbnN0IGRvdExvdHRpZUFuaW0gPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yQWxsKCAnZG90bG90dGllLXBsYXllci53cC1ibG9jay10aGVtZWlzbGUtYmxvY2tzLWxvdHRpZScgKTtcblxuXHRjb25zdCBpbml0QW5pbWF0aW9uID0gYW5pbWF0aW9uID0+IHtcblx0XHRpZiAoICdmYWxzZScgPT09IGFuaW1hdGlvbi5kYXRhc2V0Lmxvb3AgKSB7XG5cdFx0XHRhbmltYXRpb24uc2V0TG9vcGluZyggZmFsc2UgKTtcblx0XHR9XG5cblx0XHRpZiAoIC0xID09PSBhbmltYXRpb24uX19kaXJlY3Rpb24gKSB7XG5cdFx0XHRhbmltYXRpb24uc2VlayggJzEwMCUnICk7XG5cdFx0fVxuXG5cdFx0aWYgKCBCb29sZWFuKCBhbmltYXRpb24uX19jb3VudCApICkge1xuXHRcdFx0YW5pbWF0aW9uLl9fY291bnQgPSBhbmltYXRpb24uX19jb3VudCAtIDE7XG5cdFx0fVxuXG5cdFx0aWYgKCAtMSA9PT0gYW5pbWF0aW9uLl9fZGlyZWN0aW9uICYmICd0cnVlJyA9PT0gYW5pbWF0aW9uLmRhdGFzZXQubG9vcCApIHtcblx0XHRcdGFuaW1hdGlvbi5zZXRMb29waW5nKCB0cnVlICk7XG5cblx0XHRcdGlmICggQm9vbGVhbiggYW5pbWF0aW9uLl9fY291bnQgKSApIHtcblx0XHRcdFx0YW5pbWF0aW9uLmFkZEV2ZW50TGlzdGVuZXIoICdmcmFtZScsIGUgPT4ge1xuXHRcdFx0XHRcdGlmICggZS50YXJnZXQuZ2V0TG90dGllKCkucGxheUNvdW50ID09PSBhbmltYXRpb24uX19jb3VudCAmJiBlLnRhcmdldC5nZXRMb3R0aWUoKS5jdXJyZW50RnJhbWUgKSB7XG5cdFx0XHRcdFx0XHRhbmltYXRpb24uc3RvcCgpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSk7XG5cdFx0XHR9XG5cdFx0fVxuXHR9O1xuXG5cdGNvbnN0IGV2ZW50QW5pbSA9IGFuaW1hdGlvbiA9PiB7XG5cdFx0Y29uc3QgdHJpZ2dlciA9IGFuaW1hdGlvbi5nZXRBdHRyaWJ1dGUoICd0cmlnZ2VyJyApO1xuXHRcdGlmICggJ3Njcm9sbCcgPT09IHRyaWdnZXIgKSB7XG5cdFx0XHRyZXR1cm4gd2luZG93LkxvdHRpZUludGVyYWN0aXZpdHkuY3JlYXRlKHtcblx0XHRcdFx0bW9kZTogJ3Njcm9sbCcsXG5cdFx0XHRcdHBsYXllcjogYW5pbWF0aW9uLmdldExvdHRpZSgpLFxuXHRcdFx0XHRjb250YWluZXI6IGFuaW1hdGlvbixcblx0XHRcdFx0YWN0aW9uczogW3tcblx0XHRcdFx0XHR2aXNpYmlsaXR5OiBbIDAsIDEgXSxcblx0XHRcdFx0XHR0eXBlOiAnc2VlaycsXG5cdFx0XHRcdFx0ZnJhbWVzOiBbIDAsIGFuaW1hdGlvbi5nZXRMb3R0aWUoKS50b3RhbEZyYW1lcyBdXG5cdFx0XHRcdH1dXG5cdFx0XHR9KTtcblx0XHR9XG5cblx0XHRpZiAoICdob3ZlcicgPT09IHRyaWdnZXIgKSB7XG5cdFx0XHRhbmltYXRpb24uYWRkRXZlbnRMaXN0ZW5lciggJ21vdXNlb3ZlcicsICgpID0+IHtcblx0XHRcdFx0YW5pbWF0aW9uLnBsYXkoKTtcblx0XHRcdH0pO1xuXG5cdFx0XHRhbmltYXRpb24uYWRkRXZlbnRMaXN0ZW5lciggJ21vdXNlb3V0JywgKCkgPT4ge1xuXHRcdFx0XHRhbmltYXRpb24uc3RvcCgpO1xuXHRcdFx0fSk7XG5cblx0XHRcdGluaXRBbmltYXRpb24oIGFuaW1hdGlvbiApO1xuXHRcdFx0cmV0dXJuIC0xID09PSBhbmltYXRpb24uX19kaXJlY3Rpb24gPyBhbmltYXRpb24ucGF1c2UoKSA6IGFuaW1hdGlvbi5zdG9wKCk7XG5cdFx0fVxuXG5cdFx0aWYgKCAnY2xpY2snID09PSB0cmlnZ2VyICkge1xuXHRcdFx0YW5pbWF0aW9uLmFkZEV2ZW50TGlzdGVuZXIoICdjbGljaycsICgpID0+IHtcblx0XHRcdFx0YW5pbWF0aW9uLnBsYXkoKTtcblx0XHRcdH0pO1xuXG5cdFx0XHRhbmltYXRpb24uYWRkRXZlbnRMaXN0ZW5lciggJ2NvbXBsZXRlJywgKCkgPT4gYW5pbWF0aW9uLnN0b3AoKSApO1xuXHRcdFx0aW5pdEFuaW1hdGlvbiggYW5pbWF0aW9uICk7XG5cdFx0XHRyZXR1cm4gLTEgPT09IGFuaW1hdGlvbi5fX2RpcmVjdGlvbiA/IGFuaW1hdGlvbi5wYXVzZSgpIDogYW5pbWF0aW9uLnN0b3AoKTtcblx0XHR9XG5cblx0XHRyZXR1cm4gaW5pdEFuaW1hdGlvbiggYW5pbWF0aW9uICk7XG5cdH07XG5cblx0Y29uc3QgYWRkU3R5bGUgPSBhbmltYXRpb24gPT4ge1xuXHRcdGlmICggYW5pbWF0aW9uLmdldEF0dHJpYnV0ZSggJ3dpZHRoJyApICkge1xuXHRcdFx0YW5pbWF0aW9uLnN0eWxlLmhlaWdodCA9ICdhdXRvJztcblxuXHRcdFx0Y29uc3Qgd2lkdGggPSBhbmltYXRpb24uZ2V0QXR0cmlidXRlKCAnd2lkdGgnICk7XG5cdFx0XHRpZiAoICclJyA9PT0gd2lkdGgudG9TdHJpbmcoKS5zbGljZSggLTEgKSApIHtcblx0XHRcdFx0YW5pbWF0aW9uLnN0eWxlLm1heFdpZHRoID0gd2lkdGg7XG5cdFx0XHR9IGVsc2Uge1xuXHRcdFx0XHRhbmltYXRpb24uc3R5bGUud2lkdGggPSAoICdweCcgIT09IHdpZHRoLnRvU3RyaW5nKCkuc2xpY2UoIC0yICkgKSA/IGAke3dpZHRofXB4YCA6IHdpZHRoO1xuXHRcdFx0fVxuXHRcdH1cblx0fTtcblxuXHRsb3R0aWVBbWluLmZvckVhY2goIGFuaW1hdGlvbiA9PiB7XG5cdFx0YW5pbWF0aW9uLmFkZEV2ZW50TGlzdGVuZXIoICdsb2FkJywgZSA9PiB7XG5cdFx0XHRjb25zdCBhbmltYXRpb24gPSBlLnRhcmdldDtcblx0XHRcdGV2ZW50QW5pbSggYW5pbWF0aW9uICk7XG5cdFx0fSk7XG5cblx0XHRhZGRTdHlsZSggYW5pbWF0aW9uICk7XG5cdH0pO1xuXG5cdGRvdExvdHRpZUFuaW0uZm9yRWFjaCggYW5pbWF0aW9uID0+IHtcblx0XHRjb25zdCBpbnRlcnZhbCA9IHNldEludGVydmFsKCAoKSA9PiB7XG5cdFx0XHRpZiAoIGFuaW1hdGlvbi5sb2FkICkge1xuXHRcdFx0XHRhbmltYXRpb24ubG9hZCggYW5pbWF0aW9uLmRhdGFzZXQuc3JjICk/LnRoZW4oICgpID0+IHtcblx0XHRcdFx0XHRldmVudEFuaW0oIGFuaW1hdGlvbiApO1xuXHRcdFx0XHR9KTtcblxuXHRcdFx0XHRhZGRTdHlsZSggYW5pbWF0aW9uICk7XG5cdFx0XHRcdGNsZWFySW50ZXJ2YWwoIGludGVydmFsICk7XG5cdFx0XHR9XG5cdFx0fSwgMCApO1xuXHR9KTtcbn0pO1xuIl0sIm5hbWVzIjpbInJhbmdlIiwic3RhcnQiLCJlbmQiLCJzdGVwIiwidHlwZW9mU3RhcnQiLCJ0eXBlb2ZFbmQiLCJUeXBlRXJyb3IiLCJ1bmRlZmluZWQiLCJwdXNoIiwibGVuZ3RoIiwiY2hhckNvZGVBdCIsIlN0cmluZyIsImZyb21DaGFyQ29kZSIsImxpbmVhciIsIngiLCJlYXNlSW5TaW5lIiwiTWF0aCIsImNvcyIsIlBJIiwiZWFzZU91dFNpbmUiLCJzaW4iLCJlYXNlSW5PdXRTaW5lIiwiZWFzZU91dFF1YWQiLCJkb21SZWFkeSIsImNhbGxiYWNrIiwiZG9jdW1lbnQiLCJyZWFkeVN0YXRlIiwiYWRkRXZlbnRMaXN0ZW5lciIsImRlYm91bmNlIiwiZnVuYyIsInRpbWVvdXQiLCJ0aW1lciIsImFyZ3MiLCJjbGVhclRpbWVvdXQiLCJzZXRUaW1lb3V0IiwiYXBwbHkiLCJyZ2IyaHNsIiwiY29sb3IiLCJhc0FycmF5IiwicmdiIiwic3Vic3RyaW5nIiwicmVwbGFjZSIsInNwbGl0IiwiciIsInBhcnNlRmxvYXQiLCJnIiwiYiIsIm1heCIsIm1pbiIsImgiLCJzIiwibCIsImQiLCJzY3JvbGxJbnRvVmlld0lmTmVlZGVkIiwiZWxlbWVudCIsIm9wdGlvbnMiLCJyZWN0IiwiZ2V0Qm91bmRpbmdDbGllbnRSZWN0IiwiaXNGdWxseVZpc2libGUiLCJ0b3AiLCJsZWZ0IiwiYm90dG9tIiwid2luZG93IiwiaW5uZXJIZWlnaHQiLCJkb2N1bWVudEVsZW1lbnQiLCJjbGllbnRIZWlnaHQiLCJyaWdodCIsImlubmVyV2lkdGgiLCJjbGllbnRXaWR0aCIsInNjcm9sbEludG9WaWV3IiwibG90dGllQW1pbiIsInF1ZXJ5U2VsZWN0b3JBbGwiLCJkb3RMb3R0aWVBbmltIiwiaW5pdEFuaW1hdGlvbiIsImFuaW1hdGlvbiIsImRhdGFzZXQiLCJsb29wIiwic2V0TG9vcGluZyIsIl9fZGlyZWN0aW9uIiwic2VlayIsIkJvb2xlYW4iLCJfX2NvdW50IiwiZSIsInRhcmdldCIsImdldExvdHRpZSIsInBsYXlDb3VudCIsImN1cnJlbnRGcmFtZSIsInN0b3AiLCJldmVudEFuaW0iLCJ0cmlnZ2VyIiwiZ2V0QXR0cmlidXRlIiwiTG90dGllSW50ZXJhY3Rpdml0eSIsImNyZWF0ZSIsIm1vZGUiLCJwbGF5ZXIiLCJjb250YWluZXIiLCJhY3Rpb25zIiwidmlzaWJpbGl0eSIsInR5cGUiLCJmcmFtZXMiLCJ0b3RhbEZyYW1lcyIsInBsYXkiLCJwYXVzZSIsImFkZFN0eWxlIiwic3R5bGUiLCJoZWlnaHQiLCJ3aWR0aCIsInRvU3RyaW5nIiwic2xpY2UiLCJtYXhXaWR0aCIsImZvckVhY2giLCJpbnRlcnZhbCIsInNldEludGVydmFsIiwibG9hZCIsInNyYyIsInRoZW4iLCJjbGVhckludGVydmFsIl0sInNvdXJjZVJvb3QiOiIifQ==