/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ __webpack_exports__["default"] = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Icon));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close-small.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close-small.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies
 */


const closeSmall = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.Path, {
    d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
  })
});
/* harmony default export */ __webpack_exports__["default"] = (closeSmall);
//# sourceMappingURL=close-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies
 */


const plus = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.Path, {
    d: "M11 12.5V17.5H12.5V12.5H17.5V11H12.5V6H11V11H6V12.5H11Z"
  })
});
/* harmony default export */ __webpack_exports__["default"] = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/rotate-right.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies
 */


const rotateRight = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.Path, {
    d: "M15.1 4.8l-3-2.5V4c-4.4 0-8 3.6-8 8 0 3.7 2.5 6.9 6 7.7.3.1.6.1 1 .2l.2-1.5c-.4 0-.7-.1-1.1-.2l-.1.2v-.2c-2.6-.8-4.5-3.3-4.5-6.2 0-3.6 2.9-6.5 6.5-6.5v1.8l3-2.5zM20 11c-.2-1.4-.7-2.7-1.6-3.8l-1.2.8c.7.9 1.1 2 1.3 3.1L20 11zm-1.5 1.8c-.1.5-.2 1.1-.4 1.6s-.5 1-.8 1.5l1.2.9c.4-.5.8-1.1 1-1.8s.5-1.3.5-2l-1.5-.2zm-5.6 5.6l.2 1.5c1.4-.2 2.7-.7 3.8-1.6l-.9-1.1c-.9.7-2 1.1-3.1 1.2z"
  })
});
/* harmony default export */ __webpack_exports__["default"] = (rotateRight);
//# sourceMappingURL=rotate-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/trash.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/trash.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies
 */


const trash = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 5.5A2.25 2.25 0 0 0 9.878 7h4.244A2.251 2.251 0 0 0 12 5.5ZM12 4a3.751 3.751 0 0 0-3.675 3H5v1.5h1.27l.818 8.997a2.75 2.75 0 0 0 2.739 2.501h4.347a2.75 2.75 0 0 0 2.738-2.5L17.73 8.5H19V7h-3.325A3.751 3.751 0 0 0 12 4Zm4.224 4.5H7.776l.806 8.861a1.25 1.25 0 0 0 1.245 1.137h4.347a1.25 1.25 0 0 0 1.245-1.137l.805-8.861Z"
  })
});
/* harmony default export */ __webpack_exports__["default"] = (trash);
//# sourceMappingURL=trash.js.map

/***/ }),

/***/ "./node_modules/classnames/index.js":
/*!******************************************!*\
  !*** ./node_modules/classnames/index.js ***!
  \******************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = '';

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (arg) {
				classes = appendClass(classes, parseValue(arg));
			}
		}

		return classes;
	}

	function parseValue (arg) {
		if (typeof arg === 'string' || typeof arg === 'number') {
			return arg;
		}

		if (typeof arg !== 'object') {
			return '';
		}

		if (Array.isArray(arg)) {
			return classNames.apply(null, arg);
		}

		if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
			return arg.toString();
		}

		var classes = '';

		for (var key in arg) {
			if (hasOwn.call(arg, key) && arg[key]) {
				classes = appendClass(classes, key);
			}
		}

		return classes;
	}

	function appendClass (value, newClass) {
		if (!newClass) {
			return value;
		}
	
		if (value) {
			return value + ' ' + newClass;
		}
	
		return value + newClass;
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else // removed by dead control flow
{}
}());


/***/ }),

/***/ "./src/blocks/helpers/helper-functions.js":
/*!************************************************!*\
  !*** ./src/blocks/helpers/helper-functions.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _align: function() { return /* binding */ _align; },
/* harmony export */   _compactObject: function() { return /* binding */ _compactObject; },
/* harmony export */   _cssBlock: function() { return /* binding */ _cssBlock; },
/* harmony export */   _cssProp: function() { return /* binding */ _cssProp; },
/* harmony export */   _em: function() { return /* binding */ _em; },
/* harmony export */   _i: function() { return /* binding */ _i; },
/* harmony export */   _percent: function() { return /* binding */ _percent; },
/* harmony export */   _px: function() { return /* binding */ _px; },
/* harmony export */   _unit: function() { return /* binding */ _unit; },
/* harmony export */   boxToCSS: function() { return /* binding */ boxToCSS; },
/* harmony export */   boxValues: function() { return /* binding */ boxValues; },
/* harmony export */   buildResponsiveGetAttributes: function() { return /* binding */ buildResponsiveGetAttributes; },
/* harmony export */   buildResponsiveSetAttributes: function() { return /* binding */ buildResponsiveSetAttributes; },
/* harmony export */   changeActiveStyle: function() { return /* binding */ changeActiveStyle; },
/* harmony export */   compactObject: function() { return /* binding */ compactObject; },
/* harmony export */   convertToTitleCase: function() { return /* binding */ convertToTitleCase; },
/* harmony export */   decodeHTMLEntities: function() { return /* binding */ decodeHTMLEntities; },
/* harmony export */   findInnerBlocks: function() { return /* binding */ findInnerBlocks; },
/* harmony export */   formatDate: function() { return /* binding */ formatDate; },
/* harmony export */   getActiveStyle: function() { return /* binding */ getActiveStyle; },
/* harmony export */   getChoice: function() { return /* binding */ getChoice; },
/* harmony export */   getCustomPostTypeSlugs: function() { return /* binding */ getCustomPostTypeSlugs; },
/* harmony export */   getObjectFromQueryString: function() { return /* binding */ getObjectFromQueryString; },
/* harmony export */   getQueryStringFromObject: function() { return /* binding */ getQueryStringFromObject; },
/* harmony export */   getTimezone: function() { return /* binding */ getTimezone; },
/* harmony export */   hex2rgba: function() { return /* binding */ hex2rgba; },
/* harmony export */   insertBetweenItems: function() { return /* binding */ insertBetweenItems; },
/* harmony export */   isAppleOS: function() { return /* binding */ isAppleOS; },
/* harmony export */   isEmptyBox: function() { return /* binding */ isEmptyBox; },
/* harmony export */   isNullObject: function() { return /* binding */ isNullObject; },
/* harmony export */   isUndefinedObject: function() { return /* binding */ isUndefinedObject; },
/* harmony export */   lightnessFromColor: function() { return /* binding */ lightnessFromColor; },
/* harmony export */   mergeBoxDefaultValues: function() { return /* binding */ mergeBoxDefaultValues; },
/* harmony export */   numberToBox: function() { return /* binding */ numberToBox; },
/* harmony export */   objectOrNumberAsBox: function() { return /* binding */ objectOrNumberAsBox; },
/* harmony export */   pullSavedState: function() { return /* binding */ pullSavedState; },
/* harmony export */   removeBoxDefaultValues: function() { return /* binding */ removeBoxDefaultValues; },
/* harmony export */   renderBoxOrNumWithUnit: function() { return /* binding */ renderBoxOrNumWithUnit; },
/* harmony export */   setSavedState: function() { return /* binding */ setSavedState; },
/* harmony export */   setUtm: function() { return /* binding */ setUtm; },
/* harmony export */   stringToBox: function() { return /* binding */ stringToBox; },
/* harmony export */   unescapeHTML: function() { return /* binding */ unescapeHTML; }
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/date */ "@wordpress/date");
/* harmony import */ var _wordpress_date__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_date__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _plugins_copy_paste_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../plugins/copy-paste/utils */ "./src/blocks/plugins/copy-paste/utils.ts");





// Post types to exclude
const excludedTypes = ['wp_template', 'wp_template_part', 'wp_navigation', 'nav_menu_item', 'wp_block', 'attachment', 'sfwd-certificates', 'e-landing-page', 'piotnetforms-book', 'piotnetforms', 'piotnetforms-data', 'jet-menu', 'jet-popup', 'adsforwp-groups', 'pgc_simply_gallery', 'editor-story', 'pafe-form-booking', 'sfwd-assignment', 'sfwd-essays', 'pafe-formabandonment', 'frm_display', 'sfwd-transactions', 'jet-engine', 'jet-theme-core', 'reply', 'jet_options_preset', 'tutor_assignments', 'brizy_template', 'jet-smart-filters', 'pafe-fonts', 'pafe-form-database', 'ct_content_block', 'adsforwp', 'iamport_payment', 'tribe_events', 'mec_esb', 'elementor_library', 'testimonial', 'zion_template', 'popup', 'jet-engine-booking', 'tutor_quiz', 'piotnetforms-aban', 'forum', 'topic', 'sfwd-quiz', 'mec-events', 'jet-woo-builder', 'neve_custom_layouts', 'feedzy_imports', 'neve_cart_notices', 'visualizer'];

/**
 * HTML to Plaintext
 *
 * @param {HTMLElement} value
 * @return {*}
 */
const unescapeHTML = value => {
  const htmlNode = document.createElement('div');
  htmlNode.innerHTML = value;
  if (htmlNode.innerText !== undefined) {
    return htmlNode.innerText;
  }
  return htmlNode.textContent;
};

/**
 * Decode HTML entities.
 * @param  value
 * @return {string}
 */
const decodeHTMLEntities = value => {
  const textArea = document.createElement('textarea');
  textArea.innerHTML = value;
  return textArea.value;
};

/**
 * Format the date.
 *
 * @param {Date} date
 * @return {string}
 */
const formatDate = date => {
  const monthNames = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
  date = new Date(date);
  const day = date.getDate();
  const monthIndex = date.getMonth();
  const year = date.getFullYear();
  return day + ' ' + monthNames[monthIndex] + ', ' + year;
};

/**
 * Get the custom post types from the post.
 *
 * @return {Promise<undefined|*>}
 */
const getCustomPostTypeSlugs = async () => {
  const dataTypes = window.themeisleGutenberg.postTypes;
  if (dataTypes) {
    const allExistingSlugs = Object.keys(dataTypes);
    return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.without)(allExistingSlugs, ...excludedTypes);
  }
  return undefined;
};

/**
 * Convert a word to title case.
 *
 * @param {string} word
 * @return {string}
 */
const convertToTitleCase = word => {
  if ('string' === typeof word || word instanceof String) {
    return word[0].toUpperCase() + word.slice(1);
  }
  throw 'The parameter must be a string.';
};

/**
 * Insert an item between the element of the array
 *
 * @param {Array} arr
 * @param {any}   item
 * @return An array with the given item inserted between initial elements
 */
const insertBetweenItems = (arr, item) => {
  const _arr = [];
  arr?.forEach((listItem, index) => {
    _arr.push(listItem);

    // Omit to add for the last list item
    if (index < arr.length - 1) {
      _arr.push(item);
    }
  });
  return _arr;
};

/**
 * Get site's timezone.
 *
 * @return {*}
 */
const getTimezone = () => {
  const settings = (0,_wordpress_date__WEBPACK_IMPORTED_MODULE_2__.__experimentalGetSettings)();
  const offset = 60 * settings.timezone.offset;
  const sign = 0 > offset ? '-' : '+';
  const absmin = Math.abs(offset);
  const timezone = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)('%1$s%2$02d:%3$02d', sign, absmin / 60, absmin % 60);
  return timezone;
};

/**
 * Check if object has only null values.
 *
 * @param  obj
 * @return {boolean}
 */
const isNullObject = obj => !Object.keys(obj).some(k => null !== obj[k]);

/**
 * Check if object has only undefined values.
 *
 * @param  obj
 * @return {this is unknown[]}
 */
const isUndefinedObject = obj => Object.values(obj).every(l => l === undefined);

/*
 +-------------------------------- CSS Utility functions --------------------------------+
*/

/**
 * Format the value based on the given unit.
 *
 * @param {number} value
 * @param {string} unit
 * @return {string|undefined}
 */
const _unit = (value, unit) => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNumber)(value) ? value + unit : value;

/**
 * Format the value into a `px` unit.
 *
 * @param {any} value The value.
 * @return {string|undefined}
 */
const _px = value => _unit(value, 'px');

/**
 * Format the value into a `em` unit.
 *
 * @param {any} value The value.
 * @return {string|undefined}
 */
const _em = value => _unit(value, 'em');

/**
 * Format the value into a `%` unit.
 *
 * @param {any} value The value.
 * @return {string|undefined}
 */
const _percent = value => _unit(value, '%');

/**
 * Make a box type from a number or an object with Box like props.
 * @param {Object|number|undefined}     value
 * @param {import('./blocks').BoxType?} defaultValue
 * @return {import('./blocks').BoxType}
 */
const objectOrNumberAsBox = (value, defaultValue = undefined) => {
  if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNumber)(value)) {
    return (0,_plugins_copy_paste_utils__WEBPACK_IMPORTED_MODULE_3__.makeBox)(_px(value));
  }
  if (value === undefined) {
    return defaultValue;
  }
  return {
    top: value?.top,
    bottom: value?.bottom,
    right: value?.right,
    left: value?.left
  };
};
const verticalMapping = {
  'top': 'flex-start',
  'left': 'flex-start',
  'center': 'center',
  'bottom': 'flex-end',
  'right': 'flex-end'
};

/**
 * Get the CSS value for the given value position.
 *
 * @param {string} value The position type.
 * @return {string|undefined}
 */
const _align = value => {
  return verticalMapping[value];
};

/**
 * Get parameter from the URL.
 * @param queryString
 */
const getObjectFromQueryString = queryString => {
  if (-1 < queryString.indexOf('?')) {
    queryString = queryString.split('?')[1];
  }
  const pairs = queryString.split('&');
  const result = {};
  pairs.forEach(function (pair) {
    pair = pair.split('=');
    if ('' !== pair[0]) {
      result[pair[0]] = decodeURIComponent(pair[1] || '');
    }
  });
  return result;
};

/**
 * Object to Query String.
 * @param params
 */
const getQueryStringFromObject = params => Object.keys(params).map(key => key + '=' + params[key]).join('&');

/**
 * Return the value of pair [condition, value] which has the first true condition.
 *
 * @param {([bool, any]|[any])[]} arr
 * @return {*}
 */
const getChoice = arr => {
  var _r$;
  const r = arr?.filter(x => x?.[0])?.[0];
  return (_r$ = r?.[1]) !== null && _r$ !== void 0 ? _r$ : r?.[0];
};

/**
 * Converts HEX colors to RGBA.
 *
 * @param  color
 * @param  alpha
 * @return {string}
 */
const hex2rgba = (color, alpha = 100) => {
  if (!color) {
    color = '#000000';
  }
  if ('#' !== color[0]) {
    return color;
  }
  const [r, g, b] = color.match(/\w\w/g).map(x => parseInt(x, 16));
  return `rgba(${r},${g},${b},${alpha / 100})`;
};

/**
 * Check if color is a dark.
 *
 * @param  color
 * @return {string|boolean}
 */
const lightnessFromColor = color => {
  if (!color) {
    return false;
  }
  let value = color;
  if (color.startsWith('var(')) {
    value = getComputedStyle(document.documentElement).getPropertyValue(color.slice(4, -1)).trim();
  }

  // Convert hex to RGB if necessary
  if (value.startsWith('#')) {
    value = hex2rgba(value);
  }
  if (!Boolean(value)) {
    return false;
  }

  // Extract the red, green, and blue values
  const [r, g, b] = value.match(/\d+/g).map(Number);

  // Calculate the brightness value
  const brightness = 0.299 * r + 0.587 * g + 0.114 * b;

  // Compare the brightness to a threshold
  return 128 > brightness ? 'dark' : 'light';
};

/**
 * Return the values from a box type.
 *
 * @param {import('./blocks').BoxType?} box
 * @param {import('./blocks').BoxType?} defaultBox
 * @return {string}
 */
const boxValues = (box = {}, defaultBox = {}) => {
  var _ref, _box$top, _ref2, _box$right, _ref3, _box$bottom, _ref4, _box$left;
  box !== null && box !== void 0 ? box : box = {};
  return `${(_ref = (_box$top = box?.top) !== null && _box$top !== void 0 ? _box$top : defaultBox?.top) !== null && _ref !== void 0 ? _ref : '0px'} ${(_ref2 = (_box$right = box?.right) !== null && _box$right !== void 0 ? _box$right : defaultBox?.right) !== null && _ref2 !== void 0 ? _ref2 : '0px'} ${(_ref3 = (_box$bottom = box?.bottom) !== null && _box$bottom !== void 0 ? _box$bottom : defaultBox?.bottom) !== null && _ref3 !== void 0 ? _ref3 : '0px'} ${(_ref4 = (_box$left = box?.left) !== null && _box$left !== void 0 ? _box$left : defaultBox?.left) !== null && _ref4 !== void 0 ? _ref4 : '0px'}`;
};

/**
 * Remove the default values from Box object.
 *
 * @param {import('./blocks').BoxType} box
 * @param {import('./blocks').BoxType} defaultBox
 * @return {import('./blocks').BoxType}
 */
const removeBoxDefaultValues = (box, defaultBox) => {
  if (defaultBox === undefined || (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEmpty)(defaultBox)) {
    return box;
  }
  const cleaned = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.omitBy)(box, (value, key) => value === defaultBox?.[key]);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEmpty)(cleaned) ? undefined : cleaned;
};

/**
 * Merge the Box objects.
 *
 * @param {import('./blocks').BoxType?} box
 * @param {import('./blocks').BoxType?} defaultBox
 * @return {import('./blocks').BoxType}
 */
const mergeBoxDefaultValues = (box, defaultBox) => {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.merge)({
    left: '0px',
    right: '0px',
    bottom: '0px',
    top: '0px'
  }, defaultBox, box);
};
const mapViewToKey = {
  'Desktop': 0,
  'Tablet': 1,
  'Mobile': 2
};

/**
 * Helper function to add proper utm.
 * @param {string} urlAddress Url to add utms.
 * @param {string} linkArea   Descriptive name of the link
 * @param {string} content    Content of the link
 * @return {string}
 */
const setUtm = (urlAddress, linkArea, content) => {
  const urlLink = new URL(urlAddress);
  urlLink.searchParams.set('utm_campaign', linkArea);
  if (content) {
    urlLink.searchParams.set('utm_content', content);
  }
  return urlLink.toString();
};

/**
 * Build a responsive wrapper around `setAttributes`
 *
 * @param {Function}                    setAttributes The function that set the attributes.
 * @param {'Desktop'|'Tablet'|'Mobile'} currentView   The current view.
 * @template T
 * @return {(value: T, keys: string[], oldAttr: Object) => void}) => void}
 */
const buildResponsiveSetAttributes = (setAttributes, currentView) => {
  return (value, keys, oldAttr = {}) => {
    var _mapViewToKey$current, _mapViewToKey$current2;
    const attrName = keys[(_mapViewToKey$current = mapViewToKey[currentView]) !== null && _mapViewToKey$current !== void 0 ? _mapViewToKey$current : 0]?.split('.')[0];
    const attr = {
      [attrName]: {
        ...oldAttr
      }
    };
    (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(attr, keys[(_mapViewToKey$current2 = mapViewToKey[currentView]) !== null && _mapViewToKey$current2 !== void 0 ? _mapViewToKey$current2 : 0], value);
    setAttributes('object' === typeof attr[attrName] && (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEmpty)(attr[attrName]) ? {
      [attrName]: undefined
    } : attr);
  };
};

/**
 * Build a responsive wrapper around current view to choose a value.
 *
 * @param {'Desktop'|'Tablet'|'Mobile'} currentView The current view.
 * @param {'Desktop'|'Tablet'|'Mobile'} defaultView If the value of the current view is undefined or null, fallback to this view.
 * @param {boolean}                     cascade     Inherit from previous view. Mobile from Tablet, Tablet from Desktop.
 * @template T
 * @return { (values: T[]) => T}
 */
const buildResponsiveGetAttributes = (currentView, defaultView = 'Desktop', cascade = true) => {
  return values => {
    var _values$mapViewToKey$;
    if (cascade && !values?.[mapViewToKey[currentView]] && currentView !== defaultView) {
      var _values;
      return (_values = values?.[mapViewToKey[currentView] - 1]) !== null && _values !== void 0 ? _values : values?.[mapViewToKey[currentView] - 2];
    }
    return (_values$mapViewToKey$ = values?.[mapViewToKey[currentView]]) !== null && _values$mapViewToKey$ !== void 0 ? _values$mapViewToKey$ : values?.[mapViewToKey[defaultView]];
  };
};

/**
 * Get Active Style Name.
 *
 * @param { import('./blocks').BlockStyle[] } styles    Block styles.
 * @param { string | undefined }              className Classes of the block.
 *
 * @return { string }
 */
const getActiveStyle = (styles, className) => {
  const classes = className?.split(' ') || [];
  const styleValues = styles.map(i => i.value);
  const defaultValue = styles.find(i => i.isDefault)?.value || '';
  for (const style of classes) {
    if (-1 === style.indexOf('is-style-')) {
      continue;
    }
    const potentialStyleName = style.substring(9);
    if (-1 < styleValues.indexOf(potentialStyleName)) {
      return potentialStyleName;
    }
  }
  return defaultValue;
};

/**
 * Replaces the active style in the block's className.
 *
 * @param { string | undefined } className Class name.
 * @param { Object }             styles    Block styles.
 * @param { string | undefined } newStyle  The replacing style.
 *
 * @return { string } The updated className.
 */
const changeActiveStyle = (className, styles, newStyle) => {
  const classes = className?.split(' ') || [];
  const activeStyle = getActiveStyle(styles, className);
  const defaultValue = styles.find(i => i.isDefault)?.value || '';
  if (activeStyle && -1 < classes.indexOf(`is-style-${activeStyle}`)) {
    classes.splice(classes.indexOf(`is-style-${activeStyle}`), 1);
  }
  if (newStyle && newStyle !== defaultValue) {
    classes.push(`is-style-${newStyle}`);
  }
  return classes.join(' ');
};

/**
 * Create a CSS property declaration.
 * @param {string}                                        prop      The name of the property.
 * @param {string | undefined | null}                     value     The value.
 * @param { ((c: any) => boolean) | boolean | undefined } condition The condition.
 * @return
 */
const _cssProp = (prop, value, condition = undefined) => value !== undefined && null !== value && (condition === undefined || ('function' === typeof condition ? condition(value) : condition)) ? `${prop}: ${value};` : undefined;

/**
 * Create a CSS block declaration.
 * @param {[string, string, ((c: any) => boolean | boolean | undefined) | undefined][]} propsPairs The properties grouped in pairs
 * @return
 */
const _cssBlock = propsPairs => {
  var _propsPairs$map$filte;
  return `{\n${(_propsPairs$map$filte = propsPairs?.map(pair => _cssProp(pair?.[0], pair?.[1], pair?.[2]))?.filter(x => x !== undefined)?.join('\n')) !== null && _propsPairs$map$filte !== void 0 ? _propsPairs$map$filte : ''} \n}`;
};

/**
 * Wrap a given string in a box object.
 * @param {string|any} s The value.
 * @return {import('./blocks').BoxType|any}
 */
const stringToBox = s => {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isString)(s)) {
    return s;
  }
  return {
    top: s,
    bottom: s,
    right: s,
    left: s
  };
};

/**
 * Make a box intro a CSS string. If it is a string, wrap it into a box.
 * @param {string|import('./blocks').BoxType | undefined} box The box.
 * @return
 */
const boxToCSS = box => {
  if (box === undefined) {
    return undefined;
  }
  const _box = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isString)(box) ? mergeBoxDefaultValues(stringToBox(box)) : mergeBoxDefaultValues(box);
  return `${_box.top} ${_box.right} ${_box.bottom} ${_box.left}`;
};

/**
 * Print the given value then return it. Usefull for debugging.
 * @param {any} x
 * @return
 */
const _i = x => {
  console.log(x);
  return x;
};

/**
 * Helper function to remove empty props objects recursivly in a distructive way.
 * @param {Object} o The object.
 * @return {Object | undefined}
 */
const _compactObject = o => {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isObjectLike)(o)) {
    return o;
  }
  for (const p in o) {
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isObjectLike)(o[p])) {
      o[p] = compactObject(o[p]);
    }
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNil)(o[p])) {
      delete o[p];
    }
  }
  if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEmpty)(o)) {
    return undefined;
  }
  return o;
};

/**
 * Remove empty props objects recursivly.
 * @param {Object} o The object.
 * @return {Object | undefined}
 */
const compactObject = o => {
  return _compactObject((0,lodash__WEBPACK_IMPORTED_MODULE_0__.cloneDeep)(o));
};

/**
 * Utility function for rendering to CSS legacy value that were numbers before converting it to a box value type.
 * @param {string|import('./blocks').BoxType | number | undefined} box  The box to render.
 * @param {string}                                                 unit The unit to add if the box is a number.
 * @return
 */
const renderBoxOrNumWithUnit = (box, unit) => {
  if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNumber)(box)) {
    return boxToCSS(_unit(box, unit));
  }
  return boxToCSS(box);
};

/**
 * If the given value is a number, transform it into a Box Value with the given unit. Otherwise, return the value.
 *
 * @param {number | any} x    The number to convert.
 * @param {string?}      unit The unit to add.
 * @return {import('./blocks').BoxType | any} The box value or given value.
 */
const numberToBox = (x, unit = 'px') => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNumber)(x) ? stringToBox(_unit(x, unit)) : x;

/**
 * Return true if platform is MacOS.
 *
 * @param {Window?} _window window object by default; used for DI testing.
 *
 * @return {boolean} True if MacOS; false otherwise.
 */
function isAppleOS(_window = null) {
  if (!_window) {
    if ('undefined' === typeof window) {
      return false;
    }
    _window = window;
  }
  const {
    platform
  } = _window.navigator;
  return -1 !== platform.indexOf('Mac') || ['iPad', 'iPhone'].includes(platform);
}

/**
 * Check if a box value is empty.
 *
 * @param {import('./blocks').BoxType | undefined} box The box.
 * @return {boolean}
 */
const isEmptyBox = box => {
  return !(box?.top !== undefined && box?.right !== undefined && box?.bottom !== undefined && box?.left !== undefined);
};

/**
 * Get the saved state for the given key from global scope (window).
 *
 * @param {string} key
 * @param {any}    defaultValue
 * @return
 */
const pullSavedState = (key, defaultValue) => {
  var _window$oSavedStates$;
  if (key === undefined) {
    return defaultValue;
  }
  return (_window$oSavedStates$ = window.oSavedStates?.[key]) !== null && _window$oSavedStates$ !== void 0 ? _window$oSavedStates$ : defaultValue;
};

/**
 * Save a value in global scope (window) for the given key.
 *
 * @param {string} key
 * @param {any}    value
 * @return {void}
 */
const setSavedState = (key, value) => {
  var _window$oSavedStates;
  if (key === undefined) {
    return;
  }
  window.oSavedStates = (_window$oSavedStates = window.oSavedStates) !== null && _window$oSavedStates !== void 0 ? _window$oSavedStates : {};
  window.oSavedStates[key] = value;
};

/**
 * Find the blocks that match the given condition.
 *
 * @param {import('./blocks').OtterBlock<unknown>[]}                   innerBlocks      The inner blocks.
 * @param {(block: import('./blocks').OtterBlock<unknown>) => boolean} condition        The condition.
 * @param {(block: import('./blocks').OtterBlock<unknown>) => boolean} nestingCondition The condition that allow to go deeper in the tree.
 * @return {import('./blocks').OtterBlock<unknown>[]} The blocks that match the condition.
 */
const findInnerBlocks = (innerBlocks, condition, nestingCondition = x => x) => {
  if (innerBlocks === undefined || condition === undefined) {
    return [];
  }
  let found = [];
  for (const block of innerBlocks) {
    if (condition(block)) {
      found.push(block);
    }
    if (nestingCondition(block)) {
      found = found.concat(findInnerBlocks(block?.innerBlocks, condition));
    }
  }
  return found;
};

/***/ }),

/***/ "./src/blocks/helpers/icons.js":
/*!*************************************!*\
  !*** ./src/blocks/helpers/icons.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StarFilled: function() { return /* binding */ StarFilled; },
/* harmony export */   StarHalf: function() { return /* binding */ StarHalf; },
/* harmony export */   accordionIcon: function() { return /* binding */ accordionIcon; },
/* harmony export */   accordionItemIcon: function() { return /* binding */ accordionItemIcon; },
/* harmony export */   aiGeneration: function() { return /* binding */ aiGeneration; },
/* harmony export */   aiLayoutGeneratorIcon: function() { return /* binding */ aiLayoutGeneratorIcon; },
/* harmony export */   alignBottom: function() { return /* binding */ alignBottom; },
/* harmony export */   alignCenter: function() { return /* binding */ alignCenter; },
/* harmony export */   alignTop: function() { return /* binding */ alignTop; },
/* harmony export */   businessHoursIcon: function() { return /* binding */ businessHoursIcon; },
/* harmony export */   buttonIcon: function() { return /* binding */ buttonIcon; },
/* harmony export */   buttonsIcon: function() { return /* binding */ buttonsIcon; },
/* harmony export */   cartIcon: function() { return /* binding */ cartIcon; },
/* harmony export */   check: function() { return /* binding */ check; },
/* harmony export */   circleIcon: function() { return /* binding */ circleIcon; },
/* harmony export */   close: function() { return /* binding */ close; },
/* harmony export */   cols112: function() { return /* binding */ cols112; },
/* harmony export */   cols12: function() { return /* binding */ cols12; },
/* harmony export */   cols121: function() { return /* binding */ cols121; },
/* harmony export */   cols131: function() { return /* binding */ cols131; },
/* harmony export */   cols21: function() { return /* binding */ cols21; },
/* harmony export */   cols211: function() { return /* binding */ cols211; },
/* harmony export */   cols2Equal: function() { return /* binding */ cols2Equal; },
/* harmony export */   cols2Grid: function() { return /* binding */ cols2Grid; },
/* harmony export */   cols3Equal: function() { return /* binding */ cols3Equal; },
/* harmony export */   cols3Grid: function() { return /* binding */ cols3Grid; },
/* harmony export */   cols4Equal: function() { return /* binding */ cols4Equal; },
/* harmony export */   cols5Equal: function() { return /* binding */ cols5Equal; },
/* harmony export */   cols6Equal: function() { return /* binding */ cols6Equal; },
/* harmony export */   colsCollapsed: function() { return /* binding */ colsCollapsed; },
/* harmony export */   colsFull: function() { return /* binding */ colsFull; },
/* harmony export */   columnIcon: function() { return /* binding */ columnIcon; },
/* harmony export */   columnsIcon: function() { return /* binding */ columnsIcon; },
/* harmony export */   comparisonTableIcon: function() { return /* binding */ comparisonTableIcon; },
/* harmony export */   contentAiGenerationIcon: function() { return /* binding */ contentAiGenerationIcon; },
/* harmony export */   countdownIcon: function() { return /* binding */ countdownIcon; },
/* harmony export */   faIcon: function() { return /* binding */ faIcon; },
/* harmony export */   flipIcon: function() { return /* binding */ flipIcon; },
/* harmony export */   formAiGeneration: function() { return /* binding */ formAiGeneration; },
/* harmony export */   formFieldIcon: function() { return /* binding */ formFieldIcon; },
/* harmony export */   formIcon: function() { return /* binding */ formIcon; },
/* harmony export */   googleMapIcon: function() { return /* binding */ googleMapIcon; },
/* harmony export */   headingIcon: function() { return /* binding */ headingIcon; },
/* harmony export */   heartFilledIcon: function() { return /* binding */ heartFilledIcon; },
/* harmony export */   heartIcon: function() { return /* binding */ heartIcon; },
/* harmony export */   iconListIcon: function() { return /* binding */ iconListIcon; },
/* harmony export */   iconListItemIcon: function() { return /* binding */ iconListItemIcon; },
/* harmony export */   lottieIcon: function() { return /* binding */ lottieIcon; },
/* harmony export */   mapIcon: function() { return /* binding */ mapIcon; },
/* harmony export */   otterIcon: function() { return /* binding */ otterIcon; },
/* harmony export */   otterIconColored: function() { return /* binding */ otterIconColored; },
/* harmony export */   popupIcon: function() { return /* binding */ popupIcon; },
/* harmony export */   popupScratch: function() { return /* binding */ popupScratch; },
/* harmony export */   popupWithForm: function() { return /* binding */ popupWithForm; },
/* harmony export */   popupWithImageAndText: function() { return /* binding */ popupWithImageAndText; },
/* harmony export */   postsIcon: function() { return /* binding */ postsIcon; },
/* harmony export */   progressIcon: function() { return /* binding */ progressIcon; },
/* harmony export */   reviewIcon: function() { return /* binding */ reviewIcon; },
/* harmony export */   rowsCollapsed: function() { return /* binding */ rowsCollapsed; },
/* harmony export */   searchIcon: function() { return /* binding */ searchIcon; },
/* harmony export */   sharingIcon: function() { return /* binding */ sharingIcon; },
/* harmony export */   sliderIcon: function() { return /* binding */ sliderIcon; },
/* harmony export */   tabsIcon: function() { return /* binding */ tabsIcon; },
/* harmony export */   tabsItemIcon: function() { return /* binding */ tabsItemIcon; },
/* harmony export */   timelineIcon: function() { return /* binding */ timelineIcon; }
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



const otterIcon = ({
  className
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 29 32",
    width: "20",
    height: "20",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('otter-icon', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M19.831 7.877c0.001-0.003 0.001-0.005 0.001-0.009s-0-0.006-0.001-0.009l0 0c-0.047-0.081-0.092-0.164-0.132-0.247l-0.057-0.115c-0.277-0.498-0.381-0.99-1.033-1.064h-0.045c-0.001 0-0.002 0-0.003 0-0.486 0-0.883 0.382-0.908 0.862l-0 0.002c0.674 0.126 1.252 0.278 1.813 0.468l-0.092-0.027 0.283 0.096 0.147 0.053s0.028 0 0.028-0.011z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M23.982 13.574c-0.008-2.41-0.14-4.778-0.39-7.112l0.026 0.299 0.070-0.019c0.459-0.139 0.787-0.558 0.787-1.053 0-0.479-0.307-0.887-0.735-1.037l-0.008-0.002h-0.026c-0.479-0.164-0.874-0.468-1.149-0.861l-0.005-0.007c-2.7-3.96-8.252-3.781-8.252-3.781s-5.55-0.179-8.25 3.781c-0.28 0.401-0.676 0.704-1.14 0.862l-0.016 0.005c-0.441 0.148-0.754 0.557-0.754 1.040 0 0.009 0 0.017 0 0.026l-0-0.001c-0 0.010-0.001 0.022-0.001 0.034 0 0.493 0.335 0.907 0.789 1.029l0.007 0.002 0.045 0.011c-0.224 2.034-0.356 4.403-0.364 6.801l-0 0.012s-9.493 13.012-1.277 17.515c4.733 2.431 6.881-0.769 6.881-0.769s1.397-1.661-1.784-3.355v-4.609c0.006-0.344 0.282-0.621 0.625-0.628h1.212v-0.59c0-0.275 0.223-0.498 0.498-0.498v0h1.665c0.274 0.001 0.496 0.224 0.496 0.498 0 0 0 0 0 0v0 0.59h2.721v-0.59c0-0.275 0.223-0.498 0.498-0.498v0h1.665c0.271 0.005 0.49 0.226 0.49 0.498 0 0 0 0 0 0v0 0.59h1.209c0 0 0 0 0 0 0.349 0 0.633 0.28 0.639 0.627v4.584c-3.193 1.703-1.784 3.355-1.784 3.355s2.148 3.193 6.879 0.769c8.222-4.503-1.269-17.515-1.269-17.515zM22.586 10.261c-0.097 1.461-0.67 2.772-1.563 3.797l0.007-0.008c-1.703 2.010-4.407 3.249-6.721 4.432v0c-2.325-1.177-5.026-2.416-6.736-4.432-0.883-1.019-1.455-2.329-1.555-3.769l-0.001-0.020c-0.126-2.22 0.583-5.929 3.044-6.74 2.416-0.788 3.947 1.288 4.494 2.227 0.152 0.258 0.429 0.428 0.745 0.428s0.593-0.17 0.743-0.424l0.002-0.004c0.551-0.932 2.080-3.008 4.494-2.22 2.474 0.805 3.174 4.513 3.046 6.734z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M19.463 10.087h-0.028c-0.192 0.026-0.121 0.251-0.047 0.356 0.254 0.349 0.407 0.787 0.407 1.26 0 0.006-0 0.012-0 0.018v-0.001c-0.001 0.469-0.255 0.878-0.633 1.1l-0.006 0.003c-0.739 0.426-1.377-0.145-2.054-0.398-0.72-0.269-1.552-0.434-2.42-0.455l-0.009-0v-1.033c1.020-0.233 1.894-0.76 2.551-1.486l0.004-0.004c0.151-0.163 0.244-0.383 0.244-0.623 0-0.316-0.159-0.595-0.402-0.76l-0.003-0.002c-0.768-0.551-1.728-0.881-2.764-0.881-1.054 0-2.029 0.341-2.819 0.92l0.013-0.009c-0.224 0.166-0.367 0.429-0.367 0.726 0 0.226 0.083 0.433 0.221 0.591l-0.001-0.001c0.665 0.751 1.55 1.295 2.553 1.53l0.033 0.007v1.050c-0.742 0.021-1.448 0.14-2.118 0.343l0.057-0.015c-0.341 0.103-0.631 0.219-0.908 0.358l0.033-0.015c-0.519 0.26-1.037 0.436-1.58 0.121-0.371-0.213-0.617-0.607-0.617-1.058 0-0.002 0-0.004 0-0.007v0c0-0.002 0-0.004 0-0.007 0-0.47 0.153-0.905 0.411-1.257l-0.004 0.006c0.047-0.068 0.089-0.17 0.026-0.241s-0.189 0-0.27 0.030c-0.189 0.099-0.348 0.227-0.479 0.381l-0.002 0.002c-0.245 0.296-0.394 0.679-0.394 1.097 0 0.004 0 0.007 0 0.011v-0.001c0.008 0.706 0.393 1.321 0.964 1.651l0.009 0.005c0.296 0.178 0.654 0.283 1.036 0.283 0.364 0 0.706-0.095 1.001-0.263l-0.010 0.005c0.877-0.461 1.917-0.731 3.019-0.731 0.069 0 0.137 0.001 0.206 0.003l-0.010-0h0.030c1.277 0 2.382 0.266 3.266 0.775 0.27 0.159 0.594 0.253 0.94 0.253 0.001 0 0.002 0 0.003 0h-0c0.355-0.002 0.688-0.098 0.974-0.265l-0.009 0.005c0.606-0.357 1.007-1.007 1.007-1.75 0-0.001 0-0.003 0-0.004v0c0.001-0.026 0.002-0.056 0.002-0.086 0-0.625-0.34-1.171-0.846-1.462l-0.008-0.004c-0.056-0.040-0.125-0.065-0.199-0.070l-0.001-0zM13.101 8.831c-0.238 0.213-0.468 0.581-0.832 0.345-0.061-0.041-0.114-0.086-0.161-0.136l-0-0c-0.063-0.063-0.101-0.15-0.101-0.247 0-0.133 0.074-0.248 0.182-0.308l0.002-0.001c0.594-0.309 1.203-0.543 1.884-0.49-0.324 0.281-0.649 0.56-0.973 0.837z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M15.89 13.578c-0.367 0.483-0.941 0.792-1.588 0.792s-1.221-0.309-1.585-0.787l-0.004-0.005c-0.064-0.103-0.177-0.171-0.306-0.171-0.199 0-0.36 0.161-0.36 0.36 0 0.091 0.034 0.174 0.090 0.238l-0-0c0.499 0.659 1.283 1.080 2.164 1.080s1.665-0.421 2.159-1.073l0.005-0.007c0.043-0.059 0.068-0.132 0.068-0.212 0-0.116-0.055-0.22-0.14-0.286l-0.001-0.001c-0.059-0.045-0.134-0.072-0.215-0.072-0.117 0-0.221 0.056-0.286 0.143l-0.001 0.001z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M18.507 11.707c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M17.389 11.049c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M10.798 11.707c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M11.918 11.049c0 0.194-0.157 0.351-0.351 0.351s-0.351-0.157-0.351-0.351c0-0.194 0.157-0.351 0.351-0.351s0.351 0.157 0.351 0.351z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M8.773 7.877c-0.001-0.003-0.002-0.005-0.002-0.009s0.001-0.006 0.002-0.009l-0 0c0.047-0.081 0.089-0.164 0.132-0.247 0.019-0.038 0.036-0.079 0.057-0.115 0.275-0.498 0.379-0.99 1.033-1.064h0.045c0 0 0.001 0 0.001 0 0.487 0 0.884 0.382 0.91 0.862l0 0.002c-0.678 0.124-1.261 0.277-1.827 0.468l0.092-0.027-0.275 0.096-0.1 0.036-0.045 0.017s-0.023 0-0.023-0.011z"
    })]
  });
};
const otterIconColored = ({
  className
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('otter-icon', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.G, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M19.9877 9.42008C19.6369 9.61724 19.3785 10.0999 19.1922 10.38C19.3704 10.3719 19.6396 10.38 19.9061 10.3474C19.5651 12.7604 18.4405 14.9944 16.7053 16.7054C15.6732 17.7477 14.448 18.5791 13.098 19.1529C10.5336 20.2407 7.70811 20.2883 5.31094 19.2576C4.29167 18.8247 3.36554 18.1991 2.58336 17.4152C1.21259 16.0355 0.334714 14.2424 0.0855683 12.3136C0.478525 12.149 0.765424 11.6092 0.961223 11.3101C0.642655 11.3103 0.324535 11.334 0.00942443 11.3808C-0.100712 8.55259 1.00745 5.57482 3.29177 3.29186C6.55508 0.0285557 11.2379 -0.836221 14.8779 0.823987C14.7269 1.02115 14.6059 1.2319 14.4999 1.38827C14.7936 1.37195 15.3157 1.39643 15.6978 1.2523C16.0056 1.43293 16.3009 1.63418 16.5816 1.85465C16.515 1.95935 16.4456 2.05589 16.398 2.13747C16.534 2.13747 16.7135 2.13747 16.9106 2.12115C17.0833 2.26664 17.2533 2.42301 17.4151 2.58481C19.248 4.41906 20.0978 6.89102 19.9877 9.42008Z",
        fill: "#E8D3C9"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M4.32515 5.25665C3.92192 6.11059 3.77512 7.06318 3.90255 7.99889C4.02998 8.93461 4.42617 9.81325 5.04307 10.5283C5.78956 11.3645 6.80118 11.907 7.79105 12.4318C8.1473 12.6208 8.51714 12.8153 8.92097 12.8506C9.44718 12.8969 9.95843 12.6671 10.4167 12.406C11.5996 11.7357 12.6615 10.8016 13.3047 9.60365C13.9478 8.40574 14.1314 6.92774 13.6174 5.66864C13.3523 5.04048 12.9456 4.48207 12.429 4.03699C11.486 3.2291 10.2823 2.79004 9.04063 2.80101C8.43429 2.81396 7.83536 2.93698 7.273 3.16406C6.72912 3.36529 6.19611 3.39385 5.69166 3.70794C5.10339 4.08984 4.63083 4.62542 4.32515 5.25665Z",
        fill: "#D6AF99"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M13.1008 19.1488C12.6689 19.3318 12.2256 19.4867 11.7738 19.6125C11.5236 19.6832 11.2707 19.7485 11.0137 19.7933C10.9838 19.7933 10.9579 19.8042 10.928 19.8124C10.9172 19.811 10.9062 19.811 10.8954 19.8124C10.0118 19.9817 9.10938 20.0306 8.21268 19.9578C7.92865 19.9366 7.64591 19.9008 7.36558 19.8504C7.31397 19.8449 7.26269 19.8368 7.21193 19.826H7.19561L7.07732 19.8015C6.83665 19.7525 6.60006 19.6941 6.36483 19.6261C6.00688 19.5234 5.65582 19.398 5.31377 19.2508C5.24487 18.9778 5.20971 18.6975 5.20907 18.4159C5.15469 17.2072 5.10302 16.0024 5.05271 14.7937C5.01716 14.4481 5.04154 14.0989 5.12477 13.7616C5.18474 13.5696 5.28262 13.3916 5.41263 13.238C5.54264 13.0845 5.70213 12.9587 5.88165 12.8679C6.06118 12.7771 6.2571 12.7233 6.4578 12.7096C6.65851 12.6959 6.85992 12.7226 7.05012 12.7881C8.63555 12.5297 10.2726 12.2809 11.8336 12.6521C12.1926 12.7378 12.5692 12.8751 12.7772 13.181C12.9472 13.434 12.9689 13.7521 12.988 14.0567C13.0605 15.3104 13.133 16.5649 13.2055 17.8204C13.2327 18.2759 13.2545 18.7368 13.1008 19.1488Z",
        fill: "#F4816B"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M12.6452 8.15827C12.7187 7.47841 12.0361 6.85431 11.3535 6.93453C11.1316 6.97029 10.9165 7.04 10.7158 7.14121C10.5294 7.21597 10.3327 7.26182 10.1325 7.27718C9.81839 7.34244 9.5179 7.47841 9.2038 7.49745C8.93186 7.52056 8.57698 7.5532 8.31183 7.46346L7.57351 7.21599L7.40218 7.15344C7.2061 7.06715 6.99944 7.00725 6.7876 6.97532C6.01528 6.89782 5.30551 7.71228 5.5489 8.471C5.79229 9.22972 6.72777 9.36841 7.39403 9.18621C7.67413 9.11007 7.93791 8.99313 8.22345 8.92651C8.711 8.83154 9.21264 8.83523 9.69874 8.93739C10.1869 9.02169 10.6669 9.1495 11.1577 9.20933C11.7981 9.29363 12.4916 8.91563 12.6289 8.24801C12.6344 8.22082 12.6452 8.1909 12.6452 8.15827Z",
        fill: "#E8D3C9"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M8.21258 15.6802V19.966C7.92855 19.9448 7.64581 19.9089 7.36548 19.8586V15.6802C7.3657 15.5064 7.40363 15.3347 7.47663 15.1769C7.54964 15.0192 7.65599 14.8791 7.78835 14.7665C7.9211 14.8789 8.0278 15.0189 8.10106 15.1766C8.17432 15.3344 8.21237 15.5062 8.21258 15.6802Z",
        fill: "#D87768"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M11.7737 17.3839V19.6152C11.5235 19.6859 11.2706 19.7512 11.0136 19.7961C10.9837 19.7961 10.9579 19.8069 10.928 19.8151V17.3839C10.9282 16.9735 11.0787 16.5774 11.3508 16.2703C11.6236 16.5771 11.7741 16.9734 11.7737 17.3839Z",
        fill: "#F59085"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M7.89865 6.5035C7.82719 6.54284 7.76612 6.59863 7.72049 6.66625C7.67485 6.73387 7.64597 6.81138 7.63623 6.89238C7.6383 6.94844 7.65369 7.00321 7.68111 7.05215C7.70854 7.10109 7.74722 7.1428 7.79396 7.17384C7.88831 7.23528 7.99969 7.26527 8.11213 7.2595C8.30157 7.24621 8.4826 7.17608 8.63154 7.05826C8.78032 6.94126 8.91698 6.80962 9.03945 6.6653C9.0742 6.63585 9.10242 6.59948 9.12232 6.55851C9.14222 6.51754 9.15336 6.47287 9.15503 6.42736C9.12783 6.20164 8.78791 6.24379 8.62746 6.24243C8.36436 6.257 8.11116 6.3477 7.89865 6.5035Z",
        fill: "#E8D3C9"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M12.0756 6.35666C12.0763 6.35353 12.0763 6.35027 12.0756 6.34714C12.0498 6.30227 12.0253 6.2574 12.0035 6.21117C11.9926 6.19077 11.9831 6.16902 11.9709 6.14862C11.82 5.87668 11.7629 5.60473 11.4066 5.56666H11.3808C11.2524 5.56576 11.1286 5.61423 11.035 5.70204C10.9413 5.78986 10.885 5.91031 10.8777 6.03848C11.1999 6.09813 11.5179 6.17898 11.8295 6.28051L11.9845 6.33354L12.0389 6.35258L12.0647 6.36209C12.0658 6.36252 12.0669 6.36271 12.0681 6.36266C12.0692 6.36261 12.0703 6.36232 12.0714 6.36181C12.0724 6.36129 12.0733 6.36057 12.074 6.35968C12.0748 6.35879 12.0753 6.35776 12.0756 6.35666Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M14.3489 9.47719C14.3489 9.47719 14.3489 7.40363 14.1504 5.75023C14.1631 5.74517 14.1763 5.74153 14.1898 5.73935C14.3124 5.70316 14.4203 5.62893 14.4979 5.52739C14.5755 5.42585 14.6188 5.30226 14.6215 5.17449C14.6242 5.04673 14.5862 4.92141 14.513 4.81665C14.4398 4.71189 14.3352 4.63313 14.2143 4.59175H14.198C13.942 4.50432 13.7209 4.33703 13.5671 4.11449C12.8791 3.10015 11.8498 2.58346 10.9496 2.31831C10.3317 2.13562 9.69042 2.04401 9.04604 2.04637C8.35768 2.04746 7.67354 2.15384 7.01735 2.36182C6.14986 2.63377 5.18174 3.15182 4.52364 4.11721C4.36993 4.33921 4.14865 4.50564 3.89274 4.59175C3.77192 4.63227 3.6672 4.71031 3.59382 4.8145C3.52045 4.91869 3.48226 5.04358 3.48482 5.17099C3.48245 5.30229 3.52435 5.43057 3.60378 5.53516C3.6832 5.63974 3.79553 5.71454 3.92265 5.74751L3.94712 5.75566C3.88186 6.28187 3.83835 6.84343 3.81115 7.37916C3.74997 8.51724 3.74997 9.48263 3.74997 9.48263C3.74997 9.48263 1.42214 12.6535 1.22362 15.5007C1.12028 16.9216 1.54723 18.2596 3.04564 19.0795C5.63725 20.4106 6.81612 18.658 6.81612 18.658C6.81612 18.658 7.58163 17.747 5.83712 16.8196V14.3042C5.83784 14.213 5.87455 14.1259 5.93924 14.0617C6.00393 13.9975 6.09136 13.9615 6.18249 13.9615H6.84467V13.6379C6.84467 13.5658 6.87332 13.4966 6.92432 13.4456C6.97532 13.3946 7.04449 13.366 7.11661 13.366H8.02762C8.09974 13.366 8.16891 13.3946 8.21991 13.4456C8.27091 13.4966 8.29956 13.5658 8.29956 13.6379V13.9615H9.78981V13.6379C9.78981 13.5658 9.81846 13.4966 9.86946 13.4456C9.92046 13.3946 9.98962 13.366 10.0617 13.366H10.9728C11.0449 13.366 11.114 13.3946 11.165 13.4456C11.216 13.4966 11.2447 13.5658 11.2447 13.6379V13.9615H11.9082C11.9989 13.9619 12.0857 13.9981 12.1496 14.0624C12.2136 14.1266 12.2495 14.2135 12.2495 14.3042V16.8169C10.5077 17.7442 11.2746 18.6552 11.2746 18.6552C11.2746 18.6552 12.4494 20.4079 15.0437 19.0768C19.5512 16.6089 14.3489 9.47719 14.3489 9.47719ZM13.5861 7.66198C13.5354 8.43053 13.2351 9.16149 12.7309 9.7437C11.7954 10.8437 10.3187 11.5236 9.04876 12.1708C7.77607 11.5236 6.29535 10.8437 5.35715 9.7437C4.8555 9.16014 4.5564 8.42977 4.50461 7.66198C4.4339 6.4464 4.82006 4.41363 6.17433 3.97036C7.49733 3.53661 8.33627 4.67469 8.63541 5.1941C8.67753 5.26489 8.73721 5.32361 8.80867 5.36458C8.88013 5.40555 8.96096 5.42739 9.04333 5.42797C9.12588 5.42833 9.20708 5.4069 9.2787 5.36584C9.35032 5.32477 9.40984 5.26553 9.45124 5.1941C9.75717 4.67469 10.5934 3.53525 11.9178 3.97036C13.2707 4.41363 13.6541 6.4464 13.5861 7.66198Z",
        fill: "#87574C"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M11.9763 7.60351C11.946 7.58302 11.9108 7.57083 11.8743 7.56816H11.858C11.7533 7.58176 11.7927 7.70413 11.8335 7.7626C11.9807 7.96822 12.0583 8.21546 12.0551 8.46829C12.0541 8.59201 12.02 8.71319 11.9564 8.81932C11.8928 8.92546 11.802 9.01269 11.6935 9.072C11.2855 9.30451 10.9415 8.9945 10.569 8.85445C10.144 8.70162 9.69741 8.61762 9.24598 8.60562V8.03182C9.78596 7.91128 10.2753 7.62625 10.6465 7.21599C10.695 7.1622 10.7316 7.09864 10.7536 7.02959C10.7756 6.96053 10.7825 6.88757 10.774 6.8156C10.7655 6.74362 10.7418 6.67429 10.7043 6.61226C10.6668 6.55023 10.6165 6.49692 10.5567 6.45591C10.1115 6.14086 9.57875 5.97303 9.03329 5.97596C8.48782 5.97889 7.95695 6.15242 7.51507 6.47223C7.4601 6.51237 7.41409 6.5635 7.37994 6.62238C7.34579 6.68125 7.32427 6.74659 7.31672 6.81423C7.30918 6.88187 7.31578 6.95034 7.33612 7.01529C7.35645 7.08024 7.39007 7.14026 7.43484 7.19152C7.80594 7.6164 8.30264 7.91214 8.85302 8.0359V8.6097C8.47005 8.61985 8.09011 8.68066 7.7231 8.79054C7.55681 8.83782 7.39487 8.89923 7.23904 8.9741C6.9535 9.11007 6.66932 9.21205 6.37291 9.03937C6.26953 8.98066 6.18374 8.89535 6.12444 8.7923C6.06515 8.68925 6.03451 8.57222 6.0357 8.45333C6.03418 8.20663 6.11081 7.96578 6.25461 7.76532C6.28181 7.72725 6.30356 7.67014 6.26821 7.62935C6.23286 7.58856 6.16351 7.62935 6.12 7.64566C6.02013 7.69831 5.93146 7.7699 5.85894 7.85642C5.71284 8.02755 5.63405 8.24602 5.6373 8.47101C5.63957 8.65652 5.69034 8.8382 5.78456 8.99802C5.87878 9.15783 6.01317 9.29022 6.17439 9.38202C6.34253 9.48028 6.5333 9.5332 6.72804 9.53558C6.92277 9.53797 7.11478 9.48974 7.28527 9.39561C7.8313 9.11543 8.43948 8.97836 9.0529 8.99722C9.05781 8.99848 9.06295 8.99848 9.06786 8.99722C9.6917 8.98021 10.3091 9.12695 10.8586 9.42281C11.0173 9.51459 11.1974 9.56292 11.3807 9.56292C11.5641 9.56292 11.7442 9.51459 11.9029 9.42281C12.072 9.32549 12.2124 9.18519 12.3098 9.01612C12.4072 8.84706 12.4582 8.65525 12.4576 8.46013C12.4667 8.28643 12.4262 8.11374 12.341 7.96211C12.2558 7.81047 12.1293 7.68613 11.9763 7.60351ZM8.388 6.88014C8.25203 6.99028 8.13102 7.1956 7.9325 7.06915C7.90018 7.04675 7.87012 7.02124 7.84276 6.993C7.8218 6.97182 7.80603 6.94607 7.79669 6.91778C7.78734 6.88948 7.78467 6.85941 7.78888 6.82991C7.7931 6.80041 7.80408 6.77229 7.82098 6.74774C7.83787 6.7232 7.86022 6.70289 7.88627 6.68843C8.1967 6.4998 8.55521 6.40533 8.91829 6.41648L8.388 6.88014Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M9.915 9.48126C9.81366 9.6161 9.68234 9.72552 9.53143 9.80088C9.38052 9.87624 9.21415 9.91547 9.04547 9.91547C8.87679 9.91547 8.71042 9.87624 8.55951 9.80088C8.4086 9.72552 8.27728 9.6161 8.17593 9.48126C8.14456 9.43925 8.09778 9.41142 8.04589 9.4039C7.994 9.39638 7.94124 9.40978 7.89923 9.44115C7.85722 9.47253 7.82939 9.5193 7.82187 9.5712C7.81435 9.62309 7.82775 9.67584 7.85912 9.71785C7.99751 9.90144 8.17663 10.0504 8.38238 10.1529C8.58814 10.2555 8.81489 10.3089 9.04479 10.3089C9.27469 10.3089 9.50144 10.2555 9.7072 10.1529C9.91295 10.0504 10.0921 9.90144 10.2305 9.71785C10.246 9.69714 10.2573 9.67357 10.2637 9.64849C10.2701 9.62341 10.2716 9.59731 10.2679 9.57168C10.2642 9.54605 10.2556 9.52139 10.2424 9.49911C10.2292 9.47683 10.2117 9.45737 10.191 9.44183C10.1703 9.4263 10.1467 9.41499 10.1217 9.40857C10.0966 9.40214 10.0705 9.40072 10.0448 9.40438C10.0192 9.40804 9.99456 9.41672 9.97228 9.42991C9.95 9.4431 9.93054 9.46055 9.915 9.48126Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M11.1577 8.64913C11.2643 8.64913 11.3508 8.56268 11.3508 8.45605C11.3508 8.34941 11.2643 8.26297 11.1577 8.26297C11.051 8.26297 10.9646 8.34941 10.9646 8.45605C10.9646 8.56268 11.051 8.64913 11.1577 8.64913Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M10.5446 8.28743C10.6513 8.28743 10.7377 8.20099 10.7377 8.09435C10.7377 7.98772 10.6513 7.90128 10.5446 7.90128C10.438 7.90128 10.3516 7.98772 10.3516 8.09435C10.3516 8.20099 10.438 8.28743 10.5446 8.28743Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M6.93307 8.64913C7.0397 8.64913 7.12615 8.56268 7.12615 8.45605C7.12615 8.34941 7.0397 8.26297 6.93307 8.26297C6.82643 8.26297 6.73999 8.34941 6.73999 8.45605C6.73999 8.56268 6.82643 8.64913 6.93307 8.64913Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M7.54635 8.28743C7.65299 8.28743 7.73943 8.20099 7.73943 8.09435C7.73943 7.98772 7.65299 7.90128 7.54635 7.90128C7.43972 7.90128 7.35327 7.98772 7.35327 8.09435C7.35327 8.20099 7.43972 8.28743 7.54635 8.28743Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M6.01525 6.35664C6.01445 6.35352 6.01445 6.35025 6.01525 6.34713C6.04109 6.30226 6.06556 6.25739 6.08868 6.21115C6.09955 6.19076 6.10907 6.169 6.11995 6.14861C6.27088 5.87667 6.32799 5.60472 6.68559 5.56665H6.71007C6.83819 5.56646 6.96151 5.61543 7.05461 5.70347C7.1477 5.7915 7.20348 5.91189 7.21044 6.03983C6.88812 6.09915 6.57014 6.18 6.25864 6.28186L6.10227 6.33489L6.04789 6.35392L6.02341 6.36344C6.02341 6.36344 6.01525 6.36208 6.01525 6.35664Z",
        fill: "#53484A"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M13.3525 15.1282C13.3523 15.3089 13.323 15.4884 13.2655 15.6598C13.2118 15.8229 13.1363 15.9779 13.0411 16.1207C13.0003 16.1903 12.9548 16.2571 12.9051 16.3206C12.8496 16.3777 12.7911 16.4317 12.7297 16.4824L12.7066 16.5042C12.6386 16.5627 12.5625 16.617 12.4904 16.6714L12.4659 16.6905L12.436 16.7081C12.4143 16.7217 12.3966 16.7353 12.3748 16.7462C12.3531 16.7571 12.3341 16.7734 12.315 16.7843L12.2824 16.8033L12.2525 16.8196C12.2497 16.7825 12.2497 16.7453 12.2525 16.7081V15.8162C12.2525 15.4762 12.2525 15.1363 12.2525 14.7937V14.3042C12.2525 14.2135 12.2166 14.1266 12.1526 14.0624C12.0886 13.9981 12.0018 13.9619 11.9112 13.9615H11.2463V13.6379C11.2463 13.5658 11.2176 13.4966 11.1666 13.4456C11.1156 13.3946 11.0465 13.366 10.9743 13.366H10.062C9.98985 13.366 9.92068 13.3946 9.86968 13.4456C9.81868 13.4966 9.79003 13.5658 9.79003 13.6379V13.9615H8.30115V13.6379C8.30115 13.5658 8.27249 13.4966 8.2215 13.4456C8.1705 13.3946 8.10133 13.366 8.0292 13.366H7.1182C7.04607 13.366 6.9769 13.3946 6.9259 13.4456C6.8749 13.4966 6.84625 13.5658 6.84625 13.6379V13.9615H6.18271C6.13754 13.9613 6.09277 13.9701 6.05096 13.9872C6.00916 14.0043 5.97114 14.0295 5.93907 14.0613C5.907 14.0931 5.88151 14.131 5.86405 14.1726C5.8466 14.2143 5.83753 14.259 5.83735 14.3042V16.6714C5.8412 16.7167 5.8412 16.7622 5.83735 16.8074C5.62372 16.6941 5.42806 16.5498 5.25675 16.3791C5.17926 16.3062 5.11161 16.2234 5.05551 16.133C5.16311 15.994 5.26298 15.8492 5.35465 15.6992C5.22956 15.7074 5.03648 15.6992 4.8502 15.7264C4.77619 15.5342 4.73794 15.3301 4.73734 15.1241C4.7369 15.0596 4.74053 14.9951 4.74822 14.931C4.86978 14.7846 4.97936 14.6286 5.07591 14.4646H4.86923C5.34105 13.3252 7.03389 12.4699 9.04627 12.4699C10.0345 12.4547 11.0113 12.6826 11.8908 13.1335C11.8201 13.2327 11.7548 13.3333 11.7099 13.4054C11.8991 13.4057 12.0881 13.3929 12.2756 13.3673C12.9446 13.8419 13.3525 14.4551 13.3525 15.1282Z",
        fill: "#775049"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M4.56173 9.71378C3.03477 10.9334 1.76752 13.589 1.22363 15.5007C1.42215 12.6535 3.74182 9.47719 3.74182 9.47719C3.74182 9.47719 3.74182 8.5118 3.80301 7.37372C3.84176 7.88946 3.96677 8.39504 4.17285 8.8694C4.05771 9.01407 3.95232 9.16624 3.85739 9.32491C3.98113 9.31675 4.17829 9.3249 4.36185 9.29771C4.42983 9.43912 4.49646 9.57917 4.56173 9.71378Z",
        fill: "#775049"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M9.04627 2.03956C8.35791 2.04065 7.67377 2.14703 7.01758 2.35501C7.22969 2.45427 7.42549 2.55897 7.60905 2.66639C7.51251 2.79284 7.43229 2.93833 7.36566 3.03079C7.60034 3.03533 7.83478 3.01344 8.06456 2.96552C8.1611 3.03623 8.24812 3.10965 8.3365 3.18172C8.29163 3.2497 8.2522 3.31769 8.21684 3.368C8.29707 3.368 8.40448 3.368 8.52006 3.35712C8.61198 3.45013 8.69654 3.55014 8.77297 3.65626C8.79314 3.68406 8.81962 3.70669 8.85022 3.7223C8.88083 3.73791 8.91469 3.74604 8.94905 3.74604C8.9834 3.74604 9.01727 3.73791 9.04787 3.7223C9.07848 3.70669 9.10496 3.68406 9.12513 3.65626C9.46914 3.16404 10.1014 2.70446 10.9539 2.31694C10.335 2.13201 9.69228 2.03857 9.04627 2.03956Z",
        fill: "#775049"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M16.107 12.6372C16.035 12.4672 15.9615 12.2972 15.884 12.1354C15.6814 11.6935 15.4652 11.2856 15.2613 10.928C15.1688 10.7635 15.0804 10.6126 14.9893 10.4725C14.6209 9.85655 14.3421 9.47719 14.3421 9.47719C14.3421 9.47719 14.3421 8.5118 14.2809 7.37372C14.2211 8.31192 13.8404 9.04888 13.5222 9.71378C13.6754 9.83888 13.8268 9.97485 13.9764 10.1217C14.1123 10.2577 14.2483 10.4072 14.3748 10.5636C14.4346 10.6316 14.4876 10.6996 14.5447 10.7744C14.4455 10.9035 14.3639 11.0463 14.2973 11.1401C14.4237 11.132 14.6127 11.1401 14.7976 11.117C15.0714 11.5 15.3211 11.8997 15.5455 12.3136C15.412 12.4654 15.2936 12.6297 15.1919 12.8044C15.3894 12.805 15.5866 12.7913 15.7821 12.7636C16.2263 13.6403 16.5873 14.5566 16.8603 15.5007C16.7978 14.538 16.4878 13.5373 16.107 12.6372Z",
        fill: "#775049"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("clipPath", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
          width: "20",
          height: "19.9986",
          fill: "white"
        })
      })
    })]
  });
};
const accordionIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 10H4v5h16v-5ZM4 9a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-5a1 1 0 0 0-1-1H4Zm16-4H4v2h16V5ZM4 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H4Zm16 14H4v2h16v-2ZM4 17a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    })
  });
};
const accordionItemIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M3 10a1 1 0 0 1 1-1h16a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-4Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 10H4v4h16v-4ZM4 9a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H4Zm16-4H4v2h16V5ZM4 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H4Zm16 13H4v2h16v-2ZM4 16a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    })]
  });
};
const headingIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M15.999 6.455v12.39h.651c.364 0 .546.133.546.399v.357c0 .266-.182.399-.546.399h-2.541c-.364 0-.546-.133-.546-.399v-.357c0-.266.182-.399.546-.399h.651v-5.88H6.843v5.88h.651c.364 0 .546.133.546.399v.357c0 .266-.182.399-.546.399H4.953c-.364 0-.546-.133-.546-.399v-.357c0-.266.182-.399.546-.399h.651V6.455h-.651c-.364 0-.546-.133-.546-.399v-.357c0-.266.182-.399.546-.399h2.541c.364 0 .546.133.546.399v.357c0 .266-.182.399-.546.399h-.651v5.355h7.917V6.455h-.651c-.364 0-.546-.133-.546-.399v-.357c0-.266.182-.399.546-.399h2.541c.364 0 .546.133.546.399v.357c0 .266-.182.399-.546.399h-.651Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M17.5 3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 5.5a.5.5 0 0 1-.5-.5V1a.5.5 0 0 1 1 0v4a.5.5 0 0 1-.5.5Z",
      clipRule: "evenodd"
    })]
  });
};
const buttonsIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 5H4v5h16V5ZM4 4a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M5.5 7a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM20 14H4v5h16v-5ZM4 13a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-5a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M5.618 16a.5.5 0 0 0 0 1h12.764a.5.5 0 0 0 0-1H5.618Z",
      clipRule: "evenodd"
    })]
  });
};
const buttonIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 9H4v5h16V9ZM4 8a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M5.618 11a.5.5 0 0 0 0 1h12.764a.5.5 0 0 0 0-1H5.618Z",
      clipRule: "evenodd"
    })]
  });
};
const circleIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M12 21a9 9 0 1 0 0-18 9 9 0 0 0 0 18Zm0-1.346a7.654 7.654 0 1 1 0-15.308 7.654 7.654 0 0 1 0 15.308ZM12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Zm0-3.346a6.654 6.654 0 1 1 0-13.308 6.654 6.654 0 0 1 0 13.308Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M6.005 18.713a9 9 0 0 1-2.115-2.81.355.355 0 0 1 .01-.335.615.615 0 0 1 .378-.296c.316-.091.812.079 1.128.615a7.655 7.655 0 1 0 8.1-11.392c-.61-.122-.934-.535-.951-.864a.615.615 0 0 1 .155-.454.355.355 0 0 1 .314-.119 9 9 0 1 1-7.019 15.655Zm-3.016-2.377c-.4-.832.123-1.768 1.011-2.025.888-.256 1.798.272 2.267 1.068a6.655 6.655 0 1 0 7.042-9.903c-.905-.182-1.703-.869-1.753-1.791-.049-.923.664-1.725 1.581-1.62A10 10 0 1 1 2.99 16.337Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M4.182 14.868c-.867.318-1.324 1.289-.866 2.091A10 10 0 1 0 13.921 2.186c-.906-.177-1.68.566-1.704 1.49-.024.923.717 1.671 1.606 1.924a6.654 6.654 0 1 1-7.304 10.174c-.524-.761-1.47-1.224-2.337-.906Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M6.36 19.013a9 9 0 0 1-2.175-2.55.355.355 0 0 1-.015-.335.615.615 0 0 1 .357-.321c.308-.114.816.021 1.168.534a7.653 7.653 0 1 0 8.402-11.703c-.599-.17-.889-.607-.88-.936a.615.615 0 0 1 .19-.441.355.355 0 0 1 .322-.093 9 9 0 1 1-7.37 15.845ZM3.315 16.96c-.458-.802-.001-1.773.866-2.091.868-.318 1.813.145 2.337.906A6.655 6.655 0 1 0 13.823 5.6c-.889-.253-1.63-1-1.606-1.924.024-.924.798-1.667 1.704-1.49A10 10 0 1 1 3.316 16.96Z",
      clipRule: "evenodd"
    })]
  });
};
const countdownIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M9 9H3v6h6V9ZM3 8a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1H3Zm18 1h-6v6h6V9Zm-6-1a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1h-6Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M11 10a1 1 0 1 1 2 0 1 1 0 1 1-2 0Zm0 4a1 1 0 1 1 2 0 1 1 0 1 1-2 0Z"
    })]
  });
};
const flipIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M11.5 7V4h1v3A2.5 2.5 0 0 0 15 9.5h4v1h-4A3.5 3.5 0 0 1 11.5 7Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M11 4H5v16h14v-8a8 8 0 0 0-8-8ZM5 3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-8a9 9 0 0 0-9-9H5Z",
      clipRule: "evenodd"
    })]
  });
};
const faIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 4H4v16h16V4ZM4 3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M11.776 7.454a.25.25 0 0 1 .448 0l1.187 2.406a.25.25 0 0 0 .189.136l2.654.386a.25.25 0 0 1 .139.427l-1.921 1.872a.25.25 0 0 0-.072.221l.453 2.644a.25.25 0 0 1-.362.263l-2.375-1.248a.25.25 0 0 0-.232 0L9.509 15.81a.25.25 0 0 1-.362-.263l.453-2.644a.25.25 0 0 0-.072-.221l-1.92-1.872a.25.25 0 0 1 .138-.427l2.654-.386a.25.25 0 0 0 .189-.136l1.187-2.406Z"
    })]
  });
};
const formIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M19 3H5v18h14V3ZM5 2a1 1 0 0 0-1 1v18a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H5Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M17 5H7v2h10V5ZM7 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H7Zm10 7H7v1h10v-1ZM7 10a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1H7Zm10 5H7v4h10v-4ZM7 14a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H7Z",
      clipRule: "evenodd"
    })]
  });
};
const formFieldIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M19 10H5v4h14v-4ZM5 9a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H5Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M6 12.5a.5.5 0 0 1 .5-.5h8a.5.5 0 0 1 0 1h-8a.5.5 0 0 1-.5-.5Z"
    })]
  });
};
const googleMapIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M16.453 13.552C17.429 11.962 18 10.499 18 9.125 18 5.725 15.297 3 12 3S6 5.726 6 9.125c0 1.374.57 2.837 1.547 4.427.975 1.586 2.285 3.19 3.648 4.859l.004.004.801.983c.267-.33.535-.657.801-.983l.004-.004c1.363-1.669 2.673-3.273 3.648-4.86Zm-3.813 6.645c.31-.384.624-.769.939-1.153C16.286 15.732 19 12.412 19 9.125 19 5.19 15.866 2 12 2S5 5.19 5 9.125c0 3.287 2.714 6.607 5.421 9.919.315.384.629.769.939 1.153.216.268.43.535.64.803.21-.268.424-.535.64-.803ZM15.5 9a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Zm-1 0a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z",
      clipRule: "evenodd"
    })
  });
};
const iconListIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 6H9v2h11V6ZM9 5a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H9Zm11 6H9v2h11v-2ZM9 10a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H9Zm11 6H9v2h11v-2ZM9 15a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H9ZM6 6H4v2h2V6ZM4 5a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Zm2 6H4v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Zm2 6H4v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    })
  });
};
const iconListItemIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 6H9v2h11V6ZM9 5a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H9Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M8 11a1 1 0 0 1 1-1h11a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1v-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 11H9v2h11v-2ZM9 10a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H9Zm11 6H9v2h11v-2ZM9 15a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H9ZM6 6H4v2h2V6ZM4 5a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M3 11a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M6 11H4v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Zm2 6H4v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    })]
  });
};
const mapIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M8.872 8.64a.5.5 0 0 0-.41 0l-5.667 2.55a.5.5 0 0 0-.295.457v8.806a.5.5 0 0 0 .705.456l4.846-2.18a1.5 1.5 0 0 1 1.231 0l5.846 2.63a.5.5 0 0 0 .41 0l5.667-2.55a.5.5 0 0 0 .295-.456V9.547a.5.5 0 0 0-.705-.456l-4.846 2.18a1.5 1.5 0 0 1-1.231 0l-5.846-2.63Zm-.82-.911a1.5 1.5 0 0 1 1.23 0l5.846 2.63a.5.5 0 0 0 .41 0l4.846-2.18A1.5 1.5 0 0 1 22.5 9.547v8.806a1.5 1.5 0 0 1-.884 1.368l-5.667 2.55a1.5 1.5 0 0 1-1.231 0l-5.846-2.63a.5.5 0 0 0-.41 0l-4.846 2.18A1.5 1.5 0 0 1 1.5 20.453v-8.806a1.5 1.5 0 0 1 .884-1.368l5.667-2.55Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M16.515 13.662C18.255 11.396 20 9.123 20 6.875 20 4.183 17.985 2 15.5 2S11 4.183 11 6.875c0 2.25 1.745 4.52 3.485 6.787.343.446.686.892 1.015 1.338.33-.446.672-.892 1.015-1.338ZM15.5 8.5a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm-2.4 6.2a.5.5 0 0 1 .7-.1l4 3a.5.5 0 0 1-.6.8l-4-3a.5.5 0 0 1-.1-.7Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M17.9 14.7a.5.5 0 0 0-.7-.1l-4 3a.5.5 0 0 0 .6.8l4-3a.5.5 0 0 0 .1-.7Z",
      clipRule: "evenodd"
    })]
  });
};
const lottieIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M16.917 5.26c.302-.046.747-.01.58-.01a.75.75 0 0 1 .007 1.5.879.879 0 0 1-.2-.014c-.034-.006-.05-.01-.16.007-.128.02-.367.086-.71.33-.707.502-1.83 1.74-3.235 4.74-1.464 3.126-2.915 4.744-4.07 5.578-.579.418-1.078.636-1.456.747a2.858 2.858 0 0 1-.464.099 1.897 1.897 0 0 1-.2.013h-.033s-.002 0 .024-.75l-.026.75a.75.75 0 0 1 .029-1.5H7m.003 0a1.372 1.372 0 0 0 .246-.05c.21-.063.556-.203 1.001-.524.891-.644 2.2-2.03 3.591-5 1.45-3.095 2.709-4.605 3.723-5.326.517-.367.974-.531 1.353-.59",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 4H4v16h16V4ZM4 3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H4Z",
      clipRule: "evenodd"
    })]
  });
};
const popupIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M3 9.5a.5.5 0 0 0-.5.5v11a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-3.5a.5.5 0 0 1 1 0V21a1.5 1.5 0 0 1-1.5 1.5H3A1.5 1.5 0 0 1 1.5 21V10A1.5 1.5 0 0 1 3 8.5h1.531a.5.5 0 1 1 0 1H3Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M21 3H8v11h13V3ZM8 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h13a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H8Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M14.45 4.55h4.5a.5.5 0 0 1 .5.5v4.5a.5.5 0 1 1-1 0V6.257l-4.096 4.097a.5.5 0 0 1-.707-.708l4.096-4.096H14.45a.5.5 0 0 1 0-1Z",
      clipRule: "evenodd"
    })]
  });
};
const postsIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M7 5H5v2h2V5ZM5 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H5Zm2 7H5v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H5Zm2 7H5v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H5Zm8-11h-2v2h2V5Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1h-2Zm2 7h-2v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2Zm2 7h-2v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2Zm8-11h-2v2h2V5Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1h-2Zm2 7h-2v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2Zm2 7h-2v2h2v-2Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2Z",
      clipRule: "evenodd"
    })
  });
};
const progressIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M21 10H3v4h18v-4ZM3 9a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h18a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H3Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M13 10H3v4h10a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1ZM3 9a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h10a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2H3Z",
      clipRule: "evenodd"
    })]
  });
};
const reviewIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M1.717 8.588a.5.5 0 0 1 .695.13l2.264 3.297a.5.5 0 1 1-.825.566L1.588 9.283a.5.5 0 0 1 .13-.695Zm20.566 0a.5.5 0 0 1 .13.695l-2.264 3.298a.5.5 0 1 1-.825-.566l2.264-3.298a.5.5 0 0 1 .695-.13Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M19 13H5v7h14v-7ZM5 12a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H5Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M11.776 3.454a.25.25 0 0 1 .448 0l1.04 2.108a.25.25 0 0 0 .189.137l2.326.338a.25.25 0 0 1 .138.426l-1.683 1.64a.25.25 0 0 0-.072.222l.397 2.316a.25.25 0 0 1-.362.264l-2.08-1.094a.25.25 0 0 0-.233 0l-2.08 1.094a.25.25 0 0 1-.363-.264l.397-2.316a.25.25 0 0 0-.072-.221L8.083 6.463a.25.25 0 0 1 .139-.426l2.325-.338a.25.25 0 0 0 .189-.137l1.04-2.108Z"
    })]
  });
};
const columnsIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M21 4H3v16h18V4ZM3 3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h18a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H3Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M19 15H5v3h14v-3ZM5 14a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1H5Zm5-8H5v6h5V6ZM5 5a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H5Zm14 1h-5v1h5V6Zm-5-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-5Zm5 5h-5v2h5v-2Zm-5-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-5Z",
      clipRule: "evenodd"
    })]
  });
};
const columnIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M21 4H3v16h18V4ZM3 3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h18a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H3Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M4 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M7 6H5v12h2V6ZM5 5a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H5Zm8 1h-2v12h2V6Zm-2-1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-2Zm8 1h-2v12h2V6Zm-2-1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-2Z",
      clipRule: "evenodd"
    })]
  });
};
const sharingIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "m14.69 6.154-6.715 4.268a.5.5 0 0 1-.537-.844l6.716-4.268.536.844Zm-7.122 7.094a.5.5 0 0 1 .684-.18l6.432 3.752-.504.864-6.432-3.752a.5.5 0 0 1-.18-.684Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M17 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm0 12a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM6 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z",
      clipRule: "evenodd"
    })]
  });
};
const sliderIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M2 5H1a1 1 0 0 0-1 1v13a1 1 0 0 0 1 1h1v-1H1V6h1V5Zm20 14h1V6h-1V5h1a1 1 0 0 1 1 1v13a1 1 0 0 1-1 1h-1v-1Zm-6.5-8a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm-8-3.87v8.37h9.207L7.5 8.13Zm-1-.904a.6.6 0 0 1 1.004-.444l10.64 9.674a.6.6 0 0 1-.403 1.044H7.1a.6.6 0 0 1-.6-.6V7.226Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M3 3v18a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1Zm1 0v18h16V3H4Z",
      clipRule: "evenodd"
    })]
  });
};
const tabsIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M11.726 4.722c-1.033-.345-2.398-.243-3.628.003a.5.5 0 0 1-.196-.98c1.27-.255 2.851-.403 4.14.028.658.22 1.257.596 1.688 1.199.431.602.663 1.386.663 2.366a.5.5 0 0 1-1 0c0-.821-.193-1.388-.476-1.784-.283-.396-.688-.664-1.191-.832Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M15.726 4.722c-1.033-.345-2.398-.243-3.628.003a.5.5 0 0 1-.196-.98c1.27-.255 2.851-.403 4.14.028.658.22 1.257.596 1.688 1.199.431.602.663 1.386.663 2.366a.5.5 0 0 1-1 0c0-.821-.192-1.388-.476-1.784-.283-.396-.688-.664-1.192-.832Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "m8.449 7.878-.091-.9-.035-.365c-.073-.795-.126-1.366-.5-1.83C7.468 4.338 6.57 3.763 4 3.887v16.01h16V7.877H8.449ZM3 3.866v16.03a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V7.878a1 1 0 0 0-1-1H9.353l-.03-.33C9.182 4.893 8.99 2.632 3.91 2.891a.968.968 0 0 0-.91.975Z",
      clipRule: "evenodd"
    })]
  });
};
const tabsItemIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "m8.449 8.002-.091-.9-.035-.365c-.073-.793-.126-1.362-.499-1.826C7.467 4.468 6.57 3.893 4 4.017V20h16V8.002H8.449ZM3 3.996V20a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V8.002a1 1 0 0 0-1-1H9.353l-.03-.33C9.182 5.02 8.99 2.762 3.91 3.02a.968.968 0 0 0-.91.976Z",
      clipRule: "evenodd"
    })
  });
};
const searchIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M13.5 6C10.5 6 8 8.5 8 11.5c0 1.1.3 2.1.9 3l-3.4 3 1 1.1 3.4-2.9c1 .9 2.2 1.4 3.6 1.4 3 0 5.5-2.5 5.5-5.5C19 8.5 16.5 6 13.5 6zm0 9.5c-2.2 0-4-1.8-4-4s1.8-4 4-4 4 1.8 4 4-1.8 4-4 4z",
      clipRule: "evenodd"
    })
  });
};
const cartIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
      d: "M11 18.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm6 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
      fillRule: "evenodd",
      d: "M2.5 4a.5.5 0 0 1 .5-.5h.78a1.5 1.5 0 0 1 1.422 1.026L6.36 8h12.286a1.5 1.5 0 0 1 1.434 1.941l-1.385 4.5a1.5 1.5 0 0 1-1.434 1.059H8.74a1.5 1.5 0 0 1-1.434-1.059L5.524 8.653l-1.27-3.811a.5.5 0 0 0-.475-.342H3a.5.5 0 0 1-.5-.5Zm4.177 5 1.584 5.147a.5.5 0 0 0 .478.353h8.522a.5.5 0 0 0 .478-.353l1.385-4.5A.5.5 0 0 0 18.646 9H6.677Z",
      clipRule: "evenodd"
    })]
  });
};
const businessHoursIcon = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 24 24",
    xmlns: "http://www.w3.org/2000/svg",
    className: "o-block-icon",
    width: "24",
    height: "24",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M16.347 8.36a.477.477 0 0 1-.694 0l-3.12-3.243L9.415 8.36a.477.477 0 0 1-.693 0 .524.524 0 0 1 0-.72l3.466-3.604a.48.48 0 0 1 .693 0l3.467 3.604a.524.524 0 0 1 0 .72Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M20 9H4v10h16V9ZM4 8h16a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      fillRule: "evenodd",
      d: "M8 15.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm-3-3a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Z",
      clipRule: "evenodd"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M14 3.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"
    })]
  });
};
const StarFilled = ({
  className
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24",
    className: className,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M11.776 4.454a.25.25 0 01.448 0l2.069 4.192a.25.25 0 00.188.137l4.626.672a.25.25 0 01.139.426l-3.348 3.263a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.362.263l-4.138-2.175a.25.25 0 00-.232 0l-4.138 2.175a.25.25 0 01-.363-.263l.79-4.607a.25.25 0 00-.071-.222L4.754 9.881a.25.25 0 01.139-.426l4.626-.672a.25.25 0 00.188-.137l2.069-4.192z"
    })
  });
};
const StarHalf = ({
  className
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24",
    className: className,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M9.518 8.783a.25.25 0 00.188-.137l2.069-4.192a.25.25 0 01.448 0l2.07 4.192a.25.25 0 00.187.137l4.626.672a.25.25 0 01.139.427l-3.347 3.262a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.363.264l-4.137-2.176a.25.25 0 00-.233 0l-4.138 2.175a.25.25 0 01-.362-.263l.79-4.607a.25.25 0 00-.072-.222L4.753 9.882a.25.25 0 01.14-.427l4.625-.672zM12 14.533c.28 0 .559.067.814.2l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39v7.143z"
    })
  });
};
const check = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M18.3 5.6L9.9 16.9l-4.6-3.4-.9 2.4 5.8 4.3 9.3-12.6z"
  })
});
const close = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
  })
});
const colsFull = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    })
  });
};
const cols2Equal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols12 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "16.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols21 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "28.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols3Equal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "28.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "16.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols112 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "12.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols211 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "32.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols121 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "13.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "31.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols131 = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "11.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "33.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols4Equal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "13.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "32.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols5Equal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "10.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "34.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "26.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "18.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const colsCollapsed = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "4",
      y: "22.9",
      width: "40",
      height: "2.2"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const rowsCollapsed = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
      viewBox: "0 0 48 48",
      xmlns: "http://www.w3.org/1999/xlink",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
        d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
        x: "6",
        y: "22.9",
        width: "36",
        height: "2.2"
      })]
    })
  });
};
const cols6Equal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "10.4",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "35.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "29.4",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "16.4",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const cols2Grid = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "4",
      y: "18.9",
      width: "40",
      height: "2.2"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "22.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "4",
      y: "26.9",
      width: "40",
      height: "2.2"
    })]
  });
};
const cols3Grid = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    viewBox: "0 0 48 48",
    xmlns: "http://www.w3.org/1999/xlink",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M41.8,13.2V34.8H6.2V13.2H41.8M42,11H6a2,2,0,0,0-2,2V35a2,2,0,0,0,2,2H42a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "4",
      y: "22.9",
      width: "40",
      height: "2.2"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "28.9",
      y: "13",
      width: "2.2",
      height: "22"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
      x: "16.9",
      y: "13",
      width: "2.2",
      height: "22"
    })]
  });
};
const alignBottom = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M15 4H9v11h6V4zM4 18.5V20h16v-1.5H4z"
  })
});
const alignCenter = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M20 11h-5V4H9v7H4v1.5h5V20h6v-7.5h5z"
  })
});
const alignTop = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M9 20h6V9H9v11zM4 4v1.5h16V4H4z"
  })
});
const popupScratch = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "48",
  height: "48",
  viewBox: "0 0 48 48",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "1.5",
    y: "8.5",
    width: "45",
    height: "31",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "42",
    y: "11",
    width: "2",
    height: "2",
    rx: "1",
    fill: "#ED6F57"
  })]
});
const popupWithForm = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "48",
  height: "48",
  viewBox: "0 0 48 48",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "1.5",
    y: "8.5",
    width: "45",
    height: "31",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "42",
    y: "11",
    width: "2",
    height: "2",
    rx: "1",
    fill: "#ED6F57"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "16.5",
    y: "14.5",
    width: "15",
    height: "19",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "18.5",
    y: "16.5",
    width: "11",
    height: "3",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "18.5",
    y: "22.5",
    width: "11",
    height: "2",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "18.5",
    y: "26.5",
    width: "11",
    height: "5",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  })]
});
const popupWithImageAndText = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "48",
  height: "48",
  viewBox: "0 0 48 48",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Circle, {
    cx: "37.5",
    cy: "21.5",
    r: "2",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M29 28.9V19.2261C29 19.1392 29.103 19.0937 29.1673 19.1521L34.5 24L39.8086 28.826C39.8762 28.8875 39.8327 29 39.7413 29H34.5H29.1C29.0448 29 29 28.9552 29 28.9Z",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("mask", {
    id: "path-3-inside-1_3034_34948",
    fill: "white",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
      d: "M25 16C25 15.4477 25.4477 15 26 15H42C42.5523 15 43 15.4477 43 16V32C43 32.5523 42.5523 33 42 33H26C25.4477 33 25 32.5523 25 32V16Z"
    })
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M24 16C24 14.8954 24.8954 14 26 14H42C43.1046 14 44 14.8954 44 16H42H26H24ZM44 32C44 33.1046 43.1046 34 42 34H26C24.8954 34 24 33.1046 24 32H26H42H44ZM26 34C24.8954 34 24 33.1046 24 32V16C24 14.8954 24.8954 14 26 14V16V32V34ZM42 14C43.1046 14 44 14.8954 44 16V32C44 33.1046 43.1046 34 42 34V32V16V14Z",
    fill: "#ED6F57",
    mask: "url(#path-3-inside-1_3034_34948)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M5 18H21",
    stroke: "#ED6F57",
    strokeLinecap: "round",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M5 22H21",
    stroke: "#ED6F57",
    strokeLinecap: "round",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M5 26H21",
    stroke: "#ED6F57",
    strokeLinecap: "round",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M5 30H13.8889",
    stroke: "#ED6F57",
    strokeLinecap: "round",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "1.5",
    y: "8.5",
    width: "45",
    height: "31",
    rx: "0.5",
    stroke: "#ED6F57",
    fill: "none"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Rect, {
    x: "42",
    y: "11",
    width: "2",
    height: "2",
    rx: "1",
    fill: "#ED6F57"
  })]
});
const aiGeneration = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  "data-target": "generator-icon",
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  style: {
    color: 'transparent'
  },
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M6 17V21",
    stroke: "url(#paint0_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M4 19H8",
    stroke: "url(#paint1_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M17 3V7",
    stroke: "url(#paint2_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M15 5H19",
    stroke: "url(#paint3_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M6.5 5C6.5 6.933 8.067 8.5 10 8.5",
    stroke: "url(#paint4_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M10 8.5C8.067 8.5 6.5 10.067 6.5 12",
    stroke: "url(#paint5_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M6.5 12C6.5 10.067 4.933 8.5 3 8.5",
    stroke: "url(#paint6_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M3 8.5C4.933 8.5 6.5 6.933 6.5 5",
    stroke: "url(#paint7_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M11.609 15.778C14.202 15.778 16.304 13.676 16.304 11.083",
    stroke: "url(#paint8_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M16.3051 11.083C16.3051 13.676 18.4071 15.778 21.0001 15.778",
    stroke: "url(#paint9_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M21.0001 15.7781C18.4071 15.7781 16.3051 17.8801 16.3051 20.4731",
    stroke: "url(#paint10_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M16.305 20.4731C16.305 17.8801 14.203 15.7781 11.61 15.7781",
    stroke: "url(#paint11_linear_3599_37937)",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint0_linear_3599_37937",
      x1: "6",
      y1: "17",
      x2: "6",
      y2: "21",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint1_linear_3599_37937",
      x1: "6",
      y1: "18.5",
      x2: "6",
      y2: "19.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint2_linear_3599_37937",
      x1: "17",
      y1: "3",
      x2: "17",
      y2: "7",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint3_linear_3599_37937",
      x1: "17",
      y1: "4.5",
      x2: "17",
      y2: "5.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint4_linear_3599_37937",
      x1: "8.25",
      y1: "5",
      x2: "8.25",
      y2: "8.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint5_linear_3599_37937",
      x1: "8.25",
      y1: "8.5",
      x2: "8.25",
      y2: "12",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint6_linear_3599_37937",
      x1: "4.75",
      y1: "8.5",
      x2: "4.75",
      y2: "12",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint7_linear_3599_37937",
      x1: "4.75",
      y1: "5",
      x2: "4.75",
      y2: "8.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint8_linear_3599_37937",
      x1: "13.9565",
      y1: "11.083",
      x2: "13.9565",
      y2: "15.778",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint9_linear_3599_37937",
      x1: "18.6526",
      y1: "11.083",
      x2: "18.6526",
      y2: "15.778",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint10_linear_3599_37937",
      x1: "18.6526",
      y1: "15.7781",
      x2: "18.6526",
      y2: "20.4731",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint11_linear_3599_37937",
      x1: "13.9575",
      y1: "15.7781",
      x2: "13.9575",
      y2: "20.4731",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    })]
  })]
});
const formAiGeneration = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "20",
  height: "21",
  viewBox: "0 0 20 21",
  fill: "none",
  style: {
    color: 'transparent'
  },
  xmlns: "http://www.w3.org/2000/svg",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M17.5044 8.5V20C17.5044 20.3 17.3044 20.5 17.0044 20.5H3.00439C2.70439 20.5 2.50439 20.3 2.50439 20V2C2.50439 1.7 2.70439 1.5 3.00439 1.5H12.8044",
    stroke: "url(#paint0_linear_3726_618)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.00439 3.5H10.0044C10.3044 3.5 10.5044 3.7 10.5044 4V6C10.5044 6.3 10.3044 6.5 10.0044 6.5H5.00439C4.70439 6.5 4.50439 6.3 4.50439 6V4C4.50439 3.7 4.70439 3.5 5.00439 3.5Z",
    stroke: "url(#paint1_linear_3726_618)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.00439 9.5H13.0044C13.3044 9.5 13.5044 9.7 13.5044 10V11C13.5044 11.3 13.3044 11.5 13.0044 11.5H5.00439C4.70439 11.5 4.50439 11.3 4.50439 11V10C4.50439 9.7 4.70439 9.5 5.00439 9.5Z",
    stroke: "url(#paint2_linear_3726_618)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.00439 13.5H15.0044C15.3044 13.5 15.5044 13.7 15.5044 14V18C15.5044 18.3 15.3044 18.5 15.0044 18.5H5.00439C4.70439 18.5 4.50439 18.3 4.50439 18V14C4.50439 13.7 4.70439 13.5 5.00439 13.5Z",
    stroke: "url(#paint3_linear_3726_618)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M16.0044 7C16.0044 5.3 17.3044 4 19.0044 4C17.3044 4 16.0044 2.7 16.0044 1C16.0044 2.7 14.7044 4 13.0044 4C13.8044 4 14.6044 4.3 15.1044 4.9C15.7044 5.4 16.0044 6.2 16.0044 7Z",
    stroke: "url(#paint4_linear_3726_618)",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint0_linear_3726_618",
      x1: "10.0044",
      y1: "1",
      x2: "10.0044",
      y2: "21",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint1_linear_3726_618",
      x1: "7.50439",
      y1: "3",
      x2: "7.50439",
      y2: "7",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint2_linear_3726_618",
      x1: "9.00439",
      y1: "9",
      x2: "9.00439",
      y2: "12",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint3_linear_3726_618",
      x1: "10.0044",
      y1: "13",
      x2: "10.0044",
      y2: "19",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint4_linear_3726_618",
      x1: "16.0057",
      y1: "1",
      x2: "16.0057",
      y2: "7.0025",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    })]
  })]
});
const contentAiGenerationIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "20",
  height: "21",
  viewBox: "0 0 20 21",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  style: {
    color: 'transparent'
  },
  ...props,
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M17.5044 8.49112V19.9911C17.5044 20.2911 17.3044 20.4911 17.0044 20.4911H3.00439C2.70439 20.4911 2.50439 20.2911 2.50439 19.9911V1.99112C2.50439 1.69112 2.70439 1.49112 3.00439 1.49112H12.8044",
    stroke: "url(#paint0_linear_1006_2437)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.50439 4.49112H9.50439",
    stroke: "url(#paint1_linear_1006_2437)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.50439 8.49112H13.5044",
    stroke: "url(#paint2_linear_1006_2437)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.50439 12.4911H14.5044",
    stroke: "url(#paint3_linear_1006_2437)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M5.50439 16.4911H14.5044",
    stroke: "url(#paint4_linear_1006_2437)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M16.0044 6.99112C16.0044 5.29112 17.3044 3.99112 19.0044 3.99112C17.3044 3.99112 16.0044 2.69112 16.0044 0.991119C16.0044 2.69112 14.7044 3.99112 13.0044 3.99112C13.8044 3.99112 14.6044 4.29112 15.1044 4.89112C15.7044 5.39112 16.0044 6.19112 16.0044 6.99112Z",
    stroke: "url(#paint5_linear_1006_2437)",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint0_linear_1006_2437",
      x1: "10.0044",
      y1: "1.49112",
      x2: "10.0044",
      y2: "20.4911",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint1_linear_1006_2437",
      x1: "7.50439",
      y1: "4.24112",
      x2: "7.50439",
      y2: "5.74112",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint2_linear_1006_2437",
      x1: "9.50439",
      y1: "8.24112",
      x2: "9.50439",
      y2: "9.74112",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint3_linear_1006_2437",
      x1: "10.0044",
      y1: "12.2411",
      x2: "10.0044",
      y2: "13.7411",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint4_linear_1006_2437",
      x1: "10.0044",
      y1: "16.2411",
      x2: "10.0044",
      y2: "17.7411",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint5_linear_1006_2437",
      x1: "16.0044",
      y1: "0.991119",
      x2: "16.0044",
      y2: "6.99112",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    })]
  })]
});
const aiLayoutGeneratorIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "21",
  height: "21",
  viewBox: "0 0 21 21",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  style: {
    color: 'transparent'
  },
  ...props,
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M19.5 8V19.5C19.5 19.8 19.3 20 19 20H1C0.7 20 0.5 19.8 0.5 19.5V1.5C0.5 1.2 0.7 1 1 1H12.8",
    stroke: "url(#paint0_linear_1036_1071)",
    strokeLinecap: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M17 6.5C17 4.8 18.3 3.5 20 3.5C18.3 3.5 17 2.2 17 0.5C17 2.2 15.7 3.5 14 3.5C14.8 3.5 15.6 3.8 16.1 4.4C16.7 4.9 17 5.7 17 6.5Z",
    stroke: "url(#paint1_linear_1036_1071)",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M3 3H10C10.3 3 10.5 3.2 10.5 3.5V9.5C10.5 9.8 10.3 10 10 10H3C2.7 10 2.5 9.8 2.5 9.5V3.5C2.5 3.2 2.7 3 3 3Z",
    stroke: "url(#paint2_linear_1036_1071)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M3 12H10C10.3 12 10.5 12.2 10.5 12.5V17.5C10.5 17.8 10.3 18 10 18H3C2.7 18 2.5 17.8 2.5 17.5V12.5C2.5 12.2 2.7 12 3 12Z",
    stroke: "url(#paint3_linear_1036_1071)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "none",
    d: "M13 9H17C17.3 9 17.5 9.2 17.5 9.5V17.5C17.5 17.8 17.3 18 17 18H13C12.7 18 12.5 17.8 12.5 17.5V9.5C12.5 9.2 12.7 9 13 9Z",
    stroke: "url(#paint4_linear_1036_1071)"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint0_linear_1036_1071",
      x1: "10",
      y1: "0.99",
      x2: "10",
      y2: "19.99",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint1_linear_1036_1071",
      x1: "17",
      y1: "0.49",
      x2: "17",
      y2: "6.49",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint2_linear_1036_1071",
      x1: "6.5",
      y1: "2.5",
      x2: "6.5",
      y2: "10.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint3_linear_1036_1071",
      x1: "6.5",
      y1: "11.5",
      x2: "6.5",
      y2: "18.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint4_linear_1036_1071",
      x1: "15",
      y1: "8.5",
      x2: "15",
      y2: "18.5",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    })]
  })]
});
const comparisonTableIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  width: "24",
  height: "24",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  ...props,
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.G, {
    "clip-path": "url(#clip0_1028_2592)",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
      d: "M20 3H4C3.45 3 3 3.45 3 4V19C3 19.55 3.45 20 4 20H11.502C12.052 20 12.502 19.55 12.502 19V12H20C20.55 12 21 11.55 21 11V4C21 3.45 20.55 3 20 3ZM11.502 19H4V12H11.502V19ZM4 4H20V11H12.502V3.82L11.502 3.64V11H4V4Z",
      fill: "url(#paint0_linear_1028_2592)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
      d: "M16.8007 12.7084C16.8822 12.5432 17.1178 12.5432 17.1993 12.7084L18.1239 14.5818C18.1562 14.6474 18.2188 14.6929 18.2912 14.7034L20.3586 15.0038C20.5409 15.0303 20.6137 15.2543 20.4818 15.3829L18.9858 16.8411C18.9334 16.8922 18.9095 16.9657 18.9219 17.0378L19.275 19.0969C19.3062 19.2785 19.1156 19.4169 18.9526 19.3312L17.1034 18.359C17.0387 18.325 16.9613 18.325 16.8966 18.359L15.0474 19.3312C14.8844 19.4169 14.6938 19.2785 14.725 19.0969L15.0781 17.0378C15.0905 16.9657 15.0666 16.8922 15.0142 16.8411L13.5182 15.3829C13.3863 15.2543 13.4591 15.0303 13.6414 15.0038L15.7088 14.7034C15.7812 14.6929 15.8438 14.6474 15.8761 14.5818L16.8007 12.7084Z",
      fill: "url(#paint1_linear_1028_2592)"
    })]
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Defs, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint0_linear_1028_2592",
      x1: "12",
      y1: "3",
      x2: "12",
      y2: "20",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.LinearGradient, {
      id: "paint1_linear_1028_2592",
      x1: "17",
      y1: "12.3046",
      x2: "17",
      y2: "19.5407",
      gradientUnits: "userSpaceOnUse",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        stopColor: "#ED6F57"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("stop", {
        offset: "1",
        stopColor: "#F22B6C"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("clipPath", {
      id: "clip0_1028_2592",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("rect", {
        width: "18",
        height: "17",
        fill: "white",
        transform: "translate(3 3)"
      })
    })]
  })]
});

// Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.
const heartIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512",
  ...props,
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M225.8 468.2l-2.5-2.3L48.1 303.2C17.4 274.7 0 234.7 0 192.8l0-3.3c0-70.4 50-130.8 119.2-144C158.6 37.9 198.9 47 231 69.6c9 6.4 17.4 13.8 25 22.3c4.2-4.8 8.7-9.2 13.5-13.3c3.7-3.2 7.5-6.2 11.5-9c0 0 0 0 0 0C313.1 47 353.4 37.9 392.8 45.4C462 58.6 512 119.1 512 189.5l0 3.3c0 41.9-17.4 81.9-48.1 110.4L288.7 465.9l-2.5 2.3c-8.2 7.6-19 11.9-30.2 11.9s-22-4.2-30.2-11.9zM239.1 145c-.4-.3-.7-.7-1-1.1l-17.8-20-.1-.1s0 0 0 0c-23.1-25.9-58-37.7-92-31.2C81.6 101.5 48 142.1 48 189.5l0 3.3c0 28.5 11.9 55.8 32.8 75.2L256 430.7 431.2 268c20.9-19.4 32.8-46.7 32.8-75.2l0-3.3c0-47.3-33.6-88-80.1-96.9c-34-6.5-69 5.4-92 31.2c0 0 0 0-.1 .1s0 0-.1 .1l-17.8 20c-.3 .4-.7 .7-1 1.1c-4.5 4.5-10.6 7-16.9 7s-12.4-2.5-16.9-7z"
  })
});
const heartFilledIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M47.6 300.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9L464.4 300.4c30.4-28.3 47.6-68 47.6-109.5v-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96 244 84c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1v5.8c0 41.5 17.2 81.2 47.6 109.5z"
  })
});

// Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.
const timelineIcon = (props = {}) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 640 512",
  ...props,
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
    fill: "#ED6F57",
    d: "M128 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm32 97.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3L96 224l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0 54.7c-28.3 12.3-48 40.5-48 73.3c0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-54.7 256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-54.7c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3l0 54.7-320 0 0-54.7zM488 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM320 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"
  })
});

/***/ }),

/***/ "./src/blocks/helpers/use-settings.js":
/*!********************************************!*\
  !*** ./src/blocks/helpers/use-settings.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api */ "@wordpress/api");
/* harmony import */ var _wordpress_api__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/**
 * WordPress dependencies.
 */





/**
 * useSettings Hook, modifed for Otter usage.
 *
 * useSettings hook to get/update WordPress' settings database.
 *
 * Setting field needs to be registered to REST for this function to work.
 *
 * This hook works similar to get_option and update_option in PHP just without the option for a default value.
 * For notificiations to work, you need to add a Snackbar section to your React codebase if it isn't being
 * used inside the block editor.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/packages/editor/src/components/editor-snackbars/index.js
 * @author  Hardeep Asrani <hardeepasrani@gmail.com>
 * @version 1.1
 * @return {[(optionName: string) => any, (option: string, value: any, success?: string, noticeId?: string, onSuccess: Function) => void, 'loading' | 'loaded' | 'error' | 'saving']} [ getOption, updateOption, status ]
 */
let updatedSettings = {};
const useSettings = () => {
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.dispatch)('core/notices');
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('loading');
  const [settings, setSettings] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)({});
  (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    // Bail out if settings are already loaded.
    if (Object.keys(settings).length) {
      return;
    }
    const {
      getEntityRecord
    } = select('core');
    const request = getEntityRecord('root', 'site');
    if (request) {
      setStatus('loaded');
      setSettings(request);
    }
  }, [settings]);

  /**
   * Get the value of the given option.
   *
   * @param {string} option Option name.
   * @return {any} Option value.
   */
  const getOption = option => {
    return updatedSettings?.[option] || settings?.[option];
  };

  /**
   * Set the value of the given option. Also set the message to be displayed on success Notice.
   *
   * @param {string}    option    Option name.
   * @param {any}       value     Option value.
   * @param {string?}   success   Success message for Notice.
   * @param {string?}   noticeId  Notice ID.
   * @param {Function?} onSuccess Callback function to be executed on success.
   * @param {Function?} onError   Callback function to be executed on error.
   */
  const updateOption = (option, value, success = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Settings saved.', 'otter-blocks'), noticeId = undefined, onSuccess = () => {}, onError = () => {}) => {
    setStatus('saving');
    const save = new (_wordpress_api__WEBPACK_IMPORTED_MODULE_0___default().models).Settings({
      [option]: value
    }).save();
    save.success((response, status) => {
      if ('success' === status) {
        setStatus('loaded');
        createNotice('success', success, {
          isDismissible: true,
          type: 'snackbar',
          id: noticeId
        });
      }
      if ('error' === status) {
        setStatus('error');
        createNotice('error', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An unknown error occurred.', 'otter-blocks'), {
          isDismissible: true,
          type: 'snackbar',
          id: noticeId
        });
      }
      updatedSettings = response;
      setSettings(response);
      onSuccess?.(response);
    });
    save.error(response => {
      var _response$responseJSO;
      setStatus('error');
      createNotice('error', (_response$responseJSO = response?.responseJSON?.message) !== null && _response$responseJSO !== void 0 ? _response$responseJSO : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An unknown error occurred.', 'otter-blocks'), {
        isDismissible: true,
        type: 'snackbar',
        id: noticeId
      });
      onError?.(response);
    });
  };
  return [getOption, updateOption, status];
};
/* harmony default export */ __webpack_exports__["default"] = (useSettings);

/***/ }),

/***/ "./src/blocks/plugins/copy-paste/utils.ts":
/*!************************************************!*\
  !*** ./src/blocks/plugins/copy-paste/utils.ts ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addUnit: function() { return /* binding */ addUnit; },
/* harmony export */   createBoxFrom: function() { return /* binding */ createBoxFrom; },
/* harmony export */   extractThemeCSSVar: function() { return /* binding */ extractThemeCSSVar; },
/* harmony export */   getColorFromThemeStyles: function() { return /* binding */ getColorFromThemeStyles; },
/* harmony export */   getInt: function() { return /* binding */ getInt; },
/* harmony export */   getSingleValueFromBox: function() { return /* binding */ getSingleValueFromBox; },
/* harmony export */   makeBox: function() { return /* binding */ makeBox; }
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);

/**
 * Add unit to the given value if it is defined.
 * @param x    The value.
 * @param unit The unit.
 * @return
 */
const addUnit = (x, unit) => x !== undefined ? `${x}${unit}` : undefined;

/**
 * Extract the number from a given string.
 * @param s            The number in string.
 * @param defaultValue Default value.
 * @return
 */
const getInt = (s, defaultValue) => {
  defaultValue !== null && defaultValue !== void 0 ? defaultValue : defaultValue = undefined;
  if (s === undefined) {
    return defaultValue;
  }
  const x = parseInt(s);
  if (Number.isNaN(x)) {
    return defaultValue;
  }
  return x;
};

/**
 * Wrapt the given value in a box type.
 * @param x The value.
 * @return
 */
const makeBox = x => {
  return {
    top: x,
    left: x,
    right: x,
    bottom: x
  };
};

/**
 * Extract a single value from the box. Non-zero values have priority.
 * @param box The box.
 * @return
 */
const getSingleValueFromBox = box => {
  if (box === undefined) {
    return undefined;
  }
  const nonZero = Object.values(box).find(v => v !== undefined && !v.startsWith('0'));
  return nonZero !== null && nonZero !== void 0 ? nonZero : Object.values(box).pop();
};

/**
 * Extract the CSS var name from the given string source.
 * @param source    The text source with the CSS styles.
 * @param colorName The string that is contained in the desired CSS var.
 * @return
 */
const extractCSSColorVar = (source, colorName) => {
  const initPosition = source.indexOf(colorName);
  if (-1 === initPosition) {
    return undefined;
  }
  let left = initPosition;
  let right = initPosition;
  while ('{' !== source[left - 1] && '}' !== source[left - 1] && ';' !== source[left - 1] && 0 < left - 1) {
    left -= 1;
  }
  while (':' !== source[right + 1] && '{' !== source[right + 1] && '}' !== source[right + 1] && ';' !== source[right + 1] && right + 1 < source.length) {
    right += 1;
  }
  const s = source.slice(left, right + 1).trim();
  return s?.includes('--wp--preset--') ? s : undefined;
};
/**
 * Extract the styles from Settings and saved it to global value `window.oThemeStyles`
 * @param  settings The WP settings.
 * @return {void}
 */
const extractThemeCSSVar = settings => {
  var _settings$colors$map, _settings$gradients$m, _settings$styles$map$;
  if ('undefined' === typeof window) {
    return;
  }
  window.oThemeStyles = {
    colors: (_settings$colors$map = settings?.colors?.map(({
      slug,
      color
    }) => ({
      label: slug,
      value: color
    }))) !== null && _settings$colors$map !== void 0 ? _settings$colors$map : [],
    gradients: (_settings$gradients$m = settings?.gradients?.map(({
      slug,
      gradient
    }) => ({
      label: slug,
      value: gradient
    }))) !== null && _settings$gradients$m !== void 0 ? _settings$gradients$m : [],
    cssVars: []
  };
  const styleSources = (_settings$styles$map$ = settings?.styles?.map(({
    css
  }) => css)?.filter(x => x?.includes('--wp--preset--'))) !== null && _settings$styles$map$ !== void 0 ? _settings$styles$map$ : [];
  const excludeTags = ['var(', 'linear-gradient(', 'important'];
  window.oThemeStyles.cssVars = styleSources.flatMap(source => source.split(':')).flatMap(s => s.split(';')).filter(s => s !== undefined && excludeTags.every(t => !s.includes(t))).map(s => extractCSSColorVar(s, '--wp--preset--')).flatMap(s => s ? [s] : []); // this a little trick to simulate a filter which gives us the correct type of string[]
};

/**
 * Retrieve the desired color from the global object `window.oThemeStyles` that containts the CSS color values and vars for the current theme.
 * @param type      The type of the color.
 * @param colorName The string that is contained in the desired CSS var.
 * @return
 */
const selectColorFromThemeStyles = (type, colorName) => {
  var _window$oThemeStyles$, _window$oThemeStyles$2;
  if ('undefined' === typeof window) {
    return undefined;
  }
  if (window.oThemeStyles === undefined) {
    return undefined;
  }
  switch (type) {
    case 'color':
      const simpleColor = window.oThemeStyles.colors?.find(({
        label
      }) => label.includes(colorName));
      if (simpleColor !== undefined) {
        return simpleColor.value;
      }
      return window.oThemeStyles.cssVars?.filter(x => x.includes('color')).find(varName => varName.includes(colorName));
    case 'gradient':
      const simpleGradient = window.oThemeStyles.gradients?.find(({
        label
      }) => label.includes(colorName));
      if (simpleGradient !== undefined) {
        return simpleGradient.value;
      }
      return window.oThemeStyles.cssVars?.filter(x => x.includes('gradient')).find(varName => varName.includes(colorName));
    case 'duotone':
      return window.oThemeStyles.cssVars?.filter(x => x.includes('duotone')).find(varName => varName.includes(colorName));
    case 'any':
      const simple = [...((_window$oThemeStyles$ = window.oThemeStyles.colors) !== null && _window$oThemeStyles$ !== void 0 ? _window$oThemeStyles$ : []), ...((_window$oThemeStyles$2 = window.oThemeStyles.gradients) !== null && _window$oThemeStyles$2 !== void 0 ? _window$oThemeStyles$2 : [])]?.find(({
        label
      }) => label.includes(colorName));
      if (simple !== undefined) {
        return simple.value;
      }
      return window.oThemeStyles.cssVars?.find(varName => varName.includes(colorName));
    default:
      return undefined;
  }
};

/**
 * Get the value of the given color name from current theme. This is a wrapper around `selectColorFromThemeStyles`.
 * @param type      The type of the color.
 * @param colorName The string that is contained in the desired CSS var.
 * @return
 */
const getColorFromThemeStyles = (type, colorName) => {
  const color = selectColorFromThemeStyles(type, colorName);
  const isCSSVar = Boolean(color?.includes('--wp--preset--'));
  return isCSSVar ? `var(${color})` : color;
};
const createBoxFrom = x => {
  if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isNumber)(x)) {
    return makeBox(addUnit(x, 'px'));
  }
  if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isString)(x)) {
    return makeBox(x);
  }
  return x;
};

/***/ }),

/***/ "./src/blocks/plugins/feedback/editor.scss":
/*!*************************************************!*\
  !*** ./src/blocks/plugins/feedback/editor.scss ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/blocks/plugins/feedback/feedback-form.js":
/*!******************************************************!*\
  !*** ./src/blocks/plugins/feedback/feedback-form.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/plugins/feedback/editor.scss");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal Dependencies
 */


const {
  version
} = window.themeisleGutenberg ? window.themeisleGutenberg : window.otterObj;
const collectedInfo = [{
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Plugin version', 'otter-blocks'),
  value: version
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Feedback', 'otter-blocks'),
  value: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Text from the above text area', 'otter-blocks')
}];
const helpTextByStatus = {
  error: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('There has been an error. Your feedback couldn\'t be sent.', 'otter-blocks'),
  emptyFeedback: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Please provide a feedback before submitting the form.', 'otter-blocks')
};

/**
 * Displays a button that opens a modal for sending feedback
 *
 * @param {import('./type').FeedbackFormProps} props
 * @return
 */
const FeedbackForm = ({
  source,
  status,
  setStatus
}) => {
  const [feedback, setFeedback] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [showInfo, setShowInfo] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const info = document.querySelector('.o-feedback-form .info');
    if (info) {
      info.style.height = showInfo ? `${info.querySelector('.wrapper')?.clientHeight}px` : '0';
    }
  }, [showInfo]);
  const sendFeedback = () => {
    const trimmedFeedback = feedback.trim();
    if (5 >= trimmedFeedback.length) {
      setStatus('emptyFeedback');
      return;
    }
    setStatus('loading');
    try {
      fetch('https://api.themeisle.com/tracking/feedback', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          Accept: 'application/json, */*;q=0.1',
          'Cache-Control': 'no-cache'
        },
        body: JSON.stringify({
          slug: 'otter-blocks',
          version,
          feedback: trimmedFeedback,
          data: {
            'feedback-area': source
          }
        })
      }).then(r => {
        if (!r.ok) {
          setStatus('error');
          return;
        }
        setStatus('submitted');
      })?.catch(error => {
        console.warn(error.message);
        setStatus('error');
      });
    } catch (error) {
      console.warn(error.message);
      setStatus('error');
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("form", {
    className: "o-feedback-form",
    onSubmit: e => {
      e.preventDefault();
      sendFeedback();
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextareaControl, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'invalid': 'emptyFeedback' === status,
        'f-error': 'error' === status
      }),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Tell us how can we help you better with Otter Blocks', 'otter-blocks'),
      value: feedback,
      rows: 7,
      cols: 50,
      onChange: value => {
        setFeedback(value);
        if (5 < value.trim().length) {
          setStatus('notSubmitted');
        }
      },
      help: helpTextByStatus[status] || false,
      autoFocus: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "info",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "wrapper",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('We value privacy, that\'s why no domain name, email address or IP addresses are collected after you submit the survey. Below is a detailed view of all data that Themeisle will receive if you fill in this survey.', 'otter-blocks')
        }), collectedInfo.map((row, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "info-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("b", {
                children: row.name
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
              children: row.value
            })]
          }, index);
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "buttons-wrap",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "toggle-info",
        "aria-expanded": showInfo,
        variant: "link",
        isLink: true,
        onClick: () => setShowInfo(!showInfo),
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('What info do we collect?', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "f-send",
        variant: "primary",
        type: "submit",
        isPrimary: true,
        disabled: 'loading' === status,
        children: 'loading' === status ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Spinner, {}) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Send feedback', 'otter-blocks')
      })]
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (FeedbackForm);

/***/ }),

/***/ "./src/blocks/plugins/feedback/index.js":
/*!**********************************************!*\
  !*** ./src/blocks/plugins/feedback/index.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FeedbackModalComponent: function() { return /* binding */ FeedbackModalComponent; }
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/plugins/feedback/editor.scss");
/* harmony import */ var _feedback_form__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./feedback-form */ "./src/blocks/plugins/feedback/feedback-form.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal Dependencies
 */



const {
  assetsPath
} = window.themeisleGutenberg ? window.themeisleGutenberg : window.otterObj;
const finishIcon = assetsPath + ('/' === assetsPath[assetsPath.length - 1] ? '' : '/') + 'icons/finish-feedback.svg';
const FeedbackModalComponent = ({
  source,
  status,
  setStatus,
  closeModal,
  isOpen
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Modal, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('o-feedback-modal', {
        'no-header': 'submitted' === status
      }),
      overlayClassName: "o-feedback-modal-overlay",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('What\'s the one thing you need in Otter?', 'otter-blocks'),
      onRequestClose: closeModal,
      shouldCloseOnClickOutside: false,
      children: 'submitted' !== status ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_feedback_form__WEBPACK_IMPORTED_MODULE_6__["default"], {
        source: source,
        status: status,
        setStatus: setStatus
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "finish-feedback",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
          src: finishIcon
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
          className: "f-title",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Thank you for your feedback', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
          className: "f-description",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Your feedback is highly appreciated and will help us to improve Otter Blocks.', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
          className: "f-done",
          variant: "secondary",
          isSecondary: true,
          onClick: closeModal,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Done', 'otter-blocks')
        })]
      })
    })
  });
};

/**
 * Displays a button that opens a modal for sending feedback
 *
 * @param {string}               content
 * @param {string}               source
 * @param {string}               text
 * @param {Button.ButtonVariant} variant
 */
const FeedbackModal = (content, source, text = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Help us improve', 'otter-blocks'), variant = 'link') => {
  const [isOpen, setIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('notSubmitted');
  const closeModal = () => {
    setIsOpen(false);
    setStatus('notSubmitted');
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      id: "o-feedback",
      variant: variant,
      isLink: 'link' === variant,
      isSecondary: 'secondary' === variant,
      isPrimary: 'primary' === variant,
      onClick: () => {
        window.oTrk?.add({
          feature: 'feedback',
          featureComponent: 'open-button'
        });
        setIsOpen(!isOpen);
      },
      children: text
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(FeedbackModalComponent, {
      isOpen: isOpen,
      status: status,
      closeModal: closeModal,
      source: source,
      setStatus: setStatus
    })]
  });
};
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_4__.addFilter)('otter.feedback', 'themeisle-gutenberg/feedback-modal', FeedbackModal);

/***/ }),

/***/ "./src/dashboard/components/ButtonControl.js":
/*!***************************************************!*\
  !*** ./src/dashboard/components/ButtonControl.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */


const ButtonControl = ({
  label,
  help,
  buttonLabel,
  disabled,
  action,
  className
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('components-base-control', 'otter-button-control', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "components-base-control_labels",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "components-base-control__label",
        children: label
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
        className: "components-base-control__help",
        children: help
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "otter-button-control-group",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        variant: "secondary",
        isSecondary: true,
        disabled: disabled,
        onClick: action,
        children: buttonLabel
      })
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (ButtonControl);

/***/ }),

/***/ "./src/dashboard/components/Deal.js":
/*!******************************************!*\
  !*** ./src/dashboard/components/Deal.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Deal = props => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "otter-deal",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("a", {
      href: props.link,
      target: "_blank",
      rel: "external noreferrer noopener",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
        src: props.image,
        alt: props.alt
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "o-urgency",
        children: props.urgencyText
      })]
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Deal);

/***/ }),

/***/ "./src/dashboard/components/Footer.js":
/*!********************************************!*\
  !*** ./src/dashboard/components/Footer.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies.
 */


const Footer = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("footer", {
    className: "otter-footer",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "otter-container",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No otters were harmed during the making of this plugin.', 'otter-blocks')
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Footer);

/***/ }),

/***/ "./src/dashboard/components/Header.js":
/*!********************************************!*\
  !*** ./src/dashboard/components/Header.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */


const NAVIGATION_ITEMS = [{
  slug: 'dashboard',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dashboard', 'otter-blocks'),
  visibility: true
}, {
  slug: 'blocks',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Blocks', 'otter-blocks'),
  visibility: true
}, {
  slug: 'integrations',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Integrations', 'otter-blocks'),
  visibility: true
}, {
  slug: 'upsell',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Free vs PRO', 'otter-blocks'),
  visibility: !Boolean(window.otterObj.hasPro)
}, {
  slug: 'feedback',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Feedback', 'otter-blocks'),
  visibility: true
}];
const Headers = ({
  isActive,
  setActive
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("header", {
    className: "otter-header",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "otter-container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "otter-logo",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
          src: window.otterObj.assetsPath + 'images/logo.png',
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Otter – Page Builder Blocks & Extensions for Gutenberg', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("abbr", {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(
          // translators: %s: version number
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Version: %s', 'otter-blocks'), window.otterObj.version),
          className: "version",
          children: window.otterObj.version
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("nav", {
        className: "otter-navigation",
        children: NAVIGATION_ITEMS.map(item => item.visibility && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("button", {
          className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
            'is-active': item.slug === (isActive || 'dashboard')
          }),
          onClick: () => setActive(item.slug),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
            children: item.label
          })
        }, item.slug))
      })]
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Headers);

/***/ }),

/***/ "./src/dashboard/components/Infobox.js":
/*!*********************************************!*\
  !*** ./src/dashboard/components/Infobox.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
/**
 * WordPress dependencies.
 */



const Infobox = ({
  title,
  children
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelBody, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "otter-info",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
        children: title
      }), children]
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Infobox);

/***/ }),

/***/ "./src/dashboard/components/LicenseField.js":
/*!**************************************************!*\
  !*** ./src/dashboard/components/LicenseField.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Infobox_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Infobox.js */ "./src/dashboard/components/Infobox.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
/**
 * WordPress dependencies.
 */






/**
 * Internal dependencies.
 */


const LicenseField = () => {
  const [isLoading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const [license, setLicense] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(window.otterObj?.license);
  const [licenseKey, setLicenseKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/notices');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    const statuses = ['valid', 'active_expired'];
    if (license.key && statuses.includes(license.valid)) {
      setLicenseKey(license.key);
    }
  }, [license]);
  const onSaveLicense = data => {
    setLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
      path: 'otter/v1/toggle_license',
      method: 'POST',
      data
    }).then(res => {
      setLoading(false);
      createNotice(res.success ? 'success' : 'error', res.message, {
        isDismissible: true,
        type: 'snackbar'
      });
      if (res?.success && res.license && 'free' !== res.license.key) {
        setLicense(res.license);
        setLicenseKey(res.license.key);
      } else {
        setLicense({});
        setLicenseKey('');
      }
      window.location.reload();
    }).catch(err => {
      setLoading(false);
      console.log(err);
    });
  };
  const isValid = 'valid' === license?.valid || 'valid' === license?.license;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_Infobox_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Otter Pro License', 'otter-blocks'),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enter your license from ThemeIsle purchase history in order to get plugin updates.', 'otter-blocks')
    }), Boolean(window.otterObj.hasNevePro) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Neve Pro license can also be used to activate Otter Pro.', 'otter-blocks')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
      type: "text",
      value: licenseKey,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enter license key', 'otter-blocks'),
      disabled: isLoading || isValid,
      onChange: e => setLicenseKey(e.target.value)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "otter-info-button-group is-single",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        variant: isValid ? 'secondary' : 'primary',
        isPrimary: !isValid,
        isSecondary: isValid,
        isBusy: isLoading,
        disabled: isLoading,
        onClick: () => {
          onSaveLicense({
            action: isValid ? 'deactivate' : 'activate',
            key: isValid ? undefined : licenseKey
          });
        },
        children: isValid ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Deactivate', 'otter-blocks') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activate', 'otter-blocks')
      })
    }), isValid && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "otter-license-footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("p", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
          icon: "yes"
        }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(
        // translators: %s: expiration date
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Valid - Expires %s', 'otter-blocks'), license.expiration)]
      })
    }), 'active_expired' === license?.valid && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "otter-license-footer is-expired",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('License Key has expired. In order to continue receiving support and software updates you must renew your license key.', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
          href: `${window.otterObj.storeURL}?license=${licenseKey}`,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Renew License', 'otter-blocks')
        })
      })]
    }), !isValid && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
      className: "otter-license-purchase-history",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
        href: window.otterObj.purchaseHistoryURL,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get license from Purchase History', 'otter-blocks')
      })
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (LicenseField);

/***/ }),

/***/ "./src/dashboard/components/Main.js":
/*!******************************************!*\
  !*** ./src/dashboard/components/Main.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../blocks/helpers/use-settings.js */ "./src/blocks/helpers/use-settings.js");
/* harmony import */ var _Sidebar_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Sidebar.js */ "./src/dashboard/components/Sidebar.js");
/* harmony import */ var _pages_Dashboard_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./pages/Dashboard.js */ "./src/dashboard/components/pages/Dashboard.js");
/* harmony import */ var _pages_Upsell_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pages/Upsell.js */ "./src/dashboard/components/pages/Upsell.js");
/* harmony import */ var _pages_Integrations_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./pages/Integrations.js */ "./src/dashboard/components/pages/Integrations.js");
/* harmony import */ var _pages_Feedback_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./pages/Feedback.js */ "./src/dashboard/components/pages/Feedback.js");
/* harmony import */ var _NoticeCard__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./NoticeCard */ "./src/dashboard/components/NoticeCard.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _pages_Blocks__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./pages/Blocks */ "./src/dashboard/components/pages/Blocks.js");
/* harmony import */ var _Deal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Deal */ "./src/dashboard/components/Deal.js");
/* harmony import */ var _WelcomeNotice_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./WelcomeNotice.js */ "./src/dashboard/components/WelcomeNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
/**
 * WordPress dependencies.
 */




/**
 * Internal dependencies.
 */












let isWelcomePage = false;
if (typeof window !== 'undefined' && window.location) {
  const urlParams = new URLSearchParams(window.location.search);
  isWelcomePage = urlParams.get('welcome') === 'true';
}
const Main = ({
  currentTab,
  setTab
}) => {
  const [getOption, updateOption, status] = (0,_blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const feedbackBtn = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_10__.applyFilters)('otter.feedback', '', 'dashboard', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Share your Feedback', 'otter-blocks'), 'secondary');
  if ('loading' === status) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Placeholder, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Spinner, {})
    });
  }
  const Content = () => {
    switch (currentTab) {
      case 'integrations':
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("div", {
          className: "otter-left",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_pages_Integrations_js__WEBPACK_IMPORTED_MODULE_7__["default"], {})
        });
      case 'upsell':
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_pages_Upsell_js__WEBPACK_IMPORTED_MODULE_6__["default"], {});
      case 'feedback':
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_pages_Feedback_js__WEBPACK_IMPORTED_MODULE_8__["default"], {});
      case 'blocks':
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_pages_Blocks__WEBPACK_IMPORTED_MODULE_11__["default"], {});
      default:
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("div", {
          className: "otter-left",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_pages_Dashboard_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
            status: status,
            getOption: getOption,
            updateOption: updateOption
          })
        });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [window.otterObj?.deal?.active && window.otterObj.deal?.bannerStoreUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_Deal__WEBPACK_IMPORTED_MODULE_12__["default"], {
      link: window.otterObj.deal.bannerStoreUrl,
      image: window.otterObj.deal.bannerUrl,
      alt: window.otterObj.deal.bannerAlt,
      urgencyText: window.otterObj.deal.urgencyText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("div", {
      id: "tsdk_banner",
      className: "otter-banner"
    }), isWelcomePage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_WelcomeNotice_js__WEBPACK_IMPORTED_MODULE_13__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
      className: `otter-main is-${currentTab}`,
      children: ['dashboard' === currentTab && window.otterObj.showFeedbackNotice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(_NoticeCard__WEBPACK_IMPORTED_MODULE_9__["default"], {
        slug: "feedback",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("img", {
          src: window.otterObj.assetsPath + 'images/dashboard-feedback.png',
          style: {
            maxWidth: '100%',
            objectFit: 'cover'
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
          className: "notice-text",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("h3", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What\'s the one thing you need in Otter Blocks?', 'otter-blocks')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('We\'re always looking for suggestions to further improve Otter Blocks and your feedback can help us do that.', 'otter-blocks')
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("span", {
          children: feedbackBtn
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(Content, {}), 'upsell' !== currentTab && 'blocks' !== currentTab && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)("div", {
        className: "otter-right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_Sidebar_js__WEBPACK_IMPORTED_MODULE_4__["default"], {
          setTab: setTab
        })
      })]
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Main);

/***/ }),

/***/ "./src/dashboard/components/NeveSidebarUpsell.js":
/*!*******************************************************!*\
  !*** ./src/dashboard/components/NeveSidebarUpsell.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
/**
 * WordPress dependencies.
 */




// Install theme.

const InstallTheme = slug => {
  return new Promise(resolve => {
    wp.updates.ajax('install-theme', {
      slug,
      success: () => {
        resolve({
          success: true
        });
      },
      error: err => {
        resolve({
          success: false,
          code: err.errorCode
        });
      }
    });
  });
};

// Activate theme.
const activateTheme = url => {
  return new Promise(resolve => {
    jQuery.get(url).done(() => {
      resolve({
        success: true
      });
    }).fail(() => {
      resolve({
        success: false
      });
    });
  });
};
const NeveSidebarUpsell = () => {
  const [isShowNeveUpsell, setShowNeveUpsell] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const [isNeveInstalled, setNeveInstalled] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(window.otterObj?.neveInstalled);
  const [showStatus, setShowStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const [progress, setProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (Boolean(isNeveInstalled)) {
      setShowNeveUpsell(true);
    }
  }, [isNeveInstalled]);
  const ThemeInstallActivateRequest = async e => {
    e.preventDefault();
    setShowStatus(true);
    setProgress('installing');
    await InstallTheme('neve');
    setProgress('activating');
    await activateTheme(window.otterObj?.neveThemeActivationUrl);
    setProgress('done');
  };
  const installThemeRequestStatus = () => {
    if ('done' === progress) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: 'done',
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
          children: [" ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Awesome! You are all set!', 'otter-blocks')]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          icon: 'external',
          isPrimary: true,
          href: window.otterObj?.neveDashboardUrl,
          target: "_blank",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Go to Neve dashboard', 'otter-blocks')
        })]
      });
    }
    if (progress) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
        className: "otter-neve-progress",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: "dashicons dashicons-update spin"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
          children: ['installing' === progress && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Installing', 'otter-blocks'), 'activating' === progress && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activating', 'otter-blocks'), "\u2026"]
        })]
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: !isShowNeveUpsell && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "otter-nv-sidebar-upsell",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "otter-nv-sidebar-left",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "otter-nv-sidebar-heading",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
            src: window.otterObj.assetsPath + 'images/neve-logo.png'
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('- Experience lightning fast performance!', 'otter-blocks')
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "otter-nv-sidebar-text",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("strong", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Fast, Flexible, and Free:', 'otter-blocks')
            }), " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Whether you\'re managing a blog, an online store, or a business website, Neve ensures top-tier responsiveness and SEO optimization. Install now and experience the difference today.', 'otter-blocks')]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "otter-nv-sidebar-active-website",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              children: "300,000+"
            }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Active websites', 'otter-blocks')]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              children: "1050+"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
              src: window.otterObj.assetsPath + 'images/star.png',
              width: "57"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "otter-nv-sidebar-action",
          children: [!showStatus && 'done' !== progress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
            variant: "primary",
            onClick: ThemeInstallActivateRequest,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Install & Activate Neve Theme', 'otter-blocks')
          }), (showStatus || 'done' === progress) && installThemeRequestStatus(), !showStatus && 'done' !== progress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
            icon: 'external',
            iconPosition: 'right',
            variant: "secondary",
            href: window.otterObj?.neveThemePreviewUrl,
            target: "_blank",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Theme Preview', 'otter-blocks')
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "otter-nv-sidebar-right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
          src: window.otterObj.assetsPath + 'images/neve-upsell-img.png'
        })
      })]
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (NeveSidebarUpsell);

/***/ }),

/***/ "./src/dashboard/components/NoticeCard.js":
/*!************************************************!*\
  !*** ./src/dashboard/components/NoticeCard.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close-small.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
/**
 * WordPress dependencies.
 */





const NoticeCard = ({
  slug,
  className,
  children
}) => {
  const storageKey = `otter-${slug}-dismissed`;
  const [dismissed, setDismissed] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(localStorage.getItem(storageKey));
  const dismissNotice = () => {
    localStorage.setItem(storageKey, 'true');
    setDismissed('true');
  };
  if (dismissed) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelBody, {
    className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('notice-card', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
      className: "dismiss",
      onClick: dismissNotice,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"]
      })
    }), children]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (NoticeCard);

/***/ }),

/***/ "./src/dashboard/components/Notices.js":
/*!*********************************************!*\
  !*** ./src/dashboard/components/Notices.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/notices */ "@wordpress/notices");
/* harmony import */ var _wordpress_notices__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_notices__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
/**
 * WordPress dependencies.
 */





const Notices = () => {
  const notices = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_wordpress_notices__WEBPACK_IMPORTED_MODULE_3__.store).getNotices(), []);
  const {
    removeNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_wordpress_notices__WEBPACK_IMPORTED_MODULE_3__.store);
  const snackbarNotices = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.filter)(notices, {
    type: 'snackbar'
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SnackbarList, {
    notices: snackbarNotices,
    className: "components-editor-notices__snackbar",
    onRemove: removeNotice
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Notices);

/***/ }),

/***/ "./src/dashboard/components/Sidebar.js":
/*!*********************************************!*\
  !*** ./src/dashboard/components/Sidebar.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Infobox_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Infobox.js */ "./src/dashboard/components/Infobox.js");
/* harmony import */ var _LicenseField_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./LicenseField.js */ "./src/dashboard/components/LicenseField.js");
/* harmony import */ var _blocks_helpers_helper_functions_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../blocks/helpers/helper-functions.js */ "./src/blocks/helpers/helper-functions.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
/**
 * WordPress dependencies.
 */




/**
 * Internal dependencies.
 */




const Sidebar = ({
  setTab
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [Boolean(window.otterObj.hasPro) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_LicenseField_js__WEBPACK_IMPORTED_MODULE_4__["default"], {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_Infobox_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Otter Pro', 'otter-blocks'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("ul", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pro Block Addons', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pro Block Patterns', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dynamic Content', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Block Conditions', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('WooCommerce Product Builder', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Priority Support', 'otter-blocks')
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "otter-info-button-group",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          variant: "secondary",
          isSecondary: true,
          onClick: () => setTab('upsell'),
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn More', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          variant: "primary",
          isPrimary: true,
          target: "_blank",
          href: (0,_blocks_helpers_helper_functions_js__WEBPACK_IMPORTED_MODULE_5__.setUtm)(window.otterObj.upgradeLink, 'infobox'),
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Explore Otter Pro', 'otter-blocks')
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_Infobox_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Useful links', 'otter-blocks'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("ul", {
        className: "otter-info-links",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
            href: "https://wordpress.org/support/plugin/otter-blocks",
            target: "_blank",
            rel: "noreferrer",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Support', 'otter-blocks')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
            href: "https://github.com/Codeinwp/otter-blocks/discussions",
            target: "_blank",
            rel: "noreferrer",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Feature request', 'otter-blocks')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
            href: "https://wordpress.org/support/plugin/otter-blocks/reviews/#new-post",
            target: "_blank",
            rel: "noreferrer",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Leave a review', 'otter-blocks')
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "otter-info-button-group is-single",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          variant: "secondary",
          isSecondary: true,
          target: "_blank",
          href: window.otterObj.docsLink,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Documentation', 'otter-blocks')
        })
      })]
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Sidebar);

/***/ }),

/***/ "./src/dashboard/components/WelcomeNotice.js":
/*!***************************************************!*\
  !*** ./src/dashboard/components/WelcomeNotice.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
/**
 * WordPress dependencies.
 */



const WelcomeNotice = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "otter-nv-sidebar-upsell o-welcome",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "otter-nv-sidebar-left",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "otter-nv-sidebar-heading",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Welcome to Otter!', 'otter-blocks')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "otter-nv-sidebar-text",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('We\'re excited to help you build beautiful, fast, and flexible WordPress sites. Explore our powerful blocks and customization tools — your site-building journey just got a whole lot easier.', 'otter-blocks')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "otter-nv-sidebar-action",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          variant: "primary",
          href: window.otterObj?.newPageUrl,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create New Page', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          icon: "external",
          iconPosition: "right",
          variant: "secondary",
          href: window.otterObj?.otterPage,
          target: "_blank",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn More', 'otter-blocks')
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "otter-nv-sidebar-right",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("iframe", {
        src: "https://www.youtube.com/embed/WcS2Vi4IOYw",
        title: "Otter - Page Builder Blocks & Extensions for Gutenberg",
        frameBorder: "0",
        allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
        referrerPolicy: "strict-origin-when-cross-origin",
        allowfullscreen: true
      })
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (WelcomeNotice);

/***/ }),

/***/ "./src/dashboard/components/pages/Blocks.js":
/*!**************************************************!*\
  !*** ./src/dashboard/components/pages/Blocks.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_edit_site__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/edit-site */ "@wordpress/edit-site");
/* harmony import */ var _wordpress_edit_site__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_edit_site__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../blocks/helpers/icons */ "./src/blocks/helpers/icons.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */





// Hack: This is by the toolchain to load the 'wp-edit-site' package so that we can use the 'core/preferences' store.


/**
 * Internal dependencies
 */


/**
 * List with all the blocks that can be disabled.
 *
 * @type {import('../../dashboard').BlocksToDisableList}
 */

const otterBlocks = [{
  'slug': 'themeisle-blocks/accordion',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Accordion', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.accordionIcon,
  'docLink': 'https://docs.themeisle.com/article/1672-accessibility-blocks#accordion'
}, {
  'slug': 'themeisle-blocks/advanced-heading',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Advanced Heading', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.headingIcon,
  'docLink': 'https://docs.themeisle.com/article/1686-global-defaults-blocks#advanced-heading'
}, {
  'slug': 'themeisle-blocks/business-hours',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Business Hours', 'otter-blocks'),
  'isPro': true,
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.businessHoursIcon,
  'docLink': 'https://docs.themeisle.com/article/1679-business-blocks#business-hours'
}, {
  'slug': 'themeisle-blocks/button-group',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Button Group', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.buttonsIcon,
  'docLink': 'https://docs.themeisle.com/article/1686-global-defaults-blocks#button-group'
}, {
  'slug': 'themeisle-blocks/circle-counter',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Circle Counter', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.circleIcon,
  'docLink': 'https://docs.themeisle.com/article/1669-tracking-blocks#circle-counter'
}, {
  'slug': 'themeisle-blocks/countdown',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Countdown', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.countdownIcon,
  'docLink': 'https://docs.themeisle.com/article/1669-tracking-blocks#countdown'
}, {
  'slug': 'themeisle-blocks/flip',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Flip Card', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.flipIcon,
  'docLink': 'https://docs.themeisle.com/article/1673-popularity-block#flip-card'
}, {
  'slug': 'themeisle-blocks/font-awesome-icons',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Icon', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.faIcon,
  'docLink': 'https://docs.themeisle.com/article/1676-useful-blocks#icon'
}, {
  'slug': 'themeisle-blocks/form',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Form', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.formIcon,
  'docLink': 'https://docs.themeisle.com/article/1674-form-blocks'
}, {
  'slug': 'themeisle-blocks/google-map',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Google Maps', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.googleMapIcon,
  'docLink': 'https://docs.themeisle.com/article/1675-location-blocks#google-maps'
}, {
  'slug': 'themeisle-blocks/icon-list',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Icon List', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.iconListIcon,
  'docLink': 'https://docs.themeisle.com/article/1676-useful-blocks#icon-list'
}, {
  'slug': 'themeisle-blocks/leaflet-map',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Maps', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.mapIcon,
  'docLink': 'https://docs.themeisle.com/article/1675-location-blocks#maps'
}, {
  'slug': 'themeisle-blocks/modal',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Modal', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.popupIcon,
  'docLink': 'https://docs.themeisle.com/article/2050-modal-block',
  'isPro': true
}, {
  'slug': 'themeisle-blocks/lottie',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Lottie Animation', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.lottieIcon,
  'docLink': 'https://docs.themeisle.com/article/1668-image-related-blocks#lottie-animation'
}, {
  'slug': 'themeisle-blocks/popup',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Popup', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.popupIcon,
  'docLink': 'https://docs.themeisle.com/article/1551-the-popup-block-otter-blocks-library'
}, {
  'slug': 'themeisle-blocks/posts-grid',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Posts', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.postsIcon,
  'docLink': 'https://docs.themeisle.com/article/1530-posts-block'
}, {
  'slug': 'themeisle-blocks/progress-bar',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Progress Bar', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.progressIcon,
  'docLink': 'https://docs.themeisle.com/article/1669-tracking-blocks#progress-bar'
}, {
  'slug': 'themeisle-blocks/review',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Product Review', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.reviewIcon,
  'docLink': 'https://docs.themeisle.com/article/1671-shop-related-blocks#product-review'
}, {
  'slug': 'themeisle-blocks/review-comparison',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Review Comparison Table', 'otter-blocks'),
  'isPro': true,
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.comparisonTableIcon,
  'docLink': 'https://docs.themeisle.com/article/1671-shop-related-blocks#comparison-table'
}, {
  'slug': 'themeisle-blocks/advanced-columns',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Section', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.columnsIcon,
  'docLink': 'https://docs.themeisle.com/article/1833-the-section-block-otter-blocks-library'
}, {
  'slug': 'themeisle-blocks/sharing-icons',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Sharing Icons', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.sharingIcon,
  'docLink': 'https://docs.themeisle.com/article/1673-popularity-block#sharing-icons'
}, {
  'slug': 'themeisle-blocks/slider',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Image Slider', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.sliderIcon,
  'docLink': 'https://docs.themeisle.com/article/1668-image-related-blocks#slider'
}, {
  'slug': 'themeisle-blocks/stripe-checkout',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Stripe Checkout', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.cartIcon,
  'docLink': 'https://docs.themeisle.com/article/1688-integrations-related-blocks#stripe-checkout'
}, {
  'slug': 'themeisle-blocks/tabs',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Tabs', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.tabsIcon,
  'docLink': 'https://docs.themeisle.com/article/1672-accessibility-blocks#tabs'
}, {
  'slug': 'themeisle-gutenberg/live-search',
  // TODO: find why this can not be disabled.
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Live Search', 'otter-blocks'),
  'isPro': true,
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.searchIcon,
  'docLink': 'https://docs.themeisle.com/article/1747-the-live-search-feature-otter-features-library'
}, {
  'slug': 'themeisle-blocks/content-generator',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('AI Block', 'otter-blocks'),
  'icon': () => _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.aiGeneration,
  'docLink': 'https://docs.themeisle.com/article/1917-the-ai-block-otter-blocks-library#content-generator'
}, {
  'slug': 'themeisle-blocks/timeline',
  'name': (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Timeline', 'otter-blocks'),
  'icon': _blocks_helpers_icons__WEBPACK_IMPORTED_MODULE_7__.timelineIcon,
  'docLink': 'https://docs.themeisle.com/article/2051-timeline-block'
}].sort((a, b) => a.name.localeCompare(b.name));

/**
 * Dashboard Block Card component.
 * @param {import('../../dashboard').BlockCardProps} props Component props.
 */
const BlockCard = ({
  block,
  isLoading,
  onToggle
}) => {
  var _block$docLink;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "o-block-card",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('o-block-card__icon', {
        'is-disabled': block?.isPro && !otterObj?.hasPro
      }),
      children: (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isString)(block.icon) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: `dashicons dashicons-${block.icon}`
      }) : block.icon?.()
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "o-block-card__description",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("h3", {
        children: block.name
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("a", {
        href: (_block$docLink = block?.docLink) !== null && _block$docLink !== void 0 ? _block$docLink : 'https://docs.themeisle.com/category/1611-blocks-library',
        target: "_blank",
        rel: "noopener noreferrer",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'otter-blocks')
      }), block?.isPro && !otterObj?.hasPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
        children: ["|", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("a", {
          href: otterObj.upgradeLink,
          target: "_blank",
          rel: "noopener noreferrer",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get Pro', 'otter-blocks')
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "o-block-card__action",
      children: isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Spinner, {}) : block?.isPro && !(otterObj?.hasPro && 'valid' === otterObj?.license.valid) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "o-block-upsell",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pro', 'otter-blocks')
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
        checked: !block?.isDisabled,
        onChange: onToggle
      })
    })]
  });
};

/**
 * Dashboard Header component.
 * @param {import('../../dashboard').BlockCardHeaderProps} props Component props.
 */
const Header = ({
  blocks,
  onDisableAll,
  onEnableAll,
  canDisplayBtn
}) => {
  const allEnabled = blocks.every(block => !block.isDisabled);
  const allDisabled = blocks.every(block => block.isDisabled);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "o-blocks-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "o-blocks-header__left",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("h3", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Otter Blocks', 'otter-blocks')
      })
    }), canDisplayBtn && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "o-blocks-header__right",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        variant: "secondary",
        disabled: allDisabled,
        onClick: onDisableAll,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Disable All', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        variant: "primary",
        disabled: allEnabled,
        onClick: onEnableAll,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Enable All', 'otter-blocks')
      })]
    })]
  });
};

/**
 * Dashboard Blocks component page.
 */
const Blocks = () => {
  const [blocksStatus, setBlocksStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(otterBlocks);
  const [canShowNotice, canShowNoticeSet] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const {
    preferencesHiddenBlocks,
    isLoading
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    /**
     * Array of hidden block types.
     * @type {Array<string>|undefined}
     */
    const hiddenBlocks = select('core/preferences')?.get('core/edit-post', 'hiddenBlockTypes');
    const isResolving = select('core/preferences').isResolving('get', ['hiddenBlockTypes']);
    return {
      preferencesHiddenBlocks: hiddenBlocks ? new Set(hiddenBlocks) : undefined,
      isLoading: isResolving
    };
  }, [blocksStatus]);

  /**
   * Update the WP Option with the new value.
   * @param {import('../../dashboard').BlocksToDisableList} blocks Blocks to be updated.
   */
  const sendUpdates = blocks => {
    const newPreferencesHiddenBlocks = new Set();

    // Copy the old preferences.
    if (preferencesHiddenBlocks) {
      preferencesHiddenBlocks.forEach(block => {
        newPreferencesHiddenBlocks.add(block);
      });
    }

    // Add the new preferences.
    blocks.forEach(block => {
      if (block.isDisabled) {
        newPreferencesHiddenBlocks.add(block.slug);
      } else {
        newPreferencesHiddenBlocks.delete(block.slug);
      }
    });
    (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.dispatch)('core/preferences').set('core/edit-post', 'hiddenBlockTypes', [...newPreferencesHiddenBlocks]);
  };

  /**
   * Toggle the block status.
   * @param {string} blockSlug Block slug.
   */
  const toggleBlock = blockSlug => {
    const updatedBlocksStatus = blocksStatus.map(block => {
      if (block.slug === blockSlug) {
        block.isDisabled = !block.isDisabled;
      }
      return block;
    });
    sendUpdates(updatedBlocksStatus);
    setBlocksStatus(updatedBlocksStatus);
    canShowNoticeSet(true);
  };

  /**
   * Disable all blocks and update the WP Option.
   */
  const onDisableAll = () => {
    const updatedBlocksStatus = blocksStatus.map(block => {
      if (block.isPro && !otterObj.hasPro) {
        return block;
      }
      block.isDisabled = true;
      return block;
    });
    sendUpdates(updatedBlocksStatus);
    setBlocksStatus(updatedBlocksStatus);
    canShowNoticeSet(true);
  };

  /**
   * Enable all blocks and update the WP Option.
   */
  const onEnableAll = () => {
    const updatedBlocksStatus = blocksStatus.map(block => {
      block.isDisabled = false;
      return block;
    });
    sendUpdates(updatedBlocksStatus);
    setBlocksStatus(updatedBlocksStatus);
    canShowNoticeSet(true);
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (window.tsdk_reposition_notice) {
      window.tsdk_reposition_notice();
    }
  }, []);

  /**
   * Initiate the blocks' status.
   */
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (isLoading) {
      return;
    }
    const updatedBlocksStatus = blocksStatus.map(block => {
      if (preferencesHiddenBlocks?.has(block.slug)) {
        block.isDisabled = true;
      } else {
        block.isDisabled = false;
      }
      return block;
    });
    setBlocksStatus(updatedBlocksStatus);
  }, [isLoading]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!canShowNotice || isLoading) {
      return;
    }
    (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.dispatch)?.('core/notices')?.createNotice('info', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Option Updated.', 'otter-blocks'), {
      isDismissible: true,
      type: 'snackbar',
      id: 'saved-options'
    });
    canShowNoticeSet(false);
  }, [canShowNotice, preferencesHiddenBlocks, isLoading]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Header, {
      blocks: blocksStatus,
      onDisableAll: onDisableAll,
      onEnableAll: onEnableAll,
      canDisplayBtn: !isLoading
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "o-block-cards",
      children: blocksStatus.map(block => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(BlockCard, {
          block: block,
          isLoading: isLoading,
          onToggle: () => toggleBlock(block.slug)
        }, block.slug);
      })
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Blocks);

/***/ }),

/***/ "./src/dashboard/components/pages/Dashboard.js":
/*!*****************************************************!*\
  !*** ./src/dashboard/components/pages/Dashboard.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _ButtonControl_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../ButtonControl.js */ "./src/dashboard/components/ButtonControl.js");
/* harmony import */ var _blocks_helpers_use_settings__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../blocks/helpers/use-settings */ "./src/blocks/helpers/use-settings.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
/**
 * External dependencies.
 */


/**
 * WordPress dependencies.
 */






/**
 * Internal dependencies.
 */



const optionMapping = {
  enableCustomCss: 'themeisle_blocks_settings_css_module',
  enableBlocksAnimation: 'themeisle_blocks_settings_blocks_animation',
  enableBlockConditions: 'themeisle_blocks_settings_block_conditions',
  enablePatternsLibrary: 'themeisle_blocks_settings_patterns_library',
  enableDynamicContent: 'themeisle_blocks_settings_dynamic_content',
  enableOnboardingWizard: 'themeisle_blocks_settings_onboarding_wizard',
  enableSectionDefaultBlock: 'themeisle_blocks_settings_default_block',
  enableOptimizeAnimationsCss: 'themeisle_blocks_settings_optimize_animations_css',
  enableRichSchema: 'themeisle_blocks_settings_disable_review_schema',
  enableReviewScale: 'themeisle_blocks_settings_review_scale',
  enableHighlightDynamic: 'themeisle_blocks_settings_highlight_dynamic',
  enableAnonymousDataTracking: 'otter_blocks_logger_flag',
  enableAIToolbar: 'themeisle_blocks_settings_block_ai_toolbar_module'
};
const initialState = {
  values: {
    enableCustomCss: false,
    enableBlocksAnimation: false,
    enableBlockConditions: false,
    enablePatternsLibrary: false,
    enableDynamicContent: false,
    enableOnboardingWizard: false,
    enableSectionDefaultBlock: false,
    enableOptimizeAnimationsCss: false,
    enableRichSchema: false,
    enableReviewScale: false,
    enableHighlightDynamic: false,
    enableAnonymousDataTracking: 'no',
    enableAIToolbar: false
  },
  status: {
    enableCustomCss: 'init',
    enableBlocksAnimation: 'init',
    enableBlockConditions: 'init',
    enablePatternsLibrary: 'init',
    enableDynamicContent: 'init',
    enableOnboardingWizard: 'init',
    enableSectionDefaultBlock: 'init',
    enableOptimizeAnimationsCss: 'init',
    enableRichSchema: 'init',
    enableReviewScale: 'init',
    enableHighlightDynamic: 'init',
    enableAnonymousDataTracking: 'init',
    enableAIToolbar: 'init'
  },
  dirty: {
    enableCustomCss: false,
    enableBlocksAnimation: false,
    enableBlockConditions: false,
    enablePatternsLibrary: false,
    enableDynamicContent: false,
    enableOnboardingWizard: false,
    enableSectionDefaultBlock: false,
    enableOptimizeAnimationsCss: false,
    enableRichSchema: false,
    enableReviewScale: false,
    enableHighlightDynamic: false,
    enableAnonymousDataTracking: false,
    enableAIToolbar: false
  },
  old: {}
};

/**
 * Reducer.
 * @param {Object} state  The current state.
 * @param {Object} action The action to be performed.
 * @return {*}
 */
const reducer = (state, action) => {
  switch (action.type) {
    case 'init':
      state.values[action.name] = action.value;
      state.status[action.name] = 'saved';
      return {
        ...state
      };
    case 'update':
      state.old[action.name] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isString)(state.values[action.name]) ? state.values[action.name] : Boolean(state.values[action.name]);
      state.values[action.name] = action.value;
      state.dirty[action.name] = true;
      return {
        ...state
      };
    case 'status_bulk':
      action.names.forEach(name => {
        state.status[name] = action.value;
        state.dirty[name] = false;
      });
      return {
        ...state
      };
    case 'saved':
      state.status[action.name] = 'saved';
      state.values[action.name] = action.value;
      state.old[action.name] = undefined;
      return {
        ...state
      };
    case 'rollback':
      if (undefined !== state.old[action.name]) {
        state.values[action.name] = state.old[action.name];
      }
      state.old[action.name] = undefined;
      state.dirty[action.name] = false;
      state.status[action.name] = 'saved';
      return {
        ...state
      };
    default:
      return state;
  }
};
const Dashboard = () => {
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!Boolean(window.otterObj.stylesExist)) {
      setRegeneratedDisabled(true);
    }
    if (window.tsdk_reposition_notice) {
      window.tsdk_reposition_notice();
    }
  }, []);
  const [getOption, updateOption, status] = (0,_blocks_helpers_use_settings__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)('core/notices');
  const [isRegeneratedDisabled, setRegeneratedDisabled] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const [isOpen, setOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const [state, applyAction] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useReducer)(reducer, initialState);

  /**
   * Regenerate styles.
   * @return {Promise<void>}
   */
  const regenerateStyles = async () => {
    const data = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: 'otter/v1/regenerate',
      method: 'DELETE'
    });
    createNotice(data.success ? 'success' : 'error', data.data.message, {
      isDismissible: true,
      type: 'snackbar'
    });
    window.tiTrk?.with('otter').add({
      feature: 'dashboard',
      featureComponent: 'regenerate-style'
    });
    setRegeneratedDisabled(true);
    setOpen(false);
  };

  /**
   * Initialize the state with values from the WordPress options.
   */
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if ('loaded' !== status) {
      return;
    }
    Object.entries(state.status).filter(([key, value]) => 'init' === value).forEach(([name, _]) => {
      applyAction({
        type: 'init',
        name,
        value: getOption(optionMapping[name])
      });
    });
  }, [state, status, getOption]);

  /**
   * Update the WordPress options.
   */
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    const dirtyOptionNames = Object.entries(state.dirty).filter(([key, value]) => value).map(([key, value]) => key);
    if (dirtyOptionNames.length) {
      if ('error' !== status) {
        applyAction({
          type: 'status_bulk',
          value: 'saving',
          names: dirtyOptionNames
        });
      }
      for (const name of dirtyOptionNames) {
        updateOption(optionMapping[name], state.values[name], (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Settings saved.', 'otter-blocks'), 'o-settings-saved-notice', response => {
          applyAction({
            type: 'saved',
            name,
            value: response[optionMapping[name]]
          });
        }, () => {
          applyAction({
            type: 'rollback',
            name
          });
        });
      }
    }
  }, [state, status]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Modules', 'otter-blocks'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Custom CSS Module', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Custom CSS module allows to add custom CSS to each block in Block Editor.', 'otter-blocks'),
          checked: state.values.enableCustomCss,
          disabled: 'saving' === state.status.enableCustomCss,
          onChange: value => {
            applyAction({
              type: 'update',
              name: 'enableCustomCss',
              value
            });
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable AI Block Toolbar Module', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Display AI Block shortcut in Editor Blocks toolbar.', 'otter-blocks'),
          checked: state.values.enableAIToolbar,
          disabled: 'saving' === state.status.enableAIToolbar,
          onChange: value => {
            applyAction({
              type: 'update',
              name: 'enableAIToolbar',
              value
            });
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Blocks Animation Module', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Blocks Animation module allows to add CSS animations to each block in Block Editor.', 'otter-blocks'),
          checked: state.values.enableBlocksAnimation,
          disabled: 'saving' === state.status.enableBlocksAnimation,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableBlocksAnimation',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Visibility Condition Module', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Blocks Conditions module allows to hide/display blocks to your users based on selected conditions.', 'otter-blocks'),
          checked: state.values.enableBlockConditions,
          disabled: 'saving' === state.status.enableBlockConditions,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableBlockConditions',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Patterns Library', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Toggle the visibility of the Patterns Library in the Block Editor. Patterns will still be visible in the Block Editor.', 'otter-blocks'),
          checked: state.values.enablePatternsLibrary,
          disabled: 'saving' === state.status.enablePatternsLibrary,
          onChange: value => applyAction({
            type: 'update',
            name: 'enablePatternsLibrary',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Dynamic Content Module', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Toggle the Dynamic Content Module that includes Dynamic Content, Link and Images.', 'otter-blocks'),
          checked: state.values.enableDynamicContent,
          disabled: 'saving' === state.status.enableDynamicContent,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableDynamicContent',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Theme Setup Wizard', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Toggle the visibility of the Theme Setup link in the Appearance menu.', 'otter-blocks'),
          checked: state.values.enableOnboardingWizard,
          disabled: 'saving' === state.status.enableOnboardingWizard,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableOnboardingWizard',
            value
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Other', 'otter-blocks'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Make Section your default block for Pages', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Everytime you create a new page, Section block will be appended there by default.', 'otter-blocks'),
          checked: state.values.enableSectionDefaultBlock,
          disabled: 'saving' === state.status.enableSectionDefaultBlock,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableSectionDefaultBlock',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Optimize Animations CSS', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Only load CSS for the animations that are used on the page. We recommend you to regenerate styles after you toggle this option.', 'otter-blocks'),
          checked: state.values.enableOptimizeAnimationsCss,
          disabled: 'saving' === state.status.enableOptimizeAnimationsCss,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableOptimizeAnimationsCss',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable Rich Schema', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Control if you want to show rich schema in Product Review Block.', 'otter-blocks'),
          checked: state.values.enableRichSchema,
          disabled: 'saving' === state.status.enableRichSchema,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableRichSchema',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Use 1–5 Scale for Review Block', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Use 1–5 rating scale instead of the default 1–10.', 'otter-blocks'),
          checked: state.values.enableReviewScale,
          disabled: 'saving' === state.status.enableReviewScale,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableReviewScale',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Highlight the Dynamic Text', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Easily differentiate between dynamic and normal text in the editor.', 'otter-blocks'),
          checked: state.values.enableHighlightDynamic,
          disabled: 'saving' === state.status.enableHighlightDynamic,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableHighlightDynamic',
            value
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Anonymous Data Tracking.', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Become a contributor by opting in to our anonymous data tracking. We guarantee no sensitive data is collected.', 'otter-blocks'),
          checked: 'yes' === state.values.enableAnonymousDataTracking,
          disabled: 'saving' === state.status.enableAnonymousDataTracking,
          onChange: value => applyAction({
            type: 'update',
            name: 'enableAnonymousDataTracking',
            value: value ? 'yes' : 'no'
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ButtonControl_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Regenerate Styles', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Clicking on this will delete all the Otter generated CSS files.', 'otter-blocks'),
          buttonLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Regenerate', 'otter-blocks'),
          disabled: isRegeneratedDisabled,
          action: () => setOpen(true)
        })
      })
    }), isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Are you sure?', 'otter-blocks'),
      onRequestClose: () => setOpen(false),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Are you sure you want to delete all Otter generated CSS files?', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Note: Styles will be regenerated as users start visiting your pages.', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "otter-modal-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          isSecondary: true,
          onClick: () => setOpen(false),
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          isPrimary: true,
          disabled: 'saving' === status,
          isBusy: 'saving' === status,
          onClick: regenerateStyles,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Confirm', 'otter-blocks')
        })]
      })]
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Dashboard);

/***/ }),

/***/ "./src/dashboard/components/pages/Feedback.js":
/*!****************************************************!*\
  !*** ./src/dashboard/components/pages/Feedback.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _blocks_plugins_feedback_feedback_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../blocks/plugins/feedback/feedback-form */ "./src/blocks/plugins/feedback/feedback-form.js");
/* harmony import */ var _Infobox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Infobox */ "./src/dashboard/components/Infobox.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const finishIcon = `${window.otterObj.assetsPath}icons/finish-feedback.svg`;
const Feedback = () => {
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('notSubmitted');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Infobox__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: 'submitted' !== status && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What\'s one thing you need in Otter Blocks?', 'otter-blocks'),
    children: 'submitted' !== status ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_blocks_plugins_feedback_feedback_form__WEBPACK_IMPORTED_MODULE_2__["default"], {
      source: "dashboard",
      status: status,
      setStatus: setStatus
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "finish-feedback",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
        src: finishIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "f-title",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Thank you for your feedback', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "f-description",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your feedback is highly appreciated and will help us to improve Otter Blocks.', 'otter-blocks')
      })]
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Feedback);

/***/ }),

/***/ "./src/dashboard/components/pages/Integrations.js":
/*!********************************************************!*\
  !*** ./src/dashboard/components/pages/Integrations.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../blocks/helpers/use-settings.js */ "./src/blocks/helpers/use-settings.js");
/* harmony import */ var _template_cloud_TCPanel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../template-cloud/TCPanel */ "./src/dashboard/components/template-cloud/TCPanel.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
/**
 * WordPress dependencies.
 */







/**
 * Internal dependencies.
 */



const Integrations = () => {
  const [getOption, updateOption, status] = (0,_blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const [googleMapsAPI, setGoogleMapsAPI] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [googleCaptchaAPISiteKey, setGoogleCaptchaAPISiteKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [googleCaptchaAPISecretKey, setGoogleCaptchaAPISecretKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [stripeAPI, setStripeAPI] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [openAISecretKey, setOpenAISecretKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [toolbarActions, setToolbarActions] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const [maskOpenAISecretKey, setMaskOpenAISecretKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    setGoogleMapsAPI(getOption('themeisle_google_map_block_api_key'));
  }, [getOption('themeisle_google_map_block_api_key')]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    setGoogleCaptchaAPISiteKey(getOption('themeisle_google_captcha_api_site_key'));
    setGoogleCaptchaAPISecretKey(getOption('themeisle_google_captcha_api_secret_key'));
  }, [getOption('themeisle_google_captcha_api_site_key'), getOption('themeisle_google_captcha_api_secret_key')]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    setStripeAPI(getOption('themeisle_stripe_api_key'));
  }, [getOption('themeisle_stripe_api_key')]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const apiKey = getOption('themeisle_open_ai_api_key');
    if (!apiKey || 8 > apiKey.length) {
      return;
    }
    setMaskOpenAISecretKey(apiKey.slice(0, 3) + 'X'.repeat(apiKey.length - 8) + apiKey.slice(-4));
  }, [getOption('themeisle_open_ai_api_key')]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    setToolbarActions(getOption('themeisle_blocks_settings_prompt_actions'));
  }, [getOption('themeisle_blocks_settings_prompt_actions')]);
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)('core/notices');
  let ProModules = () => {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Fonts Module', 'otter-blocks'),
      className: "is-pro",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Disabled, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save Google Fonts Locally', 'otter-blocks'),
            help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable this option to save Google Fonts locally to make your website faster', 'otter-blocks'),
            checked: false,
            disabled: true
          })
        })
      })
    });
  };
  ProModules = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__.applyFilters)('otter.dashboard.integrations', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(ProModules, {}));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Maps', 'otter-blocks'),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Maps API', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In order to use Google Maps block, you need to use Google Maps and Places API.', 'otter-blocks'),
          id: "otter-options-google-map-api",
          className: "otter-button-field",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            type: "password",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Secret Key', 'otter-blocks'),
            value: googleMapsAPI,
            placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Maps API Key', 'otter-blocks'),
            disabled: 'saving' === status,
            onChange: value => setGoogleMapsAPI(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "otter-button-group",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              variant: "secondary",
              isSecondary: true,
              disabled: 'saving' === status,
              onClick: () => updateOption('themeisle_google_map_block_api_key', googleMapsAPI),
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://developers.google.com/maps/documentation/javascript/get-api-key",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get API Key', 'otter-blocks')
            })]
          })]
        })
      })
    }), ProModules, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google reCaptcha API', 'otter-blocks'),
      initialOpen: false,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In order to use reCaptcha field in the Form block, you need to use Google reCaptcha API.', 'otter-blocks'),
          id: "otter-options-google-recaptcha-api",
          className: "otter-button-field",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            type: "password",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Key', 'otter-blocks'),
            value: googleCaptchaAPISiteKey,
            placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Key', 'otter-blocks'),
            disabled: 'saving' === status,
            onChange: value => setGoogleCaptchaAPISiteKey(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            type: "password",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Secret Key', 'otter-blocks'),
            value: googleCaptchaAPISecretKey,
            placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Secret Key', 'otter-blocks'),
            disabled: 'saving' === status,
            onChange: value => setGoogleCaptchaAPISecretKey(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "otter-button-group",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              variant: "secondary",
              isSecondary: true,
              disabled: 'saving' === status,
              onClick: () => {
                updateOption('themeisle_google_captcha_api_site_key', googleCaptchaAPISiteKey);
                updateOption('themeisle_google_captcha_api_secret_key', googleCaptchaAPISecretKey);
              },
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://www.google.com/recaptcha/admin",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get API Key', 'otter-blocks')
            })]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Stripe', 'otter-blocks'),
      initialOpen: false,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Stripe API', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In order to use Stripe block, you need to use Stripe API. You can also use Restricted keys.', 'otter-blocks'),
          id: "otter-options-stripe-api",
          className: "otter-button-field",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            type: "password",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Secret Key', 'otter-blocks'),
            value: stripeAPI,
            placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Stripe API Key', 'otter-blocks'),
            disabled: 'saving' === status,
            onChange: value => setStripeAPI(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "otter-button-group",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              variant: "secondary",
              isSecondary: true,
              disabled: 'saving' === status,
              onClick: () => {
                window.tiTrk?.with('otter').add({
                  feature: 'dashboard-integration',
                  featureComponent: 'stripe'
                });
                updateOption('themeisle_stripe_api_key', stripeAPI);
              },
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://stripe.com/docs/keys",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get API Key', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://docs.themeisle.com/article/1688-integrations-related-blocks#stripe-checkout",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('More Info', 'otter-blocks')
            })]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OpenAI', 'otter-blocks'),
      initialOpen: false,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OpenAI API', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In order to use AI Block, you need to use OpenAI API.', 'otter-blocks'),
          id: "otter-options-stripe-api",
          className: "otter-button-field",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            type: "text",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Secret Key', 'otter-blocks'),
            value: openAISecretKey,
            placeholder: maskOpenAISecretKey ? maskOpenAISecretKey : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OpenAI API Key', 'otter-blocks'),
            disabled: 'saving' === status,
            onChange: value => setOpenAISecretKey(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "otter-button-group",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              variant: "secondary",
              isSecondary: true,
              disabled: 'saving' === status,
              onClick: async () => {
                try {
                  const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
                    path: 'otter/v1/openai/key',
                    method: 'POST',
                    data: {
                      'api_key': openAISecretKey
                    }
                  });
                  if (!response.success) {
                    var _response$message;
                    createNotice('error', (_response$message = response.message) !== null && _response$message !== void 0 ? _response$message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An unknown error occurred.', 'otter-blocks'), {
                      isDismissible: true,
                      type: 'snackbar'
                    });
                    return;
                  }
                  createNotice('success', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('API Key saved successfully.', 'otter-blocks'), {
                    isDismissible: true,
                    type: 'snackbar'
                  });
                } catch (e) {
                  var _e$message;
                  createNotice('error', (_e$message = e?.message) !== null && _e$message !== void 0 ? _e$message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An unknown error occurred.', 'otter-blocks'), {
                    isDismissible: true,
                    type: 'snackbar'
                  });
                }
              },
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://platform.openai.com/account/api-keys",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get API Key', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://docs.themeisle.com/article/1916-how-to-generate-an-openai-api-key",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('More Info', 'otter-blocks')
            })]
          })]
        })
      }), 0 < getOption('themeisle_open_ai_api_key')?.length ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.BaseControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Toolbar Actions', 'otter-blocks'),
          help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Change the actions present in the AI Toolbar.', 'otter-blocks'),
          id: "otter-options-toolbar-actions",
          className: "otter-button-field",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
            className: "otter-ai-toolbar-actions",
            children: toolbarActions.map((action, index) => {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
                title: action.title,
                initialOpen: false,
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
                  type: "text",
                  value: action.title,
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Action Name', 'otter-blocks'),
                  placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Action Name', 'otter-blocks'),
                  disabled: 'saving' === status,
                  onChange: value => {
                    const newActions = [...toolbarActions];
                    newActions[index].title = value;
                    setToolbarActions(newActions);
                  }
                }, `name-${index}`), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
                  type: "text",
                  value: action.prompt,
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Prompt', 'otter-blocks'),
                  placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Prompt', 'otter-blocks'),
                  disabled: 'saving' === status,
                  onChange: value => {
                    const newActions = [...toolbarActions];
                    newActions[index].prompt = value;
                    setToolbarActions(newActions);
                  }
                }, `prompt-${index}`)]
              }, `container-${index}`);
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "otter-button-group",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              variant: "secondary",
              isSecondary: true,
              disabled: 'saving' === status,
              onClick: () => {
                window.tiTrk?.with('otter').add({
                  feature: 'dashboard-integration',
                  featureComponent: 'toolbar-actions'
                });
                updateOption('themeisle_blocks_settings_prompt_actions', toolbarActions);
              },
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ExternalLink, {
              href: "https://docs.themeisle.com/article/1916-how-to-generate-an-openai-api-key",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('More Info', 'otter-blocks')
            })]
          })]
        })
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {})]
    }), Boolean(window?.otterObj?.hasPatternSources) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_template_cloud_TCPanel__WEBPACK_IMPORTED_MODULE_7__["default"], {})]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Integrations);

/***/ }),

/***/ "./src/dashboard/components/pages/Upsell.js":
/*!**************************************************!*\
  !*** ./src/dashboard/components/pages/Upsell.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _blocks_helpers_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../blocks/helpers/helper-functions.js */ "./src/blocks/helpers/helper-functions.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
/**
 * WordPress dependencies.
 */



/**
 * Internal dependencies.
 */


const FEATURES = [{
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('More than 30 Custom Blocks', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Harness the potential of the new WordPress era with the growing list of 30+ page building blocks, covering all the elements needed to build a website.', 'otter-blocks'),
  inFree: true
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Extra Functionalities for all Blocks', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Otter Blocks adds extra functionality such as Custom CSS, Animations and Visibility Conditions to default or third party blocks present on your website.', 'otter-blocks'),
  inFree: true
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Premium Blocks', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enhance your website\'s design with powerful Pro Blocks, like the Add to Cart Block, Business Hours Block and more blocks are coming soon.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Extended Visibility Conditions & Sticky Blocks functionality', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The Visibility Conditions feature allows you to set which conditions should be met for your chosen blocks to be displayed on the page. While the Sticky feature lets you set a Block as sticky, so that it sticks to its parent.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dynamic Values', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Streamline your Workflow with Otter Dynamic Values, which allows you to bind certain elements in the editor - with the dynamic data from your website database.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Review Comparison Table', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Allows you to display and compare a selection of product reviews made on the website.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('WooCommerce Builder Blocks', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Build custom Single Product Pages using WooCommerce Builder Blocks by Otter. All the new features from Otter Pro are designed to maximize your conversion rate.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Extended Popups', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Display your content in beautiful popup with many customization options. Otter Pro extends the functionality of the popups in the free Otter version, with more advanced options.', 'otter-blocks')
}, {
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Priority Support', 'otter-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Our Happiness Engineers are happy to help you get the best results from our products. On average, Otter Pro user get a reply in five hours or less.', 'otter-blocks')
}];
const crossIcon = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
  width: "31",
  height: "31",
  viewBox: "0 0 31 31",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  role: "img",
  "aria-hidden": "true",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
    d: "M22.5326 10.5767L17.2226 15.8867L22.5326 21.1967L20.4176 23.3117L15.1076 18.0167L9.81262 23.3117L7.68262 21.1817L12.9776 15.8867L7.68262 10.5917L9.81262 8.46167L15.1076 13.7567L20.4176 8.46167L22.5326 10.5767Z",
    fill: "#FF7E65"
  })
});
const checkIcon = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
  width: "31",
  height: "31",
  viewBox: "0 0 31 31",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  role: "img",
  "aria-hidden": "true",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
    d: "M22.9863 7.99243L12.7863 18.1924L8.58633 13.9924L6.48633 16.0924L12.7863 22.3924L25.0863 10.0924",
    fill: "#5FBFD5"
  })
});
const Upsell = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "otter-upsell",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "upsell-title",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Powerful features available only in Otter Pro', 'otter-blocks')
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("ul", {
      className: "upsell-table",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
        className: "t-head",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "c",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Free', 'otter-blocks')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "c",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pro', 'otter-blocks')
        })]
      }), FEATURES.map((feature, i) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
          className: "t-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "content",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "h-wrap",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h4", {
                children: feature.label
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
              children: feature.description
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "c",
            children: feature?.inFree ? checkIcon : crossIcon
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "c",
            children: checkIcon
          })]
        }, i);
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
      variant: "primary",
      href: (0,_blocks_helpers_helper_functions_js__WEBPACK_IMPORTED_MODULE_2__.setUtm)(window.otterObj.upgradeLink, 'viewallfvsp'),
      target: "_blank",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('View all Otter Pro features', 'otter-blocks')
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Upsell);

/***/ }),

/***/ "./src/dashboard/components/template-cloud/AddSourceForm.js":
/*!******************************************************************!*\
  !*** ./src/dashboard/components/template-cloud/AddSourceForm.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/plus.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./common */ "./src/dashboard/components/template-cloud/common.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);








const STATUSES = {
  SAVING: 'saving',
  NONE: 'none'
};
const AddSourceForm = ({
  setSources,
  onCancel
}) => {
  const [apiURL, setApiURL] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [accessKey, setAccessKey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(STATUSES.NONE);
  const [error, setError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)('core/notices');
  const isSaving = STATUSES.SAVING === status;
  const addSource = () => {
    setStatus(STATUSES.SAVING);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      path: 'otter/v1/template-cloud/add-source',
      method: 'POST',
      accept: 'application/json',
      data: {
        url: apiURL,
        key: accessKey
      }
    }).then(response => {
      setStatus(STATUSES.NONE);
      setSources(response.sources);
      onCancel();
      createNotice('success', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Source added successfully', 'otter-blocks'), {
        isDismissible: true,
        type: 'snackbar'
      });
    }).catch(e => {
      var _e$message;
      setStatus(STATUSES.NONE);
      setError((_e$message = e?.message) !== null && _e$message !== void 0 ? _e$message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An unknown error occurred.', 'otter-blocks'));
    });
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
      type: "text",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('API URL', 'otter-blocks'),
      value: apiURL,
      placeholder: "https://example.com/wp-json",
      disabled: isSaving,
      onChange: value => setApiURL(value)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
      type: "text",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Access Key', 'otter-blocks'),
      value: accessKey,
      placeholder: '•'.repeat(32),
      disabled: isSaving,
      onChange: value => setAccessKey(value)
    }), error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Notice, {
      status: "error",
      isDismissible: true,
      children: error
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      style: _common__WEBPACK_IMPORTED_MODULE_5__.BUTTON_GROUP_STYLE,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        onClick: onCancel,
        variant: "secondary",
        disabled: isSaving,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cancel', 'otter-blocks')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        variant: "primary",
        disabled: isSaving || !apiURL || !accessKey,
        onClick: addSource,
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Add Source', 'otter-blocks')
      })]
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (AddSourceForm);

/***/ }),

/***/ "./src/dashboard/components/template-cloud/Sources.js":
/*!************************************************************!*\
  !*** ./src/dashboard/components/template-cloud/Sources.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/trash.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);







const Sources = ({
  sourcesData,
  setSources,
  isSyncing
}) => {
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('core/notices');
  const [error, setError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const deleteSource = key => {
    // eslint-disable-next-line no-alert
    const confirm = window.confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Are you sure you want to delete this source?', 'otter-blocks'));
    if (!confirm) {
      return;
    }
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: `otter/v1/template-cloud/delete-source/${key}`,
      method: 'DELETE',
      accept: 'application/json'
    }).then(response => {
      setSources(response.sources);
      createNotice('success', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source deleted', 'otter-blocks'), {
        isDismissible: true,
        type: 'snackbar'
      });
    }).catch(e => {
      var _e$message;
      setError((_e$message = e?.message) !== null && _e$message !== void 0 ? _e$message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An unknown error occurred.', 'otter-blocks'));
    });
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("table", {
      className: "tc-table",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("thead", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("tr", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Name', 'otter-blocks')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source URL', 'otter-blocks')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Actions', 'otter-blocks')
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tbody", {
        children: sourcesData.map(source => {
          const displayURL = new URL(source.url).hostname;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("tr", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
              children: source.name
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
              children: displayURL
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
                disabled: isSyncing,
                variant: "primary",
                size: "compact",
                isDestructive: true,
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"],
                onClick: () => {
                  deleteSource(source.key);
                },
                text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Remove', 'otter-blocks')
              })
            })]
          }, source.key);
        })
      })]
    }), error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Notice, {
      status: "error",
      isDismissible: true,
      onDismiss: () => {
        setError('');
      },
      children: error
    })]
  });
};
/* harmony default export */ __webpack_exports__["default"] = (Sources);

/***/ }),

/***/ "./src/dashboard/components/template-cloud/TCPanel.js":
/*!************************************************************!*\
  !*** ./src/dashboard/components/template-cloud/TCPanel.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/plus.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/rotate-right.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _blocks_helpers_use_settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../blocks/helpers/use-settings */ "./src/blocks/helpers/use-settings.js");
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./common */ "./src/dashboard/components/template-cloud/common.js");
/* harmony import */ var _AddSourceForm__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AddSourceForm */ "./src/dashboard/components/template-cloud/AddSourceForm.js");
/* harmony import */ var _Sources__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Sources */ "./src/dashboard/components/template-cloud/Sources.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);











const TCPanel = () => {
  const [getOption] = (0,_blocks_helpers_use_settings__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const [sources, setSources] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [isAdding, setIsAdding] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [status, setStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(_common__WEBPACK_IMPORTED_MODULE_6__.STATUSES.NONE);
  const [syncErrors, setSyncErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [shouldOpen, setShouldOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const panelRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const {
    createNotice
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('core/notices');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    setSources(getOption('themeisle_template_cloud_sources'));
  }, [getOption('themeisle_template_cloud_sources')]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const hasURLParam = new URLSearchParams(window.location.search).get('scrollTo') === 'tc';
    if (hasURLParam) {
      setShouldOpen(true);
      if (panelRef.current) {
        panelRef.current.scrollIntoView({
          behavior: 'smooth'
        });
      }
    }
  }, [panelRef.current]);
  const syncSources = () => {
    setStatus(_common__WEBPACK_IMPORTED_MODULE_6__.STATUSES.SYNCING);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      path: 'otter/v1/template-cloud/sync'
    }).then(response => {
      const {
        sources,
        errors
      } = response;
      setSources(sources);
      setStatus(_common__WEBPACK_IMPORTED_MODULE_6__.STATUSES.NONE);
      if (errors.length > 0) {
        setSyncErrors(errors);
      }
      createNotice('success', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Sources synced successfully.', 'otter-blocks'), {
        isDismissible: true,
        type: 'snackbar'
      });
    }).catch(e => {
      var _e$message;
      setStatus(_common__WEBPACK_IMPORTED_MODULE_6__.STATUSES.NONE);
      setSyncErrors([(_e$message = e?.message) !== null && _e$message !== void 0 ? _e$message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('An unknown error occurred.', 'otter-blocks')]);
    });
  };
  const clearErrors = () => {
    setSyncErrors([]);
  };
  const toggleAdding = () => {
    setIsAdding(!isAdding);
  };
  const isSyncing = _common__WEBPACK_IMPORTED_MODULE_6__.STATUSES.SYNCING === status;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelBody, {
      ref: panelRef,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Template Cloud', 'otter-blocks'),
      initialOpen: shouldOpen,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "tc-panel-content-wrap",
        children: [sources.length < 1 && !isAdding && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "tc-sources-empty",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h4", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('No sources found', 'otter-blocks')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
            variant: "primary",
            onClick: toggleAdding,
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Add Source', 'otter-blocks')
          })]
        }), sources.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Sources__WEBPACK_IMPORTED_MODULE_8__["default"], {
          isSyncing: isSyncing,
          sourcesData: sources,
          setSources: setSources
        }), isAdding && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_AddSourceForm__WEBPACK_IMPORTED_MODULE_7__["default"], {
          onCancel: toggleAdding,
          setSources: setSources
        }), !isAdding && sources.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
          children: [syncErrors.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Notice, {
            status: "error",
            isDismissible: true,
            onDismiss: clearErrors,
            children: syncErrors.map((error, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
              children: error
            }, index))
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            style: _common__WEBPACK_IMPORTED_MODULE_6__.BUTTON_GROUP_STYLE,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
              variant: "secondary",
              onClick: syncSources,
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"],
              disabled: isSyncing,
              children: isSyncing ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Syncing', 'otter-blocks') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Sync Sources', 'otter-blocks')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
              variant: "primary",
              disabled: isSyncing,
              onClick: toggleAdding,
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Add Source', 'otter-blocks')
            })]
          })]
        }), typeof _wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createInterpolateElement !== 'undefined' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
            className: "description",
            children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createInterpolateElement)(/* translators: %s: External Link */
            (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Check-out our curated list of sources that you can import <tcLink/>.', 'otter-blocks'), {
              tcLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ExternalLink, {
                href: otterObj.tcDocs,
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('here', 'otter-blocks')
              })
            })
          }), sources.length < 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
            className: "description",
            children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createInterpolateElement)(/* translators: %1$s: `Otter Pro Agency` link, %2$s: `Templates Cloud` link */
            (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Want to share your patterns across multiple sites? Get <otterLink/> or the <tcLink/> plugin to unlock the pattern sharing capabilities!', 'otter-blocks'), {
              otterLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ExternalLink, {
                href: otterObj.upgradeLinkFromTc,
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Otter PRO Agency', 'otter-blocks')
              }),
              tcLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ExternalLink, {
                href: otterObj.tcUpgradeLink,
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Templates Cloud', 'otter-blocks')
              })
            })
          })]
        })]
      })
    })
  });
};
/* harmony default export */ __webpack_exports__["default"] = (TCPanel);

/***/ }),

/***/ "./src/dashboard/components/template-cloud/common.js":
/*!***********************************************************!*\
  !*** ./src/dashboard/components/template-cloud/common.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BUTTON_GROUP_STYLE: function() { return /* binding */ BUTTON_GROUP_STYLE; },
/* harmony export */   STATUSES: function() { return /* binding */ STATUSES; }
/* harmony export */ });
const BUTTON_GROUP_STYLE = {
  display: 'flex',
  alignItems: 'center',
  gap: '10px',
  marginTop: '10px'
};
const STATUSES = {
  NONE: 'none',
  SAVING: 'loading',
  SYNCING: 'syncing'
};

/***/ }),

/***/ "./src/dashboard/index.js":
/*!********************************!*\
  !*** ./src/dashboard/index.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.scss */ "./src/dashboard/style.scss");
/* harmony import */ var _blocks_plugins_feedback__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../blocks/plugins/feedback */ "./src/blocks/plugins/feedback/index.js");
/* harmony import */ var _components_Notices_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/Notices.js */ "./src/dashboard/components/Notices.js");
/* harmony import */ var _components_Header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Header.js */ "./src/dashboard/components/Header.js");
/* harmony import */ var _components_Main_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/Main.js */ "./src/dashboard/components/Main.js");
/* harmony import */ var _components_Footer_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/Footer.js */ "./src/dashboard/components/Footer.js");
/* harmony import */ var _blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../blocks/helpers/use-settings.js */ "./src/blocks/helpers/use-settings.js");
/* harmony import */ var _components_NeveSidebarUpsell_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/NeveSidebarUpsell.js */ "./src/dashboard/components/NeveSidebarUpsell.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
/* eslint-disable camelcase */
/**
 * External dependencies.
 */

/**
 * WordPress dependencies.
 */


/**
 * Internal dependencies.
 */









if (undefined === window.otterUtils) {
  window.otterUtils = {};
}
window.otterUtils.useSettings = _blocks_helpers_use_settings_js__WEBPACK_IMPORTED_MODULE_7__["default"];
const getInitialStateFromURLQuery = () => {
  const hash = window.location.hash.slice(1); // Remove the '#' at the start
  return hash;
};
const convertToCategory = (number, scale = 1) => {
  const normalizedNumber = Math.round(number / scale);
  if (0 === normalizedNumber || 1 === normalizedNumber) {
    return 0;
  } else if (1 < normalizedNumber && 8 > normalizedNumber) {
    return 7;
  } else if (8 <= normalizedNumber && 31 > normalizedNumber) {
    return 30;
  } else if (30 < normalizedNumber && 90 > normalizedNumber) {
    return 90;
  } else if (90 < normalizedNumber) {
    return 91;
  }
};
const App = () => {
  const [currentTab, setTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(getInitialStateFromURLQuery());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: [undefined !== wp.notices.store && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_Notices_js__WEBPACK_IMPORTED_MODULE_3__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_Header_js__WEBPACK_IMPORTED_MODULE_4__["default"], {
      isActive: currentTab,
      setActive: setTab
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_Main_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
      currentTab: currentTab,
      setTab: setTab
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_NeveSidebarUpsell_js__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_Footer_js__WEBPACK_IMPORTED_MODULE_6__["default"], {})]
  });
};
const root = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createRoot)(document.getElementById('otter'));
root.render(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(App, {}));

/***/ }),

/***/ "./src/dashboard/style.scss":
/*!**********************************!*\
  !*** ./src/dashboard/style.scss ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "@wordpress/api":
/*!*****************************!*\
  !*** external ["wp","api"] ***!
  \*****************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["api"];

/***/ }),

/***/ "@wordpress/api-fetch":
/*!**********************************!*\
  !*** external ["wp","apiFetch"] ***!
  \**********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["apiFetch"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/date":
/*!******************************!*\
  !*** external ["wp","date"] ***!
  \******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["date"];

/***/ }),

/***/ "@wordpress/edit-site":
/*!**********************************!*\
  !*** external ["wp","editSite"] ***!
  \**********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["editSite"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/hooks":
/*!*******************************!*\
  !*** external ["wp","hooks"] ***!
  \*******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["hooks"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "@wordpress/notices":
/*!*********************************!*\
  !*** external ["wp","notices"] ***!
  \*********************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["notices"];

/***/ }),

/***/ "@wordpress/primitives":
/*!************************************!*\
  !*** external ["wp","primitives"] ***!
  \************************************/
/***/ (function(module) {

"use strict";
module.exports = window["wp"]["primitives"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ (function(module) {

"use strict";
module.exports = window["lodash"];

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ (function(module) {

"use strict";
module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	!function() {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = function(result, chunkIds, fn, priority) {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var chunkIds = deferred[i][0];
/******/ 				var fn = deferred[i][1];
/******/ 				var priority = deferred[i][2];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every(function(key) { return __webpack_require__.O[key](chunkIds[j]); })) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	!function() {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"index": 0,
/******/ 			"./style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = function(chunkId) { return installedChunks[chunkId] === 0; };
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = function(parentChunkLoadingFunction, data) {
/******/ 			var chunkIds = data[0];
/******/ 			var moreModules = data[1];
/******/ 			var runtime = data[2];
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some(function(id) { return installedChunks[id] !== 0; })) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunkotter_blocks"] = self["webpackChunkotter_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["./style-index"], function() { return __webpack_require__("./src/dashboard/index.js"); })
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map