# Otter Blocks - Gutenberg Blocks, Page Builder for Gutenberg Editor & FSE #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle/), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani/), [soarerobertdaniel7](https://profiles.wordpress.org/soarerobertdaniel7/), [mariamunteanu1](https://profiles.wordpress.org/mariamunteanu1/), [arinat](https://profiles.wordpress.org/arinat/), [uriahs-victor](https://profiles.wordpress.org/uriahs-victor/), [john_pixle](https://profiles.wordpress.org/john_pixle/), [wildmisha](https://profiles.wordpress.org/wildmisha/), [irinelenache](https://profiles.wordpress.org/irinelenache/)  
**Tags:** block, blocks, gutenberg, gutenberg blocks, page builder  
**Requires at least:** 6.2  
**Tested up to:** 6.8  
**Requires PHP:** 5.6  
**Stable tag:** 3.1.3  
**License:** GPLv3  
**License URI:** https://www.gnu.org/licenses/gpl-3.0.en.html  

Quickly create WordPress pages with 20+ blocks, 100+ ready-to-import designs, and advanced editor extensions. It’s website building, Lego-style!

## Description ##

Otter is a Gutenberg Blocks page builder plugin that adds extra functionality to the WordPress Block Editor (also known as Gutenberg) for a better page-building experience without the need for traditional page builders like Elementor and Divi.

## Quick Links 🔗

- Do you want to see Otter blocks in action before installing? [SEE OTTER BLOCKS DEMO](https://demo.themeisle.com/otter-blocks/?utm_source=wpadmin&utm_medium=readme&utm_campaign=otter-blocks)
- New to the Gutenberg Blocks ecosystem? Check out our article on [GUTENBERG EXPLAINED](https://themeisle.com/blog/gutenberg-blocks-explained/)
- Need any help with setup? Checkout our [DOCUMENTATION](https://docs.themeisle.com/article/1478-otter-blocks-documentation)
- Interested in Otter Pro? Here are more details about [OTTER PRO](https://themeisle.com/plugins/otter-blocks/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=otter-blocks)

## With Otter Blocks, You Get Access To

- 20+ extra blocks for Gutenberg
- Collection of Patterns
- Full-page Templates
- Visibility Conditions
- Custom CSS 
- Animations 
- Dynamic Content and more

For all blocks including third-party blocks present on your website.

The Custom CSS block feature makes it possible to directly customize the CSS properties of any Gutenberg block on the page, while the Animation feature makes it quick and easy to add animations to any block to enhance the appeal of your different page blocks and sections. 

With the Visibility Conditions feature by Otter, you can set which conditions should be met for your chosen blocks to be displayed on the page.

Patterns Library, contains a range of different elements in a variety of styles to help you build great pages. All of your website’s most important areas are covered: headers, testimonials, pricing tables, sections, and more.

### Checkout a quick overview of Otter Blocks
https://www.youtube.com/watch?v=WcS2Vi4IOYw

## How Can Otter’s Gutenberg Blocks Help You? 🤔

### A WordPress Gutenberg Blocks Plugin

Otter adds 26+ amazing and useful blocks to make page building in Gutenberg a breeze! 

More than just blocks, you need advanced customization options to give you control over style and appearance. With Otter, you’ve got it all.

Every block has customization support to help you style your site according to your vision:

- Color controls for primary, accents, and backgrounds.
- Animation backing, bouncing, fading, flipping, rotating, sliding, rolling, light speed, and more at the click of a button.
- Typography controls from spacing to font choice.

### Mobile Responsiveness of Otter Blocks

Create mobile-friendly designs with Otter’s built-in responsive settings. Each block can be tweaked to provide a consistent experience for mobile, tablet, and desktop.

### A WordPress Gutenberg Block Conditions Plugin

Want to show certain blocks only when a user is Logged in or Logged Out? How about if they’re a customer of your store versus an editor for your blog or any other user role? With the Gutenberg Block Conditions feature available in Otter, it’s possible. Upgrade to the PRO version of Otter to unleash the power of more block conditions such as:

- URL Query String 
- Date Range
- Day of the Week
- Time of the Day
- WooCommerce Products in Cart
- WooCommerce Total Spent
- WooCommerce Cart Total
- WooCommerce Categories
- WooCommerce Tags
- WooCommerce Attributes
- Cookie-based
- And more

### A WordPress Gutenberg Blocks Animation Plugin

WOW, your website visitors with amazing animations that can be added to any block on the page. With over 50+ animations available to choose from; Otter makes it possible to add some extra flare to any post or page on your website

### A WordPress Gutenberg Popup Plugin

Popups are one of the oldest lead-capturing and notice-conveying techniques on the web. With the Gutenberg Popup Block available in Otter, you can create popups made from any other block available in Gutenberg! 

Fine-tune your popups by setting when they should appear and how they can be closed. With our popup block, you gain access to multiple triggers such as on load, on exit, on anchor click, and on scroll. 

Additionally, you can design your popup with custom overlays to align with your brand identity and capture more attention. [Check live demo](https://demo.themeisle.com/otter-blocks/popup/)

### Global Defaults for Otter's Blocks

Tired of always having to set the same options every time you add a block to the page? With Otter, you can set the default configuration for some of the most commonly used blocks like the Section Block, Icon Block, Advanced Heading, and more.

## Blocks Available in Otter:

#### Accordion Gutenberg Block [FREE]

Use this block to create vertically stacked lists of content that can be revealed or hidden with the click of a button; more commonly known as Accordions. [Check live demo](https://demo.themeisle.com/otter-blocks/accordion/)

#### Advanced Heading Gutenberg Block [FREE]

The heading block you didn't know you needed. This Otter block has all the functionality of the default heading block with a few other capabilities like the ability to change the font, highlight parts of the text, and more. [Check live demo](https://demo.themeisle.com/otter-blocks/advanced-heading/)

#### AI Block [FREE]

Step inside the AI Block, your gateway to effortless content and form creation, all powered by AI. With the AI Content Generator, crafting text, dynamic headings, and insightful paragraphs is a breeze, while the AI Form Generator simplifies building forms. It's your all-in-one solution for seamless work — everything you need with AI, neatly packed into a single block.

#### Button Group Gutenberg Block [FREE]

Create multiple buttons quickly and easily and show them vertically or horizontally based on the device the page is being viewed on. [Check live demo](https://demo.themeisle.com/otter-blocks/button-group/)

#### Countdown Gutenberg Block [FREE]

Counting down to a big event? Show it by making use of these Gutenberg blocks. Count down from Days, Hours, Minutes, or Seconds. [Check live demo](https://demo.themeisle.com/otter-blocks/countdown/)

#### Contact Form Gutenberg Block [FREE]

Quickly and easily insert a contact form anywhere on the page. Optionally, turn the form into a lead-generating machine by integrating it with Brevo(Sendinblue) or Mailchimp. Plus, streamline data management with webhook integration and ensure enhanced security with hCaptcha integration. [Check live demo](https://demo.themeisle.com/otter-blocks/form/)

#### Content Timeline Block [FREE]

Elegantly display events in a chronological timeline. Ideal for highlighting historical events, process steps, or key milestones.

#### Countdown Block [FREE]

Counting down to a big event? Show it by making use of these Gutenberg blocks. [Check live demo](https://demo.themeisle.com/otter-blocks/countdown/)

#### Circular Progress Block [FREE]

Show your progress with a beautiful Circle Counter block. [Check live demo](https://demo.themeisle.com/otter-blocks/circle-counter/)

#### Flip Box Block [FREE]

Creates a card with a flip effect, where you can insert any content or blocks available in Gutenberg. [Check live demo](https://demo.themeisle.com/otter-blocks/flip-card/)

#### Icon List Gutenberg Block [FREE]

Supercharge boring point lists by using custom icons as the pointers. [Check live demo](https://demo.themeisle.com/otter-blocks/icon-list/)

#### Icon Gutenberg Block [FREE]

Display any icon from Font Awesome or our own list of custom icons anywhere on the page. Change colors, add borders, and couple with other blocks to enhance the look of your page. [Check live demo](https://demo.themeisle.com/otter-blocks/icon/)

#### Lottie Animation Gutenberg Block [FREE]

Have you heard about Lottie? Awesome! With Otter's Lottie Animation Gutenberg Block, you can display Lottie animations anywhere in Gutenberg. [Check live demo](https://demo.themeisle.com/otter-blocks/lottie-animation/)

#### Maps Gutenberg Block [FREE]

Choose between either an Open Street Map or Google Maps block and create markers for your points of interest for your website visitors. Our Maps block helps you customize the map experience right down to the color and description of the markers, search for places by name or coordinates, add and remove map controls, or change the size and style of the maps with a few clicks. [Check live demo](https://demo.themeisle.com/otter-blocks/maps/)

#### Progress Bar Block [FREE]

Show your progress with a beautiful Progress Bar block. [Check live demo](https://demo.themeisle.com/otter-blocks/progress-bar/)

#### Posts Gutenberg Block [FREE]

Use this block to insert items from posts, pages, and custom post types into the current page being edited. The Posts block allows displaying a certain number of posts on different pages. Customizations available for this block cover areas such as styles, post types, settings, designs, and layout.

#### Product Review Gutenberg Block [FREE]

Blogging about a product you love? Or maybe you run a review website? Use this block to create a review table for the item and list its features, pros and cons as well as optional buy links. [Check live demo](https://demo.themeisle.com/otter-blocks/product-review/)

#### Popup Gutenberg Block [FREE]

Create stunning popups and fine-tune when they should appear and how they can be closed. [Check live demo](https://demo.themeisle.com/otter-blocks/popup/)

#### Slider Gutenberg Block [FREE]

Use this Gutenberg block to create image sliders on any Gutenberg page. Settings include slider height, delay, slides per page, autoplay, and more. [Check live demo](https://demo.themeisle.com/otter-blocks/slider/)

#### Section Gutenberg Block [FREE]

A column block on steroids! This block allows you to create a section with up to 6 columns that can each have a custom background color, image, or gradient. Use this block's responsive features to set the padding and margin for desktop, tablet, and mobile displays. [Check live demo](https://demo.themeisle.com/otter-blocks/section/)

#### Stripe Checkout [FREE]

This block will be very useful if you want to sell a couple of products without setting up a whole store, such as ebooks, some licenses, etc.

#### Sharing Icons Block [FREE]

Share buttons for your website visitors to share content on any social sharing service. [Check live demo](https://demo.themeisle.com/otter-blocks/sharing-icons/)

#### Tabs Gutenberg Block [FREE]

Use this block to create horizontally stacked lists of content that can be revealed or hidden with the click of a button; more commonly known as Tabs. [Check live demo](https://demo.themeisle.com/otter-blocks/tabs/)

#### Add to Cart Gutenberg Block [PRO]

Drop an Add to Cart button block for any WooCommerce product anywhere on the post or page that you're editing.

#### Business Hours Gutenberg Block [PRO]

Create a beautifully styled Business Hours table and fine-tune its settings until it's perfect.

#### Live Search [PRO]

The Live Search feature enhances the core block Search by adding two additional attributes ( isLive and postTypes ) that can be set inside the inspector under the Live Search panel.

#### Modal [PRO]

Implement modal dialogs for an interactive experience, displaying forms, content, or announcements directly within the page layout.

#### Review Comparision Table [PRO]

Get ready to impress your readers with Otter's "Review Comparison Table" block. Effortlessly create professional-looking product comparison tables for your blog or website.

---

We're constantly adding new Gutenberg Blocks to Otter to assist in your website page building. Feel free to tell us what we’re missing on our [Support Forum](https://wordpress.org/support/plugin/otter-blocks/)! Some other blocks include:

## Ready to Import Patterns & Full-page Templates in Otter:

Easily launch your site with our customizable patterns and full-page WordPress templates. Import ready-made designs with just one click and get started in no time.

#### Service Patterns

Organize your services clearly with sections that keep your page tidy while offering detailed information on demand. [Check live demo](https://demo.themeisle.com/otter-blocks/service/)

#### Testimonial Patterns

Organize your services clearly with sections that keep your page tidy while offering detailed information on demand. [Check live demo](https://demo.themeisle.com/otter-blocks/service/)

#### Pricing Patterns

Tailor your pricing tables with versatile layout patterns that enhance readability and appeal, suitable for any business model. [Check live demo](https://demo.themeisle.com/otter-blocks/pricing/)

#### Features Section Patterns

Detail the features of your products or services using clean, organized layouts that make complex information easy to digest. [Check live demo](https://demo.themeisle.com/otter-blocks/features-patterns/)

#### Call-to-action Section Patterns

Drive conversions with compelling call-to-action sections, designed to grab attention and motivate immediate responses. [Check live demo](https://demo.themeisle.com/otter-blocks/cta-patterns/)

📌 Check a live demo of all the patterns available by [clicking here](https://demo.themeisle.com/otter-blocks/patterns/).

📌 Check a live demo of all the Full-page templates available by [clicking here](https://demo.themeisle.com/otter-blocks/templates/).

### Get More Options in Otter Pro 🤩

#### WooCommerce Builder Blocks 

Build custom Single Product Pages using WooCommerce Builder Blocks by Otter. All the new features are designed to maximize your conversion rate and bring more improvements. 

With [Otter Pro](https://themeisle.com/plugins/otter-blocks/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=otter-blocks), you get a lot more features, including:

- Add to Cart Block
- Business Hours Block
- Modal Block
- Product Review Comparison Block
- Live Search Block
- Pro Add-ons for Free Blocks
- More Dynamic Content options
- More Visibility Conditions options
- More Patterns & Full-page templates
- and more!

You can try a live demo of Otter Blocks - no setup required. [Click here](https://themeisle.com/plugins/otter-blocks/try-otter/?utm_source=wpadmin&utm_medium=readme&utm_campaign=otter-blocks) to try it out.

## Who is Otter For? 👀

- Anyone looking to bring out the best features of the new Gutenberg Editor with useful and easy-to-use Gutenberg blocks.
- Anyone thinking of moving away from traditional page builders like Elementor and Divi Builder in favor of the new Gutenberg Block Editor.
- Anyone trying to build quick Gutenberg pages in record time.
- Anyone trying to hide/show Gutenberg blocks based on conditions like user logged in/out status.
- Anyone trying to add animations to Gutenberg blocks.

## Let's See Some Use Cases 🚀

Otter opens up a world of opportunities! Discover how different audience segments can make the most of it:

- **Travel Bloggers:** Enhance your travel blog with captivating maps using Otter's Maps and Google Maps blocks to showcase your journeys to the world.
  
- **Non-Profit Organizations:** Engage your audience and promote your cause with Otter's Circle Counter and Testimonial blocks to share inspiring success stories.
  
- **Restaurant Owners:** Showcase your restaurant's menus and gather reservations easily with Otter's Flip Card and Form blocks for a mouth-watering online presence.

- **Tech Product Reviewers:** Present detailed product reviews with Otter's Product Review, making your content informative and captivating.

- **Bloggers:** Enhance your blog posts with Sharing Icons, creating easy sharing options for your readers. Use Slider to display image galleries and engage your audience.

- **Content Creators and Digital Product Sellers:** Stripe checkout gutenberg block offers a convenient way to sell digital products, such as e-books, online courses, software licenses, or digital artwork, without the need to set up a full-fledged online store. By integrating this block, you can provide a streamlined and secure checkout experience to customers.

- **Product Reviewers:** Create informative and attractive product review comparisons with a Review Comparison Table, helping users make informed decisions.

- **Restaurant Owners:** Display your business hours in a stylish format using Business Hours blocks, making it easy for customers to find you.

- **Online Directories:** Websites offering directories, listings, or extensive content where live search simplifies content access.

---

### Support 🤝

We're here to help. Feel free to open a new thread on the [Support Forum](https://wordpress.org/support/plugin/otter-blocks/).

### Documentation 📚

Discover how to make the most of Otter Blocks with our detailed and user-friendly [documentation](https://docs.themeisle.com/article/1478-otter-blocks-documentation).

### Become a Contributor 💁‍♂️

Otter Blocks is an open-source project, and we welcome contributors to be part of our vibrant community! Help us improve the plugin and make it even better - [GitHub Link](https://github.com/Codeinwp/otter-blocks/)

### Useful Resources 📌

- Read more about WordPress on our [blog](https://themeisle.com/blog/).
- Interested in our other plugins? Take a look [here](https://themeisle.com/wordpress-plugins/?utm_source=wpadmin&utm_medium=readme&utm_campaign=otter-blocks).
- Get the most out of Otter Blocks with our helpful [YouTube Tutorials Playlist](https://youtube.com/playlist?list=PLmRasCVwuvpSep2MOsIoE0ncO9JE3FcKP).

The plugin is relying on the service behind api.themeisle.com for accessing the patterns list, AI prompts and Onboarding. No account is required to access the service template collection and the privacy policy can be found [here](https://themeisle.com/privacy-policy/).

## Screenshots ##

1. Gutenberg Block Animations
2. Visibility Condition Rules
3. Posts Block
4. AI Form Generator
5. AI Layout Generator
6. Patterns & Full-page templates Library

## Installation ##

#### Automatic Installation

To download and install the Otter plugin, make sure you follow the steps below:

- Navigate to the WordPress  Dashboard > Plugins.
- Click the Add New button and type in the Search Bar "Otter Blocks".
- When the plugin appears, click on the Install button and then on  Activate.

#### Manual Installation

- Log into your website admin page, then go to Appearance > Plugins. You will see all the plugins currently installed in your dashboard listed there.
- To install a new WordPress plugin, simply click on the Add New tab.
- Click the Upload Plugin button in the WordPress Dashboard.
- Click the Choose File button, select the ZIP archive of the Otter Blocks plugin from your local computer, and press the Install Now button.
- Click on the Activate button under the "Plugin installed successfully" message.

If you want to upload the plugin using FTP, [click here](https://themeisle.com/blog/what-is-ftp-wordpress/) to see a detailed explanation about it.

## Frequently Asked Questions ##

### Is Otter Blocks free? ###

Otter comes in both free and premium versions. The [premium version](https://themeisle.com/plugins/otter-blocks/upgrade/) offers a wider variety of blocks and multiple options to customize them, [compared to the free version](https://docs.themeisle.com/article/1487-whats-the-difference-between-otter-free-and-otter-neve-pro).

### What page builder is compatible with Otter? ###

Otter provides blocks for Gutenberg, the default WordPress editor, and page builder.

### Can I use Otter with any WordPress theme? ###

Sure, Otter is compatible with any WordPress theme.

### Where can I get help? ###

If you encounter any difficulties or if you have questions about Otter, you can create a ticket on our [support forum](https://wordpress.org/support/plugin/otter-blocks/). Also, feel free to check our [documentation](https://docs.themeisle.com/article/1478-otter-blocks-documentation) to find out more about the features within the plugin and how to use it to its full potential.

### What are the Patterns and how can I use them? ###

The Patterns have been designed to make it easier for you to build your site using predefined blocks that can be then customized according to your needs. You can take a look at our [dedicated documentation](https://docs.themeisle.com/article/1785-block-patterns-otter-features-library) to find out all you need to know about the Patterns.

## Changelog ##

##### [Version 3.1.3](https://github.com/Codeinwp/otter-blocks/compare/v3.1.2...v3.1.3) (2025-11-05)

- Updated dependencies




[See changelog for all versions](https://github.com/Codeinwp/otter-blocks/blob/master/CHANGELOG.md).
