/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!*******************************************!*\
  !*** ./src/blocks/frontend/tabs/index.js ***!
  \*******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const tabs = document.querySelectorAll('.wp-block-themeisle-blocks-tabs');
  const hash = window.location.hash.substring(1);
  tabs.forEach(tab => {
    const items = Array.from(tab.querySelectorAll(':scope > .wp-block-themeisle-blocks-tabs__content > .wp-block-themeisle-blocks-tabs-item'));
    const header = document.createElement('div');
    header.classList.add('wp-block-themeisle-blocks-tabs__header');
    tab.prepend(header);
    let openedTab = false;
    const closedTabs = [];
    items.forEach((item, index) => {
      const content = item.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__content');
      content.setAttribute('role', 'tabpanel');
      const headerMobile = item.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__header');
      headerMobile.setAttribute('role', 'tab');
      const headerItem = document.createElement('div');
      headerItem.classList.add('wp-block-themeisle-blocks-tabs__header_item');
      headerItem.tabIndex = 0;
      const tabTitle = headerMobile.cloneNode(true);
      tabTitle.classList.remove('wp-block-themeisle-blocks-tabs-item__header');
      headerItem.appendChild(tabTitle);
      if (item?.id) {
        headerItem.setAttribute('for', item.id);
      }
      if ('true' === item.dataset.defaultOpen && !openedTab) {
        headerItem.classList.add('active');
        content.classList.add('active');
        headerMobile.classList.add('active');
        openedTab = true;
      } else {
        closedTabs.push({
          headerItem,
          content,
          headerMobile
        });
      }
      const toggleTabs = (tabItem, tabIndex) => {
        const tabContent = tabItem.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__content');
        const tabHeaderMobile = tabItem.querySelector(':scope > .wp-block-themeisle-blocks-tabs-item__header');
        tabContent.classList.toggle('active', tabIndex === index);
        tabContent.classList.toggle('hidden', tabIndex !== index);
        tabHeaderMobile.classList.toggle('active', tabIndex === index);
        tabHeaderMobile.classList.toggle('hidden', tabIndex !== index);
        tabHeaderMobile.setAttribute('aria-selected', tabIndex === index);
        const headerItems = Array.from(header.childNodes);
        headerItems.forEach((headerElement, headerIndex) => {
          headerElement.classList.toggle('active', headerIndex === index);
          headerElement.classList.toggle('hidden', headerIndex !== index);
          headerElement.setAttribute('aria-selected', headerIndex === index);
        });
        if (tabIndex === index && tabHeaderMobile) {
          (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.scrollIntoViewIfNeeded)(tabHeaderMobile);
        }
      };
      headerItem.addEventListener('click', () => items.forEach(toggleTabs));
      headerItem.addEventListener('keyup', event => {
        if ('Enter' === event.code) {
          event.preventDefault();
          items.forEach(toggleTabs);
        }
      });
      headerMobile.addEventListener('click', () => items.forEach(toggleTabs));
      headerMobile.addEventListener('keyup', event => {
        if ('Enter' === event.code) {
          event.preventDefault();
          items.forEach(toggleTabs);
        }
      });
      header.appendChild(headerItem);
      if (hash) {
        const targetTab = item.id === hash;
        if (targetTab) {
          toggleTabs(item, index);
          openedTab = true;
          (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.scrollIntoViewIfNeeded)(headerItem);
        }
      }
    });

    /**
     * If no tab is set to open, open the first closed tab.
     */
    if (!openedTab) {
      closedTabs?.[0]?.headerItem.classList.add('active');
      closedTabs?.[0]?.content.classList.add('active');
      closedTabs?.[0]?.headerMobile.classList.add('active');
    }
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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