/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/helpers/frontend-helper-functions.js":
/*!*********************************************************!*\
  !*** ./src/blocks/helpers/frontend-helper-functions.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   domReady: function() { return /* binding */ domReady; },
/* harmony export */   easeInOutSine: function() { return /* binding */ easeInOutSine; },
/* harmony export */   easeInSine: function() { return /* binding */ easeInSine; },
/* harmony export */   easeOutQuad: function() { return /* binding */ easeOutQuad; },
/* harmony export */   easeOutSine: function() { return /* binding */ easeOutSine; },
/* harmony export */   linear: function() { return /* binding */ linear; },
/* harmony export */   range: function() { return /* binding */ range; },
/* harmony export */   rgb2hsl: function() { return /* binding */ rgb2hsl; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/**
 * Create a list with numbers from interval [start, end].
 *
 * @param {number} start The start.
 * @param {number} end   The end.
 * @param {number} step  The step.
 * @return {*[]}
 */
const range = (start, end, step) => {
  const range = [];
  const typeofStart = typeof start;
  const typeofEnd = typeof end;
  if (0 === step) {
    throw TypeError('Step cannot be zero.');
  }
  if (undefined === typeofStart || undefined === typeofEnd) {
    throw TypeError('Must pass start and end arguments.');
  } else if (typeofStart !== typeofEnd) {
    throw TypeError('Start and end arguments must be of same type.');
  }
  if ('undefined' === typeof step) {
    step = 1;
  }
  if (end < start) {
    step = -step;
  }
  if ('number' === typeofStart) {
    while (0 < step ? end >= start : end <= start) {
      range.push(start);
      start += step;
    }
  } else if ('string' === typeofStart) {
    if (1 !== start.length || 1 !== end.length) {
      throw TypeError('Only strings with one character are supported.');
    }
    start = start.charCodeAt(0);
    end = end.charCodeAt(0);
    while (0 < step ? end >= start : end <= start) {
      range.push(String.fromCharCode(start));
      start += step;
    }
  } else {
    throw TypeError('Only string and number types are supported');
  }
  return range;
};

// Easing functions for animation

/**
 * Linear
 *
 * @param {number} x
 * @return {number}
 */
const linear = x => {
  return x;
};

/**
 * Ease In Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeInSine = x => {
  return 1 - Math.cos(x * Math.PI / 2);
};

/**
 * Ease Out Sine
 *
 * @param {number} x
 * @return {number}
 */
const easeOutSine = x => {
  return Math.sin(x * Math.PI / 2);
};

/**
 * Ease In Out SSine
 * @param {number} x
 * @return {number}
 */
const easeInOutSine = x => {
  return -(Math.cos(Math.PI * x) - 1) / 2;
};

/**
 * Ease Out Quad
 * @param {number} x
 * @return {number}
 */
const easeOutQuad = x => {
  return 1 - (1 - x) * (1 - x);
};

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 * @return {void}
 */
const domReady = callback => {
  if ('undefined' === typeof document) {
    return;
  }
  if ('complete' === document.readyState ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  'interactive' === document.readyState // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
};

/**
 * Debounce function
 *
 * @param  func    The function to apply.
 * @param  timeout
 * @return {(function(...[*]): void)|*}
 */
const debounce = (func, timeout = 500) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(undefined, args);
    }, timeout);
  };
};

/**
 * Converts HEX colors to HSL.
 *
 * @param  color
 * @param  asArray
 * @return {string | Array}
 */
const rgb2hsl = (color, asArray = true) => {
  const rgb = color.substring(4, color.length - 1).replace(/ /g, '').split(',');
  const r = parseFloat(rgb[0]) / 255;
  const g = parseFloat(rgb[1]) / 255;
  const b = parseFloat(rgb[2]) / 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max === min) {
    h = s = 0; // achromatic
  } else {
    const d = max - min;
    s = 0.5 < l ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h = (b - r) / d + 2;
        break;
      case b:
        h = (r - g) / d + 4;
        break;
    }
    h /= 6;
  }
  if (asArray) {
    return [h * 360, s * 100, l * 100];
  }
  return `hsl( ${h * 360}, ${s * 100}, ${l * 100} )`;
};

/**
 *	Scrolls the element into view if it's not fully visible.
 *
 * @param {HTMLElement} element The element to scroll into view.
 * @param {*}           options The options for the scrollIntoView method.
 */
const scrollIntoViewIfNeeded = (element, options = {}) => {
  if (!element) {
    return;
  }
  const rect = element.getBoundingClientRect();
  const isFullyVisible = 0 <= rect.top && 0 <= rect.left && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
  if (!isFullyVisible) {
    element.scrollIntoView(options);
  }
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
!function() {
/*!************************************************!*\
  !*** ./src/blocks/frontend/accordion/index.js ***!
  \************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/frontend-helper-functions.js */ "./src/blocks/helpers/frontend-helper-functions.js");
/**
 * Internal dependencies
 */

(0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.domReady)(() => {
  const accordions = document.querySelectorAll('.wp-block-themeisle-blocks-accordion');

  /**
   *	Handle the opening of the accordion items.
   *
   * @param {HTMLDetailsElement} accordion The accordion root element.
   * @return {void}
   */
  const handleItemOpening = accordion => {
    if (!accordion.classList.contains('exclusive')) {
      return;
    }
    const items = Array.from(accordion.children);
    items.forEach(item => {
      item.addEventListener('click', () => {
        const isOpened = !item.open;
        if (!isOpened) {
          return;
        }
        const openSibling = Array.from(accordion.children).filter(sibling => sibling.open);
        openSibling.forEach(sibling => {
          sibling.removeAttribute('open');
        });
        const title = item.querySelector(':scope > .wp-block-themeisle-blocks-accordion-item__title');
        (0,_helpers_frontend_helper_functions_js__WEBPACK_IMPORTED_MODULE_0__.scrollIntoViewIfNeeded)(title);
      });
    });
  };

  /**
   * Generate FAQPage schema for the accordion.
   *
   * @param {HTMLDivElement} accordion The accordion root element.
   * @return {void}
   */
  const addFAQSchema = accordion => {
    if (!accordion.dataset.hasSchema || 'false' === accordion.dataset.hasSchema) {
      return;
    }
    const mainEntity = [];
    const items = Array.from(accordion.children);

    // build the JSON object for structured data
    items.forEach(item => {
      var _questionElem$innerTe;
      const questionElem = item.querySelector(':scope > .wp-block-themeisle-blocks-accordion-item__title > *');
      const question = (_questionElem$innerTe = questionElem?.innerText) !== null && _questionElem$innerTe !== void 0 ? _questionElem$innerTe : questionElem?.innerHTML?.replace(/<[^>]*>?/gm, '');
      const textElements = item.querySelectorAll(':scope > .wp-block-themeisle-blocks-accordion-item__content :is(p, h1, h2, h3, h4, h5, h6)');
      const answer = Array.from(textElements).map(elem => elem.innerHTML).join(' ');
      mainEntity.push({
        '@type': 'Question',
        'name': question,
        'acceptedAnswer': {
          '@type': 'Answer',
          'text': answer
        }
      });
    });
    const structuredData = {
      '@context': 'https://schema.org',
      '@type': 'FAQPage',
      mainEntity
    };

    // add the structured data to the page
    const script = document.createElement('script');
    script.setAttribute('type', 'application/ld+json');
    script.setAttribute('data-o-acc-id', accordion.id);
    script.textContent = JSON.stringify(structuredData);
    document.head.appendChild(script);
  };
  accordions.forEach(accordion => {
    handleItemOpening(accordion);
    addFAQSchema(accordion);
  });
});
}();
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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