# Visualizer: Tables and Charts Manager for WordPress #
**Contributors:** [codeinwp](https://profiles.wordpress.org/codeinwp), [themeisle](https://profiles.wordpress.org/themeisle), [marius2012](https://profiles.wordpress.org/marius2012), [marius_codeinwp](https://profiles.wordpress.org/marius_codeinwp), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani), [rozroz](https://profiles.wordpress.org/rozroz), [Madalin_ThemeIsle](https://profiles.wordpress.org/Madalin_ThemeIsle)  
**Tags:** tables, charts, pie, visualization, graphs  
**Requires at least:** 5.2  
**Tested up to:** 6.8  
**Requires PHP:** 7.4  
**Stable tag:** trunk  
**License:** GPL v2.0 or later  
**License URI:** http://www.opensource.org/licenses/gpl-license.php  

A simple yet powerful WordPress chart plugin to effortlessly create and embed responsive charts & tables into your site, supporting multiple data sources for enhanced data presentation.

## Description ##

<p><a href="https://themeisle.com/plugins/visualizer-charts-and-graphs/?utm_source=wpadmin&utm_medium=readme&utm_campaign=description" rel="nofollow">Visualizer: Tables and Charts Manager for WordPress</a> is a powerful and easy to use plugin used to create, manage and embed interactive, responsive charts & tables into your WordPress posts and pages.</p>

The plugin leverages the Google Visualization API, DataTables.net, and ChartJS libraries to deliver responsive and animated charts, graphs, and tables, ensuring excellent cross-browser compatibility and a seamless mobile experience. You can fully customize all aspects of the charts and tables to suit your needs. For enhanced data management features, including importing from Excel, CSV, Google Sheets, and more, consider exploring the [PRO version](https://themeisle.com/plugins/visualizer-charts-and-graphs/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=pro-cta).

### 🔗 HELPFUL LINKS ###

- Want to see Visualizer in action before installing? <a href="https://demo.themeisle.com/visualizer/">View Visualizer Demo</a> [You can also try <b>Live Preview</b> button above]
- Need any help with setup? <a href="https://docs.themeisle.com/collection/1560-visualizer-charts-and-graphs">Check Documentation</a>
- Don’t like reading? <a href="https://youtube.com/playlist?list=PLmRasCVwuvpT0Gu1myGW-Dyt2oh-BPuci&si=S3o4BIyo3AYNh95w">Check YouTube Playlist</a>
- Interested in Visualizer Pro? <a href="https://themeisle.com/plugins/visualizer-charts-and-graphs/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=pro-cta">Know more about Visualizer PRO</a>

### Why You’ll Love Visualizer ###

- **Diverse Chart Options:** Begin with essential chart types like line, pie, bar, and table in the free version. Elevate your data presentation with advanced chart types such as scatter, area, and geo available in the Pro version. The free version offers a comprehensive range of options that are perfect for various visualization needs.

- **Manual Data Entry:** Input data manually for quick visualization tasks. This method provides ultimate control over the content and structure of your charts, making it simple to tailor data presentation directly within the plugin interface.

- **Ultimate Responsiveness:** Crafted using HTML5/SVG technology, Visualizer charts ensure flawless functionality across all devices. This commitment to responsiveness guarantees that your data is not only accessible but also optimally displayed on desktops, tablets, and smartphones, enhancing user interaction and engagement.

- **Data Table Capabilities:** In addition to our responsive charts and graphs, you can also add responsive tables to your posts and pages and customize them to your liking. Visualizer Pro lets you enhance them with features such as sorting capabilities, pagination, and search functions. From pricing tables to product tables, the possibilities are vast and customizable to meet any data presentation need.

- **Seamless Integration and Compatibility:** Whether you're using the Gutenberg editor or other page builders, Visualizer integrates effortlessly into your WordPress environment. This seamless compatibility allows for straightforward chart insertion and management.

- **Flexible and Customizable:** Make the charts and tables truly your own. Visualizer offers an extensive set of configuration options to perfectly match the look and feel of your website. Utilize Google Chart Tools with their default settings for simplicity, or dive into customization if your site’s style requires a unique approach. Every chart and table exposes numerous options that customize its appearance and functionality, ensuring your visualizations integrate seamlessly into your pages.

These versatile data handling capabilities ensure that Visualizer Free is equipped to meet a wide range of data visualization requirements right out of the box. Perfect for bloggers, educators, small businesses, and more, Visualizer helps you turn raw data into compelling, interactive charts that engage and inform your audience.

*The above descriptions were partially taken from the Google Visualization API site*

### CHECK OUT A QUICK OVERVIEW OF VISUALIZER ### 

https://youtu.be/hQO_evnb_tQ

### ✨ YOU SHOULD USE VISUALIZER IF: ###

- **You Own a Personal or Small Business Website:** You need a straightforward, powerful tool to enhance your website's visual appeal with interactive charts and tables. Visualizer makes complex data understandable and engaging.

- **You Run an Educational or Financial Institution:** For organizations that require regular reporting and data display, Visualizer offers comprehensive options for creating dynamic and informative charts and tables. This helps in better data analysis and presentation, aiding in decision-making and reporting.

- **You Aim to Enhance SEO and User Engagement:** Using Visualizer’s interactive and responsive charts can significantly improve user engagement, keeping visitors on your site longer, which can positively impact your SEO rankings.

- **You are a Non-Profit Organizations:** Non-profits can use Visualizer to display the impact of their initiatives through data. Create pie charts to show the distribution of spending or line charts to track donation trends over time, which can be powerful visuals for fundraising campaigns and annual reports.

- **You are Financial Advisors and Economists:** Visualizer allows for detailed financial reporting and economic analyses with advanced chart types like candlestick and radar charts. These tools can be used to depict stock performances, economic cycles, or budget allocations, providing clients with clear insights into financial matters.

- **Regardless of Industry:** With over 30,000 happy active users and 160+ 5-star ratings, Visualizer has been employed across a broad range of industries, including healthcare, marketing, education, and finance, demonstrating its versatility and effectiveness in any field.

**Types of charts you can create with Visualizer:** Visualizer WordPress graph and charts plugin provides a variety of charts that are optimized to address your WordPress data visualization needs. In the free version, it has line charts, bar charts, pie charts, table charts. These charts are based on pure HTML5/SVG technology (adopting VML for old IE versions), so no extra plugins are required. Adding these charts to your page can be done in a few simple steps.

- **Table:** Tables are extremely useful tools for displaying organized data. We use the datatable library to offer you endless customization options for any table needs you might have. [Click here to see demo](https://demo.themeisle.com/visualizer/table-chart/).
- **Pie Chart:** Pie charts are simple visualizations that allow you to easily illustrate the proportion of your data to your users. [Click here to see demo](https://demo.themeisle.com/visualizer/pie-chart/).
- **Line Chart:** You can display a series of data points connected with line segments using the line chart. [Click here to see demo](https://demo.themeisle.com/visualizer/line-chart/).
- **Bar Chart:** You can show grouped data with bars proportional to the values they represent using the bar chart. [Click here to see demo](https://demo.themeisle.com/visualizer/bar-chart/).
- **Area Chart [PRO]:** You can visually display quantitative data using the area chart. [Click here to see demo](https://demo.themeisle.com/visualizer/area-chart/).
- **Geo Chart [PRO]:** You can display a map of countries, continents, or regions with areas identified by the values you specify. [Click here to see demo](https://demo.themeisle.com/visualizer/geo-chart/).
- **Column Chart [PRO]:** You can use a column chart to show comparisons among different categories. [Click here to see demo](https://demo.themeisle.com/visualizer/column-chart/).
- **Bubble Chart [PRO]:** A bubble chart is a type of chart that displays three dimensions of data. Bubble charts can be considered a variation of the scatter plot, where data points are replaced with bubbles. [Click here to see demo](https://demo.themeisle.com/visualizer/bubble-chart/).
- **Scatter Chart [PRO]:** You can display values in Cartesian coordinates using the scatter chart. [Click here to see demo](https://demo.themeisle.com/visualizer/scatter-chart/).
- **Gauge Chart [PRO]:** You can build different gauge charts to indicate metrics like speed, performance, progress, or similar measures. [Click here to see demo](https://demo.themeisle.com/visualizer/gauge-chart/).
- **Candlestick Chart [PRO]:** A candlestick chart is a style of financial chart used to describe price movements of a security, derivative, or currency. [Click here to see demo](https://demo.themeisle.com/visualizer/candlestick-chart/).
- **Timeline Chart [PRO]:** You can group time-based values using the timeline chart. [Click here to see demo](https://demo.themeisle.com/visualizer/timeline-chart/).
- **Combo Chart [PRO]:** You can combine data series using different types of charts with the combo chart. [Click here to see demo](https://demo.themeisle.com/visualizer/combo-chart/).
- **Polar Area Chart [PRO]:** Polar charts are data visualizations best used for displaying multivariate observations with an arbitrary number of variables in the form of a two-dimensional chart. [Click here to see demo](https://demo.themeisle.com/visualizer/polar-area-chart/).
- **Radar/Spider Chart [PRO]:** A radar chart is a graphical method of displaying multivariate data in the form of a two-dimensional chart of three or more quantitative variables represented on axes starting from the same point. [Click here to see demo](https://demo.themeisle.com/visualizer/radar-spider-chart/).

**🤝 ELEVATE YOUR DATA WITH VISUALIZER PREMIUM FEATURES**

If you’re already benefiting from Visualizer, why not take your website to the next level with more powerful tools to enhance your data visualization capabilities and keep your audience engaged longer?

- **Advanced Data Synchronization:** Automatically sync your data sources to ensure your charts are always current without manual input.  
**USE CASE:** 🔍 Sarah, a market analyst, leverages Advanced Data Synchronization to streamline her workflow. She sets her data sources to auto-update, ensuring her market trend charts are always accurate, saving her hours each week and enhancing her reports' credibility.

- **Multi-Language Support:** Automatically translate your charts and data presentations into multiple languages, broadening your audience reach.  
**USE CASE:** 🌍 Elena, who manages a multilingual educational platform, uses Multi-Language Support to provide data visualizations in several languages, effectively increasing her site's global usability and accessibility.

- **Advanced User Permissions:** Control who can view or edit your charts, perfect for teams needing to manage access at various levels.  
**USE CASE:** 🛠️ Rachel, a project manager, configures user permissions to ensure that only relevant team members can edit financial forecasts, maintaining data integrity and security.

- **Import Data from Files:** Upload CSV files directly into Visualizer. This feature is ideal for those who prepare data in spreadsheet tools like Microsoft Excel or Google Sheets, allowing for quick and easy data visualization.

- **Import Data from URLs:** Keep your charts updated by importing data dynamically from external sources in CSV or JSON formats via URLs. This powerful feature is essential for displaying real-time or frequently updated data, reducing the need for manual updates.

- **Import from Other Charts:** Seamlessly integrate data from other charts into new visualizations, facilitating easy data consolidation and comparison.

- **Import from WordPress:** Directly pull data from your WordPress posts, pages, or custom post types to create dynamic charts that automatically update as your content changes.  
**USE CASE:** ✍️ Benjamin, a digital marketing manager, uses this feature to track engagement across blog posts in real-time. He creates charts that update automatically with views and social shares, helping him quickly adjust content strategies based on what resonates with audiences.

- **Import from Database:** Connect directly to your database to fetch data, ensuring your visualizations reflect the most up-to-date information available.

- **Data Filter:** Apply filters to your data within Visualizer, enabling viewers to interact with and explore data in a more focused manner.  
**USE CASE:** 🕵️‍♂️ Tom, a market researcher, implements data filters on his demographic analysis charts, allowing users to select specific variables such as age and income, thereby drilling down into personalized data insights.

- **Priority Support:** Have access to our dedicated support team to help you resolve any technical issues swiftly, ensuring your visualizations are always performing optimally.

Unlock these premium features and more with Visualizer PRO!

**Still have questions?** Ask your pre-sales questions [here](https://themeisle.com/contact/?utm_source=wpadmin&utm_medium=readme&utm_campaign=pre-sales), and we will get back to you promptly. Or, purchase with confidence and try it for yourself—we offer **a 30-day no-questions-asked 100% money-back guarantee**.

**WE’RE HERE FOR YOU, AND WE TAKE ALL FEEDBACK SERIOUSLY**

- **📚 Knowledge Base:** We’ve created a complete documentation library and we’re still constantly updating with new tutorials.

- **📽️ Youtube Tutorials:** Don’t like reading? We’ve created some YouTube tutorials to help you get started with the Visualizer plugin step by step.

- **🦸 Support Forum:** We offer support to free version users here and try to reply within one business day.

- **🌟 Premium Support:** We offer priority support for Plus license customers and live chat support for Infinite license customers.

If you have any feedback or feature suggestions for the Visualizer plugin, don’t hesitate to tell us. We read all feedback and ideas.

**You’re in good hands**

Visualizer is one of many great products by Themeisle. Join over 30,000+ Visualizer active users and half of a million Themeisle users from all over the world.

**See what real users talk about us:**

- [*Visualizer is amazing!*](https://wordpress.org/support/topic/visualizer-is-amazing/) - "Just what I was looking for to make my information available and looks pleasing!"

- [*Great Plugin for Bloggers*](https://wordpress.org/support/topic/great-plugin-for-bloggers-4/) - "It’s a great plugin for new bloggers like me. It's working seamlessly on my website. I am using this plugin for the last couple of weeks and I am loving it."

- [*Works Well and Devs are Responsive*](https://wordpress.org/support/topic/works-well-and-devs-are-responsive/) - "We are using it on a rather complicated multisite install. After much research, we went with this plugin for our editors' needs."

- [*The Best One I’ve Found*](https://wordpress.org/support/topic/the-best-one-ive-found-2/) - "After trying a couple of options, this was the one that worked the best."


## Installation ##

1. Upload the files to the `/wp-content/plugins/visualizer/` directory.
1. Activate the plugin through the 'Plugins' menu in WordPress.

## Frequently Asked Questions ##

### Shortcode does not turn into graph ###

Pay attention that to turn your shortcodes into graphs, your theme has to have `<?php wp_footer(); ?>` call at the bottom of **footer.php** file.

### Is there any documentation available for this plugin? ###

[http://docs.themeisle.com/article/428-visualizer-charts-and-graphs-documentation](http://docs.themeisle.com/article/428-visualizer-charts-and-graphs-documentation)

### How to format chart series values? ###

[http://docs.themeisle.com/article/672-how-to-format-series-values](http://docs.themeisle.com/article/672-how-to-format-series-values)

### How to create charts from your WordPress posts? ###

[http://docs.themeisle.com/article/673-how-to-create-charts-from-your-wordpress-posts](http://docs.themeisle.com/article/673-how-to-create-charts-from-your-wordpress-posts)

### How to automatically sync charts with online files? ###

[http://docs.themeisle.com/article/674-how-to-automatically-sync-charts-with-online-files](http://docs.themeisle.com/article/674-how-to-automatically-sync-charts-with-online-files)

### How can I create/add a chart? ###

[http://docs.themeisle.com/article/597-create-chart](http://docs.themeisle.com/article/597-create-chart)

### How can I edit a chart? ###

[http://docs.themeisle.com/article/602-how-can-i-edit-a-chart](http://docs.themeisle.com/article/602-how-can-i-edit-a-chart)

### How can I delete a chart? ###

[http://docs.themeisle.com/article/600-delete-chart](http://docs.themeisle.com/article/600-delete-chart)

### How can I clone a chart? ###

[http://docs.themeisle.com/article/598-clone-chart](http://docs.themeisle.com/article/598-clone-chart)

### How can I highlight a single bar? ###

[http://docs.themeisle.com/article/603-how-can-i-highlight-a-single-bar](http://docs.themeisle.com/article/603-how-can-i-highlight-a-single-bar)

### How can I populate chart series and data dynamically? ###

[http://docs.themeisle.com/article/605-how-can-i-populate-chart-series-and-data-dynamically](http://docs.themeisle.com/article/605-how-can-i-populate-chart-series-and-data-dynamically)

### How can I populate data from Google Spreadsheet? ###

[http://docs.themeisle.com/article/607-how-can-i-populate-data-from-google-spreadsheet](http://docs.themeisle.com/article/607-how-can-i-populate-data-from-google-spreadsheet)

### How can I import content from another chart? ###

[http://docs.themeisle.com/article/609-how-can-i-import-content-from-another-chart](http://docs.themeisle.com/article/609-how-can-i-import-content-from-another-chart)

### How to export a chart? ###

[http://docs.themeisle.com/article/608-how-to-export-a-chart](http://docs.themeisle.com/article/608-how-to-export-a-chart)

### How can I edit the data manually? ###

[http://docs.themeisle.com/article/610-how-can-i-edit-the-data-manually](http://docs.themeisle.com/article/610-how-can-i-edit-the-data-manually)

### How to enable frontend action buttons? ###

[http://docs.themeisle.com/article/675-how-to-enable-frontend-action-buttons](http://docs.themeisle.com/article/675-how-to-enable-frontend-action-buttons)
### How to use Google Visualization variables? ###

[http://docs.themeisle.com/article/691-how-to-use-google-visualization-variables](http://docs.themeisle.com/article/691-how-to-use-google-visualization-variables)

## Screenshots ##

1. Charts Selection
2. Quick Actions
3. Import Options
4. Bar Chart
5. Bar Chart Settings
6. Line Chart Settings
7. Block editor - Chart Library

## Changelog ##

##### [Version 3.11.14](https://github.com/Codeinwp/visualizer/compare/v3.11.13...v3.11.14) (2025-11-28)

- Enhanced security




##### [Version 3.11.13](https://github.com/Codeinwp/visualizer/compare/v3.11.12...v3.11.13) (2025-11-06)

- Enhanced security




##### [Version 3.11.12](https://github.com/Codeinwp/visualizer/compare/v3.11.11...v3.11.12) (2025-09-04)

- Updated dependencies
- Fixed issue with the number format not being applied properly to the last value of the Google chart




##### [Version 3.11.11](https://github.com/Codeinwp/visualizer/compare/v3.11.10...v3.11.11) (2025-05-27)

- Fixed chart rendering on page load with multiple charts
- Updated dependencies




##### [Version 3.11.10](https://github.com/Codeinwp/visualizer/compare/v3.11.9...v3.11.10) (2025-04-16)

- Fixed special characters not rendering correctly in Legend labels
- Updated dependencies




##### [Version 3.11.9](https://github.com/Codeinwp/visualizer/compare/v3.11.8...v3.11.9) (2025-02-13)

- Enhanced security
- Fixed extra column issue with a simple editor




##### [Version 3.11.8](https://github.com/Codeinwp/visualizer/compare/v3.11.7...v3.11.8) (2024-11-13)

- Updated WordPress core tested up to version




##### [Version 3.11.7](https://github.com/Codeinwp/visualizer/compare/v3.11.6...v3.11.7) (2024-11-07)

- Updated dependencies
- Enhanced security




##### [Version 3.11.6](https://github.com/Codeinwp/visualizer/compare/v3.11.5...v3.11.6) (2024-08-30)

- Fixed chart overlapping issue with the Gutenberg editor




##### [Version 3.11.5](https://github.com/Codeinwp/visualizer/compare/v3.11.4...v3.11.5) (2024-07-17)

- Updated promotional links and buttons




##### [Version 3.11.4](https://github.com/Codeinwp/visualizer/compare/v3.11.3...v3.11.4) (2024-07-09)

- Fixed broken link in the Map settings of the Geo Chart
- Fixed the default cron job sync time for data synchronization [PRO]




##### [Version 3.11.3](https://github.com/Codeinwp/visualizer/compare/v3.11.2...v3.11.3) (2024-05-27)

- Fixed the rendering of Visualizer widgets in the Customizer




##### [Version 3.11.2](https://github.com/Codeinwp/visualizer/compare/v3.11.1...v3.11.2) (2024-05-23)

- Fixed Visualizer block widget not loading
- Improved the popup rendering
- Enhanced security




##### [Version 3.11.1](https://github.com/Codeinwp/visualizer/compare/v3.11.0...v3.11.1) (2024-05-14)

- Fixed the permissions of the plans




#### [Version 3.11.0](https://github.com/Codeinwp/visualizer/compare/v3.10.15...v3.11.0) (2024-05-13)

#### Enhancements
- Added a manual data edit feature to the free version of the plugin
- Improved the flow of chart creation
- Added a chart information panel: backend chart title & quick shortcode access
- Line and Pie charts from the ChartJS library are now available for free users, along with library selection and relative images
- Improved wording in onboarding
- Improved workflow for creating charts via the Visualizer Gutenberg block
- Moved chart library selection to the top of the page and showing charts from the available library only
- Unified chart edition (removed duplicated chart settings in block editor)
- Added optional feature usage data
- Enhanced security
- Improved the UI of the database query option (visible database prefix, sample query, autocompleting table names) [PRO]




##### [Version 3.10.15](https://github.com/Codeinwp/visualizer/compare/v3.10.14...v3.10.15) (2024-05-10)

- Updated internal dependencies




##### [Version 3.10.14](https://github.com/Codeinwp/visualizer/compare/v3.10.13...v3.10.14) (2024-05-10)

- Updated internal dependencies




##### [Version 3.10.13](https://github.com/Codeinwp/visualizer/compare/v3.10.12...v3.10.13) (2024-04-17)

### Fixes
- **Updated internal dependencies:** Enhanced performance and security.




##### [Version 3.10.12](https://github.com/Codeinwp/visualizer/compare/v3.10.11...v3.10.12) (2024-04-15)

### Fixes
- **Updated internal dependencies:** Enhanced performance and security.




##### [Version 3.10.11](https://github.com/Codeinwp/visualizer/compare/v3.10.10...v3.10.11) (2024-04-01)

### Fixes
- Updated internal dependencies
- Improved E2E testing




##### [Version 3.10.10](https://github.com/Codeinwp/visualizer/compare/v3.10.9...v3.10.10) (2024-03-28)

### Fixes
- Fixed blueprint schema for Live Preview




##### [Version 3.10.9](https://github.com/Codeinwp/visualizer/compare/v3.10.8...v3.10.9) (2024-03-27)

### Fixes
- Visualizer live preview fixed
- Updated internal dependencies




##### [Version 3.10.8](https://github.com/Codeinwp/visualizer/compare/v3.10.7...v3.10.8) (2024-03-14)

### Bug Fixes
- Fix Google chart rendering condition for Classic Plugin
- Changes the speed and position of the loading bar

### Improvements
- Add a Live Preview button for the plugin page on wordpress.org
- Added NPS survey




##### [Version 3.10.7](https://github.com/Codeinwp/visualizer/compare/v3.10.6...v3.10.7) (2024-02-06)

### Fixes
- Rendering charts that are under tabs/hidden containers
- Updated dependencies
- Updated CTA buttons
- Updated UTM campaign links




##### [Version 3.10.6](https://github.com/Codeinwp/visualizer/compare/v3.10.5...v3.10.6) (2024-01-18)

### Fixes
- Enhanced security




##### [Version 3.10.5](https://github.com/Codeinwp/visualizer/compare/v3.10.4...v3.10.5) (2023-12-19)

### Improvements
- **Added chart responsive support**
- **SDK Updates**

### Bug Fixes
- **Fixed chart data filter issue**
- **Fixed animation issue fusion builder**
- **Fixed live import issue with Gutenberg block**
- **Fixed tooltip text rendering issue in ChartJS**
- **Fixed onboarding chart import issue**
- **Removed PHP deprecated function**
- **Fixed compatibility issue with WP VIP**
- **Fixed PHP 8.1 deprecated error**




##### [Version 3.10.4](https://github.com/Codeinwp/visualizer/compare/v3.10.3...v3.10.4) (2023-08-17)

- Updated dependencies
- Updated WordPress version required to 5.2 or higher




##### [Version 3.10.3](https://github.com/Codeinwp/visualizer/compare/v3.10.2...v3.10.3) (2023-06-13)

- Removed branding label




##### [Version 3.10.2](https://github.com/Codeinwp/visualizer/compare/v3.10.1...v3.10.2) (2023-06-05)

- Added About Us page integration
- Updated dependencies




##### [Version 3.10.1](https://github.com/Codeinwp/visualizer/compare/v3.10.0...v3.10.1) (2023-05-24)

- Fixed data tables horizontal scrolling issue
- Added legend position default label text
- Added tooltip default label text
- Fixed Gutenberg block error
- Fixed table chart rendering issue in Gutenberg block
- Fixed compatibility issue with the FSE editor
- Fixed compatibility issue with WP 5.6
- Fixed console error when importing charts from others
- Fixed pagination enable/disable issue
- Fixed editor rows limitation issue




#### [Version 3.10.0](https://github.com/Codeinwp/visualizer/compare/v3.9.7...v3.10.0) (2023-04-04)

- Added a setup wizard onboarding page
- Fixed empty chart issue




##### [Version 3.9.7](https://github.com/Codeinwp/visualizer/compare/v3.9.6...v3.9.7) (2023-03-30)

- Improved chart actions icons
- Updated WordPress core tested up to version




##### [Version 3.9.6](https://github.com/Codeinwp/visualizer/compare/v3.9.5...v3.9.6) (2023-03-20)

- Fixed custom format issue in ChartJS




##### [Version 3.9.5](https://github.com/Codeinwp/visualizer/compare/v3.9.4...v3.9.5) (2023-01-30)

- Improved security by escaping shortcode attribute before render
- Compatibility with PHP 8.2




##### [Version 3.9.4](https://github.com/Codeinwp/visualizer/compare/v3.9.3...v3.9.4) (2023-01-12)

- Fixed the lock of PRO features bypass




##### [Version 3.9.3](https://github.com/Codeinwp/visualizer/compare/v3.9.2...v3.9.3) (2023-01-05)

- Fixed the chart refresh problem when importing from CSV [#970](https://github.com/Codeinwp/visualizer/issues/970)




##### [Version 3.9.2](https://github.com/Codeinwp/visualizer/compare/v3.9.1...v3.9.2) (2022-12-21)

- Fixed Geo chart [PRO] flickering issue
- Added disable legend option for ChartJS chart
- Enhanced security




##### [Version 3.9.1](https://github.com/Codeinwp/visualizer/compare/v3.9.0...v3.9.1) (2022-11-17)

- Fixed PHP error when Polylang plugin is activated [#960](https://github.com/Codeinwp/visualizer/issues/960)




#### [Version 3.9.0](https://github.com/Codeinwp/visualizer/compare/v3.8.1...v3.9.0) (2022-11-10)

- Fixed table chart decimal number issue Decimal Numbers are ignored and not displayed [#955](https://github.com/Codeinwp/visualizer/issues/955)
- Fix the scrollbar issue that happens on WP 6.1 version [WP 6.1] Chart permissions selector is not scrollable [#950](https://github.com/Codeinwp/visualizer/issues/950)
- Fix PHP Warning Warning when copy (frontend action) is enabled [#949](https://github.com/Codeinwp/visualizer/issues/949)
- Compatibility with the WPML translation plugin for translating charts [PRO feature] add support for string translations [#731](https://github.com/Codeinwp/visualizer/issues/731)
- Integration with Woocommerce Data endpoints for creating charts [PRO feature]
- Show new features on chart library page




##### [Version 3.8.1](https://github.com/Codeinwp/visualizer/compare/v3.8.0...v3.8.1) (2022-10-12)


- Change copy shortcode icon to clone a chart We can change copy Short Code icon [#945](https://github.com/Codeinwp/visualizer/issues/945)
- Fix temp file creation issue on instawp selecting the line chart is not working on instawp [#940](https://github.com/Codeinwp/visualizer/issues/940)
- Fix control Type error
- Fixed simple editor scrolling issue
- Fix filter broken layout
- Fix chartJs javascript error when rendering multiple charts




#### [Version 3.8.0](https://github.com/Codeinwp/visualizer/compare/v3.7.12...v3.8.0) (2022-09-21)

- Add data filter support for the charts




##### [Version 3.7.12](https://github.com/Codeinwp/visualizer/compare/v3.7.11...v3.7.12) (2022-09-07)

- Fixed compatibility issue with some themes and plugins [#933](https://github.com/Codeinwp/visualizer/issues/933)




##### [Version 3.7.11](https://github.com/Codeinwp/visualizer/compare/v3.7.10...v3.7.11) (2022-08-30)

- Fix update axis baseline color [#925](https://github.com/Codeinwp/visualizer/issues/925)
- Update more features images [#926](https://github.com/Codeinwp/visualizer/issues/926)
- Fix update minor grid line field [#924](https://github.com/Codeinwp/visualizer/issues/924)
- Add new filter for container attributes [#922](https://github.com/Codeinwp/visualizer/issues/922)
- Fix axis data format issue [#920](https://github.com/Codeinwp/visualizer/issues/920)
- Chart unique title [#915](https://github.com/Codeinwp/visualizer/issues/915)
- Fix block back button issue [#930](https://github.com/Codeinwp/visualizer/issues/930)
- Userguide broken documentation link [#918](https://github.com/Codeinwp/visualizer/issues/918)




##### [Version 3.7.10](https://github.com/Codeinwp/visualizer/compare/v3.7.9...v3.7.10) (2022-07-05)


- Fix watermark/copyright opacity wrong value [#910](https://github.com/Codeinwp/visualizer/issues/910)




##### [Version 3.7.9](https://github.com/Codeinwp/visualizer/compare/v3.7.8...v3.7.9) (2022-06-22)

* Fix branding bad HTML




##### [Version 3.7.8](https://github.com/Codeinwp/visualizer/compare/v3.7.7...v3.7.8) (2022-06-21)

- Add the description field in the pie chart
- Fix Label other is not visible on the pie chart
- Fix the pagination issue in the chart library
- Update dependencies




##### [Version 3.7.7](https://github.com/Codeinwp/visualizer/compare/v3.7.6...v3.7.7) (2022-05-31)

* Harden security by enforcing escaped urls.




##### [Version 3.7.6](https://github.com/Codeinwp/visualizer/compare/v3.7.5...v3.7.6) (2022-05-26)

- Fix PHP 8.0 or above compatibility issue
- Fix the space missing between the id and class attributes of the charts
- Fix compatibility issue with Ultimate Coupons for WooCommerce Free plugin
- Fix charts placed in accordion (tabs) that do not load properly
- Fix conflict with translation plugins




##### [Version 3.7.5](https://github.com/Codeinwp/visualizer/compare/v3.7.4...v3.7.5) (2022-03-17)

- Fix display long hAxis text issue
- Improve features discoverability.




##### [Version 3.7.4](https://github.com/Codeinwp/visualizer/compare/v3.7.3...v3.7.4) (2022-02-07)

- Fix multiple lazy load charts issue
- Tested up to WordPress 5.9 version




##### [Version 3.7.3](https://github.com/Codeinwp/visualizer/compare/v3.7.2...v3.7.3) (2022-01-19)

- Fix multiple charts lazy rendering issue
- Upgrade jQuery UI core library CDN
- Fix console error when rendering multiple charts
- Keep only Line / Pie / bar / Table charts in free version




##### [Version 3.7.2](https://github.com/Codeinwp/visualizer/compare/v3.7.1...v3.7.2) (2021-12-20)

- Add latest chartJS library support in the bar chart
- Fix horizontal axis showing date format in Bar chart
- Fix orientation rotate issue in mobile
- CSS performance improvements
- Improve JS performance




##### [Version 3.7.1](https://github.com/Codeinwp/visualizer/compare/v3.7.0...v3.7.1) (2021-11-17)

- [Feat] Allow charts to render in dashboard areas via 3rd party plugins like Dashboard Widgets Suite
- [Fix] Changing Line Chart series style to dot on some series changes the order of tooltip information
- [Fix] Problem with X-Axis of Line chart on Safari if date/datetime is used as values
- [Fix] Multiple Visualizer charts causing rendering issues (blank page)
- [Fix] Charts are not resizing on landscape view on mobile
- [Fix] Notices/Warnings appear on the front-end if the user is not logged in for some charts
- [Fix] Radar/Spider Chart Tooltip in PRO does not show the data value




#### [Version 3.7.0](https://github.com/Codeinwp/visualizer/compare/v3.6.1...v3.7.0) (2021-10-07)

#### Features
- Add option to enable/disable save the chart image
- Enhanced caching

#### Fixes
- Fix undefined variable errors when using Gutenberg blocks
- Fix broken chart in iOS and Safari
- Fix custom refresh time support for DB chart
- Fix table placed inside accordion cannot be scrolled down (refreshes all the time)
- Fix pagination doesn't work in the library
- Fix HTML entities in JSON break Visualizer Table Chart
- Fix string type columns affect the target of the formatting applied to a number column




##### [Version 3.6.1](https://github.com/Codeinwp/visualizer/compare/v3.6.0...v3.6.1) (2021-08-04)

- Fix broken dropdown style issue
- Add block support in widget area
- Add wp alpha color picker support
- Fix broken chart layout issue when add long title




#### [Version 3.6.0](https://github.com/Codeinwp/visualizer/compare/v3.5.1...v3.6.0) (2021-07-08)

### Features
* Adds option to render chart as image
* Automatically render chart as image on AMP

### Fixes
* [Chart Type: TABLE] When adding a blank header, the last column of the table disappears
* Styling is not applied to Chart Area for Table Chart ( Margin, Width, Height)
* Improve compatibility with Site Kit by Google
* Loading icon doesn't disappear until you edit the chart again [Line Chart]
* Broken chart if used inside an accordion (expand/collapse)




##### [Version 3.5.1](https://github.com/Codeinwp/visualizer/compare/v3.5.0...v3.5.1) (2021-05-25)


- Fix compatibility with 3rd party plugins which use the same js library as Visualizer [#801](https://github.com/Codeinwp/visualizer/issues/801)
- Fix fatal error when a new chart is created on PHP 8 [#795](https://github.com/Codeinwp/visualizer/issues/795)
- Chart doesn't get refreshed automatically when the JSON endpoint is used as the data source

#### Features:
- Adds option to add schema.org Dataset for license and creator [#794](https://github.com/Codeinwp/visualizer/issues/794)




#### [Version 3.5.0](https://github.com/Codeinwp/visualizer/compare/v3.4.11...v3.5.0) (2021-04-28)

#### Fixes
- Permissions tab disappears after a user modifies a chart's data
- Conflict with Edit Flow plugin
- Improve compatibility with Ninja Forms
- Fix for color for Minor Grid Lines not working

#### Features
- Add support for key:value header to access JSON endpoints
- Option to download CSV data of the chart without the row with series type



### 3.4.11 - 2021-02-16  ###

[Feat] Tested up to WP 5.6


### 3.4.10 - 2020-12-09  ###

* [Fix] Compatibility with Composer 2.0


### 3.4.9 - 2020-11-26  ###

* [Fix] Pie chart slices offset problem in the Gutenberg editor
* [Fix] Warning is thrown when remote file is used as source
* [Fix] Bubble chart legend position not working in the Gutenberg editor


### 3.4.8 - 2020-09-29  ###

* [Fix] Option to edit charts imported from JSON


### 3.4.7 - 2020-09-21  ###

* - [Fix] Import from JSON: Reordering columns only reorders the label, not the associated data
* - [Fix] numberFormat option doesn't apply in Bar charts when using annotations
* - [Fix] Google GEO chart is not rendering if 3rd data column is added


### 3.4.6 - 2020-08-11  ###

* - [Feat] Show chart ID in the chart library
* - [Fix] Compatibility with WP 5.5
* - [Fix] Google charts: Series number format not applying in the Gutenberg editor
* - [Fix] Google Table chart does not display chart if boolean values are specified
* - [Fix] Duplicated enque for jsapi loader


### 3.4.5 - 2020-07-08  ###

* [Feat] New Google Table Charts
* [Feat] Option for lazy loading Google Charts
* [Feat] Option to easily copy chart shortcode code
* [Fix] Remove Inside the Chart option for the legend position for Google Pie charts


### 3.4.4 - 2020-06-16  ###

* [Feat] Option to download charts as .png images
* [Fix] Make UI more intuitive when a chart is missing in the editor
* [Fix] Clicking Copy chart shows the Copied message multiple times
* [Fix] Conflict with Modern Events Calendar plugin
* [Fix] Chart size ( width and height ) options not working for ChartJS charts
* [Fix] Resizing the window causes annotation-based charts to throw an error
* [Fix] Remove Inside the Chart option as legend position for Google Pie charts
* [Fix] Clicking Advanced Options panel breaks Bubble chart
* [Fix] Missing posts revisions on chart update


### 3.4.3 - 2020-05-04  ###

* [Feat] Improved chart creation UX
* [Feat] New option to control the number of charts per page in the Charts Library
* [Feat] New option for filtering/ordering charts in the Charts Library
* [Feat] Support for custom codes for the boolean data type in Table charts
* [Fix] Support for displaying apostrophes in charts
* [Fix] Visualizer button layout in the Classic block
* [Fix] Bulk activation of plugin aborts activation of subsequent plugins


### 3.4.2 - 2020-02-17  ###

* New Cypress tests for the Gutenberg block


### 3.4.1 - 2020-02-14  ###

* [Fix] Insert chart button in the classic block
* [Fix for Pro version] Import from chart did not work


### 3.4.0 - 2020-02-13  ###

* [Feat] Support for authentication for JSON import
* [Feat] New chart type: Bubble
* [Feat] Combine one-time import and schedule import into a single control for an online .csv file import
* [Feat] Add support for annotations and other roles
* [Feat] For every chart show the last updated date and any error that exists
* [Feat] Tested up to WP 5.3
* [Fix] When new data is imported using csv/url, the manual editor still show old data
* [Fix] Having SCRIPT_DEBUG on causes issues in real time update of charts
* [Fix] Table chart: Error appears when trying to import from JSON
* [Fix] PHP Fatal error: Uncaught Error: Cannot unset string offsets
* [Fix] Long responsive table can overflow on smaller screens


### 3.3.4 - 2019-11-15  ###

* Fix issue with table chart not loading in the block editor


### 3.3.3 - 2019-11-12  ###

* Tested upto WordPress 5.3


### 3.3.2 - 2019-10-03  ###

* Add support for Dataset schema
* Horizontal Axis formatting should apply to tooltips


### 3.3.1 - 2019-09-28  ###

* Increase minimum requirement to PHP 5.6
* Fixed issue with loading customization.js on multisites
* Fixed issue with manually editing a remotely loaded chart
* Fixed issues with cloning
* Fixed issues with ChartJS assigning default colors
* Fix security issues in block editor


### 3.3.0 - 2019-08-14  ###

* Add support for ChartJS
* Add alpha color picker for supported charts
* Fix issue with some options of DataTable
* Include DataTable charts in block editor
* Fix issue with import from JSON not working with some sources
* Add menu and onboarding page
* Fix issue with frontend action checkboxes
* Improve UX in advanced settings


### 3.2.1 - 2019-05-05  ###

* Fix issue with async loading of scripts


### 3.2.0 - 2019-05-03  ###

* Add support for charts in AMP requests
* Add support to show charts from JSON/REST endpoints
* Fix loading of Google Visualization javascript files
* Add simple editors for editing chart data
* Tested up to WP 5.2


### 3.1.3 - 2019-02-24  ###

* Fix issue with changing column settings of the last column in table chart
* Add support for query language to get subset of data from Google Spreadsheet
* Fix conflict with jquery 3.3.x
* Migrated PHPExcel to PhpSpreadsheet
* Front end action 'print' should print the chart and fall back to printing the data
* Fix issue with table chart not showing in IE
* Fix issue with multiple instances of same chart not showing
* Fix issue with date type column does not work with Combo charts
* Tested with WP 5.1


### 3.1.2 - 2018-12-06  ###

* Fix bug "Warning: A non-numeric value encountered"
* Tested with WP 5.0


### 3.1.1 - 2018-12-05  ###

* Fix issue with Gutenberg support
* Fix issue with loading new Table chart
* Fix options that don't work correctly with some charts


### 3.1.0 - 2018-12-03  ###

* Add Table chart
* Fix date format in sample files


### 3.0.12 - 2018-10-11  ###

* Added filter to enable users to change schedule of charts.
* Fixed bug with line chart with timeofday column.
* Fixed bug with scheduled charts that sometimes did not show updated data.
* Javascript can be customized on a per user basis that will not be wiped out on update.


### 3.0.11 - 2018-08-15  ###

* Fixed issue with the Series Settings options for the Table Chart
* Fixed issue with chart showing "Table has no columns" with remote sources


### 3.0.10 - 2018-07-20  ###

* Fixed problem with chart reverting to the default values
* Fixed problem with Boolean column type
* Fixed problem with the Geo chart type not saving colors options


### 3.0.9 - 2018-07-12  ###

* New chart title option for the back-end of the charts that don't allow a title on the front-end
* Store the png images of the charts in a global array that can be used in JS
* Added options for charts animations


### 3.0.8 - 2018-06-27  ###

* Added revision support for the chart post type
* Added both % and Value to the Pie Slice
* Use the blog locale for Visualizer's options
* Fixed issue with data being fetched from the remote source every single time the chart was shown
* Fixed issue with scheduled charts not being updated if one of the scheduled charts is deleted


### 3.0.7 - 2018-03-26  ###

* Adds insert button in chart library.
* Remove frontend assets where they are not needed.
* Improve non-English charts compatibility.
* Adds a filter to change charts locale.


### 3.0.6 - 2018-02-27  ###

* Fix UTF-8 support while saving the data.
* Improve editing experience.
* Improves compatibility with Premium version.
* Adds chart button into TinyMCE editor.


### 3.0.5 - 2018-01-05  ###

* Fix chart rendering bug in firefox.
* Fix review notification.


### 3.0.4 - 2017-11-27  ###

* Fix for review message notification.


### 3.0.3 - 2017-11-16  ###

* Adds compatibility with WordPress 4.9.


### 3.0.2 - 2017-10-10  ###

* Fix dependency for composer dependencies.


### 3.0.1 - 2017-10-06  ###

* Improved compatibility with various theme and plugins.
* Fix for chart type selection when creation from media popup.


### 3.0.0 - 2017-09-05  ###

* Adds support manual configuration according to Google Visualization API.
* Improves compatibility with more features from the pro version.


### 2.2.0 - 2017-08-16  ###

* Added custom number format for pie chart.
* Added frontend actions buttons ( Print, Export to CSV, Export to Excel, Copy)


### 2.1.9 - 2017-07-10  ###

* Fixed display error with hex color.


### 2.1.8 - 2017-07-03  ###

* Added chart title into library.
* Fixed SDK issues with dashboard widget.


### 2.1.7 ###

* Updated sdk loading logic.



### 2.1.4 ###
* Fixed issues with non-latin chars on CSV files to import.

### 2.1.2 ###
* Fixed priority issue with wp_enqueue_media
* Added latest version of sdk

### 2.1.1 ###
* Fixed charts bliking on some themes.

### 2.1.0 ###
* Fixed geomap issue with apikey.
* Fixed responsive issues on tabbed interface and page builders.
* Added compatibility with premium import from posts/page feature.

### 2.0.4 ###
* Fixed resize issue in the library page.

### 2.0.0 ###
* Improved design and layout to support multiple datasources.
* Added new integrations in the Pro version.
* Added opt-in for tracking.

### 1.7.6 ###
* Fixed issue when using the same shortcode multiple times on the same page.

### 1.7.5 ###
* Removed footer banner upsell
* Fixed series settings issue
* Fixed issue with comas being used in numbers

### 1.7.2 ###
* Improved charts responsive system

### 1.7.1 ###
* Fixed grid lines error links

### 1.7.0 ###
* Fixed responsive issues
* Fixed issues with zero margin values
* Fixed import issue

### 1.6.6 ###
* Fixed charts resizing on tabbed content

### 1.6.5 ###
* Fixed responsive issue
* Fixed no axis text color for line and bar charts


### 1.6.0 ###
* Fixed security issue when importing charts
* Removed pointer for the pro version
* Fixed charts import from media library
* Added support to show legend on the left side


### 1.5.6 ###
* Added support for 3 more chart types
* Fixed issue with charts not saving


### 1.5.5 ###
* Added export for charts
* Enable default value for focus target. Fixed issue with hover which was not working on some machines.


### 1.5.4 ###
* Added free search text over graphs

### 1.5.2 ###
* Added step2 and 3 into step 1

### 1.5.1 ###
* Fixed bug with from web button

### 1.5 ###
* Added support for live editor
* Added support for importing data from other charts
* Added filter for chart settings
* Fixed bug when zero was not working on the charts

### 1.4.2.3 ###
* Implemented ability to edit horizontal and vertical axis number format for bar and column charts

### 1.4.2.2 ###
* Added ability to pass a class for chart wrapper div
* Added proper label for custom post type

### 1.4.2.1 ###
* Fixed issue with download_url function which not exists at front end
* Added functionality which prevents direct access to the plugin folder

### 1.4.2 ###
* Fixed remote CSV uploading issue when allow_url_fopen option is disabled in php.ini
* Replaced flattr image on widget and added donate link to plugin meta data
* Added notification message at library page when allow_url_fopen option is disabled

### 1.4.1.1 ###
* Removed CSV parser escape constant to prevent warnings which appears when PHP 5.2.x or less is used

### 1.4.1 ###
* Fixed issue which prevents the plugin working on SSL backend
* Fixed issue with CSV file uploading in IE and other browsers
* Fixed issue with empty series, which appears due to leading space in a source file
* Added ability to define custom delimiter, enclosure and escape variables for CSV parsing

### 1.4 ###
* Implemented aggregation target and selection mode options for candlestick chart
* Implemented focus target and data opacity for columnar chars
* Implemented data opacity and interpolate nulls settings for line chart
* Implemented ability to edit tooltip settings
* Implemented new settings for linear charts like selection mode and aggregation target
* Implemented area and point opacity settings for area chart
* Implemented new settings for pie chart like pie hole, start angle and slice offset
* Implemented ability to select a color for chart title and legend items
* Fixed number formatting settings for linear charts, from now it works only for axis labels
* Reworked general settings section by moving title and font settings into separate groups

### 1.3.0.2 ###
* Replaced links to github wiki

### 1.3.0.1 ###
* Added Flattr button

### 1.3.0 ###
* Implemented ability to set number and date formatters
* Implemented ability to select transparent background for a chart
* Fixed JS bugs which appear when post type editor support is disabled
* Fixed issue with NULL values for numeric series
* Fixed invalid charts rendering at "Add Media" library
* Fixed compatibility issue with another Google API related plugins
* Added "rate the plugin" box

### 1.2.0 ###
* Implemented minor grid lines settings.
* Implemented view window settings.
* Horizontal and vertical axes settings were split into separate groups.

### 1.1.4 ###
* Bug with float values has been fixed.

### 1.1.3 ###
* Issue with "fseek warning" for Google Spreadsheet document source, was fixed.

### 1.1.2 ###
* Compatibility issues with WordPress version 3.6 has been fixed.

### 1.1.1 ###
* Active type tab in the charts library was fixed.
* Library styles were updated.

### 1.1.0 ###
* Auto population was added for remote CSV file source.
* Ability to hook chart series and data was implemented.
* Ability to upload CSV files from web was implemented.

### 1.0.1 ###
* The bug with CSV file uploading was fixed.

### 1.0.0 ###
* The first version of what wil be the best wp charts plugin.
